/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.analytics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.DeniedByServerException;
import android.media.MediaCodec;
import android.media.MediaDrm;
import android.media.MediaDrmResetException;
import android.media.NotProvisionedException;
import android.media.metrics.LogSessionId;
import android.media.metrics.MediaMetricsManager;
import android.media.metrics.NetworkEvent;
import android.media.metrics.PlaybackErrorEvent;
import android.media.metrics.PlaybackMetrics;
import android.media.metrics.PlaybackSession;
import android.media.metrics.PlaybackStateEvent;
import android.media.metrics.TrackChangeEvent;
import android.net.Uri;
import android.os.SystemClock;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.C;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.ParserException;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.Tracks;
import androidx.media3.common.VideoSize;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NetworkTypeObserver;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.FileDataSource;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.UdpDataSource;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.analytics.DefaultPlaybackSessionManager;
import androidx.media3.exoplayer.analytics.PlaybackSessionManager;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.drm.UnsupportedDrmException;
import androidx.media3.exoplayer.mediacodec.MediaCodecDecoderException;
import androidx.media3.exoplayer.mediacodec.MediaCodecRenderer;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.collect.ImmutableList;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.UUID;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
@RequiresApi(value=31)
public final class MediaMetricsListener
implements AnalyticsListener,
PlaybackSessionManager.Listener {
    private final Context context;
    private final PlaybackSessionManager sessionManager;
    private final PlaybackSession playbackSession;
    private final long startTimeMs;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final HashMap<String, Long> bandwidthTimeMs;
    private final HashMap<String, Long> bandwidthBytes;
    @Nullable
    private String activeSessionId;
    @Nullable
    private PlaybackMetrics.Builder metricsBuilder;
    private int discontinuityReason;
    private int currentPlaybackState;
    private int currentNetworkType;
    @Nullable
    private PlaybackException pendingPlayerError;
    @Nullable
    private PendingFormatUpdate pendingVideoFormat;
    @Nullable
    private PendingFormatUpdate pendingAudioFormat;
    @Nullable
    private PendingFormatUpdate pendingTextFormat;
    @Nullable
    private Format currentVideoFormat;
    @Nullable
    private Format currentAudioFormat;
    @Nullable
    private Format currentTextFormat;
    private boolean isSeeking;
    private int ioErrorType;
    private boolean hasFatalError;
    private int droppedFrames;
    private int playedFrames;
    private int audioUnderruns;
    private boolean reportedEventsForCurrentSession;

    @Nullable
    public static MediaMetricsListener create(Context context) {
        MediaMetricsManager mediaMetricsManager = (MediaMetricsManager)context.getSystemService("media_metrics");
        return mediaMetricsManager == null ? null : new MediaMetricsListener(context, mediaMetricsManager.createPlaybackSession());
    }

    private MediaMetricsListener(Context context, PlaybackSession playbackSession) {
        this.context = context = context.getApplicationContext();
        this.playbackSession = playbackSession;
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        this.bandwidthBytes = new HashMap();
        this.bandwidthTimeMs = new HashMap();
        this.startTimeMs = SystemClock.elapsedRealtime();
        this.currentPlaybackState = 0;
        this.currentNetworkType = 0;
        this.sessionManager = new DefaultPlaybackSessionManager();
        this.sessionManager.setListener(this);
    }

    public LogSessionId getLogSessionId() {
        return this.playbackSession.getSessionId();
    }

    @Override
    public void onSessionCreated(AnalyticsListener.EventTime eventTime, String sessionId) {
    }

    @Override
    public void onSessionActive(AnalyticsListener.EventTime eventTime, String sessionId) {
        if (eventTime.mediaPeriodId != null && eventTime.mediaPeriodId.isAd()) {
            return;
        }
        this.finishCurrentSession();
        this.activeSessionId = sessionId;
        this.metricsBuilder = new PlaybackMetrics.Builder().setPlayerName("AndroidXMedia3").setPlayerVersion("1.0.0-rc01");
        this.maybeUpdateTimelineMetadata(eventTime.timeline, eventTime.mediaPeriodId);
    }

    @Override
    public void onAdPlaybackStarted(AnalyticsListener.EventTime eventTime, String contentSessionId, String adSessionId) {
    }

    @Override
    public void onSessionFinished(AnalyticsListener.EventTime eventTime, String sessionId, boolean automaticTransitionToNextPlayback) {
        if ((eventTime.mediaPeriodId == null || !eventTime.mediaPeriodId.isAd()) && sessionId.equals(this.activeSessionId)) {
            this.finishCurrentSession();
        }
        this.bandwidthTimeMs.remove(sessionId);
        this.bandwidthBytes.remove(sessionId);
    }

    @Override
    public void onPositionDiscontinuity(AnalyticsListener.EventTime eventTime, Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        if (reason == 1) {
            this.isSeeking = true;
        }
        this.discontinuityReason = reason;
    }

    @Override
    public void onVideoDisabled(AnalyticsListener.EventTime eventTime, DecoderCounters decoderCounters) {
        this.droppedFrames += decoderCounters.droppedBufferCount;
        this.playedFrames += decoderCounters.renderedOutputBufferCount;
    }

    @Override
    public void onBandwidthEstimate(AnalyticsListener.EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
        if (eventTime.mediaPeriodId != null) {
            String sessionId = this.sessionManager.getSessionForMediaPeriodId(eventTime.timeline, (MediaSource.MediaPeriodId)((Object)Assertions.checkNotNull((Object)((Object)eventTime.mediaPeriodId))));
            Long prevBandwidthBytes = this.bandwidthBytes.get(sessionId);
            Long prevBandwidthTimeMs = this.bandwidthTimeMs.get(sessionId);
            this.bandwidthBytes.put(sessionId, (prevBandwidthBytes == null ? 0L : prevBandwidthBytes) + totalBytesLoaded);
            this.bandwidthTimeMs.put(sessionId, (prevBandwidthTimeMs == null ? 0L : prevBandwidthTimeMs) + (long)totalLoadTimeMs);
        }
    }

    @Override
    public void onDownstreamFormatChanged(AnalyticsListener.EventTime eventTime, MediaLoadData mediaLoadData) {
        if (eventTime.mediaPeriodId == null) {
            return;
        }
        PendingFormatUpdate update = new PendingFormatUpdate((Format)Assertions.checkNotNull((Object)mediaLoadData.trackFormat), mediaLoadData.trackSelectionReason, this.sessionManager.getSessionForMediaPeriodId(eventTime.timeline, (MediaSource.MediaPeriodId)((Object)Assertions.checkNotNull((Object)((Object)eventTime.mediaPeriodId)))));
        switch (mediaLoadData.trackType) {
            case 0: 
            case 2: {
                this.pendingVideoFormat = update;
                break;
            }
            case 1: {
                this.pendingAudioFormat = update;
                break;
            }
            case 3: {
                this.pendingTextFormat = update;
                break;
            }
        }
    }

    @Override
    public void onVideoSizeChanged(AnalyticsListener.EventTime eventTime, VideoSize videoSize) {
        PendingFormatUpdate pendingVideoFormat = this.pendingVideoFormat;
        if (pendingVideoFormat != null && pendingVideoFormat.format.height == -1) {
            Format formatWithHeightAndWidth = pendingVideoFormat.format.buildUpon().setWidth(videoSize.width).setHeight(videoSize.height).build();
            this.pendingVideoFormat = new PendingFormatUpdate(formatWithHeightAndWidth, pendingVideoFormat.selectionReason, pendingVideoFormat.sessionId);
        }
    }

    @Override
    public void onLoadError(AnalyticsListener.EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
        this.ioErrorType = mediaLoadData.dataType;
    }

    @Override
    public void onPlayerError(AnalyticsListener.EventTime eventTime, PlaybackException error) {
        this.pendingPlayerError = error;
    }

    @Override
    public void onEvents(Player player, AnalyticsListener.Events events) {
        if (events.size() == 0) {
            return;
        }
        this.maybeAddSessions(events);
        long realtimeMs = SystemClock.elapsedRealtime();
        this.maybeUpdateMetricsBuilderValues(player, events);
        this.maybeReportPlaybackError(realtimeMs);
        this.maybeReportTrackChanges(player, events, realtimeMs);
        this.maybeReportNetworkChange(realtimeMs);
        this.maybeReportPlaybackStateChange(player, events, realtimeMs);
        if (events.contains(1028)) {
            this.sessionManager.finishAllSessions(events.getEventTime(1028));
        }
    }

    private void maybeAddSessions(AnalyticsListener.Events events) {
        for (int i = 0; i < events.size(); ++i) {
            int event = events.get(i);
            AnalyticsListener.EventTime eventTime = events.getEventTime(event);
            if (event == 0) {
                this.sessionManager.updateSessionsWithTimelineChange(eventTime);
                continue;
            }
            if (event == 11) {
                this.sessionManager.updateSessionsWithDiscontinuity(eventTime, this.discontinuityReason);
                continue;
            }
            this.sessionManager.updateSessions(eventTime);
        }
    }

    private void maybeUpdateMetricsBuilderValues(Player player, AnalyticsListener.Events events) {
        DrmInitData drmInitData;
        if (events.contains(0)) {
            AnalyticsListener.EventTime eventTime = events.getEventTime(0);
            if (this.metricsBuilder != null) {
                this.maybeUpdateTimelineMetadata(eventTime.timeline, eventTime.mediaPeriodId);
            }
        }
        if (events.contains(2) && this.metricsBuilder != null && (drmInitData = MediaMetricsListener.getDrmInitData((ImmutableList<Tracks.Group>)player.getCurrentTracks().getGroups())) != null) {
            ((PlaybackMetrics.Builder)Util.castNonNull((Object)this.metricsBuilder)).setDrmType(MediaMetricsListener.getDrmType(drmInitData));
        }
        if (events.contains(1011)) {
            ++this.audioUnderruns;
        }
    }

    private void maybeReportPlaybackError(long realtimeMs) {
        PlaybackException error = this.pendingPlayerError;
        if (error == null) {
            return;
        }
        ErrorInfo errorInfo = MediaMetricsListener.getErrorInfo(error, this.context, this.ioErrorType == 4);
        this.playbackSession.reportPlaybackErrorEvent(new PlaybackErrorEvent.Builder().setTimeSinceCreatedMillis(realtimeMs - this.startTimeMs).setErrorCode(errorInfo.errorCode).setSubErrorCode(errorInfo.subErrorCode).setException((Exception)error).build());
        this.reportedEventsForCurrentSession = true;
        this.pendingPlayerError = null;
    }

    private void maybeReportTrackChanges(Player player, AnalyticsListener.Events events, long realtimeMs) {
        if (events.contains(2)) {
            Tracks tracks = player.getCurrentTracks();
            boolean isVideoSelected = tracks.isTypeSelected(2);
            boolean isAudioSelected = tracks.isTypeSelected(1);
            boolean isTextSelected = tracks.isTypeSelected(3);
            if (isVideoSelected || isAudioSelected || isTextSelected) {
                if (!isVideoSelected) {
                    this.maybeUpdateVideoFormat(realtimeMs, null, 0);
                }
                if (!isAudioSelected) {
                    this.maybeUpdateAudioFormat(realtimeMs, null, 0);
                }
                if (!isTextSelected) {
                    this.maybeUpdateTextFormat(realtimeMs, null, 0);
                }
            }
        }
        if (this.canReportPendingFormatUpdate(this.pendingVideoFormat) && this.pendingVideoFormat.format.height != -1) {
            this.maybeUpdateVideoFormat(realtimeMs, this.pendingVideoFormat.format, this.pendingVideoFormat.selectionReason);
            this.pendingVideoFormat = null;
        }
        if (this.canReportPendingFormatUpdate(this.pendingAudioFormat)) {
            this.maybeUpdateAudioFormat(realtimeMs, this.pendingAudioFormat.format, this.pendingAudioFormat.selectionReason);
            this.pendingAudioFormat = null;
        }
        if (this.canReportPendingFormatUpdate(this.pendingTextFormat)) {
            this.maybeUpdateTextFormat(realtimeMs, this.pendingTextFormat.format, this.pendingTextFormat.selectionReason);
            this.pendingTextFormat = null;
        }
    }

    @EnsuresNonNullIf(result=true, expression={"#1"})
    private boolean canReportPendingFormatUpdate(@Nullable PendingFormatUpdate pendingFormatUpdate) {
        return pendingFormatUpdate != null && pendingFormatUpdate.sessionId.equals(this.sessionManager.getActiveSessionId());
    }

    private void maybeReportNetworkChange(long realtimeMs) {
        int networkType = MediaMetricsListener.getNetworkType(this.context);
        if (networkType != this.currentNetworkType) {
            this.currentNetworkType = networkType;
            this.playbackSession.reportNetworkEvent(new NetworkEvent.Builder().setNetworkType(networkType).setTimeSinceCreatedMillis(realtimeMs - this.startTimeMs).build());
        }
    }

    private void maybeReportPlaybackStateChange(Player player, AnalyticsListener.Events events, long realtimeMs) {
        if (player.getPlaybackState() != 2) {
            this.isSeeking = false;
        }
        if (player.getPlayerError() == null) {
            this.hasFatalError = false;
        } else if (events.contains(10)) {
            this.hasFatalError = true;
        }
        int newPlaybackState = this.resolveNewPlaybackState(player);
        if (this.currentPlaybackState != newPlaybackState) {
            this.currentPlaybackState = newPlaybackState;
            this.reportedEventsForCurrentSession = true;
            this.playbackSession.reportPlaybackStateEvent(new PlaybackStateEvent.Builder().setState(this.currentPlaybackState).setTimeSinceCreatedMillis(realtimeMs - this.startTimeMs).build());
        }
    }

    private int resolveNewPlaybackState(Player player) {
        int playerPlaybackState = player.getPlaybackState();
        if (this.isSeeking) {
            return 5;
        }
        if (this.hasFatalError) {
            return 13;
        }
        if (playerPlaybackState == 4) {
            return 11;
        }
        if (playerPlaybackState == 2) {
            if (this.currentPlaybackState == 0 || this.currentPlaybackState == 2) {
                return 2;
            }
            if (!player.getPlayWhenReady()) {
                return 7;
            }
            return player.getPlaybackSuppressionReason() != 0 ? 10 : 6;
        }
        if (playerPlaybackState == 3) {
            if (!player.getPlayWhenReady()) {
                return 4;
            }
            return player.getPlaybackSuppressionReason() != 0 ? 9 : 3;
        }
        if (playerPlaybackState == 1 && this.currentPlaybackState != 0) {
            return 12;
        }
        return this.currentPlaybackState;
    }

    private void maybeUpdateVideoFormat(long realtimeMs, @Nullable Format videoFormat, int trackSelectionReason) {
        if (Util.areEqual((Object)this.currentVideoFormat, (Object)videoFormat)) {
            return;
        }
        if (this.currentVideoFormat == null && trackSelectionReason == 0) {
            trackSelectionReason = 1;
        }
        this.currentVideoFormat = videoFormat;
        this.reportTrackChangeEvent(1, realtimeMs, videoFormat, trackSelectionReason);
    }

    private void maybeUpdateAudioFormat(long realtimeMs, @Nullable Format audioFormat, int trackSelectionReason) {
        if (Util.areEqual((Object)this.currentAudioFormat, (Object)audioFormat)) {
            return;
        }
        if (this.currentAudioFormat == null && trackSelectionReason == 0) {
            trackSelectionReason = 1;
        }
        this.currentAudioFormat = audioFormat;
        this.reportTrackChangeEvent(0, realtimeMs, audioFormat, trackSelectionReason);
    }

    private void maybeUpdateTextFormat(long realtimeMs, @Nullable Format textFormat, int trackSelectionReason) {
        if (Util.areEqual((Object)this.currentTextFormat, (Object)textFormat)) {
            return;
        }
        if (this.currentTextFormat == null && trackSelectionReason == 0) {
            trackSelectionReason = 1;
        }
        this.currentTextFormat = textFormat;
        this.reportTrackChangeEvent(2, realtimeMs, textFormat, trackSelectionReason);
    }

    private void reportTrackChangeEvent(int type, long realtimeMs, @Nullable Format format, int trackSelectionReason) {
        TrackChangeEvent.Builder builder = new TrackChangeEvent.Builder(type).setTimeSinceCreatedMillis(realtimeMs - this.startTimeMs);
        if (format != null) {
            builder.setTrackState(1);
            builder.setTrackChangeReason(MediaMetricsListener.getTrackChangeReason(trackSelectionReason));
            if (format.containerMimeType != null) {
                builder.setContainerMimeType(format.containerMimeType);
            }
            if (format.sampleMimeType != null) {
                builder.setSampleMimeType(format.sampleMimeType);
            }
            if (format.codecs != null) {
                builder.setCodecName(format.codecs);
            }
            if (format.bitrate != -1) {
                builder.setBitrate(format.bitrate);
            }
            if (format.width != -1) {
                builder.setWidth(format.width);
            }
            if (format.height != -1) {
                builder.setHeight(format.height);
            }
            if (format.channelCount != -1) {
                builder.setChannelCount(format.channelCount);
            }
            if (format.sampleRate != -1) {
                builder.setAudioSampleRate(format.sampleRate);
            }
            if (format.language != null) {
                Pair<String, @NullableType String> languageAndRegion = MediaMetricsListener.getLanguageAndRegion(format.language);
                builder.setLanguage((String)languageAndRegion.first);
                if (languageAndRegion.second != null) {
                    builder.setLanguageRegion((String)languageAndRegion.second);
                }
            }
            if (format.frameRate != -1.0f) {
                builder.setVideoFrameRate(format.frameRate);
            }
        } else {
            builder.setTrackState(0);
        }
        this.reportedEventsForCurrentSession = true;
        this.playbackSession.reportTrackChangeEvent(builder.build());
    }

    @RequiresNonNull(value={"metricsBuilder"})
    private void maybeUpdateTimelineMetadata(Timeline timeline, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        PlaybackMetrics.Builder metricsBuilder = this.metricsBuilder;
        if (mediaPeriodId == null) {
            return;
        }
        int periodIndex = timeline.getIndexOfPeriod(mediaPeriodId.periodUid);
        if (periodIndex == -1) {
            return;
        }
        timeline.getPeriod(periodIndex, this.period);
        timeline.getWindow(this.period.windowIndex, this.window);
        metricsBuilder.setStreamType(MediaMetricsListener.getStreamType(this.window.mediaItem));
        if (!(this.window.durationUs == -9223372036854775807L || this.window.isPlaceholder || this.window.isDynamic || this.window.isLive())) {
            metricsBuilder.setMediaDurationMillis(this.window.getDurationMs());
        }
        metricsBuilder.setPlaybackType(this.window.isLive() ? 2 : 1);
        this.reportedEventsForCurrentSession = true;
    }

    private void finishCurrentSession() {
        if (this.metricsBuilder != null && this.reportedEventsForCurrentSession) {
            this.metricsBuilder.setAudioUnderrunCount(this.audioUnderruns);
            this.metricsBuilder.setVideoFramesDropped(this.droppedFrames);
            this.metricsBuilder.setVideoFramesPlayed(this.playedFrames);
            Long networkTimeMs = this.bandwidthTimeMs.get(this.activeSessionId);
            this.metricsBuilder.setNetworkTransferDurationMillis(networkTimeMs == null ? 0L : networkTimeMs);
            Long networkBytes = this.bandwidthBytes.get(this.activeSessionId);
            this.metricsBuilder.setNetworkBytesRead(networkBytes == null ? 0L : networkBytes);
            this.metricsBuilder.setStreamSource(networkBytes != null && networkBytes > 0L ? 1 : 0);
            this.playbackSession.reportPlaybackMetrics(this.metricsBuilder.build());
        }
        this.metricsBuilder = null;
        this.activeSessionId = null;
        this.audioUnderruns = 0;
        this.droppedFrames = 0;
        this.playedFrames = 0;
        this.currentVideoFormat = null;
        this.currentAudioFormat = null;
        this.currentTextFormat = null;
        this.reportedEventsForCurrentSession = false;
    }

    private static int getTrackChangeReason(int trackSelectionReason) {
        switch (trackSelectionReason) {
            case 1: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 2: {
                return 3;
            }
        }
        return 1;
    }

    private static Pair<String, @NullableType String> getLanguageAndRegion(String languageCode) {
        String[] parts = Util.split((String)languageCode, (String)"-");
        return Pair.create((Object)parts[0], parts.length >= 2 ? parts[1] : null);
    }

    private static int getNetworkType(Context context) {
        switch (NetworkTypeObserver.getInstance((Context)context).getNetworkType()) {
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 9: {
                return 8;
            }
            case 10: {
                return 7;
            }
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 0: {
                return 0;
            }
        }
        return 1;
    }

    private static int getStreamType(MediaItem mediaItem) {
        if (mediaItem.localConfiguration == null) {
            return 0;
        }
        int contentType = Util.inferContentTypeForUriAndMimeType((Uri)mediaItem.localConfiguration.uri, (String)mediaItem.localConfiguration.mimeType);
        switch (contentType) {
            case 2: {
                return 4;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 5;
            }
        }
        return 1;
    }

    private static ErrorInfo getErrorInfo(PlaybackException error, Context context, boolean lastIoErrorForManifest) {
        Throwable cause;
        if (error.errorCode == 1001) {
            return new ErrorInfo(20, 0);
        }
        boolean isRendererExoPlaybackException = false;
        int rendererFormatSupport = 0;
        if (error instanceof ExoPlaybackException) {
            ExoPlaybackException exoPlaybackException = (ExoPlaybackException)error;
            isRendererExoPlaybackException = exoPlaybackException.type == 1;
            rendererFormatSupport = exoPlaybackException.rendererFormatSupport;
        }
        if ((cause = (Throwable)Assertions.checkNotNull((Object)error.getCause())) instanceof IOException) {
            if (cause instanceof HttpDataSource.InvalidResponseCodeException) {
                int responseCode = ((HttpDataSource.InvalidResponseCodeException)cause).responseCode;
                return new ErrorInfo(5, responseCode);
            }
            if (cause instanceof HttpDataSource.InvalidContentTypeException || cause instanceof ParserException) {
                return new ErrorInfo(lastIoErrorForManifest ? 10 : 11, 0);
            }
            if (cause instanceof HttpDataSource.HttpDataSourceException || cause instanceof UdpDataSource.UdpDataSourceException) {
                if (NetworkTypeObserver.getInstance((Context)context).getNetworkType() == 1) {
                    return new ErrorInfo(3, 0);
                }
                Throwable detailedCause = cause.getCause();
                if (detailedCause instanceof UnknownHostException) {
                    return new ErrorInfo(6, 0);
                }
                if (detailedCause instanceof SocketTimeoutException) {
                    return new ErrorInfo(7, 0);
                }
                if (cause instanceof HttpDataSource.HttpDataSourceException && ((HttpDataSource.HttpDataSourceException)cause).type == 1) {
                    return new ErrorInfo(4, 0);
                }
                return new ErrorInfo(8, 0);
            }
            if (error.errorCode == 1002) {
                return new ErrorInfo(21, 0);
            }
            if (cause instanceof DrmSession.DrmSessionException) {
                cause = (Throwable)Assertions.checkNotNull((Object)cause.getCause());
                if (Util.SDK_INT >= 21 && cause instanceof MediaDrm.MediaDrmStateException) {
                    String diagnosticsInfo = ((MediaDrm.MediaDrmStateException)cause).getDiagnosticInfo();
                    int subErrorCode = Util.getErrorCodeFromPlatformDiagnosticsInfo((String)diagnosticsInfo);
                    int errorCode = MediaMetricsListener.getDrmErrorCode(subErrorCode);
                    return new ErrorInfo(errorCode, subErrorCode);
                }
                if (Util.SDK_INT >= 23 && cause instanceof MediaDrmResetException) {
                    return new ErrorInfo(27, 0);
                }
                if (Util.SDK_INT >= 18 && cause instanceof NotProvisionedException) {
                    return new ErrorInfo(24, 0);
                }
                if (Util.SDK_INT >= 18 && cause instanceof DeniedByServerException) {
                    return new ErrorInfo(29, 0);
                }
                if (cause instanceof UnsupportedDrmException) {
                    return new ErrorInfo(23, 0);
                }
                if (cause instanceof DefaultDrmSessionManager.MissingSchemeDataException) {
                    return new ErrorInfo(28, 0);
                }
                return new ErrorInfo(30, 0);
            }
            if (cause instanceof FileDataSource.FileDataSourceException && cause.getCause() instanceof FileNotFoundException) {
                Throwable notFoundCause = ((Throwable)Assertions.checkNotNull((Object)cause.getCause())).getCause();
                if (Util.SDK_INT >= 21 && notFoundCause instanceof ErrnoException && ((ErrnoException)notFoundCause).errno == OsConstants.EACCES) {
                    return new ErrorInfo(32, 0);
                }
                return new ErrorInfo(31, 0);
            }
            return new ErrorInfo(9, 0);
        }
        if (isRendererExoPlaybackException && (rendererFormatSupport == 0 || rendererFormatSupport == 1)) {
            return new ErrorInfo(35, 0);
        }
        if (isRendererExoPlaybackException && rendererFormatSupport == 3) {
            return new ErrorInfo(15, 0);
        }
        if (isRendererExoPlaybackException && rendererFormatSupport == 2) {
            return new ErrorInfo(23, 0);
        }
        if (cause instanceof MediaCodecRenderer.DecoderInitializationException) {
            String diagnosticsInfo = ((MediaCodecRenderer.DecoderInitializationException)cause).diagnosticInfo;
            int subErrorCode = Util.getErrorCodeFromPlatformDiagnosticsInfo((String)diagnosticsInfo);
            return new ErrorInfo(13, subErrorCode);
        }
        if (cause instanceof MediaCodecDecoderException) {
            String diagnosticsInfo = ((MediaCodecDecoderException)((Object)cause)).diagnosticInfo;
            int subErrorCode = Util.getErrorCodeFromPlatformDiagnosticsInfo((String)diagnosticsInfo);
            return new ErrorInfo(14, subErrorCode);
        }
        if (cause instanceof OutOfMemoryError) {
            return new ErrorInfo(14, 0);
        }
        if (cause instanceof AudioSink.InitializationException) {
            int subErrorCode = ((AudioSink.InitializationException)cause).audioTrackState;
            return new ErrorInfo(17, subErrorCode);
        }
        if (cause instanceof AudioSink.WriteException) {
            int subErrorCode = ((AudioSink.WriteException)cause).errorCode;
            return new ErrorInfo(18, subErrorCode);
        }
        if (Util.SDK_INT >= 16 && cause instanceof MediaCodec.CryptoException) {
            int subErrorCode = ((MediaCodec.CryptoException)cause).getErrorCode();
            int errorCode = MediaMetricsListener.getDrmErrorCode(subErrorCode);
            return new ErrorInfo(errorCode, subErrorCode);
        }
        return new ErrorInfo(22, 0);
    }

    @Nullable
    private static DrmInitData getDrmInitData(ImmutableList<Tracks.Group> trackGroups) {
        for (Tracks.Group trackGroup : trackGroups) {
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                DrmInitData drmInitData;
                if (!trackGroup.isTrackSelected(trackIndex) || (drmInitData = trackGroup.getTrackFormat((int)trackIndex).drmInitData) == null) continue;
                return drmInitData;
            }
        }
        return null;
    }

    private static int getDrmType(DrmInitData drmInitData) {
        for (int i = 0; i < drmInitData.schemeDataCount; ++i) {
            UUID uuid = drmInitData.get((int)i).uuid;
            if (uuid.equals(C.WIDEVINE_UUID)) {
                return 3;
            }
            if (uuid.equals(C.PLAYREADY_UUID)) {
                return 2;
            }
            if (!uuid.equals(C.CLEARKEY_UUID)) continue;
            return 6;
        }
        return 1;
    }

    @SuppressLint(value={"SwitchIntDef"})
    private static int getDrmErrorCode(int mediaDrmErrorCode) {
        switch (Util.getErrorCodeForMediaDrmErrorCode((int)mediaDrmErrorCode)) {
            case 6002: {
                return 24;
            }
            case 6004: {
                return 25;
            }
            case 6005: {
                return 26;
            }
            case 6003: {
                return 28;
            }
        }
        return 27;
    }

    private static final class PendingFormatUpdate {
        public final Format format;
        public final int selectionReason;
        public final String sessionId;

        public PendingFormatUpdate(Format format, int selectionReason, String sessionId) {
            this.format = format;
            this.selectionReason = selectionReason;
            this.sessionId = sessionId;
        }
    }

    private static final class ErrorInfo {
        public final int errorCode;
        public final int subErrorCode;

        public ErrorInfo(int errorCode, int subErrorCode) {
            this.errorCode = errorCode;
            this.subErrorCode = subErrorCode;
        }
    }
}

