/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import androidx.annotation.Nullable;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.BaseAudioProcessor;
import androidx.media3.extractor.WavUtil;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@UnstableApi
public final class TeeAudioProcessor
extends BaseAudioProcessor {
    private final AudioBufferSink audioBufferSink;

    public TeeAudioProcessor(AudioBufferSink audioBufferSink) {
        this.audioBufferSink = (AudioBufferSink)Assertions.checkNotNull((Object)audioBufferSink);
    }

    @Override
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) {
        return inputAudioFormat;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        int remaining = inputBuffer.remaining();
        if (remaining == 0) {
            return;
        }
        this.audioBufferSink.handleBuffer(inputBuffer.asReadOnlyBuffer());
        this.replaceOutputBuffer(remaining).put(inputBuffer).flip();
    }

    @Override
    protected void onFlush() {
        this.flushSinkIfActive();
    }

    @Override
    protected void onQueueEndOfStream() {
        this.flushSinkIfActive();
    }

    @Override
    protected void onReset() {
        this.flushSinkIfActive();
    }

    private void flushSinkIfActive() {
        if (this.isActive()) {
            this.audioBufferSink.flush(this.inputAudioFormat.sampleRate, this.inputAudioFormat.channelCount, this.inputAudioFormat.encoding);
        }
    }

    public static final class WavFileAudioBufferSink
    implements AudioBufferSink {
        private static final String TAG = "WaveFileAudioBufferSink";
        private static final int FILE_SIZE_MINUS_8_OFFSET = 4;
        private static final int FILE_SIZE_MINUS_44_OFFSET = 40;
        private static final int HEADER_LENGTH = 44;
        private final String outputFileNamePrefix;
        private final byte[] scratchBuffer;
        private final ByteBuffer scratchByteBuffer;
        private int sampleRateHz;
        private int channelCount;
        private int encoding;
        @Nullable
        private RandomAccessFile randomAccessFile;
        private int counter;
        private int bytesWritten;

        public WavFileAudioBufferSink(String outputFileNamePrefix) {
            this.outputFileNamePrefix = outputFileNamePrefix;
            this.scratchBuffer = new byte[1024];
            this.scratchByteBuffer = ByteBuffer.wrap(this.scratchBuffer).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public void flush(int sampleRateHz, int channelCount, int encoding) {
            try {
                this.reset();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error resetting", (Throwable)e);
            }
            this.sampleRateHz = sampleRateHz;
            this.channelCount = channelCount;
            this.encoding = encoding;
        }

        @Override
        public void handleBuffer(ByteBuffer buffer) {
            try {
                this.maybePrepareFile();
                this.writeBuffer(buffer);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Error writing data", (Throwable)e);
            }
        }

        private void maybePrepareFile() throws IOException {
            if (this.randomAccessFile != null) {
                return;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.getNextOutputFileName(), "rw");
            this.writeFileHeader(randomAccessFile);
            this.randomAccessFile = randomAccessFile;
            this.bytesWritten = 44;
        }

        private void writeFileHeader(RandomAccessFile randomAccessFile) throws IOException {
            randomAccessFile.writeInt(1380533830);
            randomAccessFile.writeInt(-1);
            randomAccessFile.writeInt(1463899717);
            randomAccessFile.writeInt(1718449184);
            this.scratchByteBuffer.clear();
            this.scratchByteBuffer.putInt(16);
            this.scratchByteBuffer.putShort((short)WavUtil.getTypeForPcmEncoding((int)this.encoding));
            this.scratchByteBuffer.putShort((short)this.channelCount);
            this.scratchByteBuffer.putInt(this.sampleRateHz);
            int bytesPerSample = Util.getPcmFrameSize((int)this.encoding, (int)this.channelCount);
            this.scratchByteBuffer.putInt(bytesPerSample * this.sampleRateHz);
            this.scratchByteBuffer.putShort((short)bytesPerSample);
            this.scratchByteBuffer.putShort((short)(8 * bytesPerSample / this.channelCount));
            randomAccessFile.write(this.scratchBuffer, 0, this.scratchByteBuffer.position());
            randomAccessFile.writeInt(1684108385);
            randomAccessFile.writeInt(-1);
        }

        private void writeBuffer(ByteBuffer buffer) throws IOException {
            RandomAccessFile randomAccessFile = (RandomAccessFile)Assertions.checkNotNull((Object)this.randomAccessFile);
            while (buffer.hasRemaining()) {
                int bytesToWrite = Math.min(buffer.remaining(), this.scratchBuffer.length);
                buffer.get(this.scratchBuffer, 0, bytesToWrite);
                randomAccessFile.write(this.scratchBuffer, 0, bytesToWrite);
                this.bytesWritten += bytesToWrite;
            }
        }

        private void reset() throws IOException {
            RandomAccessFile randomAccessFile = this.randomAccessFile;
            if (randomAccessFile == null) {
                return;
            }
            try {
                this.scratchByteBuffer.clear();
                this.scratchByteBuffer.putInt(this.bytesWritten - 8);
                randomAccessFile.seek(4L);
                randomAccessFile.write(this.scratchBuffer, 0, 4);
                this.scratchByteBuffer.clear();
                this.scratchByteBuffer.putInt(this.bytesWritten - 44);
                randomAccessFile.seek(40L);
                randomAccessFile.write(this.scratchBuffer, 0, 4);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Error updating file size", (Throwable)e);
            }
            try {
                randomAccessFile.close();
            }
            finally {
                this.randomAccessFile = null;
            }
        }

        private String getNextOutputFileName() {
            return Util.formatInvariant((String)"%s-%04d.wav", (Object[])new Object[]{this.outputFileNamePrefix, this.counter++});
        }
    }

    public static interface AudioBufferSink {
        public void flush(int var1, int var2, int var3);

        public void handleBuffer(ByteBuffer var1);
    }
}

