/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.FrameworkMediaDrm;
import androidx.media3.exoplayer.drm.HttpMediaDrmCallback;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DefaultDrmSessionManagerProvider
implements DrmSessionManagerProvider {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @MonotonicNonNull MediaItem.DrmConfiguration drmConfiguration;
    @GuardedBy(value="lock")
    private @MonotonicNonNull DrmSessionManager manager;
    @Nullable
    private DataSource.Factory drmHttpDataSourceFactory;
    @Nullable
    private String userAgent;

    public void setDrmHttpDataSourceFactory(@Nullable DataSource.Factory drmDataSourceFactory) {
        this.drmHttpDataSourceFactory = drmDataSourceFactory;
    }

    @Deprecated
    public void setDrmUserAgent(@Nullable String userAgent) {
        this.userAgent = userAgent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DrmSessionManager get(MediaItem mediaItem) {
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        MediaItem.DrmConfiguration drmConfiguration = mediaItem.localConfiguration.drmConfiguration;
        if (drmConfiguration == null || Util.SDK_INT < 18) {
            return DrmSessionManager.DRM_UNSUPPORTED;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!Util.areEqual((Object)drmConfiguration, (Object)this.drmConfiguration)) {
                this.drmConfiguration = drmConfiguration;
                this.manager = this.createManager(drmConfiguration);
            }
            return (DrmSessionManager)Assertions.checkNotNull((Object)this.manager);
        }
    }

    @RequiresApi(value=18)
    private DrmSessionManager createManager(MediaItem.DrmConfiguration drmConfiguration) {
        DataSource.Factory dataSourceFactory = this.drmHttpDataSourceFactory != null ? this.drmHttpDataSourceFactory : new DefaultHttpDataSource.Factory().setUserAgent(this.userAgent);
        HttpMediaDrmCallback httpDrmCallback = new HttpMediaDrmCallback(drmConfiguration.licenseUri == null ? null : drmConfiguration.licenseUri.toString(), drmConfiguration.forceDefaultLicenseUri, dataSourceFactory);
        for (Map.Entry entry : drmConfiguration.licenseRequestHeaders.entrySet()) {
            httpDrmCallback.setKeyRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        DefaultDrmSessionManager drmSessionManager = new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(drmConfiguration.scheme, FrameworkMediaDrm.DEFAULT_PROVIDER).setMultiSession(drmConfiguration.multiSession).setPlayClearSamplesWithoutKeys(drmConfiguration.playClearContentWithoutKey).setUseDrmSessionsForClearContent(Ints.toArray((Collection)drmConfiguration.forcedSessionTrackTypes)).build(httpDrmCallback);
        drmSessionManager.setMode(0, drmConfiguration.getKeySetId());
        return drmSessionManager;
    }
}

