/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.ExoMediaDrm;
import androidx.media3.exoplayer.drm.HttpMediaDrmCallback;
import androidx.media3.exoplayer.drm.KeysExpiredException;
import androidx.media3.exoplayer.drm.MediaDrmCallback;
import androidx.media3.exoplayer.drm.WidevineUtil;
import androidx.media3.exoplayer.source.MediaSource;
import java.util.Map;
import java.util.UUID;

@RequiresApi(value=18)
@UnstableApi
public final class OfflineLicenseHelper {
    private static final Format FORMAT_WITH_EMPTY_DRM_INIT_DATA = new Format.Builder().setDrmInitData(new DrmInitData(new DrmInitData.SchemeData[0])).build();
    private final ConditionVariable conditionVariable;
    private final DefaultDrmSessionManager drmSessionManager;
    private final HandlerThread handlerThread;
    private final DrmSessionEventListener.EventDispatcher eventDispatcher;

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, DataSource.Factory dataSourceFactory, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return OfflineLicenseHelper.newWidevineInstance(defaultLicenseUrl, false, dataSourceFactory, eventDispatcher);
    }

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, boolean forceDefaultLicenseUrl, DataSource.Factory dataSourceFactory, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return OfflineLicenseHelper.newWidevineInstance(defaultLicenseUrl, forceDefaultLicenseUrl, dataSourceFactory, null, eventDispatcher);
    }

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, boolean forceDefaultLicenseUrl, DataSource.Factory dataSourceFactory, @Nullable Map<String, String> optionalKeyRequestParameters, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return new OfflineLicenseHelper(new DefaultDrmSessionManager.Builder().setKeyRequestParameters(optionalKeyRequestParameters).build(new HttpMediaDrmCallback(defaultLicenseUrl, forceDefaultLicenseUrl, dataSourceFactory)), eventDispatcher);
    }

    @Deprecated
    public OfflineLicenseHelper(UUID uuid, ExoMediaDrm.Provider mediaDrmProvider, MediaDrmCallback callback, @Nullable Map<String, String> optionalKeyRequestParameters, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        this(new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(uuid, mediaDrmProvider).setKeyRequestParameters(optionalKeyRequestParameters).build(callback), eventDispatcher);
    }

    public OfflineLicenseHelper(DefaultDrmSessionManager defaultDrmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        this.drmSessionManager = defaultDrmSessionManager;
        this.eventDispatcher = eventDispatcher;
        this.handlerThread = new HandlerThread("ExoPlayer:OfflineLicenseHelper");
        this.handlerThread.start();
        this.conditionVariable = new ConditionVariable();
        DrmSessionEventListener eventListener = new DrmSessionEventListener(){

            @Override
            public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.conditionVariable.open();
            }

            @Override
            public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception e) {
                OfflineLicenseHelper.this.conditionVariable.open();
            }

            @Override
            public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.conditionVariable.open();
            }

            @Override
            public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.conditionVariable.open();
            }
        };
        eventDispatcher.addEventListener(new Handler(this.handlerThread.getLooper()), eventListener);
    }

    public synchronized byte[] downloadLicense(Format format) throws DrmSession.DrmSessionException {
        Assertions.checkArgument((format.drmInitData != null ? 1 : 0) != 0);
        return this.blockingKeyRequest(2, null, format);
    }

    public synchronized byte[] renewLicense(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        return this.blockingKeyRequest(2, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
    }

    public synchronized void releaseLicense(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        this.blockingKeyRequest(3, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
    }

    public synchronized Pair<Long, Long> getLicenseDurationRemainingSec(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        this.drmSessionManager.setPlayer(this.handlerThread.getLooper(), PlayerId.UNSET);
        this.drmSessionManager.prepare();
        DrmSession drmSession = this.openBlockingKeyRequest(1, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
        DrmSession.DrmSessionException error = drmSession.getError();
        Pair<Long, Long> licenseDurationRemainingSec = WidevineUtil.getLicenseDurationRemainingSec(drmSession);
        drmSession.release(this.eventDispatcher);
        this.drmSessionManager.release();
        if (error != null) {
            if (error.getCause() instanceof KeysExpiredException) {
                return Pair.create((Object)0L, (Object)0L);
            }
            throw error;
        }
        return (Pair)Assertions.checkNotNull(licenseDurationRemainingSec);
    }

    public void release() {
        this.handlerThread.quit();
    }

    private byte[] blockingKeyRequest(int licenseMode, @Nullable byte[] offlineLicenseKeySetId, Format format) throws DrmSession.DrmSessionException {
        this.drmSessionManager.setPlayer(this.handlerThread.getLooper(), PlayerId.UNSET);
        this.drmSessionManager.prepare();
        DrmSession drmSession = this.openBlockingKeyRequest(licenseMode, offlineLicenseKeySetId, format);
        DrmSession.DrmSessionException error = drmSession.getError();
        byte[] keySetId = drmSession.getOfflineLicenseKeySetId();
        drmSession.release(this.eventDispatcher);
        this.drmSessionManager.release();
        if (error != null) {
            throw error;
        }
        return (byte[])Assertions.checkNotNull((Object)keySetId);
    }

    private DrmSession openBlockingKeyRequest(int licenseMode, @Nullable byte[] offlineLicenseKeySetId, Format format) {
        Assertions.checkNotNull((Object)format.drmInitData);
        this.drmSessionManager.setMode(licenseMode, offlineLicenseKeySetId);
        this.conditionVariable.close();
        DrmSession drmSession = this.drmSessionManager.acquireSession(this.eventDispatcher, format);
        this.conditionVariable.block();
        return (DrmSession)Assertions.checkNotNull((Object)drmSession);
    }
}

