/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.AdViewProvider;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.ClippingMediaSource;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.source.MergingMediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.source.SingleSampleMediaSource;
import androidx.media3.exoplayer.source.ads.AdsLoader;
import androidx.media3.exoplayer.source.ads.AdsMediaSource;
import androidx.media3.exoplayer.text.SubtitleDecoderFactory;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.Extractor;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.ExtractorsFactory;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.text.SubtitleExtractor;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class DefaultMediaSourceFactory
implements MediaSourceFactory {
    private static final String TAG = "DMediaSourceFactory";
    private final DelegateFactoryLoader delegateFactoryLoader;
    private DataSource.Factory dataSourceFactory;
    @Nullable
    private MediaSource.Factory serverSideAdInsertionMediaSourceFactory;
    @Nullable
    private AdsLoader.Provider adsLoaderProvider;
    @Nullable
    private AdViewProvider adViewProvider;
    @Nullable
    private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private long liveTargetOffsetMs;
    private long liveMinOffsetMs;
    private long liveMaxOffsetMs;
    private float liveMinSpeed;
    private float liveMaxSpeed;
    private boolean useProgressiveMediaSourceForSubtitles;

    public DefaultMediaSourceFactory(Context context) {
        this((DataSource.Factory)new DefaultDataSource.Factory(context));
    }

    @UnstableApi
    public DefaultMediaSourceFactory(Context context, ExtractorsFactory extractorsFactory) {
        this((DataSource.Factory)new DefaultDataSource.Factory(context), extractorsFactory);
    }

    @UnstableApi
    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory) {
        this(dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
    }

    @UnstableApi
    public DefaultMediaSourceFactory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.delegateFactoryLoader = new DelegateFactoryLoader(extractorsFactory);
        this.delegateFactoryLoader.setDataSourceFactory(dataSourceFactory);
        this.liveTargetOffsetMs = -9223372036854775807L;
        this.liveMinOffsetMs = -9223372036854775807L;
        this.liveMaxOffsetMs = -9223372036854775807L;
        this.liveMinSpeed = -3.4028235E38f;
        this.liveMaxSpeed = -3.4028235E38f;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory experimentalUseProgressiveMediaSourceForSubtitles(boolean useProgressiveMediaSourceForSubtitles) {
        this.useProgressiveMediaSourceForSubtitles = useProgressiveMediaSourceForSubtitles;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setAdsLoaderProvider(@Nullable AdsLoader.Provider adsLoaderProvider) {
        this.adsLoaderProvider = adsLoaderProvider;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setAdViewProvider(@Nullable AdViewProvider adViewProvider) {
        this.adViewProvider = adViewProvider;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultMediaSourceFactory setLocalAdInsertionComponents(AdsLoader.Provider adsLoaderProvider, AdViewProvider adViewProvider) {
        this.adsLoaderProvider = (AdsLoader.Provider)Assertions.checkNotNull((Object)adsLoaderProvider);
        this.adViewProvider = (AdViewProvider)Assertions.checkNotNull((Object)adViewProvider);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultMediaSourceFactory clearLocalAdInsertionComponents() {
        this.adsLoaderProvider = null;
        this.adViewProvider = null;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultMediaSourceFactory setDataSourceFactory(DataSource.Factory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
        this.delegateFactoryLoader.setDataSourceFactory(dataSourceFactory);
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setServerSideAdInsertionMediaSourceFactory(@Nullable MediaSource.Factory serverSideAdInsertionMediaSourceFactory) {
        this.serverSideAdInsertionMediaSourceFactory = serverSideAdInsertionMediaSourceFactory;
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLiveTargetOffsetMs(long liveTargetOffsetMs) {
        this.liveTargetOffsetMs = liveTargetOffsetMs;
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLiveMinOffsetMs(long liveMinOffsetMs) {
        this.liveMinOffsetMs = liveMinOffsetMs;
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLiveMaxOffsetMs(long liveMaxOffsetMs) {
        this.liveMaxOffsetMs = liveMaxOffsetMs;
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLiveMinSpeed(float minSpeed) {
        this.liveMinSpeed = minSpeed;
        return this;
    }

    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLiveMaxSpeed(float maxSpeed) {
        this.liveMaxSpeed = maxSpeed;
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
        this.delegateFactoryLoader.setDrmSessionManagerProvider((DrmSessionManagerProvider)Assertions.checkNotNull((Object)drmSessionManagerProvider, (Object)"MediaSource.Factory#setDrmSessionManagerProvider no longer handles null by instantiating a new DefaultDrmSessionManagerProvider. Explicitly construct and pass an instance in order to retain the old behavior."));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    @UnstableApi
    public DefaultMediaSourceFactory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
        this.loadErrorHandlingPolicy = (LoadErrorHandlingPolicy)Assertions.checkNotNull((Object)loadErrorHandlingPolicy, (Object)"MediaSource.Factory#setLoadErrorHandlingPolicy no longer handles null by instantiating a new DefaultLoadErrorHandlingPolicy. Explicitly construct and pass an instance in order to retain the old behavior.");
        this.delegateFactoryLoader.setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
        return this;
    }

    @Override
    @UnstableApi
    public int[] getSupportedTypes() {
        return this.delegateFactoryLoader.getSupportedTypes();
    }

    @Override
    @UnstableApi
    public MediaSource createMediaSource(MediaItem mediaItem) {
        MediaItem.LiveConfiguration liveConfiguration;
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        String scheme = mediaItem.localConfiguration.uri.getScheme();
        if (scheme != null && scheme.equals("ssai")) {
            return ((MediaSource.Factory)Assertions.checkNotNull((Object)this.serverSideAdInsertionMediaSourceFactory)).createMediaSource(mediaItem);
        }
        int type = Util.inferContentTypeForUriAndMimeType((Uri)mediaItem.localConfiguration.uri, (String)mediaItem.localConfiguration.mimeType);
        MediaSource.Factory mediaSourceFactory = this.delegateFactoryLoader.getMediaSourceFactory(type);
        Assertions.checkStateNotNull((Object)mediaSourceFactory, (Object)("No suitable media source factory found for content type: " + type));
        MediaItem.LiveConfiguration.Builder liveConfigurationBuilder = mediaItem.liveConfiguration.buildUpon();
        if (mediaItem.liveConfiguration.targetOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setTargetOffsetMs(this.liveTargetOffsetMs);
        }
        if (mediaItem.liveConfiguration.minPlaybackSpeed == -3.4028235E38f) {
            liveConfigurationBuilder.setMinPlaybackSpeed(this.liveMinSpeed);
        }
        if (mediaItem.liveConfiguration.maxPlaybackSpeed == -3.4028235E38f) {
            liveConfigurationBuilder.setMaxPlaybackSpeed(this.liveMaxSpeed);
        }
        if (mediaItem.liveConfiguration.minOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setMinOffsetMs(this.liveMinOffsetMs);
        }
        if (mediaItem.liveConfiguration.maxOffsetMs == -9223372036854775807L) {
            liveConfigurationBuilder.setMaxOffsetMs(this.liveMaxOffsetMs);
        }
        if (!(liveConfiguration = liveConfigurationBuilder.build()).equals((Object)mediaItem.liveConfiguration)) {
            mediaItem = mediaItem.buildUpon().setLiveConfiguration(liveConfiguration).build();
        }
        MediaSource mediaSource = mediaSourceFactory.createMediaSource(mediaItem);
        ImmutableList subtitleConfigurations = ((MediaItem.LocalConfiguration)Util.castNonNull((Object)mediaItem.localConfiguration)).subtitleConfigurations;
        if (!subtitleConfigurations.isEmpty()) {
            MediaSource[] mediaSources = new MediaSource[subtitleConfigurations.size() + 1];
            mediaSources[0] = mediaSource;
            for (int i = 0; i < subtitleConfigurations.size(); ++i) {
                if (this.useProgressiveMediaSourceForSubtitles) {
                    Format format = new Format.Builder().setSampleMimeType(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).mimeType).setLanguage(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).language).setSelectionFlags(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).selectionFlags).setRoleFlags(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).roleFlags).setLabel(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).label).setId(((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).id).build();
                    ExtractorsFactory extractorsFactory = () -> new Extractor[]{SubtitleDecoderFactory.DEFAULT.supportsFormat(format) ? new SubtitleExtractor(SubtitleDecoderFactory.DEFAULT.createDecoder(format), format) : new UnknownSubtitlesExtractor(format)};
                    ProgressiveMediaSource.Factory progressiveMediaSourceFactory = new ProgressiveMediaSource.Factory(this.dataSourceFactory, extractorsFactory);
                    if (this.loadErrorHandlingPolicy != null) {
                        progressiveMediaSourceFactory.setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
                    }
                    mediaSources[i + 1] = progressiveMediaSourceFactory.createMediaSource(MediaItem.fromUri((String)((MediaItem.SubtitleConfiguration)subtitleConfigurations.get((int)i)).uri.toString()));
                    continue;
                }
                SingleSampleMediaSource.Factory singleSampleMediaSourceFactory = new SingleSampleMediaSource.Factory(this.dataSourceFactory);
                if (this.loadErrorHandlingPolicy != null) {
                    singleSampleMediaSourceFactory.setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
                }
                mediaSources[i + 1] = singleSampleMediaSourceFactory.createMediaSource((MediaItem.SubtitleConfiguration)subtitleConfigurations.get(i), -9223372036854775807L);
            }
            mediaSource = new MergingMediaSource(mediaSources);
        }
        return this.maybeWrapWithAdsMediaSource(mediaItem, DefaultMediaSourceFactory.maybeClipMediaSource(mediaItem, mediaSource));
    }

    private static MediaSource maybeClipMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        if (mediaItem.clippingConfiguration.startPositionMs == 0L && mediaItem.clippingConfiguration.endPositionMs == Long.MIN_VALUE && !mediaItem.clippingConfiguration.relativeToDefaultPosition) {
            return mediaSource;
        }
        return new ClippingMediaSource(mediaSource, Util.msToUs((long)mediaItem.clippingConfiguration.startPositionMs), Util.msToUs((long)mediaItem.clippingConfiguration.endPositionMs), !mediaItem.clippingConfiguration.startsAtKeyFrame, mediaItem.clippingConfiguration.relativeToLiveWindow, mediaItem.clippingConfiguration.relativeToDefaultPosition);
    }

    private MediaSource maybeWrapWithAdsMediaSource(MediaItem mediaItem, MediaSource mediaSource) {
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        MediaItem.AdsConfiguration adsConfiguration = mediaItem.localConfiguration.adsConfiguration;
        if (adsConfiguration == null) {
            return mediaSource;
        }
        AdsLoader.Provider adsLoaderProvider = this.adsLoaderProvider;
        AdViewProvider adViewProvider = this.adViewProvider;
        if (adsLoaderProvider == null || adViewProvider == null) {
            Log.w((String)TAG, (String)"Playing media without ads. Configure ad support by calling setAdsLoaderProvider and setAdViewProvider.");
            return mediaSource;
        }
        AdsLoader adsLoader = adsLoaderProvider.getAdsLoader(adsConfiguration);
        if (adsLoader == null) {
            Log.w((String)TAG, (String)"Playing media without ads, as no AdsLoader was provided.");
            return mediaSource;
        }
        return new AdsMediaSource(mediaSource, new DataSpec(adsConfiguration.adTagUri), adsConfiguration.adsId != null ? adsConfiguration.adsId : ImmutableList.of((Object)mediaItem.mediaId, (Object)mediaItem.localConfiguration.uri, (Object)adsConfiguration.adTagUri), this, adsLoader, adViewProvider);
    }

    private static MediaSource.Factory newInstance(Class<? extends MediaSource.Factory> clazz, DataSource.Factory dataSourceFactory) {
        try {
            return clazz.getConstructor(DataSource.Factory.class).newInstance(dataSourceFactory);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static MediaSource.Factory newInstance(Class<? extends MediaSource.Factory> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class UnknownSubtitlesExtractor
    implements Extractor {
        private final Format format;

        public UnknownSubtitlesExtractor(Format format) {
            this.format = format;
        }

        public boolean sniff(ExtractorInput input) {
            return true;
        }

        public void init(ExtractorOutput output) {
            TrackOutput trackOutput = output.track(0, 3);
            output.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
            output.endTracks();
            trackOutput.format(this.format.buildUpon().setSampleMimeType("text/x-unknown").setCodecs(this.format.sampleMimeType).build());
        }

        public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
            int skipResult = input.skip(Integer.MAX_VALUE);
            if (skipResult == -1) {
                return -1;
            }
            return 0;
        }

        public void seek(long position, long timeUs) {
        }

        public void release() {
        }
    }

    private static final class DelegateFactoryLoader {
        private final ExtractorsFactory extractorsFactory;
        private final Map<Integer, @NullableType Supplier<MediaSource.Factory>> mediaSourceFactorySuppliers;
        private final Set<Integer> supportedTypes;
        private final Map<Integer, MediaSource.Factory> mediaSourceFactories;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @MonotonicNonNull DataSource.Factory dataSourceFactory;
        @Nullable
        private DrmSessionManagerProvider drmSessionManagerProvider;
        @Nullable
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;

        public DelegateFactoryLoader(ExtractorsFactory extractorsFactory) {
            this.extractorsFactory = extractorsFactory;
            this.mediaSourceFactorySuppliers = new HashMap<Integer, Supplier<MediaSource.Factory>>();
            this.supportedTypes = new HashSet<Integer>();
            this.mediaSourceFactories = new HashMap<Integer, MediaSource.Factory>();
        }

        public int[] getSupportedTypes() {
            this.ensureAllSuppliersAreLoaded();
            return Ints.toArray(this.supportedTypes);
        }

        @Nullable
        public MediaSource.Factory getMediaSourceFactory(int contentType) {
            MediaSource.Factory mediaSourceFactory = this.mediaSourceFactories.get(contentType);
            if (mediaSourceFactory != null) {
                return mediaSourceFactory;
            }
            Supplier<MediaSource.Factory> mediaSourceFactorySupplier = this.maybeLoadSupplier(contentType);
            if (mediaSourceFactorySupplier == null) {
                return null;
            }
            mediaSourceFactory = (MediaSource.Factory)mediaSourceFactorySupplier.get();
            if (this.drmSessionManagerProvider != null) {
                mediaSourceFactory.setDrmSessionManagerProvider(this.drmSessionManagerProvider);
            }
            if (this.loadErrorHandlingPolicy != null) {
                mediaSourceFactory.setLoadErrorHandlingPolicy(this.loadErrorHandlingPolicy);
            }
            this.mediaSourceFactories.put(contentType, mediaSourceFactory);
            return mediaSourceFactory;
        }

        public void setDataSourceFactory(DataSource.Factory dataSourceFactory) {
            if (dataSourceFactory != this.dataSourceFactory) {
                this.dataSourceFactory = dataSourceFactory;
                this.mediaSourceFactorySuppliers.clear();
                this.mediaSourceFactories.clear();
            }
        }

        public void setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            this.drmSessionManagerProvider = drmSessionManagerProvider;
            for (MediaSource.Factory mediaSourceFactory : this.mediaSourceFactories.values()) {
                mediaSourceFactory.setDrmSessionManagerProvider(drmSessionManagerProvider);
            }
        }

        public void setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
            for (MediaSource.Factory mediaSourceFactory : this.mediaSourceFactories.values()) {
                mediaSourceFactory.setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
            }
        }

        private void ensureAllSuppliersAreLoaded() {
            this.maybeLoadSupplier(0);
            this.maybeLoadSupplier(1);
            this.maybeLoadSupplier(2);
            this.maybeLoadSupplier(3);
            this.maybeLoadSupplier(4);
        }

        @Nullable
        private Supplier<MediaSource.Factory> maybeLoadSupplier(int contentType) {
            if (this.mediaSourceFactorySuppliers.containsKey(contentType)) {
                return this.mediaSourceFactorySuppliers.get(contentType);
            }
            Supplier mediaSourceFactorySupplier = null;
            DataSource.Factory dataSourceFactory = (DataSource.Factory)Assertions.checkNotNull((Object)this.dataSourceFactory);
            try {
                switch (contentType) {
                    case 0: {
                        Class<MediaSource.Factory> clazz = Class.forName("androidx.media3.exoplayer.dash.DashMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, dataSourceFactory);
                        break;
                    }
                    case 1: {
                        Class<MediaSource.Factory> clazz = Class.forName("androidx.media3.exoplayer.smoothstreaming.SsMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, dataSourceFactory);
                        break;
                    }
                    case 2: {
                        Class<MediaSource.Factory> clazz = Class.forName("androidx.media3.exoplayer.hls.HlsMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz, dataSourceFactory);
                        break;
                    }
                    case 3: {
                        Class<MediaSource.Factory> clazz = Class.forName("androidx.media3.exoplayer.rtsp.RtspMediaSource$Factory").asSubclass(MediaSource.Factory.class);
                        mediaSourceFactorySupplier = () -> DefaultMediaSourceFactory.newInstance(clazz);
                        break;
                    }
                    case 4: {
                        mediaSourceFactorySupplier = () -> new ProgressiveMediaSource.Factory(dataSourceFactory, this.extractorsFactory);
                        break;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            this.mediaSourceFactorySuppliers.put(contentType, (Supplier<MediaSource.Factory>)mediaSourceFactorySupplier);
            if (mediaSourceFactorySupplier != null) {
                this.supportedTypes.add(contentType);
            }
            return mediaSourceFactorySupplier;
        }
    }

    @Deprecated
    @UnstableApi
    public static interface AdsLoaderProvider
    extends AdsLoader.Provider {
    }
}

