/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.Util;

final class StreamVolumeManager {
    private static final String TAG = "StreamVolumeManager";
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static final int VOLUME_FLAGS = 1;
    private final Context applicationContext;
    private final Handler eventHandler;
    private final Listener listener;
    private final AudioManager audioManager;
    @Nullable
    private VolumeChangeReceiver receiver;
    private int streamType;
    private int volume;
    private boolean muted;

    public StreamVolumeManager(Context context, Handler eventHandler, Listener listener) {
        this.applicationContext = context.getApplicationContext();
        this.eventHandler = eventHandler;
        this.listener = listener;
        this.audioManager = (AudioManager)Assertions.checkStateNotNull((Object)((AudioManager)this.applicationContext.getSystemService("audio")));
        this.streamType = 3;
        this.volume = StreamVolumeManager.getVolumeFromManager(this.audioManager, this.streamType);
        this.muted = StreamVolumeManager.getMutedFromManager(this.audioManager, this.streamType);
        VolumeChangeReceiver receiver = new VolumeChangeReceiver();
        IntentFilter filter = new IntentFilter(VOLUME_CHANGED_ACTION);
        try {
            this.applicationContext.registerReceiver((BroadcastReceiver)receiver, filter);
            this.receiver = receiver;
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Error registering stream volume receiver", (Throwable)e);
        }
    }

    public void setStreamType(int streamType) {
        if (this.streamType == streamType) {
            return;
        }
        this.streamType = streamType;
        this.updateVolumeAndNotifyIfChanged();
        this.listener.onStreamTypeChanged(streamType);
    }

    public int getMinVolume() {
        return Util.SDK_INT >= 28 ? this.audioManager.getStreamMinVolume(this.streamType) : 0;
    }

    public int getMaxVolume() {
        return this.audioManager.getStreamMaxVolume(this.streamType);
    }

    public int getVolume() {
        return this.volume;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setVolume(int volume) {
        if (volume < this.getMinVolume() || volume > this.getMaxVolume()) {
            return;
        }
        this.audioManager.setStreamVolume(this.streamType, volume, 1);
        this.updateVolumeAndNotifyIfChanged();
    }

    public void increaseVolume() {
        if (this.volume >= this.getMaxVolume()) {
            return;
        }
        this.audioManager.adjustStreamVolume(this.streamType, 1, 1);
        this.updateVolumeAndNotifyIfChanged();
    }

    public void decreaseVolume() {
        if (this.volume <= this.getMinVolume()) {
            return;
        }
        this.audioManager.adjustStreamVolume(this.streamType, -1, 1);
        this.updateVolumeAndNotifyIfChanged();
    }

    public void setMuted(boolean muted) {
        if (Util.SDK_INT >= 23) {
            this.audioManager.adjustStreamVolume(this.streamType, muted ? -100 : 100, 1);
        } else {
            this.audioManager.setStreamMute(this.streamType, muted);
        }
        this.updateVolumeAndNotifyIfChanged();
    }

    public void release() {
        if (this.receiver != null) {
            try {
                this.applicationContext.unregisterReceiver((BroadcastReceiver)this.receiver);
            }
            catch (RuntimeException e) {
                Log.w((String)TAG, (String)"Error unregistering stream volume receiver", (Throwable)e);
            }
            this.receiver = null;
        }
    }

    private void updateVolumeAndNotifyIfChanged() {
        int newVolume = StreamVolumeManager.getVolumeFromManager(this.audioManager, this.streamType);
        boolean newMuted = StreamVolumeManager.getMutedFromManager(this.audioManager, this.streamType);
        if (this.volume != newVolume || this.muted != newMuted) {
            this.volume = newVolume;
            this.muted = newMuted;
            this.listener.onStreamVolumeChanged(newVolume, newMuted);
        }
    }

    private static int getVolumeFromManager(AudioManager audioManager, int streamType) {
        try {
            return audioManager.getStreamVolume(streamType);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)("Could not retrieve stream volume for stream type " + streamType), (Throwable)e);
            return audioManager.getStreamMaxVolume(streamType);
        }
    }

    private static boolean getMutedFromManager(AudioManager audioManager, int streamType) {
        if (Util.SDK_INT >= 23) {
            return audioManager.isStreamMute(streamType);
        }
        return StreamVolumeManager.getVolumeFromManager(audioManager, streamType) == 0;
    }

    private final class VolumeChangeReceiver
    extends BroadcastReceiver {
        private VolumeChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            StreamVolumeManager.this.eventHandler.post(() -> StreamVolumeManager.this.updateVolumeAndNotifyIfChanged());
        }
    }

    public static interface Listener {
        public void onStreamTypeChanged(int var1);

        public void onStreamVolumeChanged(int var1, boolean var2);
    }
}

