/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.mediacodec;

import android.media.MediaCodec;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderException;
import androidx.media3.exoplayer.mediacodec.MediaCodecInfo;

@UnstableApi
public class MediaCodecDecoderException
extends DecoderException {
    @Nullable
    public final MediaCodecInfo codecInfo;
    @Nullable
    public final String diagnosticInfo;

    public MediaCodecDecoderException(Throwable cause, @Nullable MediaCodecInfo codecInfo) {
        super("Decoder failed: " + (codecInfo == null ? null : codecInfo.name), cause);
        this.codecInfo = codecInfo;
        this.diagnosticInfo = Util.SDK_INT >= 21 ? MediaCodecDecoderException.getDiagnosticInfoV21(cause) : null;
    }

    @RequiresApi(value=21)
    @Nullable
    private static String getDiagnosticInfoV21(Throwable cause) {
        if (cause instanceof MediaCodec.CodecException) {
            return ((MediaCodec.CodecException)cause).getDiagnosticInfo();
        }
        return null;
    }
}

