/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import android.net.Uri;
import android.util.SparseArray;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.cache.CacheDataSource;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.offline.Downloader;
import androidx.media3.exoplayer.offline.DownloaderFactory;
import androidx.media3.exoplayer.offline.ProgressiveDownloader;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;

@UnstableApi
public class DefaultDownloaderFactory
implements DownloaderFactory {
    private static final SparseArray<Constructor<? extends Downloader>> CONSTRUCTORS = DefaultDownloaderFactory.createDownloaderConstructors();
    private final CacheDataSource.Factory cacheDataSourceFactory;
    private final Executor executor;

    @Deprecated
    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory) {
        this(cacheDataSourceFactory, Runnable::run);
    }

    public DefaultDownloaderFactory(CacheDataSource.Factory cacheDataSourceFactory, Executor executor) {
        this.cacheDataSourceFactory = (CacheDataSource.Factory)Assertions.checkNotNull((Object)cacheDataSourceFactory);
        this.executor = (Executor)Assertions.checkNotNull((Object)executor);
    }

    @Override
    public Downloader createDownloader(DownloadRequest request) {
        int contentType = Util.inferContentTypeForUriAndMimeType((Uri)request.uri, (String)request.mimeType);
        switch (contentType) {
            case 0: 
            case 1: 
            case 2: {
                return this.createDownloader(request, contentType);
            }
            case 4: {
                return new ProgressiveDownloader(new MediaItem.Builder().setUri(request.uri).setCustomCacheKey(request.customCacheKey).build(), this.cacheDataSourceFactory, this.executor);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + contentType);
    }

    private Downloader createDownloader(DownloadRequest request, int contentType) {
        Constructor constructor = (Constructor)CONSTRUCTORS.get(contentType);
        if (constructor == null) {
            throw new IllegalStateException("Module missing for content type " + contentType);
        }
        MediaItem mediaItem = new MediaItem.Builder().setUri(request.uri).setStreamKeys(request.streamKeys).setCustomCacheKey(request.customCacheKey).build();
        try {
            return (Downloader)constructor.newInstance(mediaItem, this.cacheDataSourceFactory, this.executor);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to instantiate downloader for content type " + contentType, e);
        }
    }

    private static SparseArray<Constructor<? extends Downloader>> createDownloaderConstructors() {
        SparseArray array = new SparseArray();
        try {
            array.put(0, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("androidx.media3.exoplayer.dash.offline.DashDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(2, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("androidx.media3.exoplayer.hls.offline.HlsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            array.put(1, DefaultDownloaderFactory.getDownloaderConstructor(Class.forName("androidx.media3.exoplayer.smoothstreaming.offline.SsDownloader")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return array;
    }

    private static Constructor<? extends Downloader> getDownloaderConstructor(Class<?> clazz) {
        try {
            return clazz.asSubclass(Downloader.class).getConstructor(MediaItem.class, CacheDataSource.Factory.class, Executor.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Downloader constructor missing", e);
        }
    }
}

