/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.MediaClock;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.RendererConfiguration;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.SampleStream;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public abstract class BaseRenderer
implements Renderer,
RendererCapabilities {
    private final Object lock = new Object();
    private final int trackType;
    private final FormatHolder formatHolder;
    @Nullable
    private RendererConfiguration configuration;
    private int index;
    private @MonotonicNonNull PlayerId playerId;
    private @MonotonicNonNull Clock clock;
    private int state;
    @Nullable
    private SampleStream stream;
    @Nullable
    private Format[] streamFormats;
    private long streamOffsetUs;
    private long lastResetPositionUs;
    private long readingPositionUs;
    private boolean streamIsFinal;
    private boolean throwRendererExceptionIsExecuting;
    private Timeline timeline;
    @GuardedBy(value="lock")
    @Nullable
    private RendererCapabilities.Listener rendererCapabilitiesListener;

    public BaseRenderer(int trackType) {
        this.trackType = trackType;
        this.formatHolder = new FormatHolder();
        this.readingPositionUs = Long.MIN_VALUE;
        this.timeline = Timeline.EMPTY;
    }

    @Override
    public final int getTrackType() {
        return this.trackType;
    }

    @Override
    public final RendererCapabilities getCapabilities() {
        return this;
    }

    @Override
    public final void init(int index, PlayerId playerId, Clock clock) {
        this.index = index;
        this.playerId = playerId;
        this.clock = clock;
        this.onInit();
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return null;
    }

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final void enable(RendererConfiguration configuration, Format[] formats, SampleStream stream, long positionUs, boolean joining, boolean mayRenderStartOfStream, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) throws ExoPlaybackException {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.configuration = configuration;
        this.state = 1;
        this.onEnabled(joining, mayRenderStartOfStream);
        this.replaceStream(formats, stream, startPositionUs, offsetUs, mediaPeriodId);
        this.resetPosition(startPositionUs, joining);
    }

    @Override
    public final void start() throws ExoPlaybackException {
        Assertions.checkState((this.state == 1 ? 1 : 0) != 0);
        this.state = 2;
        this.onStarted();
    }

    @Override
    public final void replaceStream(Format[] formats, SampleStream stream, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) throws ExoPlaybackException {
        Assertions.checkState((!this.streamIsFinal ? 1 : 0) != 0);
        this.stream = stream;
        if (this.readingPositionUs == Long.MIN_VALUE) {
            this.readingPositionUs = startPositionUs;
        }
        this.streamFormats = formats;
        this.streamOffsetUs = offsetUs;
        this.onStreamChanged(formats, startPositionUs, offsetUs, mediaPeriodId);
    }

    @Override
    @Nullable
    public final SampleStream getStream() {
        return this.stream;
    }

    @Override
    public final boolean hasReadStreamToEnd() {
        return this.readingPositionUs == Long.MIN_VALUE;
    }

    @Override
    public final long getReadingPositionUs() {
        return this.readingPositionUs;
    }

    @Override
    public final void setCurrentStreamFinal() {
        this.streamIsFinal = true;
    }

    @Override
    public final boolean isCurrentStreamFinal() {
        return this.streamIsFinal;
    }

    @Override
    public final void maybeThrowStreamError() throws IOException {
        ((SampleStream)Assertions.checkNotNull((Object)this.stream)).maybeThrowError();
    }

    @Override
    public final void setTimeline(Timeline timeline) {
        if (!Util.areEqual((Object)this.timeline, (Object)timeline)) {
            this.timeline = timeline;
            this.onTimelineChanged(this.timeline);
        }
    }

    @Override
    public final void resetPosition(long positionUs) throws ExoPlaybackException {
        this.resetPosition(positionUs, false);
    }

    private void resetPosition(long positionUs, boolean joining) throws ExoPlaybackException {
        this.streamIsFinal = false;
        this.lastResetPositionUs = positionUs;
        this.readingPositionUs = positionUs;
        this.onPositionReset(positionUs, joining);
    }

    @Override
    public final void stop() {
        Assertions.checkState((this.state == 2 ? 1 : 0) != 0);
        this.state = 1;
        this.onStopped();
    }

    @Override
    public final void disable() {
        Assertions.checkState((this.state == 1 ? 1 : 0) != 0);
        this.formatHolder.clear();
        this.state = 0;
        this.stream = null;
        this.streamFormats = null;
        this.streamIsFinal = false;
        this.onDisabled();
    }

    @Override
    public final void reset() {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.formatHolder.clear();
        this.onReset();
    }

    @Override
    public final void release() {
        Assertions.checkState((this.state == 0 ? 1 : 0) != 0);
        this.onRelease();
    }

    @Override
    public int supportsMixedMimeTypeAdaptation() throws ExoPlaybackException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setListener(RendererCapabilities.Listener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.rendererCapabilitiesListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearListener() {
        Object object = this.lock;
        synchronized (object) {
            this.rendererCapabilitiesListener = null;
        }
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
    }

    protected void onInit() {
    }

    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
    }

    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) throws ExoPlaybackException {
    }

    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
    }

    protected void onStarted() throws ExoPlaybackException {
    }

    protected void onStopped() {
    }

    protected void onDisabled() {
    }

    protected void onReset() {
    }

    protected void onRelease() {
    }

    protected void onTimelineChanged(Timeline timeline) {
    }

    protected final long getLastResetPositionUs() {
        return this.lastResetPositionUs;
    }

    protected final FormatHolder getFormatHolder() {
        this.formatHolder.clear();
        return this.formatHolder;
    }

    protected final Format[] getStreamFormats() {
        return (Format[])Assertions.checkNotNull((Object)this.streamFormats);
    }

    protected final RendererConfiguration getConfiguration() {
        return (RendererConfiguration)Assertions.checkNotNull((Object)this.configuration);
    }

    protected final int getIndex() {
        return this.index;
    }

    protected final PlayerId getPlayerId() {
        return (PlayerId)Assertions.checkNotNull((Object)this.playerId);
    }

    protected final Clock getClock() {
        return (Clock)Assertions.checkNotNull((Object)this.clock);
    }

    protected final Timeline getTimeline() {
        return this.timeline;
    }

    protected final ExoPlaybackException createRendererException(Throwable cause, @Nullable Format format, int errorCode) {
        return this.createRendererException(cause, format, false, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ExoPlaybackException createRendererException(Throwable cause, @Nullable Format format, boolean isRecoverable, int errorCode) {
        int formatSupport = 4;
        if (format != null && !this.throwRendererExceptionIsExecuting) {
            this.throwRendererExceptionIsExecuting = true;
            try {
                formatSupport = RendererCapabilities.getFormatSupport(this.supportsFormat(format));
            }
            catch (ExoPlaybackException exoPlaybackException) {
            }
            finally {
                this.throwRendererExceptionIsExecuting = false;
            }
        }
        return ExoPlaybackException.createForRenderer(cause, this.getName(), this.getIndex(), format, formatSupport, isRecoverable, errorCode);
    }

    protected final int readSource(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
        int result = ((SampleStream)Assertions.checkNotNull((Object)this.stream)).readData(formatHolder, buffer, readFlags);
        if (result == -4) {
            if (buffer.isEndOfStream()) {
                this.readingPositionUs = Long.MIN_VALUE;
                return this.streamIsFinal ? -4 : -3;
            }
            buffer.timeUs += this.streamOffsetUs;
            this.readingPositionUs = Math.max(this.readingPositionUs, buffer.timeUs);
        } else if (result == -5) {
            Format format = (Format)Assertions.checkNotNull((Object)formatHolder.format);
            if (format.subsampleOffsetUs != Long.MAX_VALUE) {
                formatHolder.format = format = format.buildUpon().setSubsampleOffsetUs(format.subsampleOffsetUs + this.streamOffsetUs).build();
            }
        }
        return result;
    }

    protected int skipSource(long positionUs) {
        return ((SampleStream)Assertions.checkNotNull((Object)this.stream)).skipData(positionUs - this.streamOffsetUs);
    }

    protected final boolean isSourceReady() {
        return this.hasReadStreamToEnd() ? this.streamIsFinal : ((SampleStream)Assertions.checkNotNull((Object)this.stream)).isReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onRendererCapabilitiesChanged() {
        RendererCapabilities.Listener listener;
        Object object = this.lock;
        synchronized (object) {
            listener = this.rendererCapabilitiesListener;
        }
        if (listener != null) {
            listener.onRendererCapabilitiesChanged(this);
        }
    }
}

