/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.Nullable;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.MediaClock;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.StandaloneMediaClock;

final class DefaultMediaClock
implements MediaClock {
    private final StandaloneMediaClock standaloneClock;
    private final PlaybackParametersListener listener;
    @Nullable
    private Renderer rendererClockSource;
    @Nullable
    private MediaClock rendererClock;
    private boolean isUsingStandaloneClock;
    private boolean standaloneClockIsStarted;

    public DefaultMediaClock(PlaybackParametersListener listener, Clock clock) {
        this.listener = listener;
        this.standaloneClock = new StandaloneMediaClock(clock);
        this.isUsingStandaloneClock = true;
    }

    public void start() {
        this.standaloneClockIsStarted = true;
        this.standaloneClock.start();
    }

    public void stop() {
        this.standaloneClockIsStarted = false;
        this.standaloneClock.stop();
    }

    public void resetPosition(long positionUs) {
        this.standaloneClock.resetPosition(positionUs);
    }

    public void onRendererEnabled(Renderer renderer) throws ExoPlaybackException {
        MediaClock rendererMediaClock = renderer.getMediaClock();
        if (rendererMediaClock != null && rendererMediaClock != this.rendererClock) {
            if (this.rendererClock != null) {
                throw ExoPlaybackException.createForUnexpected(new IllegalStateException("Multiple renderer media clocks enabled."), 1000);
            }
            this.rendererClock = rendererMediaClock;
            this.rendererClockSource = renderer;
            this.rendererClock.setPlaybackParameters(this.standaloneClock.getPlaybackParameters());
        }
    }

    public void onRendererDisabled(Renderer renderer) {
        if (renderer == this.rendererClockSource) {
            this.rendererClock = null;
            this.rendererClockSource = null;
            this.isUsingStandaloneClock = true;
        }
    }

    public long syncAndGetPositionUs(boolean isReadingAhead) {
        this.syncClocks(isReadingAhead);
        return this.getPositionUs();
    }

    @Override
    public long getPositionUs() {
        return this.isUsingStandaloneClock ? this.standaloneClock.getPositionUs() : ((MediaClock)Assertions.checkNotNull((Object)this.rendererClock)).getPositionUs();
    }

    @Override
    public boolean hasSkippedSilenceSinceLastCall() {
        return this.isUsingStandaloneClock ? this.standaloneClock.hasSkippedSilenceSinceLastCall() : ((MediaClock)Assertions.checkNotNull((Object)this.rendererClock)).hasSkippedSilenceSinceLastCall();
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        if (this.rendererClock != null) {
            this.rendererClock.setPlaybackParameters(playbackParameters);
            playbackParameters = this.rendererClock.getPlaybackParameters();
        }
        this.standaloneClock.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.rendererClock != null ? this.rendererClock.getPlaybackParameters() : this.standaloneClock.getPlaybackParameters();
    }

    private void syncClocks(boolean isReadingAhead) {
        if (this.shouldUseStandaloneClock(isReadingAhead)) {
            this.isUsingStandaloneClock = true;
            if (this.standaloneClockIsStarted) {
                this.standaloneClock.start();
            }
            return;
        }
        MediaClock rendererClock = (MediaClock)Assertions.checkNotNull((Object)this.rendererClock);
        long rendererClockPositionUs = rendererClock.getPositionUs();
        if (this.isUsingStandaloneClock) {
            if (rendererClockPositionUs < this.standaloneClock.getPositionUs()) {
                this.standaloneClock.stop();
                return;
            }
            this.isUsingStandaloneClock = false;
            if (this.standaloneClockIsStarted) {
                this.standaloneClock.start();
            }
        }
        this.standaloneClock.resetPosition(rendererClockPositionUs);
        PlaybackParameters playbackParameters = rendererClock.getPlaybackParameters();
        if (!playbackParameters.equals((Object)this.standaloneClock.getPlaybackParameters())) {
            this.standaloneClock.setPlaybackParameters(playbackParameters);
            this.listener.onPlaybackParametersChanged(playbackParameters);
        }
    }

    private boolean shouldUseStandaloneClock(boolean isReadingAhead) {
        return this.rendererClockSource == null || this.rendererClockSource.isEnded() || !this.rendererClockSource.isReady() && (isReadingAhead || this.rendererClockSource.hasReadStreamToEnd());
    }

    public static interface PlaybackParametersListener {
        public void onPlaybackParametersChanged(PlaybackParameters var1);
    }
}

