/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.audio.DefaultAudioSink;
import androidx.media3.exoplayer.audio.MediaCodecAudioRenderer;
import androidx.media3.exoplayer.image.ImageDecoder;
import androidx.media3.exoplayer.image.ImageRenderer;
import androidx.media3.exoplayer.mediacodec.DefaultMediaCodecAdapterFactory;
import androidx.media3.exoplayer.mediacodec.MediaCodecAdapter;
import androidx.media3.exoplayer.mediacodec.MediaCodecSelector;
import androidx.media3.exoplayer.metadata.MetadataOutput;
import androidx.media3.exoplayer.metadata.MetadataRenderer;
import androidx.media3.exoplayer.text.TextOutput;
import androidx.media3.exoplayer.text.TextRenderer;
import androidx.media3.exoplayer.video.MediaCodecVideoRenderer;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import androidx.media3.exoplayer.video.spherical.CameraMotionRenderer;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

@UnstableApi
public class DefaultRenderersFactory
implements RenderersFactory {
    public static final long DEFAULT_ALLOWED_VIDEO_JOINING_TIME_MS = 5000L;
    public static final int EXTENSION_RENDERER_MODE_OFF = 0;
    public static final int EXTENSION_RENDERER_MODE_ON = 1;
    public static final int EXTENSION_RENDERER_MODE_PREFER = 2;
    public static final int MAX_DROPPED_VIDEO_FRAME_COUNT_TO_NOTIFY = 50;
    private static final String TAG = "DefaultRenderersFactory";
    private final Context context;
    private final DefaultMediaCodecAdapterFactory codecAdapterFactory;
    private int extensionRendererMode;
    private long allowedVideoJoiningTimeMs;
    private boolean enableDecoderFallback;
    private MediaCodecSelector mediaCodecSelector;
    private boolean enableFloatOutput;
    private boolean enableAudioTrackPlaybackParams;

    public DefaultRenderersFactory(Context context) {
        this.context = context;
        this.codecAdapterFactory = new DefaultMediaCodecAdapterFactory();
        this.extensionRendererMode = 0;
        this.allowedVideoJoiningTimeMs = 5000L;
        this.mediaCodecSelector = MediaCodecSelector.DEFAULT;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setExtensionRendererMode(int extensionRendererMode) {
        this.extensionRendererMode = extensionRendererMode;
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory forceEnableMediaCodecAsynchronousQueueing() {
        this.codecAdapterFactory.forceEnableAsynchronous();
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory forceDisableMediaCodecAsynchronousQueueing() {
        this.codecAdapterFactory.forceDisableAsynchronous();
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory experimentalSetMediaCodecAsyncCryptoFlagEnabled(boolean enableAsyncCryptoFlag) {
        this.codecAdapterFactory.experimentalSetAsyncCryptoFlagEnabled(enableAsyncCryptoFlag);
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setEnableDecoderFallback(boolean enableDecoderFallback) {
        this.enableDecoderFallback = enableDecoderFallback;
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setMediaCodecSelector(MediaCodecSelector mediaCodecSelector) {
        this.mediaCodecSelector = mediaCodecSelector;
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setEnableAudioFloatOutput(boolean enableFloatOutput) {
        this.enableFloatOutput = enableFloatOutput;
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setEnableAudioTrackPlaybackParams(boolean enableAudioTrackPlaybackParams) {
        this.enableAudioTrackPlaybackParams = enableAudioTrackPlaybackParams;
        return this;
    }

    @CanIgnoreReturnValue
    public final DefaultRenderersFactory setAllowedVideoJoiningTimeMs(long allowedVideoJoiningTimeMs) {
        this.allowedVideoJoiningTimeMs = allowedVideoJoiningTimeMs;
        return this;
    }

    @Override
    public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
        ArrayList<Renderer> renderersList = new ArrayList<Renderer>();
        this.buildVideoRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, eventHandler, videoRendererEventListener, this.allowedVideoJoiningTimeMs, renderersList);
        AudioSink audioSink = this.buildAudioSink(this.context, this.enableFloatOutput, this.enableAudioTrackPlaybackParams);
        if (audioSink != null) {
            this.buildAudioRenderers(this.context, this.extensionRendererMode, this.mediaCodecSelector, this.enableDecoderFallback, audioSink, eventHandler, audioRendererEventListener, renderersList);
        }
        this.buildTextRenderers(this.context, textRendererOutput, eventHandler.getLooper(), this.extensionRendererMode, renderersList);
        this.buildMetadataRenderers(this.context, metadataRendererOutput, eventHandler.getLooper(), this.extensionRendererMode, renderersList);
        this.buildCameraMotionRenderers(this.context, this.extensionRendererMode, renderersList);
        this.buildImageRenderers(renderersList);
        this.buildMiscellaneousRenderers(this.context, eventHandler, this.extensionRendererMode, renderersList);
        return renderersList.toArray(new Renderer[0]);
    }

    protected void buildVideoRenderers(Context context, int extensionRendererMode, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, Handler eventHandler, VideoRendererEventListener eventListener, long allowedVideoJoiningTimeMs, ArrayList<Renderer> out) {
        Renderer renderer;
        Constructor<?> constructor;
        Class<?> clazz2;
        MediaCodecVideoRenderer videoRenderer = new MediaCodecVideoRenderer(context, this.getCodecAdapterFactory(), mediaCodecSelector, allowedVideoJoiningTimeMs, enableDecoderFallback, eventHandler, eventListener, 50);
        out.add(videoRenderer);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.vp9.LibvpxVideoRenderer");
            constructor = clazz2.getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderer = (Renderer)constructor.newInstance(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded LibvpxVideoRenderer.");
        }
        catch (ClassNotFoundException clazz2) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating VP9 extension", e);
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.av1.Libgav1VideoRenderer");
            constructor = clazz2.getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderer = (Renderer)constructor.newInstance(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded Libgav1VideoRenderer.");
        }
        catch (ClassNotFoundException clazz3) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating AV1 extension", e);
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.ffmpeg.ExperimentalFfmpegVideoRenderer");
            constructor = clazz2.getConstructor(Long.TYPE, Handler.class, VideoRendererEventListener.class, Integer.TYPE);
            renderer = (Renderer)constructor.newInstance(allowedVideoJoiningTimeMs, eventHandler, eventListener, 50);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded FfmpegVideoRenderer.");
        }
        catch (ClassNotFoundException clazz4) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating FFmpeg extension", e);
        }
    }

    protected void buildAudioRenderers(Context context, int extensionRendererMode, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, AudioSink audioSink, Handler eventHandler, AudioRendererEventListener eventListener, ArrayList<Renderer> out) {
        Renderer renderer;
        Constructor<?> constructor;
        Class<?> clazz2;
        MediaCodecAudioRenderer audioRenderer = new MediaCodecAudioRenderer(context, this.getCodecAdapterFactory(), mediaCodecSelector, enableDecoderFallback, eventHandler, eventListener, audioSink);
        out.add(audioRenderer);
        if (extensionRendererMode == 0) {
            return;
        }
        int extensionRendererIndex = out.size();
        if (extensionRendererMode == 2) {
            --extensionRendererIndex;
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.midi.MidiRenderer");
            constructor = clazz2.getConstructor(Context.class);
            renderer = (Renderer)constructor.newInstance(context);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded MidiRenderer.");
        }
        catch (ClassNotFoundException clazz2) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating MIDI extension", e);
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.opus.LibopusAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded LibopusAudioRenderer.");
        }
        catch (ClassNotFoundException clazz3) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating Opus extension", e);
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.flac.LibflacAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded LibflacAudioRenderer.");
        }
        catch (ClassNotFoundException clazz4) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating FLAC extension", e);
        }
        try {
            clazz2 = Class.forName("androidx.media3.decoder.ffmpeg.FfmpegAudioRenderer");
            constructor = clazz2.getConstructor(Handler.class, AudioRendererEventListener.class, AudioSink.class);
            renderer = (Renderer)constructor.newInstance(eventHandler, eventListener, audioSink);
            out.add(extensionRendererIndex++, renderer);
            Log.i((String)TAG, (String)"Loaded FfmpegAudioRenderer.");
        }
        catch (ClassNotFoundException clazz5) {
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating FFmpeg extension", e);
        }
    }

    protected void buildTextRenderers(Context context, TextOutput output, Looper outputLooper, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new TextRenderer(output, outputLooper));
    }

    protected void buildMetadataRenderers(Context context, MetadataOutput output, Looper outputLooper, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new MetadataRenderer(output, outputLooper));
    }

    protected void buildCameraMotionRenderers(Context context, int extensionRendererMode, ArrayList<Renderer> out) {
        out.add(new CameraMotionRenderer());
    }

    protected void buildImageRenderers(ArrayList<Renderer> out) {
        out.add(new ImageRenderer(ImageDecoder.Factory.DEFAULT, null));
    }

    protected void buildMiscellaneousRenderers(Context context, Handler eventHandler, int extensionRendererMode, ArrayList<Renderer> out) {
    }

    @Nullable
    protected AudioSink buildAudioSink(Context context, boolean enableFloatOutput, boolean enableAudioTrackPlaybackParams) {
        return new DefaultAudioSink.Builder(context).setEnableFloatOutput(enableFloatOutput).setEnableAudioTrackPlaybackParams(enableAudioTrackPlaybackParams).build();
    }

    protected MediaCodecAdapter.Factory getCodecAdapterFactory() {
        return this.codecAdapterFactory;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ExtensionRendererMode {
    }
}

