/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.AuxEffectInfo;
import androidx.media3.common.DeviceInfo;
import androidx.media3.common.Effect;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Player;
import androidx.media3.common.PriorityTaskManager;
import androidx.media3.common.VideoSize;
import androidx.media3.common.text.CueGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DefaultLivePlaybackSpeedControl;
import androidx.media3.exoplayer.DefaultLoadControl;
import androidx.media3.exoplayer.DefaultRenderersFactory;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.ExoPlayerImpl;
import androidx.media3.exoplayer.LivePlaybackSpeedControl;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.PlayerMessage;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.SimpleExoPlayer;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import androidx.media3.exoplayer.analytics.DefaultAnalyticsCollector;
import androidx.media3.exoplayer.image.ImageOutput;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ShuffleOrder;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelectionArray;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.DefaultBandwidthMeter;
import androidx.media3.exoplayer.video.VideoFrameMetadataListener;
import androidx.media3.exoplayer.video.spherical.CameraMotionListener;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;

public interface ExoPlayer
extends Player {
    @UnstableApi
    public static final long DEFAULT_RELEASE_TIMEOUT_MS = 500L;
    @UnstableApi
    public static final long DEFAULT_DETACH_SURFACE_TIMEOUT_MS = 2000L;

    @Nullable
    public ExoPlaybackException getPlayerError();

    @Deprecated
    @UnstableApi
    @Nullable
    public AudioComponent getAudioComponent();

    @Deprecated
    @UnstableApi
    @Nullable
    public VideoComponent getVideoComponent();

    @Deprecated
    @UnstableApi
    @Nullable
    public TextComponent getTextComponent();

    @Deprecated
    @UnstableApi
    @Nullable
    public DeviceComponent getDeviceComponent();

    @UnstableApi
    public void addAudioOffloadListener(AudioOffloadListener var1);

    @UnstableApi
    public void removeAudioOffloadListener(AudioOffloadListener var1);

    @UnstableApi
    public AnalyticsCollector getAnalyticsCollector();

    public void addAnalyticsListener(AnalyticsListener var1);

    public void removeAnalyticsListener(AnalyticsListener var1);

    @UnstableApi
    public int getRendererCount();

    @UnstableApi
    public int getRendererType(int var1);

    @UnstableApi
    public Renderer getRenderer(int var1);

    @UnstableApi
    @Nullable
    public TrackSelector getTrackSelector();

    @Deprecated
    @UnstableApi
    public TrackGroupArray getCurrentTrackGroups();

    @Deprecated
    @UnstableApi
    public TrackSelectionArray getCurrentTrackSelections();

    @UnstableApi
    public Looper getPlaybackLooper();

    @UnstableApi
    public Clock getClock();

    @Deprecated
    @UnstableApi
    public void prepare(MediaSource var1);

    @Deprecated
    @UnstableApi
    public void prepare(MediaSource var1, boolean var2, boolean var3);

    @UnstableApi
    public void setMediaSources(List<MediaSource> var1);

    @UnstableApi
    public void setMediaSources(List<MediaSource> var1, boolean var2);

    @UnstableApi
    public void setMediaSources(List<MediaSource> var1, int var2, long var3);

    @UnstableApi
    public void setMediaSource(MediaSource var1);

    @UnstableApi
    public void setMediaSource(MediaSource var1, long var2);

    @UnstableApi
    public void setMediaSource(MediaSource var1, boolean var2);

    @UnstableApi
    public void addMediaSource(MediaSource var1);

    @UnstableApi
    public void addMediaSource(int var1, MediaSource var2);

    @UnstableApi
    public void addMediaSources(List<MediaSource> var1);

    @UnstableApi
    public void addMediaSources(int var1, List<MediaSource> var2);

    @UnstableApi
    public void setShuffleOrder(ShuffleOrder var1);

    public void replaceMediaItem(int var1, MediaItem var2);

    public void replaceMediaItems(int var1, int var2, List<MediaItem> var3);

    @UnstableApi
    public void setAudioSessionId(int var1);

    @UnstableApi
    public int getAudioSessionId();

    @UnstableApi
    public void setAuxEffectInfo(AuxEffectInfo var1);

    @UnstableApi
    public void clearAuxEffectInfo();

    @UnstableApi
    @RequiresApi(value=23)
    public void setPreferredAudioDevice(@Nullable AudioDeviceInfo var1);

    @UnstableApi
    public void setSkipSilenceEnabled(boolean var1);

    @UnstableApi
    public boolean getSkipSilenceEnabled();

    @RequiresApi(value=18)
    @UnstableApi
    public void setVideoEffects(List<Effect> var1);

    @UnstableApi
    public void setVideoScalingMode(int var1);

    @UnstableApi
    public int getVideoScalingMode();

    @UnstableApi
    public void setVideoChangeFrameRateStrategy(int var1);

    @UnstableApi
    public int getVideoChangeFrameRateStrategy();

    @UnstableApi
    public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

    @UnstableApi
    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

    @UnstableApi
    public void setCameraMotionListener(CameraMotionListener var1);

    @UnstableApi
    public void clearCameraMotionListener(CameraMotionListener var1);

    @UnstableApi
    public PlayerMessage createMessage(PlayerMessage.Target var1);

    @UnstableApi
    public void setSeekParameters(@Nullable SeekParameters var1);

    @UnstableApi
    public SeekParameters getSeekParameters();

    @UnstableApi
    public void setForegroundMode(boolean var1);

    @UnstableApi
    public void setPauseAtEndOfMediaItems(boolean var1);

    @UnstableApi
    public boolean getPauseAtEndOfMediaItems();

    @UnstableApi
    @Nullable
    public Format getAudioFormat();

    @UnstableApi
    @Nullable
    public Format getVideoFormat();

    @UnstableApi
    @Nullable
    public DecoderCounters getAudioDecoderCounters();

    @UnstableApi
    @Nullable
    public DecoderCounters getVideoDecoderCounters();

    public void setHandleAudioBecomingNoisy(boolean var1);

    public void setWakeMode(int var1);

    @UnstableApi
    public void setPriorityTaskManager(@Nullable PriorityTaskManager var1);

    @UnstableApi
    public boolean isSleepingForOffload();

    @UnstableApi
    public boolean isTunnelingEnabled();

    @UnstableApi
    public void setImageOutput(ImageOutput var1);

    public static final class Builder {
        final Context context;
        Clock clock;
        long foregroundModeTimeoutMs;
        Supplier<RenderersFactory> renderersFactorySupplier;
        Supplier<MediaSource.Factory> mediaSourceFactorySupplier;
        Supplier<TrackSelector> trackSelectorSupplier;
        Supplier<LoadControl> loadControlSupplier;
        Supplier<BandwidthMeter> bandwidthMeterSupplier;
        Function<Clock, AnalyticsCollector> analyticsCollectorFunction;
        Looper looper;
        @Nullable
        PriorityTaskManager priorityTaskManager;
        AudioAttributes audioAttributes;
        boolean handleAudioFocus;
        int wakeMode;
        boolean handleAudioBecomingNoisy;
        boolean skipSilenceEnabled;
        boolean deviceVolumeControlEnabled;
        int videoScalingMode;
        int videoChangeFrameRateStrategy;
        boolean useLazyPreparation;
        SeekParameters seekParameters;
        long seekBackIncrementMs;
        long seekForwardIncrementMs;
        LivePlaybackSpeedControl livePlaybackSpeedControl;
        long releaseTimeoutMs;
        long detachSurfaceTimeoutMs;
        boolean pauseAtEndOfMediaItems;
        boolean usePlatformDiagnostics;
        @Nullable
        Looper playbackLooper;
        boolean buildCalled;
        boolean suppressPlaybackOnUnsuitableOutput;

        public Builder(Context context) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> new DefaultRenderersFactory(context)), (Supplier<MediaSource.Factory>)((Supplier)() -> new DefaultMediaSourceFactory(context, (ExtractorsFactory)new DefaultExtractorsFactory())));
        }

        @UnstableApi
        public Builder(Context context, RenderersFactory renderersFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> new DefaultMediaSourceFactory(context, (ExtractorsFactory)new DefaultExtractorsFactory())));
            Assertions.checkNotNull((Object)renderersFactory);
        }

        @UnstableApi
        public Builder(Context context, MediaSource.Factory mediaSourceFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> new DefaultRenderersFactory(context)), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory));
            Assertions.checkNotNull((Object)mediaSourceFactory);
        }

        @UnstableApi
        public Builder(Context context, RenderersFactory renderersFactory, MediaSource.Factory mediaSourceFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory));
            Assertions.checkNotNull((Object)renderersFactory);
            Assertions.checkNotNull((Object)mediaSourceFactory);
        }

        @UnstableApi
        public Builder(Context context, RenderersFactory renderersFactory, MediaSource.Factory mediaSourceFactory, TrackSelector trackSelector, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory), (Supplier<TrackSelector>)((Supplier)() -> trackSelector), (Supplier<LoadControl>)((Supplier)() -> loadControl), (Supplier<BandwidthMeter>)((Supplier)() -> bandwidthMeter), (Function<Clock, AnalyticsCollector>)((Function)clock -> analyticsCollector));
            Assertions.checkNotNull((Object)renderersFactory);
            Assertions.checkNotNull((Object)mediaSourceFactory);
            Assertions.checkNotNull((Object)trackSelector);
            Assertions.checkNotNull((Object)bandwidthMeter);
            Assertions.checkNotNull((Object)analyticsCollector);
        }

        private Builder(Context context, Supplier<RenderersFactory> renderersFactorySupplier, Supplier<MediaSource.Factory> mediaSourceFactorySupplier) {
            this(context, renderersFactorySupplier, mediaSourceFactorySupplier, (Supplier<TrackSelector>)((Supplier)() -> new DefaultTrackSelector(context)), (Supplier<LoadControl>)((Supplier)DefaultLoadControl::new), (Supplier<BandwidthMeter>)((Supplier)() -> DefaultBandwidthMeter.getSingletonInstance(context)), (Function<Clock, AnalyticsCollector>)((Function)DefaultAnalyticsCollector::new));
        }

        private Builder(Context context, Supplier<RenderersFactory> renderersFactorySupplier, Supplier<MediaSource.Factory> mediaSourceFactorySupplier, Supplier<TrackSelector> trackSelectorSupplier, Supplier<LoadControl> loadControlSupplier, Supplier<BandwidthMeter> bandwidthMeterSupplier, Function<Clock, AnalyticsCollector> analyticsCollectorFunction) {
            this.context = (Context)Assertions.checkNotNull((Object)context);
            this.renderersFactorySupplier = renderersFactorySupplier;
            this.mediaSourceFactorySupplier = mediaSourceFactorySupplier;
            this.trackSelectorSupplier = trackSelectorSupplier;
            this.loadControlSupplier = loadControlSupplier;
            this.bandwidthMeterSupplier = bandwidthMeterSupplier;
            this.analyticsCollectorFunction = analyticsCollectorFunction;
            this.looper = Util.getCurrentOrMainLooper();
            this.audioAttributes = AudioAttributes.DEFAULT;
            this.wakeMode = 0;
            this.videoScalingMode = 1;
            this.videoChangeFrameRateStrategy = 0;
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.seekBackIncrementMs = 5000L;
            this.seekForwardIncrementMs = 15000L;
            this.livePlaybackSpeedControl = new DefaultLivePlaybackSpeedControl.Builder().build();
            this.clock = Clock.DEFAULT;
            this.releaseTimeoutMs = 500L;
            this.detachSurfaceTimeoutMs = 2000L;
            this.usePlatformDiagnostics = true;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder experimentalSetForegroundModeTimeoutMs(long timeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.foregroundModeTimeoutMs = timeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSuppressPlaybackOnUnsuitableOutput(boolean suppressPlaybackOnUnsuitableOutput) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.suppressPlaybackOnUnsuitableOutput = suppressPlaybackOnUnsuitableOutput;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setRenderersFactory(RenderersFactory renderersFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)renderersFactory);
            this.renderersFactorySupplier = () -> renderersFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMediaSourceFactory(MediaSource.Factory mediaSourceFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)mediaSourceFactory);
            this.mediaSourceFactorySupplier = () -> mediaSourceFactory;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)trackSelector);
            this.trackSelectorSupplier = () -> trackSelector;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)loadControl);
            this.loadControlSupplier = () -> loadControl;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)bandwidthMeter);
            this.bandwidthMeterSupplier = () -> bandwidthMeter;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLooper(Looper looper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)looper);
            this.looper = looper;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)analyticsCollector);
            this.analyticsCollectorFunction = clock -> analyticsCollector;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.priorityTaskManager = priorityTaskManager;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.audioAttributes = (AudioAttributes)Assertions.checkNotNull((Object)audioAttributes);
            this.handleAudioFocus = handleAudioFocus;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWakeMode(int wakeMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.wakeMode = wakeMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.handleAudioBecomingNoisy = handleAudioBecomingNoisy;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSkipSilenceEnabled(boolean skipSilenceEnabled) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.skipSilenceEnabled = skipSilenceEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDeviceVolumeControlEnabled(boolean deviceVolumeControlEnabled) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.deviceVolumeControlEnabled = deviceVolumeControlEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setVideoScalingMode(int videoScalingMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.videoScalingMode = videoScalingMode;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setVideoChangeFrameRateStrategy(int videoChangeFrameRateStrategy) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.videoChangeFrameRateStrategy = videoChangeFrameRateStrategy;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekParameters = (SeekParameters)Assertions.checkNotNull((Object)seekParameters);
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSeekBackIncrementMs(@IntRange(from=1L) long seekBackIncrementMs) {
            Assertions.checkArgument((seekBackIncrementMs > 0L ? 1 : 0) != 0);
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekBackIncrementMs = seekBackIncrementMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setSeekForwardIncrementMs(@IntRange(from=1L) long seekForwardIncrementMs) {
            Assertions.checkArgument((seekForwardIncrementMs > 0L ? 1 : 0) != 0);
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekForwardIncrementMs = seekForwardIncrementMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setReleaseTimeoutMs(long releaseTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.releaseTimeoutMs = releaseTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setDetachSurfaceTimeoutMs(long detachSurfaceTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.detachSurfaceTimeoutMs = detachSurfaceTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setLivePlaybackSpeedControl(LivePlaybackSpeedControl livePlaybackSpeedControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.livePlaybackSpeedControl = (LivePlaybackSpeedControl)Assertions.checkNotNull((Object)livePlaybackSpeedControl);
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setUsePlatformDiagnostics(boolean usePlatformDiagnostics) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.usePlatformDiagnostics = usePlatformDiagnostics;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.clock = clock;
            return this;
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Builder setPlaybackLooper(Looper playbackLooper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.playbackLooper = playbackLooper;
            return this;
        }

        public ExoPlayer build() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            return new ExoPlayerImpl(this, null);
        }

        SimpleExoPlayer buildSimpleExoPlayer() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            return new SimpleExoPlayer(this);
        }
    }

    @UnstableApi
    public static interface AudioOffloadListener {
        default public void onSleepingForOffloadChanged(boolean isSleepingForOffload) {
        }

        default public void onOffloadedPlayback(boolean isOffloadedPlayback) {
        }
    }

    @Deprecated
    @UnstableApi
    public static interface DeviceComponent {
        @Deprecated
        public DeviceInfo getDeviceInfo();

        @Deprecated
        public int getDeviceVolume();

        @Deprecated
        public boolean isDeviceMuted();

        @Deprecated
        public void setDeviceVolume(int var1);

        @Deprecated
        public void increaseDeviceVolume();

        @Deprecated
        public void decreaseDeviceVolume();

        @Deprecated
        public void setDeviceMuted(boolean var1);
    }

    @Deprecated
    @UnstableApi
    public static interface TextComponent {
        @Deprecated
        public CueGroup getCurrentCues();
    }

    @Deprecated
    @UnstableApi
    public static interface VideoComponent {
        @Deprecated
        public void setVideoScalingMode(int var1);

        @Deprecated
        public int getVideoScalingMode();

        @Deprecated
        public void setVideoChangeFrameRateStrategy(int var1);

        @Deprecated
        public int getVideoChangeFrameRateStrategy();

        @Deprecated
        public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        @Deprecated
        public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        @Deprecated
        public void setCameraMotionListener(CameraMotionListener var1);

        @Deprecated
        public void clearCameraMotionListener(CameraMotionListener var1);

        @Deprecated
        public void clearVideoSurface();

        @Deprecated
        public void clearVideoSurface(@Nullable Surface var1);

        @Deprecated
        public void setVideoSurface(@Nullable Surface var1);

        @Deprecated
        public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        @Deprecated
        public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        @Deprecated
        public void setVideoSurfaceView(@Nullable SurfaceView var1);

        @Deprecated
        public void clearVideoSurfaceView(@Nullable SurfaceView var1);

        @Deprecated
        public void setVideoTextureView(@Nullable TextureView var1);

        @Deprecated
        public void clearVideoTextureView(@Nullable TextureView var1);

        @Deprecated
        public VideoSize getVideoSize();
    }

    @Deprecated
    @UnstableApi
    public static interface AudioComponent {
        @Deprecated
        public void setAudioAttributes(AudioAttributes var1, boolean var2);

        @Deprecated
        public AudioAttributes getAudioAttributes();

        @Deprecated
        public void setAudioSessionId(int var1);

        @Deprecated
        public int getAudioSessionId();

        @Deprecated
        public void setAuxEffectInfo(AuxEffectInfo var1);

        @Deprecated
        public void clearAuxEffectInfo();

        @Deprecated
        public void setVolume(float var1);

        @Deprecated
        public float getVolume();

        @Deprecated
        public void setSkipSilenceEnabled(boolean var1);

        @Deprecated
        public boolean getSkipSilenceEnabled();
    }
}

