/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Metadata;
import androidx.media3.common.ParserException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.HandlerWrapper;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.exoplayer.DefaultMediaClock;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.LivePlaybackSpeedControl;
import androidx.media3.exoplayer.LoadControl;
import androidx.media3.exoplayer.MediaPeriodHolder;
import androidx.media3.exoplayer.MediaPeriodInfo;
import androidx.media3.exoplayer.MediaPeriodQueue;
import androidx.media3.exoplayer.MediaSourceList;
import androidx.media3.exoplayer.PlaybackInfo;
import androidx.media3.exoplayer.PlayerMessage;
import androidx.media3.exoplayer.PlaylistTimeline;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.RendererConfiguration;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.metadata.MetadataRenderer;
import androidx.media3.exoplayer.source.BehindLiveWindowException;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.ShuffleOrder;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.text.TextRenderer;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelectorResult;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

final class ExoPlayerImplInternal
implements Handler.Callback,
MediaPeriod.Callback,
TrackSelector.InvalidationListener,
MediaSourceList.MediaSourceListInfoRefreshListener,
DefaultMediaClock.PlaybackParametersListener,
PlayerMessage.Sender {
    private static final String TAG = "ExoPlayerImplInternal";
    private static final int MSG_PREPARE = 0;
    private static final int MSG_SET_PLAY_WHEN_READY = 1;
    private static final int MSG_DO_SOME_WORK = 2;
    private static final int MSG_SEEK_TO = 3;
    private static final int MSG_SET_PLAYBACK_PARAMETERS = 4;
    private static final int MSG_SET_SEEK_PARAMETERS = 5;
    private static final int MSG_STOP = 6;
    private static final int MSG_RELEASE = 7;
    private static final int MSG_PERIOD_PREPARED = 8;
    private static final int MSG_SOURCE_CONTINUE_LOADING_REQUESTED = 9;
    private static final int MSG_TRACK_SELECTION_INVALIDATED = 10;
    private static final int MSG_SET_REPEAT_MODE = 11;
    private static final int MSG_SET_SHUFFLE_ENABLED = 12;
    private static final int MSG_SET_FOREGROUND_MODE = 13;
    private static final int MSG_SEND_MESSAGE = 14;
    private static final int MSG_SEND_MESSAGE_TO_TARGET_THREAD = 15;
    private static final int MSG_PLAYBACK_PARAMETERS_CHANGED_INTERNAL = 16;
    private static final int MSG_SET_MEDIA_SOURCES = 17;
    private static final int MSG_ADD_MEDIA_SOURCES = 18;
    private static final int MSG_MOVE_MEDIA_SOURCES = 19;
    private static final int MSG_REMOVE_MEDIA_SOURCES = 20;
    private static final int MSG_SET_SHUFFLE_ORDER = 21;
    private static final int MSG_PLAYLIST_UPDATE_REQUESTED = 22;
    private static final int MSG_SET_PAUSE_AT_END_OF_WINDOW = 23;
    private static final int MSG_ATTEMPT_RENDERER_ERROR_RECOVERY = 25;
    private static final int MSG_RENDERER_CAPABILITIES_CHANGED = 26;
    private static final int MSG_UPDATE_MEDIA_SOURCES_WITH_MEDIA_ITEMS = 27;
    private static final int ACTIVE_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private static final long PLAYBACK_STUCK_AFTER_MS = 4000L;
    private static final long PLAYBACK_BUFFER_EMPTY_THRESHOLD_US = 500000L;
    private final Renderer[] renderers;
    private final Set<Renderer> renderersToReset;
    private final RendererCapabilities[] rendererCapabilities;
    private final TrackSelector trackSelector;
    private final TrackSelectorResult emptyTrackSelectorResult;
    private final LoadControl loadControl;
    private final BandwidthMeter bandwidthMeter;
    private final HandlerWrapper handler;
    @Nullable
    private final HandlerThread internalPlaybackThread;
    private final Looper playbackLooper;
    private final Timeline.Window window;
    private final Timeline.Period period;
    private final long backBufferDurationUs;
    private final boolean retainBackBufferFromKeyframe;
    private final DefaultMediaClock mediaClock;
    private final ArrayList<PendingMessageInfo> pendingMessages;
    private final Clock clock;
    private final PlaybackInfoUpdateListener playbackInfoUpdateListener;
    private final MediaPeriodQueue queue;
    private final MediaSourceList mediaSourceList;
    private final LivePlaybackSpeedControl livePlaybackSpeedControl;
    private final long releaseTimeoutMs;
    private SeekParameters seekParameters;
    private PlaybackInfo playbackInfo;
    private PlaybackInfoUpdate playbackInfoUpdate;
    private boolean released;
    private boolean pauseAtEndOfWindow;
    private boolean pendingPauseAtEndOfPeriod;
    private boolean isRebuffering;
    private long lastRebufferRealtimeMs;
    private boolean shouldContinueLoading;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    private boolean foregroundMode;
    private boolean requestForRendererSleep;
    private boolean offloadSchedulingEnabled;
    private int enabledRendererCount;
    @Nullable
    private SeekPosition pendingInitialSeekPosition;
    private long rendererPositionUs;
    private int nextPendingMessageIndexHint;
    private boolean deliverPendingMessageAtStartPositionRequired;
    @Nullable
    private ExoPlaybackException pendingRecoverableRendererError;
    private long setForegroundModeTimeoutMs;
    private long playbackMaybeBecameStuckAtMs;

    public ExoPlayerImplInternal(Renderer[] renderers, TrackSelector trackSelector, TrackSelectorResult emptyTrackSelectorResult, LoadControl loadControl, BandwidthMeter bandwidthMeter, int repeatMode, boolean shuffleModeEnabled, AnalyticsCollector analyticsCollector, SeekParameters seekParameters, LivePlaybackSpeedControl livePlaybackSpeedControl, long releaseTimeoutMs, boolean pauseAtEndOfWindow, Looper applicationLooper, Clock clock, PlaybackInfoUpdateListener playbackInfoUpdateListener, PlayerId playerId, Looper playbackLooper) {
        this.playbackInfoUpdateListener = playbackInfoUpdateListener;
        this.renderers = renderers;
        this.trackSelector = trackSelector;
        this.emptyTrackSelectorResult = emptyTrackSelectorResult;
        this.loadControl = loadControl;
        this.bandwidthMeter = bandwidthMeter;
        this.repeatMode = repeatMode;
        this.shuffleModeEnabled = shuffleModeEnabled;
        this.seekParameters = seekParameters;
        this.livePlaybackSpeedControl = livePlaybackSpeedControl;
        this.releaseTimeoutMs = releaseTimeoutMs;
        this.setForegroundModeTimeoutMs = releaseTimeoutMs;
        this.pauseAtEndOfWindow = pauseAtEndOfWindow;
        this.clock = clock;
        this.playbackMaybeBecameStuckAtMs = -9223372036854775807L;
        this.lastRebufferRealtimeMs = -9223372036854775807L;
        this.backBufferDurationUs = loadControl.getBackBufferDurationUs();
        this.retainBackBufferFromKeyframe = loadControl.retainBackBufferFromKeyframe();
        this.playbackInfo = PlaybackInfo.createDummy(emptyTrackSelectorResult);
        this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        this.rendererCapabilities = new RendererCapabilities[renderers.length];
        RendererCapabilities.Listener rendererCapabilitiesListener = trackSelector.getRendererCapabilitiesListener();
        for (int i = 0; i < renderers.length; ++i) {
            renderers[i].init(i, playerId, clock);
            this.rendererCapabilities[i] = renderers[i].getCapabilities();
            if (rendererCapabilitiesListener == null) continue;
            this.rendererCapabilities[i].setListener(rendererCapabilitiesListener);
        }
        this.mediaClock = new DefaultMediaClock(this, clock);
        this.pendingMessages = new ArrayList();
        this.renderersToReset = Sets.newIdentityHashSet();
        this.window = new Timeline.Window();
        this.period = new Timeline.Period();
        trackSelector.init(this, bandwidthMeter);
        this.deliverPendingMessageAtStartPositionRequired = true;
        HandlerWrapper eventHandler = clock.createHandler(applicationLooper, null);
        this.queue = new MediaPeriodQueue(analyticsCollector, eventHandler, this::createMediaPeriodHolder);
        this.mediaSourceList = new MediaSourceList(this, analyticsCollector, eventHandler, playerId);
        if (playbackLooper != null) {
            this.internalPlaybackThread = null;
            this.playbackLooper = playbackLooper;
        } else {
            this.internalPlaybackThread = new HandlerThread("ExoPlayer:Playback", -16);
            this.internalPlaybackThread.start();
            this.playbackLooper = this.internalPlaybackThread.getLooper();
        }
        this.handler = clock.createHandler(this.playbackLooper, (Handler.Callback)this);
    }

    private MediaPeriodHolder createMediaPeriodHolder(MediaPeriodInfo mediaPeriodInfo, long rendererPositionOffsetUs) {
        return new MediaPeriodHolder(this.rendererCapabilities, rendererPositionOffsetUs, this.trackSelector, this.loadControl.getAllocator(), this.mediaSourceList, mediaPeriodInfo, this.emptyTrackSelectorResult);
    }

    public void experimentalSetForegroundModeTimeoutMs(long setForegroundModeTimeoutMs) {
        this.setForegroundModeTimeoutMs = setForegroundModeTimeoutMs;
    }

    public void prepare() {
        this.handler.obtainMessage(0).sendToTarget();
    }

    public void setPlayWhenReady(boolean playWhenReady, int playbackSuppressionReason) {
        this.handler.obtainMessage(1, playWhenReady ? 1 : 0, playbackSuppressionReason).sendToTarget();
    }

    public void setPauseAtEndOfWindow(boolean pauseAtEndOfWindow) {
        this.handler.obtainMessage(23, pauseAtEndOfWindow ? 1 : 0, 0).sendToTarget();
    }

    public void setRepeatMode(int repeatMode) {
        this.handler.obtainMessage(11, repeatMode, 0).sendToTarget();
    }

    public void setShuffleModeEnabled(boolean shuffleModeEnabled) {
        this.handler.obtainMessage(12, shuffleModeEnabled ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(Timeline timeline, int windowIndex, long positionUs) {
        this.handler.obtainMessage(3, (Object)new SeekPosition(timeline, windowIndex, positionUs)).sendToTarget();
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.handler.obtainMessage(4, (Object)playbackParameters).sendToTarget();
    }

    public void setSeekParameters(SeekParameters seekParameters) {
        this.handler.obtainMessage(5, (Object)seekParameters).sendToTarget();
    }

    public void stop() {
        this.handler.obtainMessage(6).sendToTarget();
    }

    public void setMediaSources(List<MediaSourceList.MediaSourceHolder> mediaSources, int windowIndex, long positionUs, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(17, (Object)new MediaSourceListUpdateMessage(mediaSources, shuffleOrder, windowIndex, positionUs)).sendToTarget();
    }

    public void addMediaSources(int index, List<MediaSourceList.MediaSourceHolder> mediaSources, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(18, index, 0, (Object)new MediaSourceListUpdateMessage(mediaSources, shuffleOrder, -1, -9223372036854775807L)).sendToTarget();
    }

    public void removeMediaSources(int fromIndex, int toIndex, ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(20, fromIndex, toIndex, (Object)shuffleOrder).sendToTarget();
    }

    public void moveMediaSources(int fromIndex, int toIndex, int newFromIndex, ShuffleOrder shuffleOrder) {
        MoveMediaItemsMessage moveMediaItemsMessage = new MoveMediaItemsMessage(fromIndex, toIndex, newFromIndex, shuffleOrder);
        this.handler.obtainMessage(19, (Object)moveMediaItemsMessage).sendToTarget();
    }

    public void setShuffleOrder(ShuffleOrder shuffleOrder) {
        this.handler.obtainMessage(21, (Object)shuffleOrder).sendToTarget();
    }

    public void updateMediaSourcesWithMediaItems(int fromIndex, int toIndex, List<MediaItem> mediaItems) {
        this.handler.obtainMessage(27, fromIndex, toIndex, mediaItems).sendToTarget();
    }

    @Override
    public synchronized void sendMessage(PlayerMessage message) {
        if (this.released || !this.playbackLooper.getThread().isAlive()) {
            Log.w((String)TAG, (String)"Ignoring messages sent after release.");
            message.markAsProcessed(false);
            return;
        }
        this.handler.obtainMessage(14, (Object)message).sendToTarget();
    }

    public synchronized boolean setForegroundMode(boolean foregroundMode) {
        if (this.released || !this.playbackLooper.getThread().isAlive()) {
            return true;
        }
        if (foregroundMode) {
            this.handler.obtainMessage(13, 1, 0).sendToTarget();
            return true;
        }
        AtomicBoolean processedFlag = new AtomicBoolean();
        this.handler.obtainMessage(13, 0, 0, (Object)processedFlag).sendToTarget();
        this.waitUninterruptibly((Supplier<Boolean>)((Supplier)processedFlag::get), this.setForegroundModeTimeoutMs);
        return processedFlag.get();
    }

    public synchronized boolean release() {
        if (this.released || !this.playbackLooper.getThread().isAlive()) {
            return true;
        }
        this.handler.sendEmptyMessage(7);
        this.waitUninterruptibly((Supplier<Boolean>)((Supplier)() -> this.released), this.releaseTimeoutMs);
        return this.released;
    }

    public Looper getPlaybackLooper() {
        return this.playbackLooper;
    }

    @Override
    public void onPlaylistUpdateRequested() {
        this.handler.sendEmptyMessage(22);
    }

    @Override
    public void onPrepared(MediaPeriod source) {
        this.handler.obtainMessage(8, (Object)source).sendToTarget();
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        this.handler.obtainMessage(9, (Object)source).sendToTarget();
    }

    @Override
    public void onTrackSelectionsInvalidated() {
        this.handler.sendEmptyMessage(10);
    }

    @Override
    public void onRendererCapabilitiesChanged(Renderer renderer) {
        this.handler.sendEmptyMessage(26);
    }

    @Override
    public void onPlaybackParametersChanged(PlaybackParameters newPlaybackParameters) {
        this.handler.obtainMessage(16, (Object)newPlaybackParameters).sendToTarget();
    }

    public boolean handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 0: {
                    this.prepareInternal();
                    break;
                }
                case 1: {
                    this.setPlayWhenReadyInternal(msg.arg1 != 0, msg.arg2, true, 1);
                    break;
                }
                case 11: {
                    this.setRepeatModeInternal(msg.arg1);
                    break;
                }
                case 12: {
                    this.setShuffleModeEnabledInternal(msg.arg1 != 0);
                    break;
                }
                case 2: {
                    this.doSomeWork();
                    break;
                }
                case 3: {
                    this.seekToInternal((SeekPosition)msg.obj);
                    break;
                }
                case 4: {
                    this.setPlaybackParametersInternal((PlaybackParameters)msg.obj);
                    break;
                }
                case 5: {
                    this.setSeekParametersInternal((SeekParameters)msg.obj);
                    break;
                }
                case 13: {
                    this.setForegroundModeInternal(msg.arg1 != 0, (AtomicBoolean)msg.obj);
                    break;
                }
                case 6: {
                    this.stopInternal(false, true);
                    break;
                }
                case 8: {
                    this.handlePeriodPrepared((MediaPeriod)msg.obj);
                    break;
                }
                case 9: {
                    this.handleContinueLoadingRequested((MediaPeriod)msg.obj);
                    break;
                }
                case 10: {
                    this.reselectTracksInternal();
                    break;
                }
                case 16: {
                    this.handlePlaybackParameters((PlaybackParameters)msg.obj, false);
                    break;
                }
                case 14: {
                    this.sendMessageInternal((PlayerMessage)msg.obj);
                    break;
                }
                case 15: {
                    this.sendMessageToTargetThread((PlayerMessage)msg.obj);
                    break;
                }
                case 17: {
                    this.setMediaItemsInternal((MediaSourceListUpdateMessage)msg.obj);
                    break;
                }
                case 18: {
                    this.addMediaItemsInternal((MediaSourceListUpdateMessage)msg.obj, msg.arg1);
                    break;
                }
                case 19: {
                    this.moveMediaItemsInternal((MoveMediaItemsMessage)msg.obj);
                    break;
                }
                case 20: {
                    this.removeMediaItemsInternal(msg.arg1, msg.arg2, (ShuffleOrder)msg.obj);
                    break;
                }
                case 21: {
                    this.setShuffleOrderInternal((ShuffleOrder)msg.obj);
                    break;
                }
                case 22: {
                    this.mediaSourceListUpdateRequestedInternal();
                    break;
                }
                case 23: {
                    this.setPauseAtEndOfWindowInternal(msg.arg1 != 0);
                    break;
                }
                case 25: {
                    this.attemptRendererErrorRecovery();
                    break;
                }
                case 26: {
                    this.reselectTracksInternalAndSeek();
                    break;
                }
                case 27: {
                    this.updateMediaSourcesWithMediaItemsInternal(msg.arg1, msg.arg2, (List)msg.obj);
                    break;
                }
                case 7: {
                    this.releaseInternal();
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        catch (ExoPlaybackException e) {
            MediaPeriodHolder readingPeriod;
            if (e.type == 1 && (readingPeriod = this.queue.getReadingPeriod()) != null) {
                e = e.copyWithMediaPeriodId(readingPeriod.info.id);
            }
            if (e.isRecoverable && (this.pendingRecoverableRendererError == null || e.errorCode == 5003)) {
                Log.w((String)TAG, (String)"Recoverable renderer error", (Throwable)((Object)e));
                if (this.pendingRecoverableRendererError != null) {
                    this.pendingRecoverableRendererError.addSuppressed((Throwable)((Object)e));
                    e = this.pendingRecoverableRendererError;
                } else {
                    this.pendingRecoverableRendererError = e;
                }
                this.handler.sendMessageAtFrontOfQueue(this.handler.obtainMessage(25, (Object)e));
            } else {
                if (this.pendingRecoverableRendererError != null) {
                    this.pendingRecoverableRendererError.addSuppressed((Throwable)((Object)e));
                    e = this.pendingRecoverableRendererError;
                }
                Log.e((String)TAG, (String)"Playback error", (Throwable)((Object)e));
                if (e.type == 1 && this.queue.getPlayingPeriod() != this.queue.getReadingPeriod()) {
                    while (this.queue.getPlayingPeriod() != this.queue.getReadingPeriod()) {
                        this.queue.advancePlayingPeriod();
                    }
                    MediaPeriodHolder newPlayingPeriodHolder = (MediaPeriodHolder)Assertions.checkNotNull((Object)this.queue.getPlayingPeriod());
                    this.playbackInfo = this.handlePositionDiscontinuity(newPlayingPeriodHolder.info.id, newPlayingPeriodHolder.info.startPositionUs, newPlayingPeriodHolder.info.requestedContentPositionUs, newPlayingPeriodHolder.info.startPositionUs, true, 0);
                }
                this.stopInternal(true, false);
                this.playbackInfo = this.playbackInfo.copyWithPlaybackError(e);
            }
        }
        catch (DrmSession.DrmSessionException e) {
            this.handleIoException(e, e.errorCode);
        }
        catch (ParserException e) {
            int errorCode = e.dataType == 1 ? (e.contentIsMalformed ? 3001 : 3003) : (e.dataType == 4 ? (e.contentIsMalformed ? 3002 : 3004) : 1000);
            this.handleIoException((IOException)((Object)e), errorCode);
        }
        catch (DataSourceException e) {
            this.handleIoException((IOException)((Object)e), e.reason);
        }
        catch (BehindLiveWindowException e) {
            this.handleIoException(e, 1002);
        }
        catch (IOException e) {
            this.handleIoException(e, 2000);
        }
        catch (RuntimeException e) {
            int errorCode = e instanceof IllegalStateException || e instanceof IllegalArgumentException ? 1004 : 1000;
            ExoPlaybackException error = ExoPlaybackException.createForUnexpected(e, errorCode);
            Log.e((String)TAG, (String)"Playback error", (Throwable)((Object)error));
            this.stopInternal(true, false);
            this.playbackInfo = this.playbackInfo.copyWithPlaybackError(error);
        }
        this.maybeNotifyPlaybackInfoChanged();
        return true;
    }

    private void handleIoException(IOException e, int errorCode) {
        ExoPlaybackException error = ExoPlaybackException.createForSource(e, errorCode);
        MediaPeriodHolder playingPeriod = this.queue.getPlayingPeriod();
        if (playingPeriod != null) {
            error = error.copyWithMediaPeriodId(playingPeriod.info.id);
        }
        Log.e((String)TAG, (String)"Playback error", (Throwable)((Object)error));
        this.stopInternal(false, false);
        this.playbackInfo = this.playbackInfo.copyWithPlaybackError(error);
    }

    private synchronized void waitUninterruptibly(Supplier<Boolean> condition, long timeoutMs) {
        long deadlineMs = this.clock.elapsedRealtime() + timeoutMs;
        long remainingMs = timeoutMs;
        boolean wasInterrupted = false;
        while (!((Boolean)condition.get()).booleanValue() && remainingMs > 0L) {
            try {
                this.clock.onThreadBlocked();
                this.wait(remainingMs);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
            remainingMs = deadlineMs - this.clock.elapsedRealtime();
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void setState(int state) {
        if (this.playbackInfo.playbackState != state) {
            if (state != 2) {
                this.playbackMaybeBecameStuckAtMs = -9223372036854775807L;
            }
            this.playbackInfo = this.playbackInfo.copyWithPlaybackState(state);
        }
    }

    private void maybeNotifyPlaybackInfoChanged() {
        this.playbackInfoUpdate.setPlaybackInfo(this.playbackInfo);
        if (this.playbackInfoUpdate.hasPendingChange) {
            this.playbackInfoUpdateListener.onPlaybackInfoUpdate(this.playbackInfoUpdate);
            this.playbackInfoUpdate = new PlaybackInfoUpdate(this.playbackInfo);
        }
    }

    private void prepareInternal() {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        this.resetInternal(false, false, false, true);
        this.loadControl.onPrepared();
        this.setState(this.playbackInfo.timeline.isEmpty() ? 4 : 2);
        this.mediaSourceList.prepare(this.bandwidthMeter.getTransferListener());
        this.handler.sendEmptyMessage(2);
    }

    private void setMediaItemsInternal(MediaSourceListUpdateMessage mediaSourceListUpdateMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        if (mediaSourceListUpdateMessage.windowIndex != -1) {
            this.pendingInitialSeekPosition = new SeekPosition(new PlaylistTimeline(mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder), mediaSourceListUpdateMessage.windowIndex, mediaSourceListUpdateMessage.positionUs);
        }
        Timeline timeline = this.mediaSourceList.setMediaSources(mediaSourceListUpdateMessage.mediaSourceHolders, mediaSourceListUpdateMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void addMediaItemsInternal(MediaSourceListUpdateMessage addMessage, int insertionIndex) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.addMediaSources(insertionIndex == -1 ? this.mediaSourceList.getSize() : insertionIndex, addMessage.mediaSourceHolders, addMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void moveMediaItemsInternal(MoveMediaItemsMessage moveMediaItemsMessage) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.moveMediaSourceRange(moveMediaItemsMessage.fromIndex, moveMediaItemsMessage.toIndex, moveMediaItemsMessage.newFromIndex, moveMediaItemsMessage.shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void removeMediaItemsInternal(int fromIndex, int toIndex, ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.removeMediaSourceRange(fromIndex, toIndex, shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void mediaSourceListUpdateRequestedInternal() throws ExoPlaybackException {
        this.handleMediaSourceListInfoRefreshed(this.mediaSourceList.createTimeline(), true);
    }

    private void setShuffleOrderInternal(ShuffleOrder shuffleOrder) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.setShuffleOrder(shuffleOrder);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void updateMediaSourcesWithMediaItemsInternal(int fromIndex, int toIndex, List<MediaItem> mediaItems) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Timeline timeline = this.mediaSourceList.updateMediaSourcesWithMediaItems(fromIndex, toIndex, mediaItems);
        this.handleMediaSourceListInfoRefreshed(timeline, false);
    }

    private void notifyTrackSelectionPlayWhenReadyChanged(boolean playWhenReady) {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            for (ExoTrackSelection trackSelection : periodHolder.getTrackSelectorResult().selections) {
                if (trackSelection == null) continue;
                trackSelection.onPlayWhenReadyChanged(playWhenReady);
            }
        }
    }

    private void setPlayWhenReadyInternal(boolean playWhenReady, int playbackSuppressionReason, boolean operationAck, int reason) throws ExoPlaybackException {
        this.playbackInfoUpdate.incrementPendingOperationAcks(operationAck ? 1 : 0);
        this.playbackInfoUpdate.setPlayWhenReadyChangeReason(reason);
        this.playbackInfo = this.playbackInfo.copyWithPlayWhenReady(playWhenReady, playbackSuppressionReason);
        this.updateRebufferingState(false, false);
        this.notifyTrackSelectionPlayWhenReadyChanged(playWhenReady);
        if (!this.shouldPlayWhenReady()) {
            this.stopRenderers();
            this.updatePlaybackPositions();
        } else if (this.playbackInfo.playbackState == 3) {
            this.startRenderers();
            this.handler.sendEmptyMessage(2);
        } else if (this.playbackInfo.playbackState == 2) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setPauseAtEndOfWindowInternal(boolean pauseAtEndOfWindow) throws ExoPlaybackException {
        this.pauseAtEndOfWindow = pauseAtEndOfWindow;
        this.resetPendingPauseAtEndOfPeriod();
        if (this.pendingPauseAtEndOfPeriod && this.queue.getReadingPeriod() != this.queue.getPlayingPeriod()) {
            this.seekToCurrentPosition(true);
            this.handleLoadingMediaPeriodChanged(false);
        }
    }

    private void setOffloadSchedulingEnabled(boolean offloadSchedulingEnabled) {
        if (offloadSchedulingEnabled == this.offloadSchedulingEnabled) {
            return;
        }
        this.offloadSchedulingEnabled = offloadSchedulingEnabled;
        if (!offloadSchedulingEnabled && this.playbackInfo.sleepingForOffload) {
            this.handler.sendEmptyMessage(2);
        }
    }

    private void setRepeatModeInternal(int repeatMode) throws ExoPlaybackException {
        this.repeatMode = repeatMode;
        if (!this.queue.updateRepeatMode(this.playbackInfo.timeline, repeatMode)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void setShuffleModeEnabledInternal(boolean shuffleModeEnabled) throws ExoPlaybackException {
        this.shuffleModeEnabled = shuffleModeEnabled;
        if (!this.queue.updateShuffleModeEnabled(this.playbackInfo.timeline, shuffleModeEnabled)) {
            this.seekToCurrentPosition(true);
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void seekToCurrentPosition(boolean sendDiscontinuity) throws ExoPlaybackException {
        MediaSource.MediaPeriodId periodId = this.queue.getPlayingPeriod().info.id;
        long newPositionUs = this.seekToPeriodPosition(periodId, this.playbackInfo.positionUs, true, false);
        if (newPositionUs != this.playbackInfo.positionUs) {
            this.playbackInfo = this.handlePositionDiscontinuity(periodId, newPositionUs, this.playbackInfo.requestedContentPositionUs, this.playbackInfo.discontinuityStartPositionUs, sendDiscontinuity, 5);
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        this.updateRebufferingState(false, false);
        this.mediaClock.start();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.mediaClock.stop();
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            this.ensureStopped(renderer);
        }
    }

    private void attemptRendererErrorRecovery() throws ExoPlaybackException {
        this.reselectTracksInternalAndSeek();
    }

    private void updatePlaybackPositions() throws ExoPlaybackException {
        float adjustedSpeed;
        long discontinuityPositionUs;
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            return;
        }
        long l = discontinuityPositionUs = playingPeriodHolder.prepared ? playingPeriodHolder.mediaPeriod.readDiscontinuity() : -9223372036854775807L;
        if (discontinuityPositionUs != -9223372036854775807L) {
            if (!playingPeriodHolder.isFullyBuffered()) {
                this.queue.removeAfter(playingPeriodHolder);
                this.handleLoadingMediaPeriodChanged(false);
                this.maybeContinueLoading();
            }
            this.resetRendererPosition(discontinuityPositionUs);
            if (discontinuityPositionUs != this.playbackInfo.positionUs) {
                this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, discontinuityPositionUs, this.playbackInfo.requestedContentPositionUs, discontinuityPositionUs, true, 5);
            }
        } else {
            this.rendererPositionUs = this.mediaClock.syncAndGetPositionUs(playingPeriodHolder != this.queue.getReadingPeriod());
            long periodPositionUs = playingPeriodHolder.toPeriodTime(this.rendererPositionUs);
            this.maybeTriggerPendingMessages(this.playbackInfo.positionUs, periodPositionUs);
            if (this.mediaClock.hasSkippedSilenceSinceLastCall()) {
                this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, periodPositionUs, this.playbackInfo.requestedContentPositionUs, periodPositionUs, true, 6);
            } else {
                this.playbackInfo.updatePositionUs(periodPositionUs);
            }
        }
        MediaPeriodHolder loadingPeriod = this.queue.getLoadingPeriod();
        this.playbackInfo.bufferedPositionUs = loadingPeriod.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if (this.playbackInfo.playWhenReady && this.playbackInfo.playbackState == 3 && this.shouldUseLivePlaybackSpeedControl(this.playbackInfo.timeline, this.playbackInfo.periodId) && this.playbackInfo.playbackParameters.speed == 1.0f && this.mediaClock.getPlaybackParameters().speed != (adjustedSpeed = this.livePlaybackSpeedControl.getAdjustedPlaybackSpeed(this.getCurrentLiveOffsetUs(), this.getTotalBufferedDurationUs()))) {
            this.setMediaClockPlaybackParameters(this.playbackInfo.playbackParameters.withSpeed(adjustedSpeed));
            this.handlePlaybackParameters(this.playbackInfo.playbackParameters, this.mediaClock.getPlaybackParameters().speed, false, false);
        }
    }

    private void setMediaClockPlaybackParameters(PlaybackParameters playbackParameters) {
        this.handler.removeMessages(16);
        this.mediaClock.setPlaybackParameters(playbackParameters);
    }

    private void notifyTrackSelectionRebuffer() {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            for (ExoTrackSelection trackSelection : periodHolder.getTrackSelectorResult().selections) {
                if (trackSelection == null) continue;
                trackSelection.onRebuffer();
            }
        }
    }

    private void doSomeWork() throws ExoPlaybackException, IOException {
        boolean sleepingForOffload;
        boolean finishedRendering;
        long operationStartTimeMs = this.clock.uptimeMillis();
        this.handler.removeMessages(2);
        this.updatePeriods();
        if (this.playbackInfo.playbackState == 1 || this.playbackInfo.playbackState == 4) {
            return;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            this.scheduleNextWork(operationStartTimeMs, 10L);
            return;
        }
        TraceUtil.beginSection((String)"doSomeWork");
        this.updatePlaybackPositions();
        boolean renderersEnded = true;
        boolean renderersAllowPlayback = true;
        if (playingPeriodHolder.prepared) {
            long rendererPositionElapsedRealtimeUs = Util.msToUs((long)this.clock.elapsedRealtime());
            playingPeriodHolder.mediaPeriod.discardBuffer(this.playbackInfo.positionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
                renderer.render(this.rendererPositionUs, rendererPositionElapsedRealtimeUs);
                renderersEnded = renderersEnded && renderer.isEnded();
                boolean isReadingAhead = playingPeriodHolder.sampleStreams[i] != renderer.getStream();
                boolean isWaitingForNextStream = !isReadingAhead && renderer.hasReadStreamToEnd();
                boolean allowsPlayback = isReadingAhead || isWaitingForNextStream || renderer.isReady() || renderer.isEnded();
                boolean bl = renderersAllowPlayback = renderersAllowPlayback && allowsPlayback;
                if (allowsPlayback) continue;
                renderer.maybeThrowStreamError();
            }
        } else {
            playingPeriodHolder.mediaPeriod.maybeThrowPrepareError();
        }
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        boolean bl = finishedRendering = renderersEnded && playingPeriodHolder.prepared && (playingPeriodDurationUs == -9223372036854775807L || playingPeriodDurationUs <= this.playbackInfo.positionUs);
        if (finishedRendering && this.pendingPauseAtEndOfPeriod) {
            this.pendingPauseAtEndOfPeriod = false;
            this.setPlayWhenReadyInternal(false, this.playbackInfo.playbackSuppressionReason, false, 5);
        }
        if (finishedRendering && playingPeriodHolder.info.isFinal) {
            this.setState(4);
            this.stopRenderers();
        } else if (this.playbackInfo.playbackState == 2 && this.shouldTransitionToReadyState(renderersAllowPlayback)) {
            this.setState(3);
            this.pendingRecoverableRendererError = null;
            if (this.shouldPlayWhenReady()) {
                this.startRenderers();
            }
        } else if (this.playbackInfo.playbackState == 3 && !(this.enabledRendererCount != 0 ? renderersAllowPlayback : this.isTimelineReady())) {
            this.updateRebufferingState(this.shouldPlayWhenReady(), false);
            this.setState(2);
            if (this.isRebuffering) {
                this.notifyTrackSelectionRebuffer();
                this.livePlaybackSpeedControl.notifyRebuffer();
            }
            this.stopRenderers();
        }
        boolean playbackMaybeStuck = false;
        if (this.playbackInfo.playbackState == 2) {
            for (int i = 0; i < this.renderers.length; ++i) {
                if (!ExoPlayerImplInternal.isRendererEnabled(this.renderers[i]) || this.renderers[i].getStream() != playingPeriodHolder.sampleStreams[i]) continue;
                this.renderers[i].maybeThrowStreamError();
            }
            if (!this.playbackInfo.isLoading && this.playbackInfo.totalBufferedDurationUs < 500000L && this.isLoadingPossible()) {
                playbackMaybeStuck = true;
            }
        }
        if (!playbackMaybeStuck) {
            this.playbackMaybeBecameStuckAtMs = -9223372036854775807L;
        } else if (this.playbackMaybeBecameStuckAtMs == -9223372036854775807L) {
            this.playbackMaybeBecameStuckAtMs = this.clock.elapsedRealtime();
        } else if (this.clock.elapsedRealtime() - this.playbackMaybeBecameStuckAtMs >= 4000L) {
            throw new IllegalStateException("Playback stuck buffering and not loading");
        }
        boolean isPlaying = this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3;
        boolean bl2 = sleepingForOffload = this.offloadSchedulingEnabled && this.requestForRendererSleep && isPlaying;
        if (this.playbackInfo.sleepingForOffload != sleepingForOffload) {
            this.playbackInfo = this.playbackInfo.copyWithSleepingForOffload(sleepingForOffload);
        }
        this.requestForRendererSleep = false;
        if (!sleepingForOffload && this.playbackInfo.playbackState != 4) {
            if (isPlaying || this.playbackInfo.playbackState == 2) {
                this.scheduleNextWork(operationStartTimeMs, 10L);
            } else if (this.playbackInfo.playbackState == 3 && this.enabledRendererCount != 0) {
                this.scheduleNextWork(operationStartTimeMs, 1000L);
            }
        }
        TraceUtil.endSection();
    }

    private long getCurrentLiveOffsetUs() {
        return this.getLiveOffsetUs(this.playbackInfo.timeline, this.playbackInfo.periodId.periodUid, this.playbackInfo.positionUs);
    }

    private long getLiveOffsetUs(Timeline timeline, Object periodUid, long periodPositionUs) {
        int windowIndex = timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)this.period).windowIndex;
        timeline.getWindow(windowIndex, this.window);
        if (this.window.windowStartTimeMs == -9223372036854775807L || !this.window.isLive() || !this.window.isDynamic) {
            return -9223372036854775807L;
        }
        return Util.msToUs((long)(this.window.getCurrentUnixTimeMs() - this.window.windowStartTimeMs)) - (periodPositionUs + this.period.getPositionInWindowUs());
    }

    private boolean shouldUseLivePlaybackSpeedControl(Timeline timeline, MediaSource.MediaPeriodId mediaPeriodId) {
        if (mediaPeriodId.isAd() || timeline.isEmpty()) {
            return false;
        }
        int windowIndex = timeline.getPeriodByUid((Object)mediaPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
        timeline.getWindow(windowIndex, this.window);
        return this.window.isLive() && this.window.isDynamic && this.window.windowStartTimeMs != -9223372036854775807L;
    }

    private void scheduleNextWork(long thisOperationStartTimeMs, long intervalMs) {
        this.handler.sendEmptyMessageAtTime(2, thisOperationStartTimeMs + intervalMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(SeekPosition seekPosition) throws ExoPlaybackException {
        boolean seekPositionAdjusted;
        long requestedContentPositionUs;
        long periodPositionUs;
        MediaSource.MediaPeriodId periodId;
        this.playbackInfoUpdate.incrementPendingOperationAcks(1);
        Pair<Object, Long> resolvedSeekPosition = ExoPlayerImplInternal.resolveSeekPositionUs(this.playbackInfo.timeline, seekPosition, true, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
        if (resolvedSeekPosition == null) {
            Pair<MediaSource.MediaPeriodId, Long> firstPeriodAndPositionUs = this.getPlaceholderFirstMediaPeriodPositionUs(this.playbackInfo.timeline);
            periodId = (MediaSource.MediaPeriodId)firstPeriodAndPositionUs.first;
            periodPositionUs = (Long)firstPeriodAndPositionUs.second;
            requestedContentPositionUs = -9223372036854775807L;
            seekPositionAdjusted = !this.playbackInfo.timeline.isEmpty();
        } else {
            Object periodUid = resolvedSeekPosition.first;
            long resolvedContentPositionUs = (Long)resolvedSeekPosition.second;
            requestedContentPositionUs = seekPosition.windowPositionUs == -9223372036854775807L ? -9223372036854775807L : resolvedContentPositionUs;
            periodId = this.queue.resolveMediaPeriodIdForAdsAfterPeriodPositionChange(this.playbackInfo.timeline, periodUid, resolvedContentPositionUs);
            if (periodId.isAd()) {
                this.playbackInfo.timeline.getPeriodByUid(periodId.periodUid, this.period);
                periodPositionUs = this.period.getFirstAdIndexToPlay(periodId.adGroupIndex) == periodId.adIndexInAdGroup ? this.period.getAdResumePositionUs() : 0L;
                seekPositionAdjusted = true;
            } else {
                periodPositionUs = resolvedContentPositionUs;
                seekPositionAdjusted = seekPosition.windowPositionUs == -9223372036854775807L;
            }
        }
        try {
            if (this.playbackInfo.timeline.isEmpty()) {
                this.pendingInitialSeekPosition = seekPosition;
            } else if (resolvedSeekPosition == null) {
                if (this.playbackInfo.playbackState != 1) {
                    this.setState(4);
                }
                this.resetInternal(false, true, false, true);
            } else {
                long newPeriodPositionUs = periodPositionUs;
                if (periodId.equals(this.playbackInfo.periodId)) {
                    MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
                    if (playingPeriodHolder != null && playingPeriodHolder.prepared && newPeriodPositionUs != 0L) {
                        newPeriodPositionUs = playingPeriodHolder.mediaPeriod.getAdjustedSeekPositionUs(newPeriodPositionUs, this.seekParameters);
                    }
                    if (Util.usToMs((long)newPeriodPositionUs) == Util.usToMs((long)this.playbackInfo.positionUs) && (this.playbackInfo.playbackState == 2 || this.playbackInfo.playbackState == 3)) {
                        periodPositionUs = this.playbackInfo.positionUs;
                        return;
                    }
                }
                newPeriodPositionUs = this.seekToPeriodPosition(periodId, newPeriodPositionUs, this.playbackInfo.playbackState == 4);
                seekPositionAdjusted |= periodPositionUs != newPeriodPositionUs;
                periodPositionUs = newPeriodPositionUs;
                this.updatePlaybackSpeedSettingsForNewPeriod(this.playbackInfo.timeline, periodId, this.playbackInfo.timeline, this.playbackInfo.periodId, requestedContentPositionUs, true);
            }
        }
        finally {
            this.playbackInfo = this.handlePositionDiscontinuity(periodId, periodPositionUs, requestedContentPositionUs, periodPositionUs, seekPositionAdjusted, 2);
        }
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs, boolean forceBufferingState) throws ExoPlaybackException {
        return this.seekToPeriodPosition(periodId, periodPositionUs, this.queue.getPlayingPeriod() != this.queue.getReadingPeriod(), forceBufferingState);
    }

    private long seekToPeriodPosition(MediaSource.MediaPeriodId periodId, long periodPositionUs, boolean forceDisableRenderers, boolean forceBufferingState) throws ExoPlaybackException {
        MediaPeriodHolder oldPlayingPeriodHolder;
        MediaPeriodHolder newPlayingPeriodHolder;
        this.stopRenderers();
        this.updateRebufferingState(false, true);
        if (forceBufferingState || this.playbackInfo.playbackState == 3) {
            this.setState(2);
        }
        for (newPlayingPeriodHolder = oldPlayingPeriodHolder = this.queue.getPlayingPeriod(); newPlayingPeriodHolder != null && !periodId.equals(newPlayingPeriodHolder.info.id); newPlayingPeriodHolder = newPlayingPeriodHolder.getNext()) {
        }
        if (forceDisableRenderers || oldPlayingPeriodHolder != newPlayingPeriodHolder || newPlayingPeriodHolder != null && newPlayingPeriodHolder.toRendererTime(periodPositionUs) < 0L) {
            for (Renderer renderer : this.renderers) {
                this.disableRenderer(renderer);
            }
            if (newPlayingPeriodHolder != null) {
                while (this.queue.getPlayingPeriod() != newPlayingPeriodHolder) {
                    this.queue.advancePlayingPeriod();
                }
                this.queue.removeAfter(newPlayingPeriodHolder);
                newPlayingPeriodHolder.setRendererOffset(1000000000000L);
                this.enableRenderers();
            }
        }
        if (newPlayingPeriodHolder != null) {
            this.queue.removeAfter(newPlayingPeriodHolder);
            if (!newPlayingPeriodHolder.prepared) {
                newPlayingPeriodHolder.info = newPlayingPeriodHolder.info.copyWithStartPositionUs(periodPositionUs);
            } else if (newPlayingPeriodHolder.hasEnabledTracks) {
                periodPositionUs = newPlayingPeriodHolder.mediaPeriod.seekToUs(periodPositionUs);
                newPlayingPeriodHolder.mediaPeriod.discardBuffer(periodPositionUs - this.backBufferDurationUs, this.retainBackBufferFromKeyframe);
            }
            this.resetRendererPosition(periodPositionUs);
            this.maybeContinueLoading();
        } else {
            this.queue.clear();
            this.resetRendererPosition(periodPositionUs);
        }
        this.handleLoadingMediaPeriodChanged(false);
        this.handler.sendEmptyMessage(2);
        return periodPositionUs;
    }

    private void resetRendererPosition(long periodPositionUs) throws ExoPlaybackException {
        MediaPeriodHolder playingMediaPeriod = this.queue.getPlayingPeriod();
        this.rendererPositionUs = playingMediaPeriod == null ? 1000000000000L + periodPositionUs : playingMediaPeriod.toRendererTime(periodPositionUs);
        this.mediaClock.resetPosition(this.rendererPositionUs);
        for (Renderer renderer : this.renderers) {
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            renderer.resetPosition(this.rendererPositionUs);
        }
        this.notifyTrackSelectionDiscontinuity();
    }

    private void setPlaybackParametersInternal(PlaybackParameters playbackParameters) throws ExoPlaybackException {
        this.setMediaClockPlaybackParameters(playbackParameters);
        this.handlePlaybackParameters(this.mediaClock.getPlaybackParameters(), true);
    }

    private void setSeekParametersInternal(SeekParameters seekParameters) {
        this.seekParameters = seekParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setForegroundModeInternal(boolean foregroundMode, @Nullable AtomicBoolean processedFlag) {
        if (this.foregroundMode != foregroundMode) {
            this.foregroundMode = foregroundMode;
            if (!foregroundMode) {
                for (Renderer renderer : this.renderers) {
                    if (ExoPlayerImplInternal.isRendererEnabled(renderer) || !this.renderersToReset.remove(renderer)) continue;
                    renderer.reset();
                }
            }
        }
        if (processedFlag == null) return;
        Renderer[] rendererArray = this;
        synchronized (this) {
            processedFlag.set(true);
            this.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void stopInternal(boolean forceResetRenderers, boolean acknowledgeStop) {
        this.resetInternal(forceResetRenderers || !this.foregroundMode, false, true, false);
        this.playbackInfoUpdate.incrementPendingOperationAcks(acknowledgeStop ? 1 : 0);
        this.loadControl.onStopped();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal(true, false, true, false);
        this.releaseRenderers();
        this.loadControl.onReleased();
        this.setState(1);
        if (this.internalPlaybackThread != null) {
            this.internalPlaybackThread.quit();
        }
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal(boolean resetRenderers, boolean resetPosition, boolean releaseMediaSourceList, boolean resetError) {
        this.handler.removeMessages(2);
        this.pendingRecoverableRendererError = null;
        this.updateRebufferingState(false, true);
        this.mediaClock.stop();
        this.rendererPositionUs = 1000000000000L;
        for (Renderer renderer : this.renderers) {
            try {
                this.disableRenderer(renderer);
            }
            catch (ExoPlaybackException | RuntimeException e) {
                Log.e((String)TAG, (String)"Disable failed.", (Throwable)e);
            }
        }
        if (resetRenderers) {
            for (Renderer renderer : this.renderers) {
                if (!this.renderersToReset.remove(renderer)) continue;
                try {
                    renderer.reset();
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)"Reset failed.", (Throwable)e);
                }
            }
        }
        this.enabledRendererCount = 0;
        MediaSource.MediaPeriodId mediaPeriodId = this.playbackInfo.periodId;
        long startPositionUs = this.playbackInfo.positionUs;
        long requestedContentPositionUs = this.playbackInfo.periodId.isAd() || ExoPlayerImplInternal.isUsingPlaceholderPeriod(this.playbackInfo, this.period) ? this.playbackInfo.requestedContentPositionUs : this.playbackInfo.positionUs;
        boolean resetTrackInfo = false;
        if (resetPosition) {
            this.pendingInitialSeekPosition = null;
            Pair<MediaSource.MediaPeriodId, Long> firstPeriodAndPositionUs = this.getPlaceholderFirstMediaPeriodPositionUs(this.playbackInfo.timeline);
            mediaPeriodId = (MediaSource.MediaPeriodId)firstPeriodAndPositionUs.first;
            startPositionUs = (Long)firstPeriodAndPositionUs.second;
            requestedContentPositionUs = -9223372036854775807L;
            if (!mediaPeriodId.equals(this.playbackInfo.periodId)) {
                resetTrackInfo = true;
            }
        }
        this.queue.clear();
        this.shouldContinueLoading = false;
        Timeline timeline = this.playbackInfo.timeline;
        if (releaseMediaSourceList && timeline instanceof PlaylistTimeline) {
            timeline = ((PlaylistTimeline)this.playbackInfo.timeline).copyWithPlaceholderTimeline(this.mediaSourceList.getShuffleOrder());
            if (mediaPeriodId.adGroupIndex != -1) {
                timeline.getPeriodByUid(mediaPeriodId.periodUid, this.period);
                if (timeline.getWindow(this.period.windowIndex, this.window).isLive()) {
                    mediaPeriodId = new MediaSource.MediaPeriodId(mediaPeriodId.periodUid, mediaPeriodId.windowSequenceNumber);
                }
            }
        }
        this.playbackInfo = new PlaybackInfo(timeline, mediaPeriodId, requestedContentPositionUs, startPositionUs, this.playbackInfo.playbackState, resetError ? null : this.playbackInfo.playbackError, false, resetTrackInfo ? TrackGroupArray.EMPTY : this.playbackInfo.trackGroups, resetTrackInfo ? this.emptyTrackSelectorResult : this.playbackInfo.trackSelectorResult, (List<Metadata>)(resetTrackInfo ? ImmutableList.of() : this.playbackInfo.staticMetadata), mediaPeriodId, this.playbackInfo.playWhenReady, this.playbackInfo.playbackSuppressionReason, this.playbackInfo.playbackParameters, startPositionUs, 0L, startPositionUs, 0L, false);
        if (releaseMediaSourceList) {
            this.mediaSourceList.release();
        }
    }

    private Pair<MediaSource.MediaPeriodId, Long> getPlaceholderFirstMediaPeriodPositionUs(Timeline timeline) {
        if (timeline.isEmpty()) {
            return Pair.create((Object)PlaybackInfo.getDummyPeriodForEmptyTimeline(), (Object)0L);
        }
        int firstWindowIndex = timeline.getFirstWindowIndex(this.shuffleModeEnabled);
        Pair firstPeriodAndPositionUs = timeline.getPeriodPositionUs(this.window, this.period, firstWindowIndex, -9223372036854775807L);
        MediaSource.MediaPeriodId firstPeriodId = this.queue.resolveMediaPeriodIdForAdsAfterPeriodPositionChange(timeline, firstPeriodAndPositionUs.first, 0L);
        long positionUs = (Long)firstPeriodAndPositionUs.second;
        if (firstPeriodId.isAd()) {
            timeline.getPeriodByUid(firstPeriodId.periodUid, this.period);
            positionUs = firstPeriodId.adIndexInAdGroup == this.period.getFirstAdIndexToPlay(firstPeriodId.adGroupIndex) ? this.period.getAdResumePositionUs() : 0L;
        }
        return Pair.create((Object)firstPeriodId, (Object)positionUs);
    }

    private void sendMessageInternal(PlayerMessage message) throws ExoPlaybackException {
        if (message.getPositionMs() == -9223372036854775807L) {
            this.sendMessageToTarget(message);
        } else if (this.playbackInfo.timeline.isEmpty()) {
            this.pendingMessages.add(new PendingMessageInfo(message));
        } else {
            PendingMessageInfo pendingMessageInfo = new PendingMessageInfo(message);
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(pendingMessageInfo, this.playbackInfo.timeline, this.playbackInfo.timeline, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) {
                this.pendingMessages.add(pendingMessageInfo);
                Collections.sort(this.pendingMessages);
            } else {
                message.markAsProcessed(false);
            }
        }
    }

    private void sendMessageToTarget(PlayerMessage message) throws ExoPlaybackException {
        if (message.getLooper() == this.playbackLooper) {
            this.deliverMessage(message);
            if (this.playbackInfo.playbackState == 3 || this.playbackInfo.playbackState == 2) {
                this.handler.sendEmptyMessage(2);
            }
        } else {
            this.handler.obtainMessage(15, (Object)message).sendToTarget();
        }
    }

    private void sendMessageToTargetThread(PlayerMessage message) {
        Looper looper = message.getLooper();
        if (!looper.getThread().isAlive()) {
            Log.w((String)"TAG", (String)"Trying to send message on a dead thread.");
            message.markAsProcessed(false);
            return;
        }
        this.clock.createHandler(looper, null).post(() -> {
            try {
                this.deliverMessage(message);
            }
            catch (ExoPlaybackException e) {
                Log.e((String)TAG, (String)"Unexpected error delivering message on external thread.", (Throwable)((Object)e));
                throw new RuntimeException((Throwable)((Object)e));
            }
        });
    }

    private void deliverMessage(PlayerMessage message) throws ExoPlaybackException {
        if (message.isCanceled()) {
            return;
        }
        try {
            message.getTarget().handleMessage(message.getType(), message.getPayload());
        }
        finally {
            message.markAsProcessed(true);
        }
    }

    private void resolvePendingMessagePositions(Timeline newTimeline, Timeline previousTimeline) {
        if (newTimeline.isEmpty() && previousTimeline.isEmpty()) {
            return;
        }
        for (int i = this.pendingMessages.size() - 1; i >= 0; --i) {
            if (ExoPlayerImplInternal.resolvePendingMessagePosition(this.pendingMessages.get(i), newTimeline, previousTimeline, this.repeatMode, this.shuffleModeEnabled, this.window, this.period)) continue;
            this.pendingMessages.get((int)i).message.markAsProcessed(false);
            this.pendingMessages.remove(i);
        }
        Collections.sort(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeTriggerPendingMessages(long oldPeriodPositionUs, long newPeriodPositionUs) throws ExoPlaybackException {
        PendingMessageInfo nextInfo;
        PendingMessageInfo previousInfo;
        if (this.pendingMessages.isEmpty() || this.playbackInfo.periodId.isAd()) {
            return;
        }
        if (this.deliverPendingMessageAtStartPositionRequired) {
            --oldPeriodPositionUs;
            this.deliverPendingMessageAtStartPositionRequired = false;
        }
        int currentPeriodIndex = this.playbackInfo.timeline.getIndexOfPeriod(this.playbackInfo.periodId.periodUid);
        int nextPendingMessageIndex = Math.min(this.nextPendingMessageIndexHint, this.pendingMessages.size());
        PendingMessageInfo pendingMessageInfo = previousInfo = nextPendingMessageIndex > 0 ? this.pendingMessages.get(nextPendingMessageIndex - 1) : null;
        while (previousInfo != null && (previousInfo.resolvedPeriodIndex > currentPeriodIndex || previousInfo.resolvedPeriodIndex == currentPeriodIndex && previousInfo.resolvedPeriodTimeUs > oldPeriodPositionUs)) {
            previousInfo = --nextPendingMessageIndex > 0 ? this.pendingMessages.get(nextPendingMessageIndex - 1) : null;
        }
        PendingMessageInfo pendingMessageInfo2 = nextInfo = nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && (nextInfo.resolvedPeriodIndex < currentPeriodIndex || nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs <= oldPeriodPositionUs)) {
            nextInfo = ++nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        }
        while (nextInfo != null && nextInfo.resolvedPeriodUid != null && nextInfo.resolvedPeriodIndex == currentPeriodIndex && nextInfo.resolvedPeriodTimeUs > oldPeriodPositionUs && nextInfo.resolvedPeriodTimeUs <= newPeriodPositionUs) {
            try {
                this.sendMessageToTarget(nextInfo.message);
            }
            finally {
                if (nextInfo.message.getDeleteAfterDelivery() || nextInfo.message.isCanceled()) {
                    this.pendingMessages.remove(nextPendingMessageIndex);
                } else {
                    ++nextPendingMessageIndex;
                }
            }
            nextInfo = nextPendingMessageIndex < this.pendingMessages.size() ? this.pendingMessages.get(nextPendingMessageIndex) : null;
        }
        this.nextPendingMessageIndexHint = nextPendingMessageIndex;
    }

    private void ensureStopped(Renderer renderer) {
        if (renderer.getState() == 2) {
            renderer.stop();
        }
    }

    private void disableRenderer(Renderer renderer) throws ExoPlaybackException {
        if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        this.mediaClock.onRendererDisabled(renderer);
        this.ensureStopped(renderer);
        renderer.disable();
        --this.enabledRendererCount;
    }

    private void reselectTracksInternalAndSeek() throws ExoPlaybackException {
        this.reselectTracksInternal();
        this.seekToCurrentPosition(true);
    }

    private void reselectTracksInternal() throws ExoPlaybackException {
        TrackSelectorResult newTrackSelectorResult;
        float playbackSpeed = this.mediaClock.getPlaybackParameters().speed;
        MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod();
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        boolean selectionsChangedForReadPeriod = true;
        while (true) {
            if (periodHolder == null || !periodHolder.prepared) {
                return;
            }
            newTrackSelectorResult = periodHolder.selectTracks(playbackSpeed, this.playbackInfo.timeline);
            if (!newTrackSelectorResult.isEquivalent(periodHolder.getTrackSelectorResult())) break;
            if (periodHolder == readingPeriodHolder) {
                selectionsChangedForReadPeriod = false;
            }
            periodHolder = periodHolder.getNext();
        }
        if (selectionsChangedForReadPeriod) {
            MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
            boolean recreateStreams = this.queue.removeAfter(playingPeriodHolder);
            boolean[] streamResetFlags = new boolean[this.renderers.length];
            long periodPositionUs = playingPeriodHolder.applyTrackSelection(newTrackSelectorResult, this.playbackInfo.positionUs, recreateStreams, streamResetFlags);
            boolean hasDiscontinuity = this.playbackInfo.playbackState != 4 && periodPositionUs != this.playbackInfo.positionUs;
            this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, periodPositionUs, this.playbackInfo.requestedContentPositionUs, this.playbackInfo.discontinuityStartPositionUs, hasDiscontinuity, 5);
            if (hasDiscontinuity) {
                this.resetRendererPosition(periodPositionUs);
            }
            boolean[] rendererWasEnabledFlags = new boolean[this.renderers.length];
            for (int i = 0; i < this.renderers.length; ++i) {
                Renderer renderer = this.renderers[i];
                rendererWasEnabledFlags[i] = ExoPlayerImplInternal.isRendererEnabled(renderer);
                SampleStream sampleStream = playingPeriodHolder.sampleStreams[i];
                if (!rendererWasEnabledFlags[i]) continue;
                if (sampleStream != renderer.getStream()) {
                    this.disableRenderer(renderer);
                    continue;
                }
                if (!streamResetFlags[i]) continue;
                renderer.resetPosition(this.rendererPositionUs);
            }
            this.enableRenderers(rendererWasEnabledFlags, this.rendererPositionUs);
        } else {
            this.queue.removeAfter(periodHolder);
            if (periodHolder.prepared) {
                long loadingPeriodPositionUs = Math.max(periodHolder.info.startPositionUs, periodHolder.toPeriodTime(this.rendererPositionUs));
                periodHolder.applyTrackSelection(newTrackSelectorResult, loadingPeriodPositionUs, false);
            }
        }
        this.handleLoadingMediaPeriodChanged(true);
        if (this.playbackInfo.playbackState != 4) {
            this.maybeContinueLoading();
            this.updatePlaybackPositions();
            this.handler.sendEmptyMessage(2);
        }
    }

    private void updateTrackSelectionPlaybackSpeed(float playbackSpeed) {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            for (ExoTrackSelection trackSelection : periodHolder.getTrackSelectorResult().selections) {
                if (trackSelection == null) continue;
                trackSelection.onPlaybackSpeed(playbackSpeed);
            }
        }
    }

    private void notifyTrackSelectionDiscontinuity() {
        for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
            for (ExoTrackSelection trackSelection : periodHolder.getTrackSelectorResult().selections) {
                if (trackSelection == null) continue;
                trackSelection.onDiscontinuity();
            }
        }
    }

    private boolean shouldTransitionToReadyState(boolean renderersReadyOrEnded) {
        if (this.enabledRendererCount == 0) {
            return this.isTimelineReady();
        }
        if (!renderersReadyOrEnded) {
            return false;
        }
        if (!this.playbackInfo.isLoading) {
            return true;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        long targetLiveOffsetUs = this.shouldUseLivePlaybackSpeedControl(this.playbackInfo.timeline, playingPeriodHolder.info.id) ? this.livePlaybackSpeedControl.getTargetLiveOffsetUs() : -9223372036854775807L;
        MediaPeriodHolder loadingHolder = this.queue.getLoadingPeriod();
        boolean isBufferedToEnd = loadingHolder.isFullyBuffered() && loadingHolder.info.isFinal;
        boolean isAdPendingPreparation = loadingHolder.info.id.isAd() && !loadingHolder.prepared;
        return isBufferedToEnd || isAdPendingPreparation || this.loadControl.shouldStartPlayback(this.playbackInfo.timeline, playingPeriodHolder.info.id, this.getTotalBufferedDurationUs(), this.mediaClock.getPlaybackParameters().speed, this.isRebuffering, targetLiveOffsetUs);
    }

    private boolean isTimelineReady() {
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        long playingPeriodDurationUs = playingPeriodHolder.info.durationUs;
        return playingPeriodHolder.prepared && (playingPeriodDurationUs == -9223372036854775807L || this.playbackInfo.positionUs < playingPeriodDurationUs || !this.shouldPlayWhenReady());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMediaSourceListInfoRefreshed(Timeline timeline, boolean isSourceRefresh) throws ExoPlaybackException {
        block13: {
            Timeline oldTimeline;
            Object oldPeriodUid;
            PositionUpdateForPlaylistChange positionUpdate = ExoPlayerImplInternal.resolvePositionForPlaylistChange(timeline, this.playbackInfo, this.pendingInitialSeekPosition, this.queue, this.repeatMode, this.shuffleModeEnabled, this.window, this.period);
            MediaSource.MediaPeriodId newPeriodId = positionUpdate.periodId;
            long newRequestedContentPositionUs = positionUpdate.requestedContentPositionUs;
            boolean forceBufferingState = positionUpdate.forceBufferingState;
            long newPositionUs = positionUpdate.periodPositionUs;
            boolean periodPositionChanged = !this.playbackInfo.periodId.equals(newPeriodId) || newPositionUs != this.playbackInfo.positionUs;
            try {
                if (positionUpdate.endPlayback) {
                    if (this.playbackInfo.playbackState != 1) {
                        this.setState(4);
                    }
                    this.resetInternal(false, false, false, true);
                }
                for (Renderer renderer : this.renderers) {
                    renderer.setTimeline(timeline);
                }
                if (!periodPositionChanged) {
                    if (!this.queue.updateQueuedPeriods(timeline, this.rendererPositionUs, this.getMaxRendererReadPositionUs())) {
                        this.seekToCurrentPosition(false);
                    }
                } else if (!timeline.isEmpty()) {
                    for (MediaPeriodHolder periodHolder = this.queue.getPlayingPeriod(); periodHolder != null; periodHolder = periodHolder.getNext()) {
                        if (!periodHolder.info.id.equals(newPeriodId)) continue;
                        periodHolder.info = this.queue.getUpdatedMediaPeriodInfo(timeline, periodHolder.info);
                        periodHolder.updateClipping();
                    }
                    newPositionUs = this.seekToPeriodPosition(newPeriodId, newPositionUs, forceBufferingState);
                }
                this.updatePlaybackSpeedSettingsForNewPeriod(timeline, newPeriodId, this.playbackInfo.timeline, this.playbackInfo.periodId, positionUpdate.setTargetLiveOffset ? newPositionUs : -9223372036854775807L, false);
                if (!periodPositionChanged && newRequestedContentPositionUs == this.playbackInfo.requestedContentPositionUs) break block13;
                oldPeriodUid = this.playbackInfo.periodId.periodUid;
                oldTimeline = this.playbackInfo.timeline;
            }
            catch (Throwable throwable) {
                this.updatePlaybackSpeedSettingsForNewPeriod(timeline, newPeriodId, this.playbackInfo.timeline, this.playbackInfo.periodId, positionUpdate.setTargetLiveOffset ? newPositionUs : -9223372036854775807L, false);
                if (periodPositionChanged || newRequestedContentPositionUs != this.playbackInfo.requestedContentPositionUs) {
                    Object oldPeriodUid2 = this.playbackInfo.periodId.periodUid;
                    Timeline oldTimeline2 = this.playbackInfo.timeline;
                    boolean reportDiscontinuity = periodPositionChanged && isSourceRefresh && !oldTimeline2.isEmpty() && !oldTimeline2.getPeriodByUid((Object)oldPeriodUid2, (Timeline.Period)this.period).isPlaceholder;
                    this.playbackInfo = this.handlePositionDiscontinuity(newPeriodId, newPositionUs, newRequestedContentPositionUs, this.playbackInfo.discontinuityStartPositionUs, reportDiscontinuity, timeline.getIndexOfPeriod(oldPeriodUid2) == -1 ? 4 : 3);
                }
                this.resetPendingPauseAtEndOfPeriod();
                this.resolvePendingMessagePositions(timeline, this.playbackInfo.timeline);
                this.playbackInfo = this.playbackInfo.copyWithTimeline(timeline);
                if (!timeline.isEmpty()) {
                    this.pendingInitialSeekPosition = null;
                }
                this.handleLoadingMediaPeriodChanged(false);
                throw throwable;
            }
            boolean reportDiscontinuity = periodPositionChanged && isSourceRefresh && !oldTimeline.isEmpty() && !oldTimeline.getPeriodByUid((Object)oldPeriodUid, (Timeline.Period)this.period).isPlaceholder;
            this.playbackInfo = this.handlePositionDiscontinuity(newPeriodId, newPositionUs, newRequestedContentPositionUs, this.playbackInfo.discontinuityStartPositionUs, reportDiscontinuity, timeline.getIndexOfPeriod(oldPeriodUid) == -1 ? 4 : 3);
        }
        this.resetPendingPauseAtEndOfPeriod();
        this.resolvePendingMessagePositions(timeline, this.playbackInfo.timeline);
        this.playbackInfo = this.playbackInfo.copyWithTimeline(timeline);
        if (!timeline.isEmpty()) {
            this.pendingInitialSeekPosition = null;
        }
        this.handleLoadingMediaPeriodChanged(false);
    }

    private void updatePlaybackSpeedSettingsForNewPeriod(Timeline newTimeline, MediaSource.MediaPeriodId newPeriodId, Timeline oldTimeline, MediaSource.MediaPeriodId oldPeriodId, long positionForTargetOffsetOverrideUs, boolean forceSetTargetOffsetOverride) throws ExoPlaybackException {
        if (!this.shouldUseLivePlaybackSpeedControl(newTimeline, newPeriodId)) {
            PlaybackParameters targetPlaybackParameters;
            PlaybackParameters playbackParameters = targetPlaybackParameters = newPeriodId.isAd() ? PlaybackParameters.DEFAULT : this.playbackInfo.playbackParameters;
            if (!this.mediaClock.getPlaybackParameters().equals((Object)targetPlaybackParameters)) {
                this.setMediaClockPlaybackParameters(targetPlaybackParameters);
                this.handlePlaybackParameters(this.playbackInfo.playbackParameters, targetPlaybackParameters.speed, false, false);
            }
            return;
        }
        int windowIndex = newTimeline.getPeriodByUid((Object)newPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
        newTimeline.getWindow(windowIndex, this.window);
        this.livePlaybackSpeedControl.setLiveConfiguration((MediaItem.LiveConfiguration)Util.castNonNull((Object)this.window.liveConfiguration));
        if (positionForTargetOffsetOverrideUs != -9223372036854775807L) {
            this.livePlaybackSpeedControl.setTargetLiveOffsetOverrideUs(this.getLiveOffsetUs(newTimeline, newPeriodId.periodUid, positionForTargetOffsetOverrideUs));
        } else {
            Object windowUid = this.window.uid;
            Object oldWindowUid = null;
            if (!oldTimeline.isEmpty()) {
                int oldWindowIndex = oldTimeline.getPeriodByUid((Object)oldPeriodId.periodUid, (Timeline.Period)this.period).windowIndex;
                oldWindowUid = oldTimeline.getWindow((int)oldWindowIndex, (Timeline.Window)this.window).uid;
            }
            if (!Util.areEqual(oldWindowUid, (Object)windowUid) || forceSetTargetOffsetOverride) {
                this.livePlaybackSpeedControl.setTargetLiveOffsetOverrideUs(-9223372036854775807L);
            }
        }
    }

    private long getMaxRendererReadPositionUs() {
        MediaPeriodHolder readingHolder = this.queue.getReadingPeriod();
        if (readingHolder == null) {
            return 0L;
        }
        long maxReadPositionUs = readingHolder.getRendererOffset();
        if (!readingHolder.prepared) {
            return maxReadPositionUs;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            if (!ExoPlayerImplInternal.isRendererEnabled(this.renderers[i]) || this.renderers[i].getStream() != readingHolder.sampleStreams[i]) continue;
            long readingPositionUs = this.renderers[i].getReadingPositionUs();
            if (readingPositionUs == Long.MIN_VALUE) {
                return Long.MIN_VALUE;
            }
            maxReadPositionUs = Math.max(readingPositionUs, maxReadPositionUs);
        }
        return maxReadPositionUs;
    }

    private void updatePeriods() throws ExoPlaybackException {
        if (this.playbackInfo.timeline.isEmpty() || !this.mediaSourceList.isPrepared()) {
            return;
        }
        this.maybeUpdateLoadingPeriod();
        this.maybeUpdateReadingPeriod();
        this.maybeUpdateReadingRenderers();
        this.maybeUpdatePlayingPeriod();
    }

    private void maybeUpdateLoadingPeriod() throws ExoPlaybackException {
        MediaPeriodInfo info;
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        if (this.queue.shouldLoadNextMediaPeriod() && (info = this.queue.getNextMediaPeriodInfo(this.rendererPositionUs, this.playbackInfo)) != null) {
            MediaPeriodHolder mediaPeriodHolder = this.queue.enqueueNextMediaPeriodHolder(info);
            mediaPeriodHolder.mediaPeriod.prepare(this, info.startPositionUs);
            if (this.queue.getPlayingPeriod() == mediaPeriodHolder) {
                this.resetRendererPosition(info.startPositionUs);
            }
            this.handleLoadingMediaPeriodChanged(false);
        }
        if (this.shouldContinueLoading) {
            this.shouldContinueLoading = this.isLoadingPossible();
            this.updateIsLoading();
        } else {
            this.maybeContinueLoading();
        }
    }

    private void maybeUpdateReadingPeriod() throws ExoPlaybackException {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        if (readingPeriodHolder == null) {
            return;
        }
        if (readingPeriodHolder.getNext() == null || this.pendingPauseAtEndOfPeriod) {
            if (readingPeriodHolder.info.isFinal || this.pendingPauseAtEndOfPeriod) {
                for (int i = 0; i < this.renderers.length; ++i) {
                    Renderer renderer = this.renderers[i];
                    SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
                    if (sampleStream == null || renderer.getStream() != sampleStream || !renderer.hasReadStreamToEnd()) continue;
                    long streamEndPositionUs = readingPeriodHolder.info.durationUs != -9223372036854775807L && readingPeriodHolder.info.durationUs != Long.MIN_VALUE ? readingPeriodHolder.getRendererOffset() + readingPeriodHolder.info.durationUs : -9223372036854775807L;
                    this.setCurrentStreamFinal(renderer, streamEndPositionUs);
                }
            }
            return;
        }
        if (!this.hasReadingPeriodFinishedReading()) {
            return;
        }
        if (!readingPeriodHolder.getNext().prepared && this.rendererPositionUs < readingPeriodHolder.getNext().getStartPositionRendererTime()) {
            return;
        }
        MediaPeriodHolder oldReadingPeriodHolder = readingPeriodHolder;
        TrackSelectorResult oldTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        readingPeriodHolder = this.queue.advanceReadingPeriod();
        TrackSelectorResult newTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        this.updatePlaybackSpeedSettingsForNewPeriod(this.playbackInfo.timeline, readingPeriodHolder.info.id, this.playbackInfo.timeline, oldReadingPeriodHolder.info.id, -9223372036854775807L, false);
        if (readingPeriodHolder.prepared && readingPeriodHolder.mediaPeriod.readDiscontinuity() != -9223372036854775807L) {
            this.setAllRendererStreamsFinal(readingPeriodHolder.getStartPositionRendererTime());
            if (!readingPeriodHolder.isFullyBuffered()) {
                this.queue.removeAfter(readingPeriodHolder);
                this.handleLoadingMediaPeriodChanged(false);
                this.maybeContinueLoading();
            }
            return;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            boolean oldRendererEnabled = oldTrackSelectorResult.isRendererEnabled(i);
            boolean newRendererEnabled = newTrackSelectorResult.isRendererEnabled(i);
            if (!oldRendererEnabled || this.renderers[i].isCurrentStreamFinal()) continue;
            boolean isNoSampleRenderer = this.rendererCapabilities[i].getTrackType() == -2;
            RendererConfiguration oldConfig = oldTrackSelectorResult.rendererConfigurations[i];
            RendererConfiguration newConfig = newTrackSelectorResult.rendererConfigurations[i];
            if (newRendererEnabled && newConfig.equals(oldConfig) && !isNoSampleRenderer) continue;
            this.setCurrentStreamFinal(this.renderers[i], readingPeriodHolder.getStartPositionRendererTime());
        }
    }

    private void maybeUpdateReadingRenderers() throws ExoPlaybackException {
        MediaPeriodHolder readingPeriod = this.queue.getReadingPeriod();
        if (readingPeriod == null || this.queue.getPlayingPeriod() == readingPeriod || readingPeriod.allRenderersInCorrectState) {
            return;
        }
        if (this.replaceStreamsOrDisableRendererForTransition()) {
            this.enableRenderers();
        }
    }

    private boolean replaceStreamsOrDisableRendererForTransition() throws ExoPlaybackException {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        TrackSelectorResult newTrackSelectorResult = readingPeriodHolder.getTrackSelectorResult();
        boolean needsToWaitForRendererToEnd = false;
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            if (!ExoPlayerImplInternal.isRendererEnabled(renderer)) continue;
            boolean rendererIsReadingOldStream = renderer.getStream() != readingPeriodHolder.sampleStreams[i];
            boolean rendererShouldBeEnabled = newTrackSelectorResult.isRendererEnabled(i);
            if (rendererShouldBeEnabled && !rendererIsReadingOldStream) continue;
            if (!renderer.isCurrentStreamFinal()) {
                Format[] formats = ExoPlayerImplInternal.getFormats(newTrackSelectorResult.selections[i]);
                renderer.replaceStream(formats, readingPeriodHolder.sampleStreams[i], readingPeriodHolder.getStartPositionRendererTime(), readingPeriodHolder.getRendererOffset(), readingPeriodHolder.info.id);
                if (!this.offloadSchedulingEnabled) continue;
                this.setOffloadSchedulingEnabled(false);
                continue;
            }
            if (renderer.isEnded()) {
                this.disableRenderer(renderer);
                continue;
            }
            needsToWaitForRendererToEnd = true;
        }
        return !needsToWaitForRendererToEnd;
    }

    private void maybeUpdatePlayingPeriod() throws ExoPlaybackException {
        boolean advancedPlayingPeriod = false;
        while (this.shouldAdvancePlayingPeriod()) {
            if (advancedPlayingPeriod) {
                this.maybeNotifyPlaybackInfoChanged();
            }
            MediaPeriodHolder newPlayingPeriodHolder = (MediaPeriodHolder)Assertions.checkNotNull((Object)this.queue.advancePlayingPeriod());
            boolean isCancelledSSAIAdTransition = this.playbackInfo.periodId.periodUid.equals(newPlayingPeriodHolder.info.id.periodUid) && this.playbackInfo.periodId.adGroupIndex == -1 && newPlayingPeriodHolder.info.id.adGroupIndex == -1 && this.playbackInfo.periodId.nextAdGroupIndex != newPlayingPeriodHolder.info.id.nextAdGroupIndex;
            this.playbackInfo = this.handlePositionDiscontinuity(newPlayingPeriodHolder.info.id, newPlayingPeriodHolder.info.startPositionUs, newPlayingPeriodHolder.info.requestedContentPositionUs, newPlayingPeriodHolder.info.startPositionUs, !isCancelledSSAIAdTransition, 0);
            this.resetPendingPauseAtEndOfPeriod();
            this.updatePlaybackPositions();
            this.allowRenderersToRenderStartOfStreams();
            advancedPlayingPeriod = true;
        }
    }

    private void maybeUpdateOffloadScheduling() {
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder != null) {
            TrackSelectorResult trackSelectorResult = playingPeriodHolder.getTrackSelectorResult();
            boolean isAudioRendererEnabledAndOffloadPreferred = false;
            boolean isAudioOnly = true;
            for (int i = 0; i < this.renderers.length; ++i) {
                if (!trackSelectorResult.isRendererEnabled(i)) continue;
                if (this.renderers[i].getTrackType() != 1) {
                    isAudioOnly = false;
                    break;
                }
                if (trackSelectorResult.rendererConfigurations[i].offloadModePreferred == 0) continue;
                isAudioRendererEnabledAndOffloadPreferred = true;
            }
            this.setOffloadSchedulingEnabled(isAudioRendererEnabledAndOffloadPreferred && isAudioOnly);
        }
    }

    private void allowRenderersToRenderStartOfStreams() {
        TrackSelectorResult playingTracks = this.queue.getPlayingPeriod().getTrackSelectorResult();
        for (int i = 0; i < this.renderers.length; ++i) {
            if (!playingTracks.isRendererEnabled(i)) continue;
            this.renderers[i].enableMayRenderStartOfStream();
        }
    }

    private void resetPendingPauseAtEndOfPeriod() {
        MediaPeriodHolder playingPeriod = this.queue.getPlayingPeriod();
        this.pendingPauseAtEndOfPeriod = playingPeriod != null && playingPeriod.info.isLastInTimelineWindow && this.pauseAtEndOfWindow;
    }

    private boolean shouldAdvancePlayingPeriod() {
        if (!this.shouldPlayWhenReady()) {
            return false;
        }
        if (this.pendingPauseAtEndOfPeriod) {
            return false;
        }
        MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
        if (playingPeriodHolder == null) {
            return false;
        }
        MediaPeriodHolder nextPlayingPeriodHolder = playingPeriodHolder.getNext();
        return nextPlayingPeriodHolder != null && this.rendererPositionUs >= nextPlayingPeriodHolder.getStartPositionRendererTime() && nextPlayingPeriodHolder.allRenderersInCorrectState;
    }

    private boolean hasReadingPeriodFinishedReading() {
        MediaPeriodHolder readingPeriodHolder = this.queue.getReadingPeriod();
        if (!readingPeriodHolder.prepared) {
            return false;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            Renderer renderer = this.renderers[i];
            SampleStream sampleStream = readingPeriodHolder.sampleStreams[i];
            if (renderer.getStream() == sampleStream && (sampleStream == null || renderer.hasReadStreamToEnd() || this.hasReachedServerSideInsertedAdsTransition(renderer, readingPeriodHolder))) continue;
            return false;
        }
        return true;
    }

    private boolean hasReachedServerSideInsertedAdsTransition(Renderer renderer, MediaPeriodHolder reading) {
        MediaPeriodHolder nextPeriod = reading.getNext();
        return reading.info.isFollowedByTransitionToSameStream && nextPeriod.prepared && (renderer instanceof TextRenderer || renderer instanceof MetadataRenderer || renderer.getReadingPositionUs() >= nextPeriod.getStartPositionRendererTime());
    }

    private void setAllRendererStreamsFinal(long streamEndPositionUs) {
        for (Renderer renderer : this.renderers) {
            if (renderer.getStream() == null) continue;
            this.setCurrentStreamFinal(renderer, streamEndPositionUs);
        }
    }

    private void setCurrentStreamFinal(Renderer renderer, long streamEndPositionUs) {
        renderer.setCurrentStreamFinal();
        if (renderer instanceof TextRenderer) {
            ((TextRenderer)renderer).setFinalStreamEndPositionUs(streamEndPositionUs);
        }
    }

    private void handlePeriodPrepared(MediaPeriod mediaPeriod) throws ExoPlaybackException {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        loadingPeriodHolder.handlePrepared(this.mediaClock.getPlaybackParameters().speed, this.playbackInfo.timeline);
        this.updateLoadControlTrackSelection(loadingPeriodHolder.info.id, loadingPeriodHolder.getTrackGroups(), loadingPeriodHolder.getTrackSelectorResult());
        if (loadingPeriodHolder == this.queue.getPlayingPeriod()) {
            this.resetRendererPosition(loadingPeriodHolder.info.startPositionUs);
            this.enableRenderers();
            this.playbackInfo = this.handlePositionDiscontinuity(this.playbackInfo.periodId, loadingPeriodHolder.info.startPositionUs, this.playbackInfo.requestedContentPositionUs, loadingPeriodHolder.info.startPositionUs, false, 5);
        }
        this.maybeContinueLoading();
    }

    private void handleContinueLoadingRequested(MediaPeriod mediaPeriod) {
        if (!this.queue.isLoading(mediaPeriod)) {
            return;
        }
        this.queue.reevaluateBuffer(this.rendererPositionUs);
        this.maybeContinueLoading();
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters, boolean acknowledgeCommand) throws ExoPlaybackException {
        this.handlePlaybackParameters(playbackParameters, playbackParameters.speed, true, acknowledgeCommand);
    }

    private void handlePlaybackParameters(PlaybackParameters playbackParameters, float currentPlaybackSpeed, boolean updatePlaybackInfo, boolean acknowledgeCommand) throws ExoPlaybackException {
        if (updatePlaybackInfo) {
            if (acknowledgeCommand) {
                this.playbackInfoUpdate.incrementPendingOperationAcks(1);
            }
            this.playbackInfo = this.playbackInfo.copyWithPlaybackParameters(playbackParameters);
        }
        this.updateTrackSelectionPlaybackSpeed(playbackParameters.speed);
        for (Renderer renderer : this.renderers) {
            if (renderer == null) continue;
            renderer.setPlaybackSpeed(currentPlaybackSpeed, playbackParameters.speed);
        }
    }

    private void maybeContinueLoading() {
        this.shouldContinueLoading = this.shouldContinueLoading();
        if (this.shouldContinueLoading) {
            this.queue.getLoadingPeriod().continueLoading(this.rendererPositionUs, this.mediaClock.getPlaybackParameters().speed, this.lastRebufferRealtimeMs);
        }
        this.updateIsLoading();
    }

    private boolean shouldContinueLoading() {
        if (!this.isLoadingPossible()) {
            return false;
        }
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        long bufferedDurationUs = this.getTotalBufferedDurationUs(loadingPeriodHolder.getNextLoadPositionUs());
        long playbackPositionUs = loadingPeriodHolder == this.queue.getPlayingPeriod() ? loadingPeriodHolder.toPeriodTime(this.rendererPositionUs) : loadingPeriodHolder.toPeriodTime(this.rendererPositionUs) - loadingPeriodHolder.info.startPositionUs;
        boolean shouldContinueLoading = this.loadControl.shouldContinueLoading(playbackPositionUs, bufferedDurationUs, this.mediaClock.getPlaybackParameters().speed);
        if (!shouldContinueLoading && bufferedDurationUs < 500000L && (this.backBufferDurationUs > 0L || this.retainBackBufferFromKeyframe)) {
            this.queue.getPlayingPeriod().mediaPeriod.discardBuffer(this.playbackInfo.positionUs, false);
            shouldContinueLoading = this.loadControl.shouldContinueLoading(playbackPositionUs, bufferedDurationUs, this.mediaClock.getPlaybackParameters().speed);
        }
        return shouldContinueLoading;
    }

    private boolean isLoadingPossible() {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder == null) {
            return false;
        }
        long nextLoadPositionUs = loadingPeriodHolder.getNextLoadPositionUs();
        return nextLoadPositionUs != Long.MIN_VALUE;
    }

    private void updateIsLoading() {
        boolean isLoading;
        MediaPeriodHolder loadingPeriod = this.queue.getLoadingPeriod();
        boolean bl = isLoading = this.shouldContinueLoading || loadingPeriod != null && loadingPeriod.mediaPeriod.isLoading();
        if (isLoading != this.playbackInfo.isLoading) {
            this.playbackInfo = this.playbackInfo.copyWithIsLoading(isLoading);
        }
    }

    @CheckResult
    private PlaybackInfo handlePositionDiscontinuity(MediaSource.MediaPeriodId mediaPeriodId, long positionUs, long requestedContentPositionUs, long discontinuityStartPositionUs, boolean reportDiscontinuity, int discontinuityReason) {
        this.deliverPendingMessageAtStartPositionRequired = this.deliverPendingMessageAtStartPositionRequired || positionUs != this.playbackInfo.positionUs || !mediaPeriodId.equals(this.playbackInfo.periodId);
        this.resetPendingPauseAtEndOfPeriod();
        TrackGroupArray trackGroupArray = this.playbackInfo.trackGroups;
        TrackSelectorResult trackSelectorResult = this.playbackInfo.trackSelectorResult;
        ImmutableList<Metadata> staticMetadata = this.playbackInfo.staticMetadata;
        if (this.mediaSourceList.isPrepared()) {
            MediaPeriodHolder playingPeriodHolder = this.queue.getPlayingPeriod();
            trackGroupArray = playingPeriodHolder == null ? TrackGroupArray.EMPTY : playingPeriodHolder.getTrackGroups();
            trackSelectorResult = playingPeriodHolder == null ? this.emptyTrackSelectorResult : playingPeriodHolder.getTrackSelectorResult();
            staticMetadata = this.extractMetadataFromTrackSelectionArray(trackSelectorResult.selections);
            if (playingPeriodHolder != null && playingPeriodHolder.info.requestedContentPositionUs != requestedContentPositionUs) {
                playingPeriodHolder.info = playingPeriodHolder.info.copyWithRequestedContentPositionUs(requestedContentPositionUs);
            }
            this.maybeUpdateOffloadScheduling();
        } else if (!mediaPeriodId.equals(this.playbackInfo.periodId)) {
            trackGroupArray = TrackGroupArray.EMPTY;
            trackSelectorResult = this.emptyTrackSelectorResult;
            staticMetadata = ImmutableList.of();
        }
        if (reportDiscontinuity) {
            this.playbackInfoUpdate.setPositionDiscontinuity(discontinuityReason);
        }
        return this.playbackInfo.copyWithNewPosition(mediaPeriodId, positionUs, requestedContentPositionUs, discontinuityStartPositionUs, this.getTotalBufferedDurationUs(), trackGroupArray, trackSelectorResult, (List<Metadata>)staticMetadata);
    }

    private ImmutableList<Metadata> extractMetadataFromTrackSelectionArray(ExoTrackSelection[] trackSelections) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        boolean seenNonEmptyMetadata = false;
        for (ExoTrackSelection trackSelection : trackSelections) {
            if (trackSelection == null) continue;
            Format format = trackSelection.getFormat(0);
            if (format.metadata == null) {
                result.add((Object)new Metadata(new Metadata.Entry[0]));
                continue;
            }
            result.add((Object)format.metadata);
            seenNonEmptyMetadata = true;
        }
        return seenNonEmptyMetadata ? result.build() : ImmutableList.of();
    }

    private void enableRenderers() throws ExoPlaybackException {
        this.enableRenderers(new boolean[this.renderers.length], this.queue.getReadingPeriod().getStartPositionRendererTime());
    }

    private void enableRenderers(boolean[] rendererWasEnabledFlags, long startPositionUs) throws ExoPlaybackException {
        int i;
        MediaPeriodHolder readingMediaPeriod = this.queue.getReadingPeriod();
        TrackSelectorResult trackSelectorResult = readingMediaPeriod.getTrackSelectorResult();
        for (i = 0; i < this.renderers.length; ++i) {
            if (trackSelectorResult.isRendererEnabled(i) || !this.renderersToReset.remove(this.renderers[i])) continue;
            this.renderers[i].reset();
        }
        for (i = 0; i < this.renderers.length; ++i) {
            if (!trackSelectorResult.isRendererEnabled(i)) continue;
            this.enableRenderer(i, rendererWasEnabledFlags[i], startPositionUs);
        }
        readingMediaPeriod.allRenderersInCorrectState = true;
    }

    private void enableRenderer(int rendererIndex, boolean wasRendererEnabled, long startPositionUs) throws ExoPlaybackException {
        Renderer renderer = this.renderers[rendererIndex];
        if (ExoPlayerImplInternal.isRendererEnabled(renderer)) {
            return;
        }
        MediaPeriodHolder periodHolder = this.queue.getReadingPeriod();
        boolean mayRenderStartOfStream = periodHolder == this.queue.getPlayingPeriod();
        TrackSelectorResult trackSelectorResult = periodHolder.getTrackSelectorResult();
        RendererConfiguration rendererConfiguration = trackSelectorResult.rendererConfigurations[rendererIndex];
        ExoTrackSelection newSelection = trackSelectorResult.selections[rendererIndex];
        Format[] formats = ExoPlayerImplInternal.getFormats(newSelection);
        boolean playing = this.shouldPlayWhenReady() && this.playbackInfo.playbackState == 3;
        boolean joining = !wasRendererEnabled && playing;
        ++this.enabledRendererCount;
        this.renderersToReset.add(renderer);
        renderer.enable(rendererConfiguration, formats, periodHolder.sampleStreams[rendererIndex], this.rendererPositionUs, joining, mayRenderStartOfStream, startPositionUs, periodHolder.getRendererOffset(), periodHolder.info.id);
        renderer.handleMessage(11, new Renderer.WakeupListener(){

            @Override
            public void onSleep() {
                ExoPlayerImplInternal.this.requestForRendererSleep = true;
            }

            @Override
            public void onWakeup() {
                ExoPlayerImplInternal.this.handler.sendEmptyMessage(2);
            }
        });
        this.mediaClock.onRendererEnabled(renderer);
        if (playing) {
            renderer.start();
        }
    }

    private void releaseRenderers() {
        for (int i = 0; i < this.renderers.length; ++i) {
            this.rendererCapabilities[i].clearListener();
            this.renderers[i].release();
        }
    }

    private void handleLoadingMediaPeriodChanged(boolean loadingTrackSelectionChanged) {
        boolean loadingMediaPeriodChanged;
        MediaPeriodHolder loadingMediaPeriodHolder = this.queue.getLoadingPeriod();
        MediaSource.MediaPeriodId loadingMediaPeriodId = loadingMediaPeriodHolder == null ? this.playbackInfo.periodId : loadingMediaPeriodHolder.info.id;
        boolean bl = loadingMediaPeriodChanged = !this.playbackInfo.loadingMediaPeriodId.equals(loadingMediaPeriodId);
        if (loadingMediaPeriodChanged) {
            this.playbackInfo = this.playbackInfo.copyWithLoadingMediaPeriodId(loadingMediaPeriodId);
        }
        this.playbackInfo.bufferedPositionUs = loadingMediaPeriodHolder == null ? this.playbackInfo.positionUs : loadingMediaPeriodHolder.getBufferedPositionUs();
        this.playbackInfo.totalBufferedDurationUs = this.getTotalBufferedDurationUs();
        if ((loadingMediaPeriodChanged || loadingTrackSelectionChanged) && loadingMediaPeriodHolder != null && loadingMediaPeriodHolder.prepared) {
            this.updateLoadControlTrackSelection(loadingMediaPeriodHolder.info.id, loadingMediaPeriodHolder.getTrackGroups(), loadingMediaPeriodHolder.getTrackSelectorResult());
        }
    }

    private long getTotalBufferedDurationUs() {
        return this.getTotalBufferedDurationUs(this.playbackInfo.bufferedPositionUs);
    }

    private long getTotalBufferedDurationUs(long bufferedPositionInLoadingPeriodUs) {
        MediaPeriodHolder loadingPeriodHolder = this.queue.getLoadingPeriod();
        if (loadingPeriodHolder == null) {
            return 0L;
        }
        long totalBufferedDurationUs = bufferedPositionInLoadingPeriodUs - loadingPeriodHolder.toPeriodTime(this.rendererPositionUs);
        return Math.max(0L, totalBufferedDurationUs);
    }

    private void updateLoadControlTrackSelection(MediaSource.MediaPeriodId mediaPeriodId, TrackGroupArray trackGroups, TrackSelectorResult trackSelectorResult) {
        this.loadControl.onTracksSelected(this.playbackInfo.timeline, mediaPeriodId, this.renderers, trackGroups, trackSelectorResult.selections);
    }

    private boolean shouldPlayWhenReady() {
        return this.playbackInfo.playWhenReady && this.playbackInfo.playbackSuppressionReason == 0;
    }

    private static PositionUpdateForPlaylistChange resolvePositionForPlaylistChange(Timeline timeline, PlaybackInfo playbackInfo, @Nullable SeekPosition pendingInitialSeekPosition, MediaPeriodQueue queue, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        long oldContentPositionUs;
        if (timeline.isEmpty()) {
            return new PositionUpdateForPlaylistChange(PlaybackInfo.getDummyPeriodForEmptyTimeline(), 0L, -9223372036854775807L, false, true, false);
        }
        MediaSource.MediaPeriodId oldPeriodId = playbackInfo.periodId;
        Object newPeriodUid = oldPeriodId.periodUid;
        boolean isUsingPlaceholderPeriod = ExoPlayerImplInternal.isUsingPlaceholderPeriod(playbackInfo, period);
        long newContentPositionUs = oldContentPositionUs = playbackInfo.periodId.isAd() || isUsingPlaceholderPeriod ? playbackInfo.requestedContentPositionUs : playbackInfo.positionUs;
        int startAtDefaultPositionWindowIndex = -1;
        boolean forceBufferingState = false;
        boolean endPlayback = false;
        boolean setTargetLiveOffset = false;
        if (pendingInitialSeekPosition != null) {
            Pair<Object, Long> periodPosition = ExoPlayerImplInternal.resolveSeekPositionUs(timeline, pendingInitialSeekPosition, true, repeatMode, shuffleModeEnabled, window, period);
            if (periodPosition == null) {
                endPlayback = true;
                startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
            } else {
                if (pendingInitialSeekPosition.windowPositionUs == -9223372036854775807L) {
                    startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)periodPosition.first, (Timeline.Period)period).windowIndex;
                } else {
                    newPeriodUid = periodPosition.first;
                    newContentPositionUs = (Long)periodPosition.second;
                    setTargetLiveOffset = true;
                }
                forceBufferingState = playbackInfo.playbackState == 4;
            }
        } else if (playbackInfo.timeline.isEmpty()) {
            startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
        } else if (timeline.getIndexOfPeriod(newPeriodUid) == -1) {
            Object subsequentPeriodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(window, period, repeatMode, shuffleModeEnabled, newPeriodUid, playbackInfo.timeline, timeline);
            if (subsequentPeriodUid == null) {
                endPlayback = true;
                startAtDefaultPositionWindowIndex = timeline.getFirstWindowIndex(shuffleModeEnabled);
            } else {
                startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)subsequentPeriodUid, (Timeline.Period)period).windowIndex;
            }
        } else if (oldContentPositionUs == -9223372036854775807L) {
            startAtDefaultPositionWindowIndex = timeline.getPeriodByUid((Object)newPeriodUid, (Timeline.Period)period).windowIndex;
        } else if (isUsingPlaceholderPeriod) {
            playbackInfo.timeline.getPeriodByUid(oldPeriodId.periodUid, period);
            if (playbackInfo.timeline.getWindow((int)period.windowIndex, (Timeline.Window)window).firstPeriodIndex == playbackInfo.timeline.getIndexOfPeriod(oldPeriodId.periodUid)) {
                long windowPositionUs = oldContentPositionUs + period.getPositionInWindowUs();
                int windowIndex = timeline.getPeriodByUid((Object)newPeriodUid, (Timeline.Period)period).windowIndex;
                Pair periodPositionUs = timeline.getPeriodPositionUs(window, period, windowIndex, windowPositionUs);
                newPeriodUid = periodPositionUs.first;
                newContentPositionUs = (Long)periodPositionUs.second;
            }
            setTargetLiveOffset = true;
        }
        long contentPositionForAdResolutionUs = newContentPositionUs;
        if (startAtDefaultPositionWindowIndex != -1) {
            Pair defaultPositionUs = timeline.getPeriodPositionUs(window, period, startAtDefaultPositionWindowIndex, -9223372036854775807L);
            newPeriodUid = defaultPositionUs.first;
            contentPositionForAdResolutionUs = (Long)defaultPositionUs.second;
            newContentPositionUs = -9223372036854775807L;
        }
        MediaSource.MediaPeriodId periodIdWithAds = queue.resolveMediaPeriodIdForAdsAfterPeriodPositionChange(timeline, newPeriodUid, contentPositionForAdResolutionUs);
        boolean earliestCuePointIsUnchangedOrLater = periodIdWithAds.nextAdGroupIndex == -1 || oldPeriodId.nextAdGroupIndex != -1 && periodIdWithAds.nextAdGroupIndex >= oldPeriodId.nextAdGroupIndex;
        boolean sameOldAndNewPeriodUid = oldPeriodId.periodUid.equals(newPeriodUid);
        boolean onlyNextAdGroupIndexIncreased = sameOldAndNewPeriodUid && !oldPeriodId.isAd() && !periodIdWithAds.isAd() && earliestCuePointIsUnchangedOrLater;
        boolean isInStreamAdChange = ExoPlayerImplInternal.isIgnorableServerSideAdInsertionPeriodChange(isUsingPlaceholderPeriod, oldPeriodId, oldContentPositionUs, periodIdWithAds, timeline.getPeriodByUid(newPeriodUid, period), newContentPositionUs);
        MediaSource.MediaPeriodId newPeriodId = onlyNextAdGroupIndexIncreased || isInStreamAdChange ? oldPeriodId : periodIdWithAds;
        long periodPositionUs = contentPositionForAdResolutionUs;
        if (newPeriodId.isAd()) {
            if (newPeriodId.equals(oldPeriodId)) {
                periodPositionUs = playbackInfo.positionUs;
            } else {
                timeline.getPeriodByUid(newPeriodId.periodUid, period);
                periodPositionUs = newPeriodId.adIndexInAdGroup == period.getFirstAdIndexToPlay(newPeriodId.adGroupIndex) ? period.getAdResumePositionUs() : 0L;
            }
        }
        return new PositionUpdateForPlaylistChange(newPeriodId, periodPositionUs, newContentPositionUs, forceBufferingState, endPlayback, setTargetLiveOffset);
    }

    private static boolean isIgnorableServerSideAdInsertionPeriodChange(boolean isUsingPlaceholderPeriod, MediaSource.MediaPeriodId oldPeriodId, long oldContentPositionUs, MediaSource.MediaPeriodId newPeriodId, Timeline.Period newPeriod, long newContentPositionUs) {
        if (isUsingPlaceholderPeriod || oldContentPositionUs != newContentPositionUs || !oldPeriodId.periodUid.equals(newPeriodId.periodUid)) {
            return false;
        }
        if (oldPeriodId.isAd() && newPeriod.isServerSideInsertedAdGroup(oldPeriodId.adGroupIndex)) {
            return newPeriod.getAdState(oldPeriodId.adGroupIndex, oldPeriodId.adIndexInAdGroup) != 4 && newPeriod.getAdState(oldPeriodId.adGroupIndex, oldPeriodId.adIndexInAdGroup) != 2;
        }
        return newPeriodId.isAd() && newPeriod.isServerSideInsertedAdGroup(newPeriodId.adGroupIndex);
    }

    private static boolean isUsingPlaceholderPeriod(PlaybackInfo playbackInfo, Timeline.Period period) {
        MediaSource.MediaPeriodId periodId = playbackInfo.periodId;
        Timeline timeline = playbackInfo.timeline;
        return timeline.isEmpty() || timeline.getPeriodByUid((Object)periodId.periodUid, (Timeline.Period)period).isPlaceholder;
    }

    private void updateRebufferingState(boolean isRebuffering, boolean resetLastRebufferRealtimeMs) {
        this.isRebuffering = isRebuffering;
        this.lastRebufferRealtimeMs = resetLastRebufferRealtimeMs ? -9223372036854775807L : this.clock.elapsedRealtime();
    }

    private static boolean resolvePendingMessagePosition(PendingMessageInfo pendingMessageInfo, Timeline newTimeline, Timeline previousTimeline, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        if (pendingMessageInfo.resolvedPeriodUid == null) {
            long requestPositionUs = pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE ? -9223372036854775807L : Util.msToUs((long)pendingMessageInfo.message.getPositionMs());
            Pair<Object, Long> periodPosition = ExoPlayerImplInternal.resolveSeekPositionUs(newTimeline, new SeekPosition(pendingMessageInfo.message.getTimeline(), pendingMessageInfo.message.getMediaItemIndex(), requestPositionUs), false, repeatMode, shuffleModeEnabled, window, period);
            if (periodPosition == null) {
                return false;
            }
            pendingMessageInfo.setResolvedPosition(newTimeline.getIndexOfPeriod(periodPosition.first), (Long)periodPosition.second, periodPosition.first);
            if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
                ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(newTimeline, pendingMessageInfo, window, period);
            }
            return true;
        }
        int index = newTimeline.getIndexOfPeriod(pendingMessageInfo.resolvedPeriodUid);
        if (index == -1) {
            return false;
        }
        if (pendingMessageInfo.message.getPositionMs() == Long.MIN_VALUE) {
            ExoPlayerImplInternal.resolvePendingMessageEndOfStreamPosition(newTimeline, pendingMessageInfo, window, period);
            return true;
        }
        pendingMessageInfo.resolvedPeriodIndex = index;
        previousTimeline.getPeriodByUid(pendingMessageInfo.resolvedPeriodUid, period);
        if (period.isPlaceholder && previousTimeline.getWindow((int)period.windowIndex, (Timeline.Window)window).firstPeriodIndex == previousTimeline.getIndexOfPeriod(pendingMessageInfo.resolvedPeriodUid)) {
            long windowPositionUs = pendingMessageInfo.resolvedPeriodTimeUs + period.getPositionInWindowUs();
            int windowIndex = newTimeline.getPeriodByUid((Object)pendingMessageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex;
            Pair periodPositionUs = newTimeline.getPeriodPositionUs(window, period, windowIndex, windowPositionUs);
            pendingMessageInfo.setResolvedPosition(newTimeline.getIndexOfPeriod(periodPositionUs.first), (Long)periodPositionUs.second, periodPositionUs.first);
        }
        return true;
    }

    private static void resolvePendingMessageEndOfStreamPosition(Timeline timeline, PendingMessageInfo messageInfo, Timeline.Window window, Timeline.Period period) {
        int windowIndex = timeline.getPeriodByUid((Object)messageInfo.resolvedPeriodUid, (Timeline.Period)period).windowIndex;
        int lastPeriodIndex = timeline.getWindow((int)windowIndex, (Timeline.Window)window).lastPeriodIndex;
        Object lastPeriodUid = timeline.getPeriod((int)lastPeriodIndex, (Timeline.Period)period, (boolean)true).uid;
        long positionUs = period.durationUs != -9223372036854775807L ? period.durationUs - 1L : Long.MAX_VALUE;
        messageInfo.setResolvedPosition(lastPeriodIndex, positionUs, lastPeriodUid);
    }

    @Nullable
    private static Pair<Object, Long> resolveSeekPositionUs(Timeline timeline, SeekPosition seekPosition, boolean trySubsequentPeriods, int repeatMode, boolean shuffleModeEnabled, Timeline.Window window, Timeline.Period period) {
        Object periodUid;
        Pair periodPositionUs;
        Timeline seekTimeline = seekPosition.timeline;
        if (timeline.isEmpty()) {
            return null;
        }
        if (seekTimeline.isEmpty()) {
            seekTimeline = timeline;
        }
        try {
            periodPositionUs = seekTimeline.getPeriodPositionUs(window, period, seekPosition.windowIndex, seekPosition.windowPositionUs);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        if (timeline.equals((Object)seekTimeline)) {
            return periodPositionUs;
        }
        int periodIndex = timeline.getIndexOfPeriod(periodPositionUs.first);
        if (periodIndex != -1) {
            if (seekTimeline.getPeriodByUid((Object)periodPositionUs.first, (Timeline.Period)period).isPlaceholder && seekTimeline.getWindow((int)period.windowIndex, (Timeline.Window)window).firstPeriodIndex == seekTimeline.getIndexOfPeriod(periodPositionUs.first)) {
                int newWindowIndex = timeline.getPeriodByUid((Object)periodPositionUs.first, (Timeline.Period)period).windowIndex;
                periodPositionUs = timeline.getPeriodPositionUs(window, period, newWindowIndex, seekPosition.windowPositionUs);
            }
            return periodPositionUs;
        }
        if (trySubsequentPeriods && (periodUid = ExoPlayerImplInternal.resolveSubsequentPeriod(window, period, repeatMode, shuffleModeEnabled, periodPositionUs.first, seekTimeline, timeline)) != null) {
            return timeline.getPeriodPositionUs(window, period, timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)period).windowIndex, -9223372036854775807L);
        }
        return null;
    }

    @Nullable
    static Object resolveSubsequentPeriod(Timeline.Window window, Timeline.Period period, int repeatMode, boolean shuffleModeEnabled, Object oldPeriodUid, Timeline oldTimeline, Timeline newTimeline) {
        int oldPeriodIndex = oldTimeline.getIndexOfPeriod(oldPeriodUid);
        int newPeriodIndex = -1;
        int maxIterations = oldTimeline.getPeriodCount();
        for (int i = 0; i < maxIterations && newPeriodIndex == -1 && (oldPeriodIndex = oldTimeline.getNextPeriodIndex(oldPeriodIndex, period, window, repeatMode, shuffleModeEnabled)) != -1; ++i) {
            newPeriodIndex = newTimeline.getIndexOfPeriod(oldTimeline.getUidOfPeriod(oldPeriodIndex));
        }
        return newPeriodIndex == -1 ? null : newTimeline.getUidOfPeriod(newPeriodIndex);
    }

    private static Format[] getFormats(ExoTrackSelection newSelection) {
        int length = newSelection != null ? newSelection.length() : 0;
        Format[] formats = new Format[length];
        for (int i = 0; i < length; ++i) {
            formats[i] = newSelection.getFormat(i);
        }
        return formats;
    }

    private static boolean isRendererEnabled(Renderer renderer) {
        return renderer.getState() != 0;
    }

    public static interface PlaybackInfoUpdateListener {
        public void onPlaybackInfoUpdate(PlaybackInfoUpdate var1);
    }

    public static final class PlaybackInfoUpdate {
        private boolean hasPendingChange;
        public PlaybackInfo playbackInfo;
        public int operationAcks;
        public boolean positionDiscontinuity;
        public int discontinuityReason;
        public boolean hasPlayWhenReadyChangeReason;
        public int playWhenReadyChangeReason;

        public PlaybackInfoUpdate(PlaybackInfo playbackInfo) {
            this.playbackInfo = playbackInfo;
        }

        public void incrementPendingOperationAcks(int operationAcks) {
            this.hasPendingChange |= operationAcks > 0;
            this.operationAcks += operationAcks;
        }

        public void setPlaybackInfo(PlaybackInfo playbackInfo) {
            this.hasPendingChange |= this.playbackInfo != playbackInfo;
            this.playbackInfo = playbackInfo;
        }

        public void setPositionDiscontinuity(int discontinuityReason) {
            if (this.positionDiscontinuity && this.discontinuityReason != 5) {
                Assertions.checkArgument((discontinuityReason == 5 ? 1 : 0) != 0);
                return;
            }
            this.hasPendingChange = true;
            this.positionDiscontinuity = true;
            this.discontinuityReason = discontinuityReason;
        }

        public void setPlayWhenReadyChangeReason(int playWhenReadyChangeReason) {
            this.hasPendingChange = true;
            this.hasPlayWhenReadyChangeReason = true;
            this.playWhenReadyChangeReason = playWhenReadyChangeReason;
        }
    }

    private static final class SeekPosition {
        public final Timeline timeline;
        public final int windowIndex;
        public final long windowPositionUs;

        public SeekPosition(Timeline timeline, int windowIndex, long windowPositionUs) {
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.windowPositionUs = windowPositionUs;
        }
    }

    private static final class MediaSourceListUpdateMessage {
        private final List<MediaSourceList.MediaSourceHolder> mediaSourceHolders;
        private final ShuffleOrder shuffleOrder;
        private final int windowIndex;
        private final long positionUs;

        private MediaSourceListUpdateMessage(List<MediaSourceList.MediaSourceHolder> mediaSourceHolders, ShuffleOrder shuffleOrder, int windowIndex, long positionUs) {
            this.mediaSourceHolders = mediaSourceHolders;
            this.shuffleOrder = shuffleOrder;
            this.windowIndex = windowIndex;
            this.positionUs = positionUs;
        }
    }

    private static class MoveMediaItemsMessage {
        public final int fromIndex;
        public final int toIndex;
        public final int newFromIndex;
        public final ShuffleOrder shuffleOrder;

        public MoveMediaItemsMessage(int fromIndex, int toIndex, int newFromIndex, ShuffleOrder shuffleOrder) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.newFromIndex = newFromIndex;
            this.shuffleOrder = shuffleOrder;
        }
    }

    private static final class PendingMessageInfo
    implements Comparable<PendingMessageInfo> {
        public final PlayerMessage message;
        public int resolvedPeriodIndex;
        public long resolvedPeriodTimeUs;
        @Nullable
        public Object resolvedPeriodUid;

        public PendingMessageInfo(PlayerMessage message) {
            this.message = message;
        }

        public void setResolvedPosition(int periodIndex, long periodTimeUs, Object periodUid) {
            this.resolvedPeriodIndex = periodIndex;
            this.resolvedPeriodTimeUs = periodTimeUs;
            this.resolvedPeriodUid = periodUid;
        }

        @Override
        public int compareTo(PendingMessageInfo other) {
            if (this.resolvedPeriodUid == null != (other.resolvedPeriodUid == null)) {
                return this.resolvedPeriodUid != null ? -1 : 1;
            }
            if (this.resolvedPeriodUid == null) {
                return 0;
            }
            int comparePeriodIndex = this.resolvedPeriodIndex - other.resolvedPeriodIndex;
            if (comparePeriodIndex != 0) {
                return comparePeriodIndex;
            }
            return Util.compareLong((long)this.resolvedPeriodTimeUs, (long)other.resolvedPeriodTimeUs);
        }
    }

    private static final class PositionUpdateForPlaylistChange {
        public final MediaSource.MediaPeriodId periodId;
        public final long periodPositionUs;
        public final long requestedContentPositionUs;
        public final boolean forceBufferingState;
        public final boolean endPlayback;
        public final boolean setTargetLiveOffset;

        public PositionUpdateForPlaylistChange(MediaSource.MediaPeriodId periodId, long periodPositionUs, long requestedContentPositionUs, boolean forceBufferingState, boolean endPlayback, boolean setTargetLiveOffset) {
            this.periodId = periodId;
            this.periodPositionUs = periodPositionUs;
            this.requestedContentPositionUs = requestedContentPositionUs;
            this.forceBufferingState = forceBufferingState;
            this.endPlayback = endPlayback;
            this.setTargetLiveOffset = setTargetLiveOffset;
        }
    }
}

