/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.common.base.Objects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class LoadingInfo {
    public final long playbackPositionUs;
    public final float playbackSpeed;
    public final long lastRebufferRealtimeMs;

    private LoadingInfo(Builder builder) {
        this.playbackPositionUs = builder.playbackPositionUs;
        this.playbackSpeed = builder.playbackSpeed;
        this.lastRebufferRealtimeMs = builder.lastRebufferRealtimeMs;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean rebufferedSince(long realtimeMs) {
        return this.lastRebufferRealtimeMs != -9223372036854775807L && realtimeMs != -9223372036854775807L && this.lastRebufferRealtimeMs >= realtimeMs;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingInfo)) {
            return false;
        }
        LoadingInfo that = (LoadingInfo)o;
        return this.playbackPositionUs == that.playbackPositionUs && this.playbackSpeed == that.playbackSpeed && this.lastRebufferRealtimeMs == that.lastRebufferRealtimeMs;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.playbackPositionUs, Float.valueOf(this.playbackSpeed), this.lastRebufferRealtimeMs});
    }

    public static final class Builder {
        private long playbackPositionUs;
        private float playbackSpeed;
        private long lastRebufferRealtimeMs;

        public Builder() {
            this.playbackPositionUs = -9223372036854775807L;
            this.playbackSpeed = -3.4028235E38f;
            this.lastRebufferRealtimeMs = -9223372036854775807L;
        }

        private Builder(LoadingInfo loadingInfo) {
            this.playbackPositionUs = loadingInfo.playbackPositionUs;
            this.playbackSpeed = loadingInfo.playbackSpeed;
            this.lastRebufferRealtimeMs = loadingInfo.lastRebufferRealtimeMs;
        }

        @CanIgnoreReturnValue
        public Builder setPlaybackPositionUs(long playbackPositionUs) {
            this.playbackPositionUs = playbackPositionUs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPlaybackSpeed(float playbackSpeed) {
            Assertions.checkArgument((playbackSpeed > 0.0f || playbackSpeed == -3.4028235E38f ? 1 : 0) != 0);
            this.playbackSpeed = playbackSpeed;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLastRebufferRealtimeMs(long lastRebufferRealtimeMs) {
            Assertions.checkArgument((lastRebufferRealtimeMs >= 0L || lastRebufferRealtimeMs == -9223372036854775807L ? 1 : 0) != 0);
            this.lastRebufferRealtimeMs = lastRebufferRealtimeMs;
            return this;
        }

        public LoadingInfo build() {
            return new LoadingInfo(this);
        }
    }
}

