/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.source.MediaSource;

final class MediaPeriodInfo {
    public final MediaSource.MediaPeriodId id;
    public final long startPositionUs;
    public final long requestedContentPositionUs;
    public final long endPositionUs;
    public final long durationUs;
    public final boolean isFollowedByTransitionToSameStream;
    public final boolean isLastInTimelinePeriod;
    public final boolean isLastInTimelineWindow;
    public final boolean isFinal;

    MediaPeriodInfo(MediaSource.MediaPeriodId id, long startPositionUs, long requestedContentPositionUs, long endPositionUs, long durationUs, boolean isFollowedByTransitionToSameStream, boolean isLastInTimelinePeriod, boolean isLastInTimelineWindow, boolean isFinal) {
        Assertions.checkArgument((!isFinal || isLastInTimelinePeriod ? 1 : 0) != 0);
        Assertions.checkArgument((!isLastInTimelineWindow || isLastInTimelinePeriod ? 1 : 0) != 0);
        Assertions.checkArgument((!isFollowedByTransitionToSameStream || !isLastInTimelinePeriod && !isLastInTimelineWindow && !isFinal ? 1 : 0) != 0);
        this.id = id;
        this.startPositionUs = startPositionUs;
        this.requestedContentPositionUs = requestedContentPositionUs;
        this.endPositionUs = endPositionUs;
        this.durationUs = durationUs;
        this.isFollowedByTransitionToSameStream = isFollowedByTransitionToSameStream;
        this.isLastInTimelinePeriod = isLastInTimelinePeriod;
        this.isLastInTimelineWindow = isLastInTimelineWindow;
        this.isFinal = isFinal;
    }

    public MediaPeriodInfo copyWithStartPositionUs(long startPositionUs) {
        return startPositionUs == this.startPositionUs ? this : new MediaPeriodInfo(this.id, startPositionUs, this.requestedContentPositionUs, this.endPositionUs, this.durationUs, this.isFollowedByTransitionToSameStream, this.isLastInTimelinePeriod, this.isLastInTimelineWindow, this.isFinal);
    }

    public MediaPeriodInfo copyWithRequestedContentPositionUs(long requestedContentPositionUs) {
        return requestedContentPositionUs == this.requestedContentPositionUs ? this : new MediaPeriodInfo(this.id, this.startPositionUs, requestedContentPositionUs, this.endPositionUs, this.durationUs, this.isFollowedByTransitionToSameStream, this.isLastInTimelinePeriod, this.isLastInTimelineWindow, this.isFinal);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaPeriodInfo that = (MediaPeriodInfo)o;
        return this.startPositionUs == that.startPositionUs && this.requestedContentPositionUs == that.requestedContentPositionUs && this.endPositionUs == that.endPositionUs && this.durationUs == that.durationUs && this.isFollowedByTransitionToSameStream == that.isFollowedByTransitionToSameStream && this.isLastInTimelinePeriod == that.isLastInTimelinePeriod && this.isLastInTimelineWindow == that.isLastInTimelineWindow && this.isFinal == that.isFinal && Util.areEqual((Object)this.id, (Object)that.id);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (int)this.startPositionUs;
        result = 31 * result + (int)this.requestedContentPositionUs;
        result = 31 * result + (int)this.endPositionUs;
        result = 31 * result + (int)this.durationUs;
        result = 31 * result + (this.isFollowedByTransitionToSameStream ? 1 : 0);
        result = 31 * result + (this.isLastInTimelinePeriod ? 1 : 0);
        result = 31 * result + (this.isLastInTimelineWindow ? 1 : 0);
        result = 31 * result + (this.isFinal ? 1 : 0);
        return result;
    }
}

