/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.HandlerWrapper;
import androidx.media3.exoplayer.MediaPeriodHolder;
import androidx.media3.exoplayer.MediaPeriodInfo;
import androidx.media3.exoplayer.PlaybackInfo;
import androidx.media3.exoplayer.analytics.AnalyticsCollector;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.collect.ImmutableList;
import java.util.List;

final class MediaPeriodQueue {
    public static final long INITIAL_RENDERER_POSITION_OFFSET_US = 1000000000000L;
    private static final int MAXIMUM_BUFFER_AHEAD_PERIODS = 100;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final AnalyticsCollector analyticsCollector;
    private final HandlerWrapper analyticsCollectorHandler;
    private final MediaPeriodHolder.Factory mediaPeriodHolderFactory;
    private long nextWindowSequenceNumber;
    private int repeatMode;
    private boolean shuffleModeEnabled;
    @Nullable
    private MediaPeriodHolder playing;
    @Nullable
    private MediaPeriodHolder reading;
    @Nullable
    private MediaPeriodHolder loading;
    private int length;
    @Nullable
    private Object oldFrontPeriodUid;
    private long oldFrontPeriodWindowSequenceNumber;

    public MediaPeriodQueue(AnalyticsCollector analyticsCollector, HandlerWrapper analyticsCollectorHandler, MediaPeriodHolder.Factory mediaPeriodHolderFactory) {
        this.analyticsCollector = analyticsCollector;
        this.analyticsCollectorHandler = analyticsCollectorHandler;
        this.mediaPeriodHolderFactory = mediaPeriodHolderFactory;
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
    }

    public boolean updateRepeatMode(Timeline timeline, int repeatMode) {
        this.repeatMode = repeatMode;
        return this.updateForPlaybackModeChange(timeline);
    }

    public boolean updateShuffleModeEnabled(Timeline timeline, boolean shuffleModeEnabled) {
        this.shuffleModeEnabled = shuffleModeEnabled;
        return this.updateForPlaybackModeChange(timeline);
    }

    public boolean isLoading(MediaPeriod mediaPeriod) {
        return this.loading != null && this.loading.mediaPeriod == mediaPeriod;
    }

    public void reevaluateBuffer(long rendererPositionUs) {
        if (this.loading != null) {
            this.loading.reevaluateBuffer(rendererPositionUs);
        }
    }

    public boolean shouldLoadNextMediaPeriod() {
        return this.loading == null || !this.loading.info.isFinal && this.loading.isFullyBuffered() && this.loading.info.durationUs != -9223372036854775807L && this.length < 100;
    }

    @Nullable
    public MediaPeriodInfo getNextMediaPeriodInfo(long rendererPositionUs, PlaybackInfo playbackInfo) {
        return this.loading == null ? this.getFirstMediaPeriodInfo(playbackInfo) : this.getFollowingMediaPeriodInfo(playbackInfo.timeline, this.loading, rendererPositionUs);
    }

    public MediaPeriodHolder enqueueNextMediaPeriodHolder(MediaPeriodInfo info) {
        long rendererPositionOffsetUs = this.loading == null ? 1000000000000L : this.loading.getRendererOffset() + this.loading.info.durationUs - info.startPositionUs;
        MediaPeriodHolder newPeriodHolder = this.mediaPeriodHolderFactory.create(info, rendererPositionOffsetUs);
        if (this.loading != null) {
            this.loading.setNext(newPeriodHolder);
        } else {
            this.playing = newPeriodHolder;
            this.reading = newPeriodHolder;
        }
        this.oldFrontPeriodUid = null;
        this.loading = newPeriodHolder;
        ++this.length;
        this.notifyQueueUpdate();
        return newPeriodHolder;
    }

    @Nullable
    public MediaPeriodHolder getLoadingPeriod() {
        return this.loading;
    }

    @Nullable
    public MediaPeriodHolder getPlayingPeriod() {
        return this.playing;
    }

    @Nullable
    public MediaPeriodHolder getReadingPeriod() {
        return this.reading;
    }

    public MediaPeriodHolder advanceReadingPeriod() {
        this.reading = ((MediaPeriodHolder)Assertions.checkStateNotNull((Object)this.reading)).getNext();
        this.notifyQueueUpdate();
        return (MediaPeriodHolder)Assertions.checkStateNotNull((Object)this.reading);
    }

    @Nullable
    public MediaPeriodHolder advancePlayingPeriod() {
        if (this.playing == null) {
            return null;
        }
        if (this.playing == this.reading) {
            this.reading = this.playing.getNext();
        }
        this.playing.release();
        --this.length;
        if (this.length == 0) {
            this.loading = null;
            this.oldFrontPeriodUid = this.playing.uid;
            this.oldFrontPeriodWindowSequenceNumber = this.playing.info.id.windowSequenceNumber;
        }
        this.playing = this.playing.getNext();
        this.notifyQueueUpdate();
        return this.playing;
    }

    public boolean removeAfter(MediaPeriodHolder mediaPeriodHolder) {
        Assertions.checkStateNotNull((Object)mediaPeriodHolder);
        if (mediaPeriodHolder.equals(this.loading)) {
            return false;
        }
        boolean removedReading = false;
        this.loading = mediaPeriodHolder;
        while (mediaPeriodHolder.getNext() != null) {
            if ((mediaPeriodHolder = (MediaPeriodHolder)Assertions.checkNotNull((Object)mediaPeriodHolder.getNext())) == this.reading) {
                this.reading = this.playing;
                removedReading = true;
            }
            mediaPeriodHolder.release();
            --this.length;
        }
        ((MediaPeriodHolder)Assertions.checkNotNull((Object)this.loading)).setNext(null);
        this.notifyQueueUpdate();
        return removedReading;
    }

    public void clear() {
        MediaPeriodHolder front;
        if (this.length == 0) {
            return;
        }
        this.oldFrontPeriodUid = front.uid;
        this.oldFrontPeriodWindowSequenceNumber = front.info.id.windowSequenceNumber;
        for (front = (MediaPeriodHolder)Assertions.checkStateNotNull((Object)this.playing); front != null; front = front.getNext()) {
            front.release();
        }
        this.playing = null;
        this.loading = null;
        this.reading = null;
        this.length = 0;
        this.notifyQueueUpdate();
    }

    public boolean updateQueuedPeriods(Timeline timeline, long rendererPositionUs, long maxRendererReadPositionUs) {
        MediaPeriodHolder previousPeriodHolder = null;
        for (MediaPeriodHolder periodHolder = this.playing; periodHolder != null; periodHolder = periodHolder.getNext()) {
            MediaPeriodInfo newPeriodInfo;
            MediaPeriodInfo oldPeriodInfo = periodHolder.info;
            if (previousPeriodHolder == null) {
                newPeriodInfo = this.getUpdatedMediaPeriodInfo(timeline, oldPeriodInfo);
            } else {
                newPeriodInfo = this.getFollowingMediaPeriodInfo(timeline, previousPeriodHolder, rendererPositionUs);
                if (newPeriodInfo == null) {
                    return !this.removeAfter(previousPeriodHolder);
                }
                if (!this.canKeepMediaPeriodHolder(oldPeriodInfo, newPeriodInfo)) {
                    return !this.removeAfter(previousPeriodHolder);
                }
            }
            periodHolder.info = newPeriodInfo.copyWithRequestedContentPositionUs(oldPeriodInfo.requestedContentPositionUs);
            if (!this.areDurationsCompatible(oldPeriodInfo.durationUs, newPeriodInfo.durationUs)) {
                periodHolder.updateClipping();
                long newDurationInRendererTime = newPeriodInfo.durationUs == -9223372036854775807L ? Long.MAX_VALUE : periodHolder.toRendererTime(newPeriodInfo.durationUs);
                boolean isReadingAndReadBeyondNewDuration = periodHolder == this.reading && !periodHolder.info.isFollowedByTransitionToSameStream && (maxRendererReadPositionUs == Long.MIN_VALUE || maxRendererReadPositionUs >= newDurationInRendererTime);
                boolean readingPeriodRemoved = this.removeAfter(periodHolder);
                return !readingPeriodRemoved && !isReadingAndReadBeyondNewDuration;
            }
            previousPeriodHolder = periodHolder;
        }
        return true;
    }

    public MediaPeriodInfo getUpdatedMediaPeriodInfo(Timeline timeline, MediaPeriodInfo info) {
        long durationUs;
        long endPositionUs;
        MediaSource.MediaPeriodId id = info.id;
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInWindow = this.isLastInWindow(timeline, id);
        boolean isLastInTimeline = this.isLastInTimeline(timeline, id, isLastInPeriod);
        timeline.getPeriodByUid(info.id.periodUid, this.period);
        long l = endPositionUs = id.isAd() || id.nextAdGroupIndex == -1 ? -9223372036854775807L : this.period.getAdGroupTimeUs(id.nextAdGroupIndex);
        long l2 = id.isAd() ? this.period.getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup) : (durationUs = endPositionUs == -9223372036854775807L || endPositionUs == Long.MIN_VALUE ? this.period.getDurationUs() : endPositionUs);
        boolean isFollowedByTransitionToSameStream = id.isAd() ? this.period.isServerSideInsertedAdGroup(id.adGroupIndex) : id.nextAdGroupIndex != -1 && this.period.isServerSideInsertedAdGroup(id.nextAdGroupIndex);
        return new MediaPeriodInfo(id, info.startPositionUs, info.requestedContentPositionUs, endPositionUs, durationUs, isFollowedByTransitionToSameStream, isLastInPeriod, isLastInWindow, isLastInTimeline);
    }

    public MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Timeline timeline, Object periodUid, long positionUs) {
        long windowSequenceNumber = this.resolvePeriodIndexToWindowSequenceNumber(timeline, periodUid);
        return MediaPeriodQueue.resolveMediaPeriodIdForAds(timeline, periodUid, positionUs, windowSequenceNumber, this.window, this.period);
    }

    private static MediaSource.MediaPeriodId resolveMediaPeriodIdForAds(Timeline timeline, Object periodUid, long positionUs, long windowSequenceNumber, Timeline.Window window, Timeline.Period period) {
        timeline.getPeriodByUid(periodUid, period);
        timeline.getWindow(period.windowIndex, window);
        for (int periodIndex = timeline.getIndexOfPeriod(periodUid); MediaPeriodQueue.isSkippableAdPeriod(period) && periodIndex <= window.lastPeriodIndex; ++periodIndex) {
            timeline.getPeriod(periodIndex, period, true);
            periodUid = Assertions.checkNotNull((Object)period.uid);
        }
        timeline.getPeriodByUid(periodUid, period);
        int adGroupIndex = period.getAdGroupIndexForPositionUs(positionUs);
        if (adGroupIndex == -1) {
            int nextAdGroupIndex = period.getAdGroupIndexAfterPositionUs(positionUs);
            return new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        }
        int adIndexInAdGroup = period.getFirstAdIndexToPlay(adGroupIndex);
        return new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
    }

    private static boolean isSkippableAdPeriod(Timeline.Period period) {
        int adGroupCount = period.getAdGroupCount();
        if (adGroupCount == 0 || adGroupCount == 1 && period.isLivePostrollPlaceholder(0) || !period.isServerSideInsertedAdGroup(period.getRemovedAdGroupCount()) || period.getAdGroupIndexForPositionUs(0L) != -1) {
            return false;
        }
        if (period.durationUs == 0L) {
            return true;
        }
        long contentResumeOffsetUs = 0L;
        int lastIndexInclusive = adGroupCount - (period.isLivePostrollPlaceholder(adGroupCount - 1) ? 2 : 1);
        for (int i = 0; i <= lastIndexInclusive; ++i) {
            contentResumeOffsetUs += period.getContentResumeOffsetUs(i);
        }
        return period.durationUs <= contentResumeOffsetUs;
    }

    public MediaSource.MediaPeriodId resolveMediaPeriodIdForAdsAfterPeriodPositionChange(Timeline timeline, Object periodUid, long positionUs) {
        long windowSequenceNumber = this.resolvePeriodIndexToWindowSequenceNumber(timeline, periodUid);
        timeline.getPeriodByUid(periodUid, this.period);
        timeline.getWindow(this.period.windowIndex, this.window);
        Object periodUidToPlay = periodUid;
        boolean seenAdPeriod = false;
        for (int i = timeline.getIndexOfPeriod(periodUid); i >= this.window.firstPeriodIndex; --i) {
            timeline.getPeriod(i, this.period, true);
            boolean isAdPeriod = this.period.getAdGroupCount() > 0;
            seenAdPeriod |= isAdPeriod;
            if (this.period.getAdGroupIndexForPositionUs(this.period.durationUs) != -1) {
                periodUidToPlay = Assertions.checkNotNull((Object)this.period.uid);
            }
            if (seenAdPeriod && (!isAdPeriod || this.period.durationUs != 0L)) break;
        }
        return MediaPeriodQueue.resolveMediaPeriodIdForAds(timeline, periodUidToPlay, positionUs, windowSequenceNumber, this.window, this.period);
    }

    private void notifyQueueUpdate() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MediaPeriodHolder period = this.playing; period != null; period = period.getNext()) {
            builder.add((Object)period.info.id);
        }
        MediaSource.MediaPeriodId readingPeriodId = this.reading == null ? null : this.reading.info.id;
        this.analyticsCollectorHandler.post(() -> this.analyticsCollector.updateMediaPeriodQueueInfo((List<MediaSource.MediaPeriodId>)builder.build(), readingPeriodId));
    }

    private long resolvePeriodIndexToWindowSequenceNumber(Timeline timeline, Object periodUid) {
        MediaPeriodHolder mediaPeriodHolder;
        int oldFrontWindowIndex;
        int oldFrontPeriodIndex;
        int windowIndex = timeline.getPeriodByUid((Object)periodUid, (Timeline.Period)this.period).windowIndex;
        if (this.oldFrontPeriodUid != null && (oldFrontPeriodIndex = timeline.getIndexOfPeriod(this.oldFrontPeriodUid)) != -1 && (oldFrontWindowIndex = timeline.getPeriod((int)oldFrontPeriodIndex, (Timeline.Period)this.period).windowIndex) == windowIndex) {
            return this.oldFrontPeriodWindowSequenceNumber;
        }
        for (mediaPeriodHolder = this.playing; mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            if (!mediaPeriodHolder.uid.equals(periodUid)) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        for (mediaPeriodHolder = this.playing; mediaPeriodHolder != null; mediaPeriodHolder = mediaPeriodHolder.getNext()) {
            int holderWindowIndex;
            int indexOfHolderInTimeline = timeline.getIndexOfPeriod(mediaPeriodHolder.uid);
            if (indexOfHolderInTimeline == -1 || (holderWindowIndex = timeline.getPeriod((int)indexOfHolderInTimeline, (Timeline.Period)this.period).windowIndex) != windowIndex) continue;
            return mediaPeriodHolder.info.id.windowSequenceNumber;
        }
        long windowSequenceNumber = this.nextWindowSequenceNumber++;
        if (this.playing == null) {
            this.oldFrontPeriodUid = periodUid;
            this.oldFrontPeriodWindowSequenceNumber = windowSequenceNumber;
        }
        return windowSequenceNumber;
    }

    private boolean canKeepMediaPeriodHolder(MediaPeriodInfo oldInfo, MediaPeriodInfo newInfo) {
        return oldInfo.startPositionUs == newInfo.startPositionUs && oldInfo.id.equals(newInfo.id);
    }

    private boolean areDurationsCompatible(long previousDurationUs, long newDurationUs) {
        return previousDurationUs == -9223372036854775807L || previousDurationUs == newDurationUs;
    }

    private boolean updateForPlaybackModeChange(Timeline timeline) {
        MediaPeriodHolder lastValidPeriodHolder = this.playing;
        if (lastValidPeriodHolder == null) {
            return true;
        }
        int currentPeriodIndex = timeline.getIndexOfPeriod(lastValidPeriodHolder.uid);
        while (true) {
            int nextPeriodHolderPeriodIndex;
            int nextPeriodIndex = timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
            while (((MediaPeriodHolder)Assertions.checkNotNull((Object)lastValidPeriodHolder)).getNext() != null && !lastValidPeriodHolder.info.isLastInTimelinePeriod) {
                lastValidPeriodHolder = lastValidPeriodHolder.getNext();
            }
            MediaPeriodHolder nextMediaPeriodHolder = lastValidPeriodHolder.getNext();
            if (nextPeriodIndex == -1 || nextMediaPeriodHolder == null || (nextPeriodHolderPeriodIndex = timeline.getIndexOfPeriod(nextMediaPeriodHolder.uid)) != nextPeriodIndex) break;
            lastValidPeriodHolder = nextMediaPeriodHolder;
            currentPeriodIndex = nextPeriodIndex;
        }
        boolean readingPeriodRemoved = this.removeAfter(lastValidPeriodHolder);
        lastValidPeriodHolder.info = this.getUpdatedMediaPeriodInfo(timeline, lastValidPeriodHolder.info);
        return !readingPeriodRemoved;
    }

    @Nullable
    private MediaPeriodInfo getFirstMediaPeriodInfo(PlaybackInfo playbackInfo) {
        return this.getMediaPeriodInfo(playbackInfo.timeline, playbackInfo.periodId, playbackInfo.requestedContentPositionUs, playbackInfo.positionUs);
    }

    @Nullable
    private MediaPeriodInfo getFollowingMediaPeriodInfo(Timeline timeline, MediaPeriodHolder mediaPeriodHolder, long rendererPositionUs) {
        MediaPeriodInfo mediaPeriodInfo = mediaPeriodHolder.info;
        long bufferedDurationUs = mediaPeriodHolder.getRendererOffset() + mediaPeriodInfo.durationUs - rendererPositionUs;
        return mediaPeriodInfo.isLastInTimelinePeriod ? this.getFirstMediaPeriodInfoOfNextPeriod(timeline, mediaPeriodHolder, bufferedDurationUs) : this.getFollowingMediaPeriodInfoOfCurrentPeriod(timeline, mediaPeriodHolder, bufferedDurationUs);
    }

    @Nullable
    private MediaPeriodInfo getFirstMediaPeriodInfoOfNextPeriod(Timeline timeline, MediaPeriodHolder mediaPeriodHolder, long bufferedDurationUs) {
        MediaPeriodInfo mediaPeriodInfo = mediaPeriodHolder.info;
        int currentPeriodIndex = timeline.getIndexOfPeriod(mediaPeriodInfo.id.periodUid);
        int nextPeriodIndex = timeline.getNextPeriodIndex(currentPeriodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled);
        if (nextPeriodIndex == -1) {
            return null;
        }
        long startPositionUs = 0L;
        long contentPositionUs = 0L;
        int nextWindowIndex = timeline.getPeriod((int)nextPeriodIndex, (Timeline.Period)this.period, (boolean)true).windowIndex;
        Object nextPeriodUid = Assertions.checkNotNull((Object)this.period.uid);
        long windowSequenceNumber = mediaPeriodInfo.id.windowSequenceNumber;
        if (timeline.getWindow((int)nextWindowIndex, (Timeline.Window)this.window).firstPeriodIndex == nextPeriodIndex) {
            contentPositionUs = -9223372036854775807L;
            Pair defaultPositionUs = timeline.getPeriodPositionUs(this.window, this.period, nextWindowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
            if (defaultPositionUs == null) {
                return null;
            }
            nextPeriodUid = defaultPositionUs.first;
            startPositionUs = (Long)defaultPositionUs.second;
            MediaPeriodHolder nextMediaPeriodHolder = mediaPeriodHolder.getNext();
            windowSequenceNumber = nextMediaPeriodHolder != null && nextMediaPeriodHolder.uid.equals(nextPeriodUid) ? nextMediaPeriodHolder.info.id.windowSequenceNumber : this.nextWindowSequenceNumber++;
        }
        MediaSource.MediaPeriodId periodId = MediaPeriodQueue.resolveMediaPeriodIdForAds(timeline, nextPeriodUid, startPositionUs, windowSequenceNumber, this.window, this.period);
        if (contentPositionUs != -9223372036854775807L && mediaPeriodInfo.requestedContentPositionUs != -9223372036854775807L) {
            boolean precedingPeriodHasServerSideInsertedAds = this.hasServerSideInsertedAds(mediaPeriodInfo.id.periodUid, timeline);
            if (periodId.isAd() && precedingPeriodHasServerSideInsertedAds) {
                contentPositionUs = mediaPeriodInfo.requestedContentPositionUs;
            } else if (precedingPeriodHasServerSideInsertedAds) {
                startPositionUs = mediaPeriodInfo.requestedContentPositionUs;
            }
        }
        return this.getMediaPeriodInfo(timeline, periodId, contentPositionUs, startPositionUs);
    }

    @Nullable
    private MediaPeriodInfo getFollowingMediaPeriodInfoOfCurrentPeriod(Timeline timeline, MediaPeriodHolder mediaPeriodHolder, long bufferedDurationUs) {
        boolean isPlayedServerSideInsertedAd;
        MediaPeriodInfo mediaPeriodInfo = mediaPeriodHolder.info;
        MediaSource.MediaPeriodId currentPeriodId = mediaPeriodInfo.id;
        timeline.getPeriodByUid(currentPeriodId.periodUid, this.period);
        if (currentPeriodId.isAd()) {
            int adGroupIndex = currentPeriodId.adGroupIndex;
            int adCountInCurrentAdGroup = this.period.getAdCountInAdGroup(adGroupIndex);
            if (adCountInCurrentAdGroup == -1) {
                return null;
            }
            int nextAdIndexInAdGroup = this.period.getNextAdIndexToPlay(adGroupIndex, currentPeriodId.adIndexInAdGroup);
            if (nextAdIndexInAdGroup < adCountInCurrentAdGroup) {
                return this.getMediaPeriodInfoForAd(timeline, currentPeriodId.periodUid, adGroupIndex, nextAdIndexInAdGroup, mediaPeriodInfo.requestedContentPositionUs, currentPeriodId.windowSequenceNumber);
            }
            long startPositionUs = mediaPeriodInfo.requestedContentPositionUs;
            if (startPositionUs == -9223372036854775807L) {
                Pair defaultPositionUs = timeline.getPeriodPositionUs(this.window, this.period, this.period.windowIndex, -9223372036854775807L, Math.max(0L, bufferedDurationUs));
                if (defaultPositionUs == null) {
                    return null;
                }
                startPositionUs = (Long)defaultPositionUs.second;
            }
            long minStartPositionUs = this.getMinStartPositionAfterAdGroupUs(timeline, currentPeriodId.periodUid, currentPeriodId.adGroupIndex);
            return this.getMediaPeriodInfoForContent(timeline, currentPeriodId.periodUid, Math.max(minStartPositionUs, startPositionUs), mediaPeriodInfo.requestedContentPositionUs, currentPeriodId.windowSequenceNumber);
        }
        if (currentPeriodId.nextAdGroupIndex != -1 && this.period.isLivePostrollPlaceholder(currentPeriodId.nextAdGroupIndex)) {
            return this.getFirstMediaPeriodInfoOfNextPeriod(timeline, mediaPeriodHolder, bufferedDurationUs);
        }
        int adIndexInAdGroup = this.period.getFirstAdIndexToPlay(currentPeriodId.nextAdGroupIndex);
        boolean bl = isPlayedServerSideInsertedAd = this.period.isServerSideInsertedAdGroup(currentPeriodId.nextAdGroupIndex) && this.period.getAdState(currentPeriodId.nextAdGroupIndex, adIndexInAdGroup) == 3;
        if (adIndexInAdGroup == this.period.getAdCountInAdGroup(currentPeriodId.nextAdGroupIndex) || isPlayedServerSideInsertedAd) {
            long startPositionUs = this.getMinStartPositionAfterAdGroupUs(timeline, currentPeriodId.periodUid, currentPeriodId.nextAdGroupIndex);
            return this.getMediaPeriodInfoForContent(timeline, currentPeriodId.periodUid, startPositionUs, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
        }
        return this.getMediaPeriodInfoForAd(timeline, currentPeriodId.periodUid, currentPeriodId.nextAdGroupIndex, adIndexInAdGroup, mediaPeriodInfo.durationUs, currentPeriodId.windowSequenceNumber);
    }

    private boolean hasServerSideInsertedAds(Object periodUid, Timeline timeline) {
        int adGroupCount = timeline.getPeriodByUid(periodUid, this.period).getAdGroupCount();
        int firstAdGroupIndex = this.period.getRemovedAdGroupCount();
        return adGroupCount > 0 && this.period.isServerSideInsertedAdGroup(firstAdGroupIndex) && (adGroupCount > 1 || this.period.getAdGroupTimeUs(firstAdGroupIndex) != Long.MIN_VALUE);
    }

    @Nullable
    private MediaPeriodInfo getMediaPeriodInfo(Timeline timeline, MediaSource.MediaPeriodId id, long requestedContentPositionUs, long startPositionUs) {
        timeline.getPeriodByUid(id.periodUid, this.period);
        if (id.isAd()) {
            return this.getMediaPeriodInfoForAd(timeline, id.periodUid, id.adGroupIndex, id.adIndexInAdGroup, requestedContentPositionUs, id.windowSequenceNumber);
        }
        return this.getMediaPeriodInfoForContent(timeline, id.periodUid, startPositionUs, requestedContentPositionUs, id.windowSequenceNumber);
    }

    private MediaPeriodInfo getMediaPeriodInfoForAd(Timeline timeline, Object periodUid, int adGroupIndex, int adIndexInAdGroup, long contentPositionUs, long windowSequenceNumber) {
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber);
        long durationUs = timeline.getPeriodByUid(id.periodUid, this.period).getAdDurationUs(id.adGroupIndex, id.adIndexInAdGroup);
        long startPositionUs = adIndexInAdGroup == this.period.getFirstAdIndexToPlay(adGroupIndex) ? this.period.getAdResumePositionUs() : 0L;
        boolean isFollowedByTransitionToSameStream = this.period.isServerSideInsertedAdGroup(id.adGroupIndex);
        if (durationUs != -9223372036854775807L && startPositionUs >= durationUs) {
            startPositionUs = Math.max(0L, durationUs - 1L);
        }
        return new MediaPeriodInfo(id, startPositionUs, contentPositionUs, -9223372036854775807L, durationUs, isFollowedByTransitionToSameStream, false, false, false);
    }

    private MediaPeriodInfo getMediaPeriodInfoForContent(Timeline timeline, Object periodUid, long startPositionUs, long requestedContentPositionUs, long windowSequenceNumber) {
        long durationUs;
        boolean isFollowedByTransitionToSameStream;
        timeline.getPeriodByUid(periodUid, this.period);
        int nextAdGroupIndex = this.period.getAdGroupIndexAfterPositionUs(startPositionUs);
        boolean isNextAdGroupPostrollPlaceholder = nextAdGroupIndex != -1 && this.period.isLivePostrollPlaceholder(nextAdGroupIndex);
        boolean clipPeriodAtContentDuration = false;
        if (nextAdGroupIndex == -1) {
            clipPeriodAtContentDuration = this.period.getAdGroupCount() > 0 && this.period.isServerSideInsertedAdGroup(this.period.getRemovedAdGroupCount());
        } else if (this.period.isServerSideInsertedAdGroup(nextAdGroupIndex) && this.period.getAdGroupTimeUs(nextAdGroupIndex) == this.period.durationUs && this.period.hasPlayedAdGroup(nextAdGroupIndex)) {
            nextAdGroupIndex = -1;
            clipPeriodAtContentDuration = true;
        }
        MediaSource.MediaPeriodId id = new MediaSource.MediaPeriodId(periodUid, windowSequenceNumber, nextAdGroupIndex);
        boolean isLastInPeriod = this.isLastInPeriod(id);
        boolean isLastInWindow = this.isLastInWindow(timeline, id);
        boolean isLastInTimeline = this.isLastInTimeline(timeline, id, isLastInPeriod);
        boolean bl = isFollowedByTransitionToSameStream = nextAdGroupIndex != -1 && this.period.isServerSideInsertedAdGroup(nextAdGroupIndex) && !isNextAdGroupPostrollPlaceholder;
        long endPositionUs = nextAdGroupIndex != -1 && !isNextAdGroupPostrollPlaceholder ? this.period.getAdGroupTimeUs(nextAdGroupIndex) : (clipPeriodAtContentDuration ? this.period.durationUs : -9223372036854775807L);
        long l = durationUs = endPositionUs == -9223372036854775807L || endPositionUs == Long.MIN_VALUE ? this.period.durationUs : endPositionUs;
        if (durationUs != -9223372036854775807L && startPositionUs >= durationUs) {
            boolean endAtLastFrame = isLastInTimeline || !clipPeriodAtContentDuration;
            startPositionUs = Math.max(0L, durationUs - (long)(endAtLastFrame ? 1 : 0));
        }
        return new MediaPeriodInfo(id, startPositionUs, requestedContentPositionUs, endPositionUs, durationUs, isFollowedByTransitionToSameStream, isLastInPeriod, isLastInWindow, isLastInTimeline);
    }

    private boolean isLastInPeriod(MediaSource.MediaPeriodId id) {
        return !id.isAd() && id.nextAdGroupIndex == -1;
    }

    private boolean isLastInWindow(Timeline timeline, MediaSource.MediaPeriodId id) {
        if (!this.isLastInPeriod(id)) {
            return false;
        }
        int windowIndex = timeline.getPeriodByUid((Object)id.periodUid, (Timeline.Period)this.period).windowIndex;
        int periodIndex = timeline.getIndexOfPeriod(id.periodUid);
        return timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).lastPeriodIndex == periodIndex;
    }

    private boolean isLastInTimeline(Timeline timeline, MediaSource.MediaPeriodId id, boolean isLastMediaPeriodInPeriod) {
        int periodIndex = timeline.getIndexOfPeriod(id.periodUid);
        int windowIndex = timeline.getPeriod((int)periodIndex, (Timeline.Period)this.period).windowIndex;
        return !timeline.getWindow((int)windowIndex, (Timeline.Window)this.window).isDynamic && timeline.isLastPeriod(periodIndex, this.period, this.window, this.repeatMode, this.shuffleModeEnabled) && isLastMediaPeriodInPeriod;
    }

    private long getMinStartPositionAfterAdGroupUs(Timeline timeline, Object periodUid, int adGroupIndex) {
        timeline.getPeriodByUid(periodUid, this.period);
        long startPositionUs = this.period.getAdGroupTimeUs(adGroupIndex);
        if (startPositionUs == Long.MIN_VALUE) {
            return this.period.durationUs;
        }
        return startPositionUs + this.period.getContentResumeOffsetUs(adGroupIndex);
    }
}

