/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.MediaClock;
import androidx.media3.exoplayer.PlayerMessage;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.RendererConfiguration;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.SampleStream;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@UnstableApi
public interface Renderer
extends PlayerMessage.Target {
    public static final int MSG_SET_VIDEO_OUTPUT = 1;
    public static final int MSG_SET_VOLUME = 2;
    public static final int MSG_SET_AUDIO_ATTRIBUTES = 3;
    public static final int MSG_SET_SCALING_MODE = 4;
    public static final int MSG_SET_CHANGE_FRAME_RATE_STRATEGY = 5;
    public static final int MSG_SET_AUX_EFFECT_INFO = 6;
    public static final int MSG_SET_VIDEO_FRAME_METADATA_LISTENER = 7;
    public static final int MSG_SET_CAMERA_MOTION_LISTENER = 8;
    public static final int MSG_SET_SKIP_SILENCE_ENABLED = 9;
    public static final int MSG_SET_AUDIO_SESSION_ID = 10;
    public static final int MSG_SET_WAKEUP_LISTENER = 11;
    public static final int MSG_SET_PREFERRED_AUDIO_DEVICE = 12;
    public static final int MSG_SET_VIDEO_EFFECTS = 13;
    public static final int MSG_SET_VIDEO_OUTPUT_RESOLUTION = 14;
    public static final int MSG_SET_IMAGE_OUTPUT = 15;
    public static final int MSG_CUSTOM_BASE = 10000;
    public static final int STATE_DISABLED = 0;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_STARTED = 2;

    public String getName();

    public int getTrackType();

    public RendererCapabilities getCapabilities();

    public void init(int var1, PlayerId var2, Clock var3);

    @Nullable
    public MediaClock getMediaClock();

    public int getState();

    public void enable(RendererConfiguration var1, Format[] var2, SampleStream var3, long var4, boolean var6, boolean var7, long var8, long var10, MediaSource.MediaPeriodId var12) throws ExoPlaybackException;

    public void start() throws ExoPlaybackException;

    public void replaceStream(Format[] var1, SampleStream var2, long var3, long var5, MediaSource.MediaPeriodId var7) throws ExoPlaybackException;

    @Nullable
    public SampleStream getStream();

    public boolean hasReadStreamToEnd();

    public long getReadingPositionUs();

    public void setCurrentStreamFinal();

    public boolean isCurrentStreamFinal();

    public void maybeThrowStreamError() throws IOException;

    public void resetPosition(long var1) throws ExoPlaybackException;

    default public void setPlaybackSpeed(float currentPlaybackSpeed, float targetPlaybackSpeed) throws ExoPlaybackException {
    }

    default public void enableMayRenderStartOfStream() {
    }

    public void setTimeline(Timeline var1);

    public void render(long var1, long var3) throws ExoPlaybackException;

    public boolean isReady();

    public boolean isEnded();

    public void stop();

    public void disable();

    public void reset();

    default public void release() {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface State {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface MessageType {
    }

    public static interface WakeupListener {
        public void onSleep();

        public void onWakeup();
    }
}

