/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.analytics;

import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.DeviceInfo;
import androidx.media3.common.FlagSet;
import androidx.media3.common.Format;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import androidx.media3.common.Metadata;
import androidx.media3.common.PlaybackException;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.VideoSize;
import androidx.media3.common.text.Cue;
import androidx.media3.common.text.CueGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.source.MediaLoadData;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;

public interface AnalyticsListener {
    @UnstableApi
    public static final int EVENT_TIMELINE_CHANGED = 0;
    @UnstableApi
    public static final int EVENT_MEDIA_ITEM_TRANSITION = 1;
    @UnstableApi
    public static final int EVENT_TRACKS_CHANGED = 2;
    @UnstableApi
    public static final int EVENT_IS_LOADING_CHANGED = 3;
    @UnstableApi
    public static final int EVENT_PLAYBACK_STATE_CHANGED = 4;
    @UnstableApi
    public static final int EVENT_PLAY_WHEN_READY_CHANGED = 5;
    @UnstableApi
    public static final int EVENT_PLAYBACK_SUPPRESSION_REASON_CHANGED = 6;
    @UnstableApi
    public static final int EVENT_IS_PLAYING_CHANGED = 7;
    @UnstableApi
    public static final int EVENT_REPEAT_MODE_CHANGED = 8;
    @UnstableApi
    public static final int EVENT_SHUFFLE_MODE_ENABLED_CHANGED = 9;
    @UnstableApi
    public static final int EVENT_PLAYER_ERROR = 10;
    @UnstableApi
    public static final int EVENT_POSITION_DISCONTINUITY = 11;
    @UnstableApi
    public static final int EVENT_PLAYBACK_PARAMETERS_CHANGED = 12;
    @UnstableApi
    public static final int EVENT_AVAILABLE_COMMANDS_CHANGED = 13;
    @UnstableApi
    public static final int EVENT_MEDIA_METADATA_CHANGED = 14;
    @UnstableApi
    public static final int EVENT_PLAYLIST_METADATA_CHANGED = 15;
    @UnstableApi
    public static final int EVENT_SEEK_BACK_INCREMENT_CHANGED = 16;
    @UnstableApi
    public static final int EVENT_SEEK_FORWARD_INCREMENT_CHANGED = 17;
    @UnstableApi
    public static final int EVENT_MAX_SEEK_TO_PREVIOUS_POSITION_CHANGED = 18;
    @UnstableApi
    public static final int EVENT_TRACK_SELECTION_PARAMETERS_CHANGED = 19;
    @UnstableApi
    public static final int EVENT_AUDIO_ATTRIBUTES_CHANGED = 20;
    @UnstableApi
    public static final int EVENT_AUDIO_SESSION_ID = 21;
    @UnstableApi
    public static final int EVENT_VOLUME_CHANGED = 22;
    @UnstableApi
    public static final int EVENT_SKIP_SILENCE_ENABLED_CHANGED = 23;
    @UnstableApi
    public static final int EVENT_SURFACE_SIZE_CHANGED = 24;
    @UnstableApi
    public static final int EVENT_VIDEO_SIZE_CHANGED = 25;
    @UnstableApi
    public static final int EVENT_RENDERED_FIRST_FRAME = 26;
    @UnstableApi
    public static final int EVENT_METADATA = 28;
    @UnstableApi
    public static final int EVENT_CUES = 27;
    @UnstableApi
    public static final int EVENT_DEVICE_INFO_CHANGED = 29;
    @UnstableApi
    public static final int EVENT_DEVICE_VOLUME_CHANGED = 30;
    @UnstableApi
    public static final int EVENT_LOAD_STARTED = 1000;
    @UnstableApi
    public static final int EVENT_LOAD_COMPLETED = 1001;
    @UnstableApi
    public static final int EVENT_LOAD_CANCELED = 1002;
    @UnstableApi
    public static final int EVENT_LOAD_ERROR = 1003;
    @UnstableApi
    public static final int EVENT_DOWNSTREAM_FORMAT_CHANGED = 1004;
    @UnstableApi
    public static final int EVENT_UPSTREAM_DISCARDED = 1005;
    @UnstableApi
    public static final int EVENT_BANDWIDTH_ESTIMATE = 1006;
    @UnstableApi
    public static final int EVENT_AUDIO_ENABLED = 1007;
    @UnstableApi
    public static final int EVENT_AUDIO_DECODER_INITIALIZED = 1008;
    @UnstableApi
    public static final int EVENT_AUDIO_INPUT_FORMAT_CHANGED = 1009;
    @UnstableApi
    public static final int EVENT_AUDIO_POSITION_ADVANCING = 1010;
    @UnstableApi
    public static final int EVENT_AUDIO_UNDERRUN = 1011;
    @UnstableApi
    public static final int EVENT_AUDIO_DECODER_RELEASED = 1012;
    @UnstableApi
    public static final int EVENT_AUDIO_DISABLED = 1013;
    @UnstableApi
    public static final int EVENT_AUDIO_SINK_ERROR = 1014;
    @UnstableApi
    public static final int EVENT_VIDEO_ENABLED = 1015;
    @UnstableApi
    public static final int EVENT_VIDEO_DECODER_INITIALIZED = 1016;
    @UnstableApi
    public static final int EVENT_VIDEO_INPUT_FORMAT_CHANGED = 1017;
    @UnstableApi
    public static final int EVENT_DROPPED_VIDEO_FRAMES = 1018;
    @UnstableApi
    public static final int EVENT_VIDEO_DECODER_RELEASED = 1019;
    @UnstableApi
    public static final int EVENT_VIDEO_DISABLED = 1020;
    @UnstableApi
    public static final int EVENT_VIDEO_FRAME_PROCESSING_OFFSET = 1021;
    @UnstableApi
    public static final int EVENT_DRM_SESSION_ACQUIRED = 1022;
    @UnstableApi
    public static final int EVENT_DRM_KEYS_LOADED = 1023;
    @UnstableApi
    public static final int EVENT_DRM_SESSION_MANAGER_ERROR = 1024;
    @UnstableApi
    public static final int EVENT_DRM_KEYS_RESTORED = 1025;
    @UnstableApi
    public static final int EVENT_DRM_KEYS_REMOVED = 1026;
    @UnstableApi
    public static final int EVENT_DRM_SESSION_RELEASED = 1027;
    @UnstableApi
    public static final int EVENT_PLAYER_RELEASED = 1028;
    @UnstableApi
    public static final int EVENT_AUDIO_CODEC_ERROR = 1029;
    @UnstableApi
    public static final int EVENT_VIDEO_CODEC_ERROR = 1030;
    @UnstableApi
    public static final int EVENT_AUDIO_TRACK_INITIALIZED = 1031;
    @UnstableApi
    public static final int EVENT_AUDIO_TRACK_RELEASED = 1032;

    @Deprecated
    @UnstableApi
    default public void onPlayerStateChanged(EventTime eventTime, boolean playWhenReady, int playbackState) {
    }

    @UnstableApi
    default public void onPlaybackStateChanged(EventTime eventTime, int state) {
    }

    @UnstableApi
    default public void onPlayWhenReadyChanged(EventTime eventTime, boolean playWhenReady, int reason) {
    }

    @UnstableApi
    default public void onPlaybackSuppressionReasonChanged(EventTime eventTime, int playbackSuppressionReason) {
    }

    @UnstableApi
    default public void onIsPlayingChanged(EventTime eventTime, boolean isPlaying) {
    }

    @UnstableApi
    default public void onTimelineChanged(EventTime eventTime, int reason) {
    }

    @UnstableApi
    default public void onMediaItemTransition(EventTime eventTime, @Nullable MediaItem mediaItem, int reason) {
    }

    @Deprecated
    @UnstableApi
    default public void onPositionDiscontinuity(EventTime eventTime, int reason) {
    }

    @UnstableApi
    default public void onPositionDiscontinuity(EventTime eventTime, Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
    }

    @Deprecated
    @UnstableApi
    default public void onSeekStarted(EventTime eventTime) {
    }

    @UnstableApi
    default public void onPlaybackParametersChanged(EventTime eventTime, PlaybackParameters playbackParameters) {
    }

    @UnstableApi
    default public void onSeekBackIncrementChanged(EventTime eventTime, long seekBackIncrementMs) {
    }

    @UnstableApi
    default public void onSeekForwardIncrementChanged(EventTime eventTime, long seekForwardIncrementMs) {
    }

    @UnstableApi
    default public void onMaxSeekToPreviousPositionChanged(EventTime eventTime, long maxSeekToPreviousPositionMs) {
    }

    @UnstableApi
    default public void onRepeatModeChanged(EventTime eventTime, int repeatMode) {
    }

    @UnstableApi
    default public void onShuffleModeChanged(EventTime eventTime, boolean shuffleModeEnabled) {
    }

    @UnstableApi
    default public void onIsLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    @Deprecated
    @UnstableApi
    default public void onLoadingChanged(EventTime eventTime, boolean isLoading) {
    }

    @UnstableApi
    default public void onAvailableCommandsChanged(EventTime eventTime, Player.Commands availableCommands) {
    }

    @UnstableApi
    default public void onPlayerError(EventTime eventTime, PlaybackException error) {
    }

    @UnstableApi
    default public void onPlayerErrorChanged(EventTime eventTime, @Nullable PlaybackException error) {
    }

    @UnstableApi
    default public void onTracksChanged(EventTime eventTime, Tracks tracks) {
    }

    @UnstableApi
    default public void onTrackSelectionParametersChanged(EventTime eventTime, TrackSelectionParameters trackSelectionParameters) {
    }

    @UnstableApi
    default public void onMediaMetadataChanged(EventTime eventTime, MediaMetadata mediaMetadata) {
    }

    @UnstableApi
    default public void onPlaylistMetadataChanged(EventTime eventTime, MediaMetadata playlistMetadata) {
    }

    @UnstableApi
    default public void onLoadStarted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @UnstableApi
    default public void onLoadCompleted(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @UnstableApi
    default public void onLoadCanceled(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData) {
    }

    @UnstableApi
    default public void onLoadError(EventTime eventTime, LoadEventInfo loadEventInfo, MediaLoadData mediaLoadData, IOException error, boolean wasCanceled) {
    }

    @UnstableApi
    default public void onDownstreamFormatChanged(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    @UnstableApi
    default public void onUpstreamDiscarded(EventTime eventTime, MediaLoadData mediaLoadData) {
    }

    @UnstableApi
    default public void onBandwidthEstimate(EventTime eventTime, int totalLoadTimeMs, long totalBytesLoaded, long bitrateEstimate) {
    }

    @UnstableApi
    default public void onMetadata(EventTime eventTime, Metadata metadata) {
    }

    @Deprecated
    @UnstableApi
    default public void onCues(EventTime eventTime, List<Cue> cues) {
    }

    @UnstableApi
    default public void onCues(EventTime eventTime, CueGroup cueGroup) {
    }

    @UnstableApi
    default public void onAudioEnabled(EventTime eventTime, DecoderCounters decoderCounters) {
    }

    @UnstableApi
    default public void onAudioDecoderInitialized(EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    @UnstableApi
    default public void onAudioDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    @UnstableApi
    default public void onAudioInputFormatChanged(EventTime eventTime, Format format) {
    }

    @UnstableApi
    default public void onAudioInputFormatChanged(EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    @UnstableApi
    default public void onAudioPositionAdvancing(EventTime eventTime, long playoutStartSystemTimeMs) {
    }

    @UnstableApi
    default public void onAudioUnderrun(EventTime eventTime, int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    @UnstableApi
    default public void onAudioDecoderReleased(EventTime eventTime, String decoderName) {
    }

    @UnstableApi
    default public void onAudioDisabled(EventTime eventTime, DecoderCounters decoderCounters) {
    }

    @UnstableApi
    default public void onAudioSessionIdChanged(EventTime eventTime, int audioSessionId) {
    }

    @UnstableApi
    default public void onAudioAttributesChanged(EventTime eventTime, AudioAttributes audioAttributes) {
    }

    @UnstableApi
    default public void onSkipSilenceEnabledChanged(EventTime eventTime, boolean skipSilenceEnabled) {
    }

    @UnstableApi
    default public void onAudioSinkError(EventTime eventTime, Exception audioSinkError) {
    }

    @UnstableApi
    default public void onAudioCodecError(EventTime eventTime, Exception audioCodecError) {
    }

    @UnstableApi
    default public void onAudioTrackInitialized(EventTime eventTime, AudioSink.AudioTrackConfig audioTrackConfig) {
    }

    @UnstableApi
    default public void onAudioTrackReleased(EventTime eventTime, AudioSink.AudioTrackConfig audioTrackConfig) {
    }

    @UnstableApi
    default public void onVolumeChanged(EventTime eventTime, float volume) {
    }

    @UnstableApi
    default public void onDeviceInfoChanged(EventTime eventTime, DeviceInfo deviceInfo) {
    }

    @UnstableApi
    default public void onDeviceVolumeChanged(EventTime eventTime, int volume, boolean muted) {
    }

    @UnstableApi
    default public void onVideoEnabled(EventTime eventTime, DecoderCounters decoderCounters) {
    }

    @UnstableApi
    default public void onVideoDecoderInitialized(EventTime eventTime, String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    @UnstableApi
    default public void onVideoDecoderInitialized(EventTime eventTime, String decoderName, long initializationDurationMs) {
    }

    @Deprecated
    @UnstableApi
    default public void onVideoInputFormatChanged(EventTime eventTime, Format format) {
    }

    @UnstableApi
    default public void onVideoInputFormatChanged(EventTime eventTime, Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    @UnstableApi
    default public void onDroppedVideoFrames(EventTime eventTime, int droppedFrames, long elapsedMs) {
    }

    @UnstableApi
    default public void onVideoDecoderReleased(EventTime eventTime, String decoderName) {
    }

    @UnstableApi
    default public void onVideoDisabled(EventTime eventTime, DecoderCounters decoderCounters) {
    }

    @UnstableApi
    default public void onVideoFrameProcessingOffset(EventTime eventTime, long totalProcessingOffsetUs, int frameCount) {
    }

    @UnstableApi
    default public void onVideoCodecError(EventTime eventTime, Exception videoCodecError) {
    }

    @UnstableApi
    default public void onRenderedFirstFrame(EventTime eventTime, Object output, long renderTimeMs) {
    }

    @UnstableApi
    default public void onVideoSizeChanged(EventTime eventTime, VideoSize videoSize) {
    }

    @Deprecated
    @UnstableApi
    default public void onVideoSizeChanged(EventTime eventTime, int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
    }

    @UnstableApi
    default public void onSurfaceSizeChanged(EventTime eventTime, int width, int height) {
    }

    @Deprecated
    @UnstableApi
    default public void onDrmSessionAcquired(EventTime eventTime) {
    }

    @UnstableApi
    default public void onDrmSessionAcquired(EventTime eventTime, int state) {
    }

    @UnstableApi
    default public void onDrmKeysLoaded(EventTime eventTime) {
    }

    @UnstableApi
    default public void onDrmSessionManagerError(EventTime eventTime, Exception error) {
    }

    @UnstableApi
    default public void onDrmKeysRestored(EventTime eventTime) {
    }

    @UnstableApi
    default public void onDrmKeysRemoved(EventTime eventTime) {
    }

    @UnstableApi
    default public void onDrmSessionReleased(EventTime eventTime) {
    }

    @UnstableApi
    default public void onPlayerReleased(EventTime eventTime) {
    }

    @UnstableApi
    default public void onEvents(Player player, Events events) {
    }

    @UnstableApi
    public static final class EventTime {
        public final long realtimeMs;
        public final Timeline timeline;
        public final int windowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId mediaPeriodId;
        public final long eventPlaybackPositionMs;
        public final Timeline currentTimeline;
        public final int currentWindowIndex;
        @Nullable
        public final MediaSource.MediaPeriodId currentMediaPeriodId;
        public final long currentPlaybackPositionMs;
        public final long totalBufferedDurationMs;

        public EventTime(long realtimeMs, Timeline timeline, int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long eventPlaybackPositionMs, Timeline currentTimeline, int currentWindowIndex, @Nullable MediaSource.MediaPeriodId currentMediaPeriodId, long currentPlaybackPositionMs, long totalBufferedDurationMs) {
            this.realtimeMs = realtimeMs;
            this.timeline = timeline;
            this.windowIndex = windowIndex;
            this.mediaPeriodId = mediaPeriodId;
            this.eventPlaybackPositionMs = eventPlaybackPositionMs;
            this.currentTimeline = currentTimeline;
            this.currentWindowIndex = currentWindowIndex;
            this.currentMediaPeriodId = currentMediaPeriodId;
            this.currentPlaybackPositionMs = currentPlaybackPositionMs;
            this.totalBufferedDurationMs = totalBufferedDurationMs;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTime eventTime = (EventTime)o;
            return this.realtimeMs == eventTime.realtimeMs && this.windowIndex == eventTime.windowIndex && this.eventPlaybackPositionMs == eventTime.eventPlaybackPositionMs && this.currentWindowIndex == eventTime.currentWindowIndex && this.currentPlaybackPositionMs == eventTime.currentPlaybackPositionMs && this.totalBufferedDurationMs == eventTime.totalBufferedDurationMs && Objects.equal((Object)this.timeline, (Object)eventTime.timeline) && Objects.equal((Object)this.mediaPeriodId, (Object)eventTime.mediaPeriodId) && Objects.equal((Object)this.currentTimeline, (Object)eventTime.currentTimeline) && Objects.equal((Object)this.currentMediaPeriodId, (Object)eventTime.currentMediaPeriodId);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.realtimeMs, this.timeline, this.windowIndex, this.mediaPeriodId, this.eventPlaybackPositionMs, this.currentTimeline, this.currentWindowIndex, this.currentMediaPeriodId, this.currentPlaybackPositionMs, this.totalBufferedDurationMs});
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    @UnstableApi
    public static @interface EventFlags {
    }

    @UnstableApi
    public static final class Events {
        private final FlagSet flags;
        private final SparseArray<EventTime> eventTimes;

        public Events(FlagSet flags, SparseArray<EventTime> eventTimes) {
            this.flags = flags;
            SparseArray flagsToTimes = new SparseArray(flags.size());
            for (int i = 0; i < flags.size(); ++i) {
                int eventFlag = flags.get(i);
                flagsToTimes.append(eventFlag, (Object)((EventTime)Assertions.checkNotNull((Object)((EventTime)eventTimes.get(eventFlag)))));
            }
            this.eventTimes = flagsToTimes;
        }

        public EventTime getEventTime(int event) {
            return (EventTime)Assertions.checkNotNull((Object)((EventTime)this.eventTimes.get(event)));
        }

        public boolean contains(int event) {
            return this.flags.contains(event);
        }

        public boolean containsAny(int ... events) {
            return this.flags.containsAny(events);
        }

        public int size() {
            return this.flags.size();
        }

        public int get(int index) {
            return this.flags.get(index);
        }
    }
}

