/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.analytics;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.analytics.AnalyticsListener;
import java.util.Collections;
import java.util.List;

@UnstableApi
public final class PlaybackStats {
    public static final int PLAYBACK_STATE_NOT_STARTED = 0;
    public static final int PLAYBACK_STATE_JOINING_BACKGROUND = 1;
    public static final int PLAYBACK_STATE_JOINING_FOREGROUND = 2;
    public static final int PLAYBACK_STATE_PLAYING = 3;
    public static final int PLAYBACK_STATE_PAUSED = 4;
    public static final int PLAYBACK_STATE_SEEKING = 5;
    public static final int PLAYBACK_STATE_BUFFERING = 6;
    public static final int PLAYBACK_STATE_PAUSED_BUFFERING = 7;
    public static final int PLAYBACK_STATE_SUPPRESSED = 9;
    public static final int PLAYBACK_STATE_SUPPRESSED_BUFFERING = 10;
    public static final int PLAYBACK_STATE_ENDED = 11;
    public static final int PLAYBACK_STATE_STOPPED = 12;
    public static final int PLAYBACK_STATE_FAILED = 13;
    public static final int PLAYBACK_STATE_INTERRUPTED_BY_AD = 14;
    public static final int PLAYBACK_STATE_ABANDONED = 15;
    static final int PLAYBACK_STATE_COUNT = 16;
    public static final PlaybackStats EMPTY = PlaybackStats.merge(new PlaybackStats[0]);
    public final int playbackCount;
    public final List<EventTimeAndPlaybackState> playbackStateHistory;
    public final List<long[]> mediaTimeHistory;
    public final long firstReportedTimeMs;
    public final int foregroundPlaybackCount;
    public final int abandonedBeforeReadyCount;
    public final int endedCount;
    public final int backgroundJoiningCount;
    public final long totalValidJoinTimeMs;
    public final int validJoinTimeCount;
    public final int totalPauseCount;
    public final int totalPauseBufferCount;
    public final int totalSeekCount;
    public final int totalRebufferCount;
    public final long maxRebufferTimeMs;
    public final int adPlaybackCount;
    public final List<EventTimeAndFormat> videoFormatHistory;
    public final List<EventTimeAndFormat> audioFormatHistory;
    public final long totalVideoFormatHeightTimeMs;
    public final long totalVideoFormatHeightTimeProduct;
    public final long totalVideoFormatBitrateTimeMs;
    public final long totalVideoFormatBitrateTimeProduct;
    public final long totalAudioFormatTimeMs;
    public final long totalAudioFormatBitrateTimeProduct;
    public final int initialVideoFormatHeightCount;
    public final int initialVideoFormatBitrateCount;
    public final int totalInitialVideoFormatHeight;
    public final long totalInitialVideoFormatBitrate;
    public final int initialAudioFormatBitrateCount;
    public final long totalInitialAudioFormatBitrate;
    public final long totalBandwidthTimeMs;
    public final long totalBandwidthBytes;
    public final long totalDroppedFrames;
    public final long totalAudioUnderruns;
    public final int fatalErrorPlaybackCount;
    public final int fatalErrorCount;
    public final int nonFatalErrorCount;
    public final List<EventTimeAndException> fatalErrorHistory;
    public final List<EventTimeAndException> nonFatalErrorHistory;
    private final long[] playbackStateDurationsMs;

    public static PlaybackStats merge(PlaybackStats ... playbackStats) {
        int playbackCount = 0;
        long[] playbackStateDurationsMs = new long[16];
        long firstReportedTimeMs = -9223372036854775807L;
        int foregroundPlaybackCount = 0;
        int abandonedBeforeReadyCount = 0;
        int endedCount = 0;
        int backgroundJoiningCount = 0;
        long totalValidJoinTimeMs = -9223372036854775807L;
        int validJoinTimeCount = 0;
        int totalPauseCount = 0;
        int totalPauseBufferCount = 0;
        int totalSeekCount = 0;
        int totalRebufferCount = 0;
        long maxRebufferTimeMs = -9223372036854775807L;
        int adPlaybackCount = 0;
        long totalVideoFormatHeightTimeMs = 0L;
        long totalVideoFormatHeightTimeProduct = 0L;
        long totalVideoFormatBitrateTimeMs = 0L;
        long totalVideoFormatBitrateTimeProduct = 0L;
        long totalAudioFormatTimeMs = 0L;
        long totalAudioFormatBitrateTimeProduct = 0L;
        int initialVideoFormatHeightCount = 0;
        int initialVideoFormatBitrateCount = 0;
        int totalInitialVideoFormatHeight = -1;
        long totalInitialVideoFormatBitrate = -1L;
        int initialAudioFormatBitrateCount = 0;
        long totalInitialAudioFormatBitrate = -1L;
        long totalBandwidthTimeMs = 0L;
        long totalBandwidthBytes = 0L;
        long totalDroppedFrames = 0L;
        long totalAudioUnderruns = 0L;
        int fatalErrorPlaybackCount = 0;
        int fatalErrorCount = 0;
        int nonFatalErrorCount = 0;
        for (PlaybackStats stats : playbackStats) {
            playbackCount += stats.playbackCount;
            for (int i = 0; i < 16; ++i) {
                int n = i;
                playbackStateDurationsMs[n] = playbackStateDurationsMs[n] + stats.playbackStateDurationsMs[i];
            }
            if (firstReportedTimeMs == -9223372036854775807L) {
                firstReportedTimeMs = stats.firstReportedTimeMs;
            } else if (stats.firstReportedTimeMs != -9223372036854775807L) {
                firstReportedTimeMs = Math.min(firstReportedTimeMs, stats.firstReportedTimeMs);
            }
            foregroundPlaybackCount += stats.foregroundPlaybackCount;
            abandonedBeforeReadyCount += stats.abandonedBeforeReadyCount;
            endedCount += stats.endedCount;
            backgroundJoiningCount += stats.backgroundJoiningCount;
            if (totalValidJoinTimeMs == -9223372036854775807L) {
                totalValidJoinTimeMs = stats.totalValidJoinTimeMs;
            } else if (stats.totalValidJoinTimeMs != -9223372036854775807L) {
                totalValidJoinTimeMs += stats.totalValidJoinTimeMs;
            }
            validJoinTimeCount += stats.validJoinTimeCount;
            totalPauseCount += stats.totalPauseCount;
            totalPauseBufferCount += stats.totalPauseBufferCount;
            totalSeekCount += stats.totalSeekCount;
            totalRebufferCount += stats.totalRebufferCount;
            if (maxRebufferTimeMs == -9223372036854775807L) {
                maxRebufferTimeMs = stats.maxRebufferTimeMs;
            } else if (stats.maxRebufferTimeMs != -9223372036854775807L) {
                maxRebufferTimeMs = Math.max(maxRebufferTimeMs, stats.maxRebufferTimeMs);
            }
            adPlaybackCount += stats.adPlaybackCount;
            totalVideoFormatHeightTimeMs += stats.totalVideoFormatHeightTimeMs;
            totalVideoFormatHeightTimeProduct += stats.totalVideoFormatHeightTimeProduct;
            totalVideoFormatBitrateTimeMs += stats.totalVideoFormatBitrateTimeMs;
            totalVideoFormatBitrateTimeProduct += stats.totalVideoFormatBitrateTimeProduct;
            totalAudioFormatTimeMs += stats.totalAudioFormatTimeMs;
            totalAudioFormatBitrateTimeProduct += stats.totalAudioFormatBitrateTimeProduct;
            initialVideoFormatHeightCount += stats.initialVideoFormatHeightCount;
            initialVideoFormatBitrateCount += stats.initialVideoFormatBitrateCount;
            if (totalInitialVideoFormatHeight == -1) {
                totalInitialVideoFormatHeight = stats.totalInitialVideoFormatHeight;
            } else if (stats.totalInitialVideoFormatHeight != -1) {
                totalInitialVideoFormatHeight += stats.totalInitialVideoFormatHeight;
            }
            if (totalInitialVideoFormatBitrate == -1L) {
                totalInitialVideoFormatBitrate = stats.totalInitialVideoFormatBitrate;
            } else if (stats.totalInitialVideoFormatBitrate != -1L) {
                totalInitialVideoFormatBitrate += stats.totalInitialVideoFormatBitrate;
            }
            initialAudioFormatBitrateCount += stats.initialAudioFormatBitrateCount;
            if (totalInitialAudioFormatBitrate == -1L) {
                totalInitialAudioFormatBitrate = stats.totalInitialAudioFormatBitrate;
            } else if (stats.totalInitialAudioFormatBitrate != -1L) {
                totalInitialAudioFormatBitrate += stats.totalInitialAudioFormatBitrate;
            }
            totalBandwidthTimeMs += stats.totalBandwidthTimeMs;
            totalBandwidthBytes += stats.totalBandwidthBytes;
            totalDroppedFrames += stats.totalDroppedFrames;
            totalAudioUnderruns += stats.totalAudioUnderruns;
            fatalErrorPlaybackCount += stats.fatalErrorPlaybackCount;
            fatalErrorCount += stats.fatalErrorCount;
            nonFatalErrorCount += stats.nonFatalErrorCount;
        }
        return new PlaybackStats(playbackCount, playbackStateDurationsMs, Collections.emptyList(), Collections.emptyList(), firstReportedTimeMs, foregroundPlaybackCount, abandonedBeforeReadyCount, endedCount, backgroundJoiningCount, totalValidJoinTimeMs, validJoinTimeCount, totalPauseCount, totalPauseBufferCount, totalSeekCount, totalRebufferCount, maxRebufferTimeMs, adPlaybackCount, Collections.emptyList(), Collections.emptyList(), totalVideoFormatHeightTimeMs, totalVideoFormatHeightTimeProduct, totalVideoFormatBitrateTimeMs, totalVideoFormatBitrateTimeProduct, totalAudioFormatTimeMs, totalAudioFormatBitrateTimeProduct, initialVideoFormatHeightCount, initialVideoFormatBitrateCount, totalInitialVideoFormatHeight, totalInitialVideoFormatBitrate, initialAudioFormatBitrateCount, totalInitialAudioFormatBitrate, totalBandwidthTimeMs, totalBandwidthBytes, totalDroppedFrames, totalAudioUnderruns, fatalErrorPlaybackCount, fatalErrorCount, nonFatalErrorCount, Collections.emptyList(), Collections.emptyList());
    }

    PlaybackStats(int playbackCount, long[] playbackStateDurationsMs, List<EventTimeAndPlaybackState> playbackStateHistory, List<long[]> mediaTimeHistory, long firstReportedTimeMs, int foregroundPlaybackCount, int abandonedBeforeReadyCount, int endedCount, int backgroundJoiningCount, long totalValidJoinTimeMs, int validJoinTimeCount, int totalPauseCount, int totalPauseBufferCount, int totalSeekCount, int totalRebufferCount, long maxRebufferTimeMs, int adPlaybackCount, List<EventTimeAndFormat> videoFormatHistory, List<EventTimeAndFormat> audioFormatHistory, long totalVideoFormatHeightTimeMs, long totalVideoFormatHeightTimeProduct, long totalVideoFormatBitrateTimeMs, long totalVideoFormatBitrateTimeProduct, long totalAudioFormatTimeMs, long totalAudioFormatBitrateTimeProduct, int initialVideoFormatHeightCount, int initialVideoFormatBitrateCount, int totalInitialVideoFormatHeight, long totalInitialVideoFormatBitrate, int initialAudioFormatBitrateCount, long totalInitialAudioFormatBitrate, long totalBandwidthTimeMs, long totalBandwidthBytes, long totalDroppedFrames, long totalAudioUnderruns, int fatalErrorPlaybackCount, int fatalErrorCount, int nonFatalErrorCount, List<EventTimeAndException> fatalErrorHistory, List<EventTimeAndException> nonFatalErrorHistory) {
        this.playbackCount = playbackCount;
        this.playbackStateDurationsMs = playbackStateDurationsMs;
        this.playbackStateHistory = Collections.unmodifiableList(playbackStateHistory);
        this.mediaTimeHistory = Collections.unmodifiableList(mediaTimeHistory);
        this.firstReportedTimeMs = firstReportedTimeMs;
        this.foregroundPlaybackCount = foregroundPlaybackCount;
        this.abandonedBeforeReadyCount = abandonedBeforeReadyCount;
        this.endedCount = endedCount;
        this.backgroundJoiningCount = backgroundJoiningCount;
        this.totalValidJoinTimeMs = totalValidJoinTimeMs;
        this.validJoinTimeCount = validJoinTimeCount;
        this.totalPauseCount = totalPauseCount;
        this.totalPauseBufferCount = totalPauseBufferCount;
        this.totalSeekCount = totalSeekCount;
        this.totalRebufferCount = totalRebufferCount;
        this.maxRebufferTimeMs = maxRebufferTimeMs;
        this.adPlaybackCount = adPlaybackCount;
        this.videoFormatHistory = Collections.unmodifiableList(videoFormatHistory);
        this.audioFormatHistory = Collections.unmodifiableList(audioFormatHistory);
        this.totalVideoFormatHeightTimeMs = totalVideoFormatHeightTimeMs;
        this.totalVideoFormatHeightTimeProduct = totalVideoFormatHeightTimeProduct;
        this.totalVideoFormatBitrateTimeMs = totalVideoFormatBitrateTimeMs;
        this.totalVideoFormatBitrateTimeProduct = totalVideoFormatBitrateTimeProduct;
        this.totalAudioFormatTimeMs = totalAudioFormatTimeMs;
        this.totalAudioFormatBitrateTimeProduct = totalAudioFormatBitrateTimeProduct;
        this.initialVideoFormatHeightCount = initialVideoFormatHeightCount;
        this.initialVideoFormatBitrateCount = initialVideoFormatBitrateCount;
        this.totalInitialVideoFormatHeight = totalInitialVideoFormatHeight;
        this.totalInitialVideoFormatBitrate = totalInitialVideoFormatBitrate;
        this.initialAudioFormatBitrateCount = initialAudioFormatBitrateCount;
        this.totalInitialAudioFormatBitrate = totalInitialAudioFormatBitrate;
        this.totalBandwidthTimeMs = totalBandwidthTimeMs;
        this.totalBandwidthBytes = totalBandwidthBytes;
        this.totalDroppedFrames = totalDroppedFrames;
        this.totalAudioUnderruns = totalAudioUnderruns;
        this.fatalErrorPlaybackCount = fatalErrorPlaybackCount;
        this.fatalErrorCount = fatalErrorCount;
        this.nonFatalErrorCount = nonFatalErrorCount;
        this.fatalErrorHistory = Collections.unmodifiableList(fatalErrorHistory);
        this.nonFatalErrorHistory = Collections.unmodifiableList(nonFatalErrorHistory);
    }

    public long getPlaybackStateDurationMs(int playbackState) {
        return this.playbackStateDurationsMs[playbackState];
    }

    public int getPlaybackStateAtTime(long realtimeMs) {
        int state = 0;
        for (EventTimeAndPlaybackState timeAndState : this.playbackStateHistory) {
            if (timeAndState.eventTime.realtimeMs > realtimeMs) break;
            state = timeAndState.playbackState;
        }
        return state;
    }

    public long getMediaTimeMsAtRealtimeMs(long realtimeMs) {
        int nextIndex;
        if (this.mediaTimeHistory.isEmpty()) {
            return -9223372036854775807L;
        }
        for (nextIndex = 0; nextIndex < this.mediaTimeHistory.size() && this.mediaTimeHistory.get(nextIndex)[0] <= realtimeMs; ++nextIndex) {
        }
        if (nextIndex == 0) {
            return this.mediaTimeHistory.get(0)[1];
        }
        if (nextIndex == this.mediaTimeHistory.size()) {
            return this.mediaTimeHistory.get(this.mediaTimeHistory.size() - 1)[1];
        }
        long prevRealtimeMs = this.mediaTimeHistory.get(nextIndex - 1)[0];
        long prevMediaTimeMs = this.mediaTimeHistory.get(nextIndex - 1)[1];
        long nextRealtimeMs = this.mediaTimeHistory.get(nextIndex)[0];
        long nextMediaTimeMs = this.mediaTimeHistory.get(nextIndex)[1];
        long realtimeDurationMs = nextRealtimeMs - prevRealtimeMs;
        if (realtimeDurationMs == 0L) {
            return prevMediaTimeMs;
        }
        float fraction = (float)(realtimeMs - prevRealtimeMs) / (float)realtimeDurationMs;
        return prevMediaTimeMs + (long)((float)(nextMediaTimeMs - prevMediaTimeMs) * fraction);
    }

    public long getMeanJoinTimeMs() {
        return this.validJoinTimeCount == 0 ? -9223372036854775807L : this.totalValidJoinTimeMs / (long)this.validJoinTimeCount;
    }

    public long getTotalJoinTimeMs() {
        return this.getPlaybackStateDurationMs(2);
    }

    public long getTotalPlayTimeMs() {
        return this.getPlaybackStateDurationMs(3);
    }

    public long getMeanPlayTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalPlayTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getTotalPausedTimeMs() {
        return this.getPlaybackStateDurationMs(4) + this.getPlaybackStateDurationMs(7);
    }

    public long getMeanPausedTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalPausedTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getTotalRebufferTimeMs() {
        return this.getPlaybackStateDurationMs(6);
    }

    public long getMeanRebufferTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalRebufferTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getMeanSingleRebufferTimeMs() {
        return this.totalRebufferCount == 0 ? -9223372036854775807L : (this.getPlaybackStateDurationMs(6) + this.getPlaybackStateDurationMs(7)) / (long)this.totalRebufferCount;
    }

    public long getTotalSeekTimeMs() {
        return this.getPlaybackStateDurationMs(5);
    }

    public long getMeanSeekTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalSeekTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getMeanSingleSeekTimeMs() {
        return this.totalSeekCount == 0 ? -9223372036854775807L : this.getTotalSeekTimeMs() / (long)this.totalSeekCount;
    }

    public long getTotalWaitTimeMs() {
        return this.getPlaybackStateDurationMs(2) + this.getPlaybackStateDurationMs(6) + this.getPlaybackStateDurationMs(5);
    }

    public long getMeanWaitTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalWaitTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getTotalPlayAndWaitTimeMs() {
        return this.getTotalPlayTimeMs() + this.getTotalWaitTimeMs();
    }

    public long getMeanPlayAndWaitTimeMs() {
        return this.foregroundPlaybackCount == 0 ? -9223372036854775807L : this.getTotalPlayAndWaitTimeMs() / (long)this.foregroundPlaybackCount;
    }

    public long getTotalElapsedTimeMs() {
        long totalTimeMs = 0L;
        for (int i = 0; i < 16; ++i) {
            totalTimeMs += this.playbackStateDurationsMs[i];
        }
        return totalTimeMs;
    }

    public long getMeanElapsedTimeMs() {
        return this.playbackCount == 0 ? -9223372036854775807L : this.getTotalElapsedTimeMs() / (long)this.playbackCount;
    }

    public float getAbandonedBeforeReadyRatio() {
        int foregroundAbandonedBeforeReady = this.abandonedBeforeReadyCount - (this.playbackCount - this.foregroundPlaybackCount);
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)foregroundAbandonedBeforeReady / (float)this.foregroundPlaybackCount;
    }

    public float getEndedRatio() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.endedCount / (float)this.foregroundPlaybackCount;
    }

    public float getMeanPauseCount() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.totalPauseCount / (float)this.foregroundPlaybackCount;
    }

    public float getMeanPauseBufferCount() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.totalPauseBufferCount / (float)this.foregroundPlaybackCount;
    }

    public float getMeanSeekCount() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.totalSeekCount / (float)this.foregroundPlaybackCount;
    }

    public float getMeanRebufferCount() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.totalRebufferCount / (float)this.foregroundPlaybackCount;
    }

    public float getWaitTimeRatio() {
        long playAndWaitTimeMs = this.getTotalPlayAndWaitTimeMs();
        return playAndWaitTimeMs == 0L ? 0.0f : (float)this.getTotalWaitTimeMs() / (float)playAndWaitTimeMs;
    }

    public float getJoinTimeRatio() {
        long playAndWaitTimeMs = this.getTotalPlayAndWaitTimeMs();
        return playAndWaitTimeMs == 0L ? 0.0f : (float)this.getTotalJoinTimeMs() / (float)playAndWaitTimeMs;
    }

    public float getRebufferTimeRatio() {
        long playAndWaitTimeMs = this.getTotalPlayAndWaitTimeMs();
        return playAndWaitTimeMs == 0L ? 0.0f : (float)this.getTotalRebufferTimeMs() / (float)playAndWaitTimeMs;
    }

    public float getSeekTimeRatio() {
        long playAndWaitTimeMs = this.getTotalPlayAndWaitTimeMs();
        return playAndWaitTimeMs == 0L ? 0.0f : (float)this.getTotalSeekTimeMs() / (float)playAndWaitTimeMs;
    }

    public float getRebufferRate() {
        long playTimeMs = this.getTotalPlayTimeMs();
        return playTimeMs == 0L ? 0.0f : 1000.0f * (float)this.totalRebufferCount / (float)playTimeMs;
    }

    public float getMeanTimeBetweenRebuffers() {
        return 1.0f / this.getRebufferRate();
    }

    public int getMeanInitialVideoFormatHeight() {
        return this.initialVideoFormatHeightCount == 0 ? -1 : this.totalInitialVideoFormatHeight / this.initialVideoFormatHeightCount;
    }

    public int getMeanInitialVideoFormatBitrate() {
        return this.initialVideoFormatBitrateCount == 0 ? -1 : (int)(this.totalInitialVideoFormatBitrate / (long)this.initialVideoFormatBitrateCount);
    }

    public int getMeanInitialAudioFormatBitrate() {
        return this.initialAudioFormatBitrateCount == 0 ? -1 : (int)(this.totalInitialAudioFormatBitrate / (long)this.initialAudioFormatBitrateCount);
    }

    public int getMeanVideoFormatHeight() {
        return this.totalVideoFormatHeightTimeMs == 0L ? -1 : (int)(this.totalVideoFormatHeightTimeProduct / this.totalVideoFormatHeightTimeMs);
    }

    public int getMeanVideoFormatBitrate() {
        return this.totalVideoFormatBitrateTimeMs == 0L ? -1 : (int)(this.totalVideoFormatBitrateTimeProduct / this.totalVideoFormatBitrateTimeMs);
    }

    public int getMeanAudioFormatBitrate() {
        return this.totalAudioFormatTimeMs == 0L ? -1 : (int)(this.totalAudioFormatBitrateTimeProduct / this.totalAudioFormatTimeMs);
    }

    public int getMeanBandwidth() {
        return this.totalBandwidthTimeMs == 0L ? -1 : (int)(this.totalBandwidthBytes * 8000L / this.totalBandwidthTimeMs);
    }

    public float getDroppedFramesRate() {
        long playTimeMs = this.getTotalPlayTimeMs();
        return playTimeMs == 0L ? 0.0f : 1000.0f * (float)this.totalDroppedFrames / (float)playTimeMs;
    }

    public float getAudioUnderrunRate() {
        long playTimeMs = this.getTotalPlayTimeMs();
        return playTimeMs == 0L ? 0.0f : 1000.0f * (float)this.totalAudioUnderruns / (float)playTimeMs;
    }

    public float getFatalErrorRatio() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.fatalErrorPlaybackCount / (float)this.foregroundPlaybackCount;
    }

    public float getFatalErrorRate() {
        long playTimeMs = this.getTotalPlayTimeMs();
        return playTimeMs == 0L ? 0.0f : 1000.0f * (float)this.fatalErrorCount / (float)playTimeMs;
    }

    public float getMeanTimeBetweenFatalErrors() {
        return 1.0f / this.getFatalErrorRate();
    }

    public float getMeanNonFatalErrorCount() {
        return this.foregroundPlaybackCount == 0 ? 0.0f : (float)this.nonFatalErrorCount / (float)this.foregroundPlaybackCount;
    }

    public float getNonFatalErrorRate() {
        long playTimeMs = this.getTotalPlayTimeMs();
        return playTimeMs == 0L ? 0.0f : 1000.0f * (float)this.nonFatalErrorCount / (float)playTimeMs;
    }

    public float getMeanTimeBetweenNonFatalErrors() {
        return 1.0f / this.getNonFatalErrorRate();
    }

    public static final class EventTimeAndPlaybackState {
        public final AnalyticsListener.EventTime eventTime;
        public final int playbackState;

        public EventTimeAndPlaybackState(AnalyticsListener.EventTime eventTime, int playbackState) {
            this.eventTime = eventTime;
            this.playbackState = playbackState;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTimeAndPlaybackState that = (EventTimeAndPlaybackState)o;
            if (this.playbackState != that.playbackState) {
                return false;
            }
            return this.eventTime.equals(that.eventTime);
        }

        public int hashCode() {
            int result = this.eventTime.hashCode();
            result = 31 * result + this.playbackState;
            return result;
        }
    }

    public static final class EventTimeAndException {
        public final AnalyticsListener.EventTime eventTime;
        public final Exception exception;

        public EventTimeAndException(AnalyticsListener.EventTime eventTime, Exception exception) {
            this.eventTime = eventTime;
            this.exception = exception;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTimeAndException that = (EventTimeAndException)o;
            if (!this.eventTime.equals(that.eventTime)) {
                return false;
            }
            return this.exception.equals(that.exception);
        }

        public int hashCode() {
            int result = this.eventTime.hashCode();
            result = 31 * result + this.exception.hashCode();
            return result;
        }
    }

    public static final class EventTimeAndFormat {
        public final AnalyticsListener.EventTime eventTime;
        @Nullable
        public final Format format;

        public EventTimeAndFormat(AnalyticsListener.EventTime eventTime, @Nullable Format format) {
            this.eventTime = eventTime;
            this.format = format;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventTimeAndFormat that = (EventTimeAndFormat)o;
            if (!this.eventTime.equals(that.eventTime)) {
                return false;
            }
            return this.format != null ? this.format.equals((Object)that.format) : that.format == null;
        }

        public int hashCode() {
            int result = this.eventTime.hashCode();
            result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
            return result;
        }
    }
}

