/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.net.Uri;
import android.provider.Settings;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.AudioDeviceInfoApi23;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@UnstableApi
public final class AudioCapabilities {
    @VisibleForTesting
    static final int DEFAULT_MAX_CHANNEL_COUNT = 10;
    @VisibleForTesting
    static final int DEFAULT_SAMPLE_RATE_HZ = 48000;
    public static final AudioCapabilities DEFAULT_AUDIO_CAPABILITIES = new AudioCapabilities((List<AudioProfile>)ImmutableList.of((Object)AudioProfile.DEFAULT_AUDIO_PROFILE));
    @SuppressLint(value={"InlinedApi"})
    private static final ImmutableList<Integer> EXTERNAL_SURROUND_SOUND_ENCODINGS = ImmutableList.of((Object)2, (Object)5, (Object)6);
    @VisibleForTesting
    static final ImmutableMap<Integer, Integer> ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS = new ImmutableMap.Builder().put((Object)5, (Object)6).put((Object)17, (Object)6).put((Object)7, (Object)6).put((Object)30, (Object)10).put((Object)18, (Object)6).put((Object)6, (Object)8).put((Object)8, (Object)8).put((Object)14, (Object)8).buildOrThrow();
    private static final String EXTERNAL_SURROUND_SOUND_KEY = "external_surround_sound_enabled";
    private final SparseArray<AudioProfile> encodingToAudioProfile = new SparseArray();
    private final int maxChannelCount;

    @Deprecated
    public static AudioCapabilities getCapabilities(Context context) {
        return AudioCapabilities.getCapabilities(context, androidx.media3.common.AudioAttributes.DEFAULT, null);
    }

    public static AudioCapabilities getCapabilities(Context context, androidx.media3.common.AudioAttributes audioAttributes, @Nullable AudioDeviceInfo routedDevice) {
        AudioDeviceInfoApi23 routedDeviceApi23 = Util.SDK_INT >= 23 && routedDevice != null ? new AudioDeviceInfoApi23(routedDevice) : null;
        return AudioCapabilities.getCapabilitiesInternal(context, audioAttributes, routedDeviceApi23);
    }

    @SuppressLint(value={"UnprotectedReceiver"})
    static AudioCapabilities getCapabilitiesInternal(Context context, androidx.media3.common.AudioAttributes audioAttributes, @Nullable AudioDeviceInfoApi23 routedDevice) {
        Intent intent = context.registerReceiver(null, new IntentFilter("android.media.action.HDMI_AUDIO_PLUG"));
        return AudioCapabilities.getCapabilitiesInternal(context, intent, audioAttributes, routedDevice);
    }

    @SuppressLint(value={"InlinedApi"})
    static AudioCapabilities getCapabilitiesInternal(Context context, @Nullable Intent intent, androidx.media3.common.AudioAttributes audioAttributes, @Nullable AudioDeviceInfoApi23 routedDevice) {
        AudioDeviceInfoApi23 currentDevice;
        AudioManager audioManager = (AudioManager)Assertions.checkNotNull((Object)context.getSystemService("audio"));
        AudioDeviceInfoApi23 audioDeviceInfoApi23 = routedDevice != null ? routedDevice : (currentDevice = Util.SDK_INT >= 33 ? Api33.getDefaultRoutedDeviceForAttributes(audioManager, audioAttributes) : null);
        if (Util.SDK_INT >= 33 && (Util.isTv((Context)context) || Util.isAutomotive((Context)context))) {
            return Api33.getCapabilitiesInternalForDirectPlayback(audioManager, audioAttributes);
        }
        if (Util.SDK_INT >= 23 && Api23.isBluetoothConnected(audioManager, currentDevice)) {
            return DEFAULT_AUDIO_CAPABILITIES;
        }
        ImmutableSet.Builder supportedEncodings = new ImmutableSet.Builder();
        supportedEncodings.add((Object)2);
        if (AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() && Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)EXTERNAL_SURROUND_SOUND_KEY, (int)0) == 1) {
            supportedEncodings.addAll(EXTERNAL_SURROUND_SOUND_ENCODINGS);
        }
        if (Util.SDK_INT >= 29 && (Util.isTv((Context)context) || Util.isAutomotive((Context)context))) {
            supportedEncodings.addAll(Api29.getDirectPlaybackSupportedEncodings(audioAttributes));
            return new AudioCapabilities((List<AudioProfile>)AudioCapabilities.getAudioProfiles(Ints.toArray((Collection)supportedEncodings.build()), 10));
        }
        if (intent != null && intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0) == 1) {
            int[] encodingsFromExtra = intent.getIntArrayExtra("android.media.extra.ENCODINGS");
            if (encodingsFromExtra != null) {
                supportedEncodings.addAll((Iterable)Ints.asList((int[])encodingsFromExtra));
            }
            return new AudioCapabilities((List<AudioProfile>)AudioCapabilities.getAudioProfiles(Ints.toArray((Collection)supportedEncodings.build()), intent.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 10)));
        }
        return new AudioCapabilities((List<AudioProfile>)AudioCapabilities.getAudioProfiles(Ints.toArray((Collection)supportedEncodings.build()), 10));
    }

    @Nullable
    static Uri getExternalSurroundSoundGlobalSettingUri() {
        return AudioCapabilities.deviceMaySetExternalSurroundSoundGlobalSetting() ? Settings.Global.getUriFor((String)EXTERNAL_SURROUND_SOUND_KEY) : null;
    }

    @Deprecated
    public AudioCapabilities(@Nullable int[] supportedEncodings, int maxChannelCount) {
        this((List<AudioProfile>)AudioCapabilities.getAudioProfiles(supportedEncodings, maxChannelCount));
    }

    private AudioCapabilities(List<AudioProfile> audioProfiles) {
        for (int i = 0; i < audioProfiles.size(); ++i) {
            AudioProfile audioProfile = audioProfiles.get(i);
            this.encodingToAudioProfile.put(audioProfile.encoding, (Object)audioProfile);
        }
        int maxChannelCount = 0;
        for (int i = 0; i < this.encodingToAudioProfile.size(); ++i) {
            maxChannelCount = Math.max(maxChannelCount, ((AudioProfile)this.encodingToAudioProfile.valueAt((int)i)).maxChannelCount);
        }
        this.maxChannelCount = maxChannelCount;
    }

    public boolean supportsEncoding(int encoding) {
        return Util.contains(this.encodingToAudioProfile, (int)encoding);
    }

    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    @Deprecated
    public boolean isPassthroughPlaybackSupported(Format format) {
        return this.isPassthroughPlaybackSupported(format, androidx.media3.common.AudioAttributes.DEFAULT);
    }

    public boolean isPassthroughPlaybackSupported(Format format, androidx.media3.common.AudioAttributes audioAttributes) {
        return this.getEncodingAndChannelConfigForPassthrough(format, audioAttributes) != null;
    }

    @Deprecated
    @Nullable
    public Pair<Integer, Integer> getEncodingAndChannelConfigForPassthrough(Format format) {
        return this.getEncodingAndChannelConfigForPassthrough(format, androidx.media3.common.AudioAttributes.DEFAULT);
    }

    @Nullable
    public Pair<Integer, Integer> getEncodingAndChannelConfigForPassthrough(Format format, androidx.media3.common.AudioAttributes audioAttributes) {
        int channelCount;
        int encoding = MimeTypes.getEncoding((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (String)format.codecs);
        if (!ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.containsKey((Object)encoding)) {
            return null;
        }
        if (encoding == 18 && !this.supportsEncoding(18)) {
            encoding = 6;
        } else if (encoding == 8 && !this.supportsEncoding(8) || encoding == 30 && !this.supportsEncoding(30)) {
            encoding = 7;
        }
        if (!this.supportsEncoding(encoding)) {
            return null;
        }
        AudioProfile audioProfile = (AudioProfile)Assertions.checkNotNull((Object)((AudioProfile)this.encodingToAudioProfile.get(encoding)));
        if (format.channelCount == -1 || encoding == 18) {
            int sampleRate = format.sampleRate != -1 ? format.sampleRate : 48000;
            channelCount = audioProfile.getMaxSupportedChannelCountForPassthrough(sampleRate, audioAttributes);
        } else {
            channelCount = format.channelCount;
            if (format.sampleMimeType.equals("audio/vnd.dts.uhd;profile=p2") && Util.SDK_INT < 33 ? channelCount > 10 : !audioProfile.supportsChannelCount(channelCount)) {
                return null;
            }
        }
        int channelConfig = AudioCapabilities.getChannelConfigForPassthrough(channelCount);
        if (channelConfig == 0) {
            return null;
        }
        return Pair.create((Object)encoding, (Object)channelConfig);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AudioCapabilities)) {
            return false;
        }
        AudioCapabilities audioCapabilities = (AudioCapabilities)other;
        return Util.contentEquals(this.encodingToAudioProfile, audioCapabilities.encodingToAudioProfile) && this.maxChannelCount == audioCapabilities.maxChannelCount;
    }

    public int hashCode() {
        return this.maxChannelCount + 31 * Util.contentHashCode(this.encodingToAudioProfile);
    }

    public String toString() {
        return "AudioCapabilities[maxChannelCount=" + this.maxChannelCount + ", audioProfiles=" + this.encodingToAudioProfile + "]";
    }

    private static boolean deviceMaySetExternalSurroundSoundGlobalSetting() {
        return Util.SDK_INT >= 17 && ("Amazon".equals(Util.MANUFACTURER) || "Xiaomi".equals(Util.MANUFACTURER));
    }

    private static int getChannelConfigForPassthrough(int channelCount) {
        if (Util.SDK_INT <= 28) {
            if (channelCount == 7) {
                channelCount = 8;
            } else if (channelCount == 3 || channelCount == 4 || channelCount == 5) {
                channelCount = 6;
            }
        }
        if (Util.SDK_INT <= 26 && "fugu".equals(Util.DEVICE) && channelCount == 1) {
            channelCount = 2;
        }
        return Util.getAudioTrackChannelConfig((int)channelCount);
    }

    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(value=33)
    private static ImmutableList<AudioProfile> getAudioProfiles(List<android.media.AudioProfile> audioProfiles) {
        HashMap formatToChannelMasks = new HashMap();
        formatToChannelMasks.put(2, new HashSet(Ints.asList((int[])new int[]{12})));
        for (int i = 0; i < audioProfiles.size(); ++i) {
            int encoding;
            android.media.AudioProfile audioProfile = audioProfiles.get(i);
            if (audioProfile.getEncapsulationType() == 1 || !Util.isEncodingLinearPcm((int)(encoding = audioProfile.getFormat())) && !ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.containsKey((Object)encoding)) continue;
            if (formatToChannelMasks.containsKey(encoding)) {
                ((Set)Assertions.checkNotNull((Object)((Set)formatToChannelMasks.get(encoding)))).addAll(Ints.asList((int[])audioProfile.getChannelMasks()));
                continue;
            }
            formatToChannelMasks.put(encoding, new HashSet(Ints.asList((int[])audioProfile.getChannelMasks())));
        }
        ImmutableList.Builder localAudioProfiles = ImmutableList.builder();
        for (Map.Entry formatAndChannelMasks : formatToChannelMasks.entrySet()) {
            localAudioProfiles.add((Object)new AudioProfile((int)((Integer)formatAndChannelMasks.getKey()), (Set)formatAndChannelMasks.getValue()));
        }
        return localAudioProfiles.build();
    }

    private static ImmutableList<AudioProfile> getAudioProfiles(@Nullable int[] supportedEncodings, int maxChannelCount) {
        ImmutableList.Builder audioProfiles = ImmutableList.builder();
        if (supportedEncodings == null) {
            supportedEncodings = new int[]{};
        }
        for (int i = 0; i < supportedEncodings.length; ++i) {
            int encoding = supportedEncodings[i];
            audioProfiles.add((Object)new AudioProfile(encoding, maxChannelCount));
        }
        return audioProfiles.build();
    }

    @RequiresApi(value=33)
    private static final class Api33 {
        private Api33() {
        }

        @DoNotInline
        public static AudioCapabilities getCapabilitiesInternalForDirectPlayback(AudioManager audioManager, androidx.media3.common.AudioAttributes audioAttributes) {
            List directAudioProfiles = audioManager.getDirectProfilesForAttributes(audioAttributes.getAudioAttributesV21().audioAttributes);
            return new AudioCapabilities((List)AudioCapabilities.getAudioProfiles(directAudioProfiles));
        }

        @Nullable
        @DoNotInline
        public static AudioDeviceInfoApi23 getDefaultRoutedDeviceForAttributes(AudioManager audioManager, androidx.media3.common.AudioAttributes audioAttributes) {
            List audioDevices;
            try {
                audioDevices = ((AudioManager)Assertions.checkNotNull((Object)audioManager)).getAudioDevicesForAttributes(audioAttributes.getAudioAttributesV21().audioAttributes);
            }
            catch (RuntimeException e) {
                return null;
            }
            if (audioDevices.isEmpty()) {
                return null;
            }
            return new AudioDeviceInfoApi23((AudioDeviceInfo)audioDevices.get(0));
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static boolean isBluetoothConnected(AudioManager audioManager, @Nullable AudioDeviceInfoApi23 currentDevice) {
            AudioDeviceInfo[] audioDeviceInfoArray;
            if (currentDevice == null) {
                audioDeviceInfoArray = ((AudioManager)Assertions.checkNotNull((Object)audioManager)).getDevices(2);
            } else {
                AudioDeviceInfo[] audioDeviceInfoArray2 = new AudioDeviceInfo[1];
                audioDeviceInfoArray = audioDeviceInfoArray2;
                audioDeviceInfoArray2[0] = currentDevice.audioDeviceInfo;
            }
            AudioDeviceInfo[] audioDeviceInfos = audioDeviceInfoArray;
            ImmutableSet<Integer> allBluetoothDeviceTypesSet = Api23.getAllBluetoothDeviceTypes();
            for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfos) {
                if (!allBluetoothDeviceTypesSet.contains((Object)audioDeviceInfo.getType())) continue;
                return true;
            }
            return false;
        }

        @DoNotInline
        private static ImmutableSet<Integer> getAllBluetoothDeviceTypes() {
            ImmutableSet.Builder allBluetoothDeviceTypes = new ImmutableSet.Builder().add((Object[])new Integer[]{8, 7});
            if (Util.SDK_INT >= 31) {
                allBluetoothDeviceTypes.add((Object[])new Integer[]{26, 27});
            }
            if (Util.SDK_INT >= 33) {
                allBluetoothDeviceTypes.add((Object)30);
            }
            return allBluetoothDeviceTypes.build();
        }
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static ImmutableList<Integer> getDirectPlaybackSupportedEncodings(androidx.media3.common.AudioAttributes audioAttributes) {
            ImmutableList.Builder supportedEncodingsListBuilder = ImmutableList.builder();
            UnmodifiableIterator unmodifiableIterator = ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.keySet().iterator();
            while (unmodifiableIterator.hasNext()) {
                int encoding = (Integer)unmodifiableIterator.next();
                if (Util.SDK_INT < Util.getApiLevelThatAudioFormatIntroducedAudioEncoding((int)encoding) || !AudioTrack.isDirectPlaybackSupported((AudioFormat)new AudioFormat.Builder().setChannelMask(12).setEncoding(encoding).setSampleRate(48000).build(), (AudioAttributes)audioAttributes.getAudioAttributesV21().audioAttributes)) continue;
                supportedEncodingsListBuilder.add((Object)encoding);
            }
            supportedEncodingsListBuilder.add((Object)2);
            return supportedEncodingsListBuilder.build();
        }

        @DoNotInline
        public static int getMaxSupportedChannelCountForPassthrough(int encoding, int sampleRate, androidx.media3.common.AudioAttributes audioAttributes) {
            for (int channelCount = 10; channelCount > 0; --channelCount) {
                AudioFormat audioFormat;
                int channelConfig = Util.getAudioTrackChannelConfig((int)channelCount);
                if (channelConfig == 0 || !AudioTrack.isDirectPlaybackSupported((AudioFormat)(audioFormat = new AudioFormat.Builder().setEncoding(encoding).setSampleRate(sampleRate).setChannelMask(channelConfig).build()), (AudioAttributes)audioAttributes.getAudioAttributesV21().audioAttributes)) continue;
                return channelCount;
            }
            return 0;
        }
    }

    private static final class AudioProfile {
        public static final AudioProfile DEFAULT_AUDIO_PROFILE = Util.SDK_INT >= 33 ? new AudioProfile(2, (Set<Integer>)AudioProfile.getAllChannelMasksForMaxChannelCount(10)) : new AudioProfile(2, 10);
        public final int encoding;
        public final int maxChannelCount;
        @Nullable
        private final ImmutableSet<Integer> channelMasks;

        @RequiresApi(value=33)
        public AudioProfile(int encoding, Set<Integer> channelMasks) {
            this.encoding = encoding;
            this.channelMasks = ImmutableSet.copyOf(channelMasks);
            int maxChannelCount = 0;
            UnmodifiableIterator unmodifiableIterator = this.channelMasks.iterator();
            while (unmodifiableIterator.hasNext()) {
                int channelMask = (Integer)unmodifiableIterator.next();
                maxChannelCount = Math.max(maxChannelCount, Integer.bitCount(channelMask));
            }
            this.maxChannelCount = maxChannelCount;
        }

        public AudioProfile(int encoding, int maxChannelCount) {
            this.encoding = encoding;
            this.maxChannelCount = maxChannelCount;
            this.channelMasks = null;
        }

        public boolean supportsChannelCount(int channelCount) {
            if (this.channelMasks == null) {
                return channelCount <= this.maxChannelCount;
            }
            int channelMask = Util.getAudioTrackChannelConfig((int)channelCount);
            if (channelMask == 0) {
                return false;
            }
            return this.channelMasks.contains((Object)channelMask);
        }

        public int getMaxSupportedChannelCountForPassthrough(int sampleRate, androidx.media3.common.AudioAttributes audioAttributes) {
            if (this.channelMasks != null) {
                return this.maxChannelCount;
            }
            if (Util.SDK_INT >= 29) {
                return Api29.getMaxSupportedChannelCountForPassthrough(this.encoding, sampleRate, audioAttributes);
            }
            return (Integer)Assertions.checkNotNull((Object)((Integer)ALL_SURROUND_ENCODINGS_AND_MAX_CHANNELS.getOrDefault((Object)this.encoding, (Object)0)));
        }

        private static ImmutableSet<Integer> getAllChannelMasksForMaxChannelCount(int maxChannelCount) {
            ImmutableSet.Builder allChannelMasks = new ImmutableSet.Builder();
            for (int i = 1; i <= maxChannelCount; ++i) {
                allChannelMasks.add((Object)Util.getAudioTrackChannelConfig((int)i));
            }
            return allChannelMasks.build();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AudioProfile)) {
                return false;
            }
            AudioProfile audioProfile = (AudioProfile)other;
            return this.encoding == audioProfile.encoding && this.maxChannelCount == audioProfile.maxChannelCount && Util.areEqual(this.channelMasks, audioProfile.channelMasks);
        }

        public int hashCode() {
            int result = this.encoding;
            result = 31 * result + this.maxChannelCount;
            result = 31 * result + (this.channelMasks == null ? 0 : this.channelMasks.hashCode());
            return result;
        }

        public String toString() {
            return "AudioProfile[format=" + this.encoding + ", maxChannelCount=" + this.maxChannelCount + ", channelMasks=" + this.channelMasks + "]";
        }
    }
}

