/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioDeviceCallback;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Handler;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.AudioCapabilities;
import androidx.media3.exoplayer.audio.AudioDeviceInfoApi23;

@UnstableApi
public final class AudioCapabilitiesReceiver {
    private final Context context;
    private final Listener listener;
    private final Handler handler;
    @Nullable
    private final AudioDeviceCallbackV23 audioDeviceCallback;
    @Nullable
    private final BroadcastReceiver hdmiAudioPlugBroadcastReceiver;
    @Nullable
    private final ExternalSurroundSoundSettingObserver externalSurroundSoundSettingObserver;
    @Nullable
    private AudioCapabilities audioCapabilities;
    @Nullable
    private AudioDeviceInfoApi23 routedDevice;
    private AudioAttributes audioAttributes;
    private boolean registered;

    @Deprecated
    public AudioCapabilitiesReceiver(Context context, Listener listener) {
        this(context, listener, AudioAttributes.DEFAULT, (AudioDeviceInfo)null);
    }

    public AudioCapabilitiesReceiver(Context context, Listener listener, AudioAttributes audioAttributes, @Nullable AudioDeviceInfo routedDevice) {
        this(context, listener, audioAttributes, Util.SDK_INT >= 23 && routedDevice != null ? new AudioDeviceInfoApi23(routedDevice) : null);
    }

    AudioCapabilitiesReceiver(Context context, Listener listener, AudioAttributes audioAttributes, @Nullable AudioDeviceInfoApi23 routedDevice) {
        this.context = context = context.getApplicationContext();
        this.listener = (Listener)Assertions.checkNotNull((Object)listener);
        this.audioAttributes = audioAttributes;
        this.routedDevice = routedDevice;
        this.handler = Util.createHandlerForCurrentOrMainLooper();
        this.audioDeviceCallback = Util.SDK_INT >= 23 ? new AudioDeviceCallbackV23() : null;
        this.hdmiAudioPlugBroadcastReceiver = Util.SDK_INT >= 21 ? new HdmiAudioPlugBroadcastReceiver() : null;
        Uri externalSurroundSoundUri = AudioCapabilities.getExternalSurroundSoundGlobalSettingUri();
        this.externalSurroundSoundSettingObserver = externalSurroundSoundUri != null ? new ExternalSurroundSoundSettingObserver(this.handler, context.getContentResolver(), externalSurroundSoundUri) : null;
    }

    public void setAudioAttributes(AudioAttributes audioAttributes) {
        this.audioAttributes = audioAttributes;
        this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(this.context, audioAttributes, this.routedDevice));
    }

    @RequiresApi(value=23)
    public void setRoutedDevice(@Nullable AudioDeviceInfo routedDevice) {
        if (Util.areEqual((Object)routedDevice, this.routedDevice == null ? null : this.routedDevice.audioDeviceInfo)) {
            return;
        }
        this.routedDevice = routedDevice != null ? new AudioDeviceInfoApi23(routedDevice) : null;
        this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(this.context, this.audioAttributes, this.routedDevice));
    }

    public AudioCapabilities register() {
        if (this.registered) {
            return (AudioCapabilities)Assertions.checkNotNull((Object)this.audioCapabilities);
        }
        this.registered = true;
        if (this.externalSurroundSoundSettingObserver != null) {
            this.externalSurroundSoundSettingObserver.register();
        }
        if (Util.SDK_INT >= 23 && this.audioDeviceCallback != null) {
            Api23.registerAudioDeviceCallback(this.context, this.audioDeviceCallback, this.handler);
        }
        Intent stickyIntent = null;
        if (this.hdmiAudioPlugBroadcastReceiver != null) {
            IntentFilter intentFilter = new IntentFilter("android.media.action.HDMI_AUDIO_PLUG");
            stickyIntent = this.context.registerReceiver(this.hdmiAudioPlugBroadcastReceiver, intentFilter, null, this.handler);
        }
        this.audioCapabilities = AudioCapabilities.getCapabilitiesInternal(this.context, stickyIntent, this.audioAttributes, this.routedDevice);
        return this.audioCapabilities;
    }

    public void unregister() {
        if (!this.registered) {
            return;
        }
        this.audioCapabilities = null;
        if (Util.SDK_INT >= 23 && this.audioDeviceCallback != null) {
            Api23.unregisterAudioDeviceCallback(this.context, this.audioDeviceCallback);
        }
        if (this.hdmiAudioPlugBroadcastReceiver != null) {
            this.context.unregisterReceiver(this.hdmiAudioPlugBroadcastReceiver);
        }
        if (this.externalSurroundSoundSettingObserver != null) {
            this.externalSurroundSoundSettingObserver.unregister();
        }
        this.registered = false;
    }

    private void onNewAudioCapabilities(AudioCapabilities newAudioCapabilities) {
        if (this.registered && !newAudioCapabilities.equals(this.audioCapabilities)) {
            this.audioCapabilities = newAudioCapabilities;
            this.listener.onAudioCapabilitiesChanged(newAudioCapabilities);
        }
    }

    public static interface Listener {
        public void onAudioCapabilitiesChanged(AudioCapabilities var1);
    }

    @RequiresApi(value=23)
    private final class AudioDeviceCallbackV23
    extends AudioDeviceCallback {
        private AudioDeviceCallbackV23() {
        }

        public void onAudioDevicesAdded(AudioDeviceInfo[] addedDevices) {
            AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(AudioCapabilitiesReceiver.this.context, AudioCapabilitiesReceiver.this.audioAttributes, AudioCapabilitiesReceiver.this.routedDevice));
        }

        public void onAudioDevicesRemoved(AudioDeviceInfo[] removedDevices) {
            if (Util.contains((Object[])removedDevices, (Object)AudioCapabilitiesReceiver.this.routedDevice)) {
                AudioCapabilitiesReceiver.this.routedDevice = null;
            }
            AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(AudioCapabilitiesReceiver.this.context, AudioCapabilitiesReceiver.this.audioAttributes, AudioCapabilitiesReceiver.this.routedDevice));
        }
    }

    private final class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!this.isInitialStickyBroadcast()) {
                AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(context, intent, AudioCapabilitiesReceiver.this.audioAttributes, AudioCapabilitiesReceiver.this.routedDevice));
            }
        }
    }

    private final class ExternalSurroundSoundSettingObserver
    extends ContentObserver {
        private final ContentResolver resolver;
        private final Uri settingUri;

        public ExternalSurroundSoundSettingObserver(Handler handler, ContentResolver resolver, Uri settingUri) {
            super(handler);
            this.resolver = resolver;
            this.settingUri = settingUri;
        }

        public void register() {
            this.resolver.registerContentObserver(this.settingUri, false, (ContentObserver)this);
        }

        public void unregister() {
            this.resolver.unregisterContentObserver((ContentObserver)this);
        }

        public void onChange(boolean selfChange) {
            AudioCapabilitiesReceiver.this.onNewAudioCapabilities(AudioCapabilities.getCapabilitiesInternal(AudioCapabilitiesReceiver.this.context, AudioCapabilitiesReceiver.this.audioAttributes, AudioCapabilitiesReceiver.this.routedDevice));
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        @DoNotInline
        public static void registerAudioDeviceCallback(Context context, AudioDeviceCallback callback, Handler handler) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            ((AudioManager)Assertions.checkNotNull((Object)audioManager)).registerAudioDeviceCallback(callback, handler);
        }

        @DoNotInline
        public static void unregisterAudioDeviceCallback(Context context, AudioDeviceCallback callback) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            ((AudioManager)Assertions.checkNotNull((Object)audioManager)).unregisterAudioDeviceCallback(callback);
        }

        private Api23() {
        }
    }
}

