/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class AudioOffloadSupport {
    public static final AudioOffloadSupport DEFAULT_UNSUPPORTED = new Builder().build();
    public final boolean isFormatSupported;
    public final boolean isGaplessSupported;
    public final boolean isSpeedChangeSupported;

    private AudioOffloadSupport(Builder builder) {
        this.isFormatSupported = builder.isFormatSupported;
        this.isGaplessSupported = builder.isGaplessSupported;
        this.isSpeedChangeSupported = builder.isSpeedChangeSupported;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AudioOffloadSupport other = (AudioOffloadSupport)obj;
        return this.isFormatSupported == other.isFormatSupported && this.isGaplessSupported == other.isGaplessSupported && this.isSpeedChangeSupported == other.isSpeedChangeSupported;
    }

    public int hashCode() {
        int hashCode = (this.isFormatSupported ? 1 : 0) << 2;
        hashCode += (this.isGaplessSupported ? 1 : 0) << 1;
        return hashCode += this.isSpeedChangeSupported ? 1 : 0;
    }

    public static final class Builder {
        private boolean isFormatSupported;
        private boolean isGaplessSupported;
        private boolean isSpeedChangeSupported;

        public Builder() {
        }

        public Builder(AudioOffloadSupport audioOffloadSupport) {
            this.isFormatSupported = audioOffloadSupport.isFormatSupported;
            this.isGaplessSupported = audioOffloadSupport.isGaplessSupported;
            this.isSpeedChangeSupported = audioOffloadSupport.isSpeedChangeSupported;
        }

        @CanIgnoreReturnValue
        public Builder setIsFormatSupported(boolean isFormatSupported) {
            this.isFormatSupported = isFormatSupported;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsGaplessSupported(boolean isGaplessSupported) {
            this.isGaplessSupported = isGaplessSupported;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setIsSpeedChangeSupported(boolean isSpeedChangeSupported) {
            this.isSpeedChangeSupported = isSpeedChangeSupported;
            return this;
        }

        public AudioOffloadSupport build() {
            if (!this.isFormatSupported && (this.isGaplessSupported || this.isSpeedChangeSupported)) {
                throw new IllegalStateException("Secondary offload attribute fields are true but primary isFormatSupported is false");
            }
            return new AudioOffloadSupport(this);
        }
    }
}

