/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.media.AudioDeviceInfo;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.AuxEffectInfo;
import androidx.media3.common.Format;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.audio.AudioOffloadSupport;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;

@UnstableApi
public interface AudioSink {
    public static final int SINK_FORMAT_SUPPORTED_DIRECTLY = 2;
    public static final int SINK_FORMAT_SUPPORTED_WITH_TRANSCODING = 1;
    public static final int SINK_FORMAT_UNSUPPORTED = 0;
    public static final long CURRENT_POSITION_NOT_SET = Long.MIN_VALUE;
    public static final int OFFLOAD_MODE_DISABLED = 0;
    public static final int OFFLOAD_MODE_ENABLED_GAPLESS_REQUIRED = 1;
    public static final int OFFLOAD_MODE_ENABLED_GAPLESS_NOT_REQUIRED = 2;

    public void setListener(Listener var1);

    default public void setPlayerId(@Nullable PlayerId playerId) {
    }

    default public void setClock(Clock clock) {
    }

    public boolean supportsFormat(Format var1);

    public int getFormatSupport(Format var1);

    default public AudioOffloadSupport getFormatOffloadSupport(Format format) {
        return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
    }

    public long getCurrentPositionUs(boolean var1);

    public void configure(Format var1, int var2, @Nullable int[] var3) throws ConfigurationException;

    public void play();

    public void handleDiscontinuity();

    public boolean handleBuffer(ByteBuffer var1, long var2, int var4) throws InitializationException, WriteException;

    public void playToEndOfStream() throws WriteException;

    public boolean isEnded();

    public boolean hasPendingData();

    public void setPlaybackParameters(PlaybackParameters var1);

    public PlaybackParameters getPlaybackParameters();

    public void setSkipSilenceEnabled(boolean var1);

    public boolean getSkipSilenceEnabled();

    public void setAudioAttributes(AudioAttributes var1);

    @Nullable
    public AudioAttributes getAudioAttributes();

    public void setAudioSessionId(int var1);

    public void setAuxEffectInfo(AuxEffectInfo var1);

    @RequiresApi(value=23)
    default public void setPreferredDevice(@Nullable AudioDeviceInfo audioDeviceInfo) {
    }

    default public void setOutputStreamOffsetUs(long outputStreamOffsetUs) {
    }

    public void enableTunnelingV21();

    public void disableTunneling();

    @RequiresApi(value=29)
    default public void setOffloadMode(int offloadMode) {
    }

    @RequiresApi(value=29)
    default public void setOffloadDelayPadding(int delayInFrames, int paddingInFrames) {
    }

    public void setVolume(float var1);

    public void pause();

    public void flush();

    public void reset();

    default public void release() {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface OffloadMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface SinkFormatSupport {
    }

    public static final class UnexpectedDiscontinuityException
    extends Exception {
        public final long actualPresentationTimeUs;
        public final long expectedPresentationTimeUs;

        public UnexpectedDiscontinuityException(long actualPresentationTimeUs, long expectedPresentationTimeUs) {
            super("Unexpected audio track timestamp discontinuity: expected " + expectedPresentationTimeUs + ", got " + actualPresentationTimeUs);
            this.actualPresentationTimeUs = actualPresentationTimeUs;
            this.expectedPresentationTimeUs = expectedPresentationTimeUs;
        }
    }

    public static final class WriteException
    extends Exception {
        public final int errorCode;
        public final boolean isRecoverable;
        public final Format format;

        public WriteException(int errorCode, Format format, boolean isRecoverable) {
            super("AudioTrack write failed: " + errorCode);
            this.isRecoverable = isRecoverable;
            this.errorCode = errorCode;
            this.format = format;
        }
    }

    public static final class InitializationException
    extends Exception {
        public final int audioTrackState;
        public final boolean isRecoverable;
        public final Format format;

        public InitializationException(int audioTrackState, int sampleRate, int channelConfig, int bufferSize, Format format, boolean isRecoverable, @Nullable Exception audioTrackException) {
            super("AudioTrack init failed " + audioTrackState + " " + "Config(" + sampleRate + ", " + channelConfig + ", " + bufferSize + ")" + " " + format + (isRecoverable ? " (recoverable)" : ""), audioTrackException);
            this.audioTrackState = audioTrackState;
            this.isRecoverable = isRecoverable;
            this.format = format;
        }
    }

    public static final class ConfigurationException
    extends Exception {
        public final Format format;

        public ConfigurationException(Throwable cause, Format format) {
            super(cause);
            this.format = format;
        }

        public ConfigurationException(String message, Format format) {
            super(message);
            this.format = format;
        }
    }

    public static final class AudioTrackConfig {
        public final int encoding;
        public final int sampleRate;
        public final int channelConfig;
        public final boolean tunneling;
        public final boolean offload;
        public final int bufferSize;

        public AudioTrackConfig(int encoding, int sampleRate, int channelConfig, boolean tunneling, boolean offload, int bufferSize) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
            this.channelConfig = channelConfig;
            this.tunneling = tunneling;
            this.offload = offload;
            this.bufferSize = bufferSize;
        }
    }

    public static interface Listener {
        public void onPositionDiscontinuity();

        default public void onPositionAdvancing(long playoutStartSystemTimeMs) {
        }

        public void onUnderrun(int var1, long var2, long var4);

        public void onSkipSilenceEnabledChanged(boolean var1);

        default public void onOffloadBufferEmptying() {
        }

        default public void onOffloadBufferFull() {
        }

        default public void onAudioSinkError(Exception audioSinkError) {
        }

        default public void onAudioCapabilitiesChanged() {
        }

        default public void onAudioTrackInitialized(AudioTrackConfig audioTrackConfig) {
        }

        default public void onAudioTrackReleased(AudioTrackConfig audioTrackConfig) {
        }

        default public void onSilenceSkipped() {
        }
    }
}

