/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.AudioAttributes;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.AudioOffloadSupport;
import androidx.media3.exoplayer.audio.DefaultAudioSink;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public final class DefaultAudioOffloadSupportProvider
implements DefaultAudioSink.AudioOffloadSupportProvider {
    private static final String OFFLOAD_VARIABLE_RATE_SUPPORTED_KEY = "offloadVariableRateSupported";
    @Nullable
    private final Context context;
    private @MonotonicNonNull Boolean isOffloadVariableRateSupported;

    public DefaultAudioOffloadSupportProvider() {
        this(null);
    }

    public DefaultAudioOffloadSupportProvider(@Nullable Context context) {
        this.context = context;
    }

    @Override
    public AudioOffloadSupport getAudioOffloadSupport(Format format, AudioAttributes audioAttributes) {
        AudioFormat audioFormat;
        Assertions.checkNotNull((Object)format);
        Assertions.checkNotNull((Object)audioAttributes);
        if (Util.SDK_INT < 29 || format.sampleRate == -1) {
            return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
        }
        boolean isOffloadVariableRateSupported = this.isOffloadVariableRateSupported(this.context);
        int encoding = MimeTypes.getEncoding((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (String)format.codecs);
        if (encoding == 0 || Util.SDK_INT < Util.getApiLevelThatAudioFormatIntroducedAudioEncoding((int)encoding)) {
            return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
        }
        int channelConfig = Util.getAudioTrackChannelConfig((int)format.channelCount);
        if (channelConfig == 0) {
            return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
        }
        try {
            audioFormat = Util.getAudioFormat((int)format.sampleRate, (int)channelConfig, (int)encoding);
        }
        catch (IllegalArgumentException e) {
            return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
        }
        if (Util.SDK_INT >= 31) {
            return Api31.getOffloadedPlaybackSupport(audioFormat, audioAttributes.getAudioAttributesV21().audioAttributes, isOffloadVariableRateSupported);
        }
        return Api29.getOffloadedPlaybackSupport(audioFormat, audioAttributes.getAudioAttributesV21().audioAttributes, isOffloadVariableRateSupported);
    }

    private boolean isOffloadVariableRateSupported(@Nullable Context context) {
        String offloadVariableRateSupportedKeyValue;
        AudioManager audioManager;
        if (this.isOffloadVariableRateSupported != null) {
            return this.isOffloadVariableRateSupported;
        }
        this.isOffloadVariableRateSupported = context != null ? ((audioManager = (AudioManager)context.getSystemService("audio")) != null ? Boolean.valueOf((offloadVariableRateSupportedKeyValue = audioManager.getParameters(OFFLOAD_VARIABLE_RATE_SUPPORTED_KEY)) != null && offloadVariableRateSupportedKeyValue.equals("offloadVariableRateSupported=1")) : Boolean.valueOf(false)) : Boolean.valueOf(false);
        return this.isOffloadVariableRateSupported;
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static AudioOffloadSupport getOffloadedPlaybackSupport(AudioFormat audioFormat, android.media.AudioAttributes audioAttributes, boolean isOffloadVariableRateSupported) {
            int playbackOffloadSupport = AudioManager.getPlaybackOffloadSupport((AudioFormat)audioFormat, (android.media.AudioAttributes)audioAttributes);
            if (playbackOffloadSupport == 0) {
                return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
            }
            AudioOffloadSupport.Builder audioOffloadSupport = new AudioOffloadSupport.Builder();
            boolean isGaplessSupported = Util.SDK_INT > 32 && playbackOffloadSupport == 2;
            return audioOffloadSupport.setIsFormatSupported(true).setIsGaplessSupported(isGaplessSupported).setIsSpeedChangeSupported(isOffloadVariableRateSupported).build();
        }
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static AudioOffloadSupport getOffloadedPlaybackSupport(AudioFormat audioFormat, android.media.AudioAttributes audioAttributes, boolean isOffloadVariableRateSupported) {
            if (!AudioManager.isOffloadedPlaybackSupported((AudioFormat)audioFormat, (android.media.AudioAttributes)audioAttributes)) {
                return AudioOffloadSupport.DEFAULT_UNSUPPORTED;
            }
            return new AudioOffloadSupport.Builder().setIsFormatSupported(true).setIsSpeedChangeSupported(isOffloadVariableRateSupported).build();
        }
    }
}

