/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import androidx.annotation.Nullable;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.extractor.OpusUtil;
import com.google.common.primitives.UnsignedBytes;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

@UnstableApi
public final class OggOpusAudioPacketizer {
    private static final int CHECKSUM_INDEX = 22;
    private static final int FIRST_AUDIO_SAMPLE_PAGE_SEQUENCE_NUMBER = 2;
    private static final int OGG_PACKET_HEADER_LENGTH = 28;
    private static final int SERIAL_NUMBER = 0;
    private static final byte[] OGG_DEFAULT_ID_HEADER_PAGE = new byte[]{79, 103, 103, 83, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, -43, -59, -9, 1, 19, 79, 112, 117, 115, 72, 101, 97, 100, 1, 2, 56, 1, -128, -69, 0, 0, 0, 0, 0};
    private static final byte[] OGG_DEFAULT_COMMENT_HEADER_PAGE = new byte[]{79, 103, 103, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, -103, 87, 83, 1, 16, 79, 112, 117, 115, 84, 97, 103, 115, 0, 0, 0, 0, 0, 0, 0, 0};
    private ByteBuffer outputBuffer = AudioProcessor.EMPTY_BUFFER;
    private int pageSequenceNumber = 2;
    private int granulePosition = 0;

    public void packetize(DecoderInputBuffer inputBuffer, List<byte[]> initializationData) {
        Assertions.checkNotNull((Object)inputBuffer.data);
        if (inputBuffer.data.limit() - inputBuffer.data.position() == 0) {
            return;
        }
        byte[] providedOggIdHeaderPayloadBytes = this.pageSequenceNumber == 2 && (initializationData.size() == 1 || initializationData.size() == 3) ? initializationData.get(0) : null;
        this.outputBuffer = this.packetizeInternal(inputBuffer.data, providedOggIdHeaderPayloadBytes);
        inputBuffer.clear();
        inputBuffer.ensureSpaceForWrite(this.outputBuffer.remaining());
        inputBuffer.data.put(this.outputBuffer);
        inputBuffer.flip();
    }

    public void reset() {
        this.outputBuffer = AudioProcessor.EMPTY_BUFFER;
        this.granulePosition = 0;
        this.pageSequenceNumber = 2;
    }

    private ByteBuffer packetizeInternal(ByteBuffer inputBuffer, @Nullable byte[] providedOggIdHeaderPayloadBytes) {
        int checksum;
        int i;
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int inputBufferSize = limit - position;
        int numSegments = (inputBufferSize + 255) / 255;
        int headerSize = 27 + numSegments;
        int outputPacketSize = headerSize + inputBufferSize;
        int oggIdHeaderPageSize = 0;
        if (this.pageSequenceNumber == 2) {
            oggIdHeaderPageSize = providedOggIdHeaderPayloadBytes != null ? 28 + providedOggIdHeaderPayloadBytes.length : OGG_DEFAULT_ID_HEADER_PAGE.length;
            outputPacketSize += oggIdHeaderPageSize + OGG_DEFAULT_COMMENT_HEADER_PAGE.length;
        }
        ByteBuffer buffer = this.replaceOutputBuffer(outputPacketSize);
        if (this.pageSequenceNumber == 2) {
            if (providedOggIdHeaderPayloadBytes != null) {
                this.writeOggIdHeaderPage(buffer, providedOggIdHeaderPayloadBytes);
            } else {
                buffer.put(OGG_DEFAULT_ID_HEADER_PAGE);
            }
            buffer.put(OGG_DEFAULT_COMMENT_HEADER_PAGE);
        }
        int numSamples = OpusUtil.parsePacketAudioSampleCount((ByteBuffer)inputBuffer);
        this.granulePosition += numSamples;
        this.writeOggPacketHeader(buffer, this.granulePosition, this.pageSequenceNumber, numSegments, false);
        int bytesLeft = inputBufferSize;
        for (i = 0; i < numSegments; ++i) {
            if (bytesLeft >= 255) {
                buffer.put((byte)-1);
                bytesLeft -= 255;
                continue;
            }
            buffer.put((byte)bytesLeft);
            bytesLeft = 0;
        }
        for (i = position; i < limit; ++i) {
            buffer.put(inputBuffer.get(i));
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
        if (this.pageSequenceNumber == 2) {
            checksum = Util.crc32((byte[])buffer.array(), (int)(buffer.arrayOffset() + oggIdHeaderPageSize + OGG_DEFAULT_COMMENT_HEADER_PAGE.length), (int)(buffer.limit() - buffer.position()), (int)0);
            buffer.putInt(oggIdHeaderPageSize + OGG_DEFAULT_COMMENT_HEADER_PAGE.length + 22, checksum);
        } else {
            checksum = Util.crc32((byte[])buffer.array(), (int)buffer.arrayOffset(), (int)(buffer.limit() - buffer.position()), (int)0);
            buffer.putInt(22, checksum);
        }
        ++this.pageSequenceNumber;
        return buffer;
    }

    private void writeOggIdHeaderPage(ByteBuffer buffer, byte[] idHeaderPayloadBytes) {
        this.writeOggPacketHeader(buffer, 0L, 0, 1, true);
        buffer.put(UnsignedBytes.checkedCast((long)idHeaderPayloadBytes.length));
        buffer.put(idHeaderPayloadBytes);
        int checksum = Util.crc32((byte[])buffer.array(), (int)buffer.arrayOffset(), (int)(28 + idHeaderPayloadBytes.length), (int)0);
        buffer.putInt(22, checksum);
        buffer.position(28 + idHeaderPayloadBytes.length);
    }

    private void writeOggPacketHeader(ByteBuffer byteBuffer, long granulePosition, int pageSequenceNumber, int numberPageSegments, boolean isIdHeaderPacket) {
        byteBuffer.put((byte)79);
        byteBuffer.put((byte)103);
        byteBuffer.put((byte)103);
        byteBuffer.put((byte)83);
        byteBuffer.put((byte)0);
        byteBuffer.put(isIdHeaderPacket ? (byte)2 : 0);
        byteBuffer.putLong(granulePosition);
        byteBuffer.putInt(0);
        byteBuffer.putInt(pageSequenceNumber);
        byteBuffer.putInt(0);
        byteBuffer.put(UnsignedBytes.checkedCast((long)numberPageSegments));
    }

    private ByteBuffer replaceOutputBuffer(int size) {
        if (this.outputBuffer.capacity() < size) {
            this.outputBuffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.outputBuffer.clear();
        }
        return this.outputBuffer;
    }
}

