/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.nio.ByteBuffer;

@UnstableApi
public final class SilenceSkippingAudioProcessor
extends BaseAudioProcessor {
    public static final float DEFAULT_SILENCE_RETENTION_RATIO = 0.2f;
    public static final int DEFAULT_MIN_VOLUME_TO_KEEP_PERCENTAGE = 10;
    public static final short DEFAULT_SILENCE_THRESHOLD_LEVEL = 1024;
    public static final long DEFAULT_MINIMUM_SILENCE_DURATION_US = 100000L;
    public static final long DEFAULT_MAX_SILENCE_TO_KEEP_DURATION_US = 2000000L;
    @Deprecated
    public static final long DEFAULT_PADDING_SILENCE_US = 20000L;
    private static final int STATE_NOISY = 0;
    private static final int STATE_SHORTENING_SILENCE = 1;
    private static final int FADE_OUT = 0;
    private static final int MUTE = 1;
    private static final int FADE_IN = 2;
    private static final int DO_NOT_CHANGE_VOLUME = 3;
    private static final int AVOID_TRUNCATION_FACTOR = 1000;
    private final float silenceRetentionRatio;
    private final short silenceThresholdLevel;
    private final int minVolumeToKeepPercentageWhenMuting;
    private final long minimumSilenceDurationUs;
    private final long maxSilenceToKeepDurationUs;
    private AudioProcessor.AudioFormat inputFormat;
    private int bytesPerFrame;
    private boolean enabled;
    private int state;
    private long skippedFrames;
    private int outputSilenceFramesSinceNoise = 0;
    private byte[] maybeSilenceBuffer;
    private int maybeSilenceBufferStartIndex = 0;
    private int maybeSilenceBufferContentsSize = 0;
    private byte[] contiguousOutputBuffer;

    public SilenceSkippingAudioProcessor() {
        this(100000L, 0.2f, 2000000L, 10, 1024);
    }

    @Deprecated
    public SilenceSkippingAudioProcessor(long minimumSilenceDurationUs, long paddingSilenceUs, short silenceThresholdLevel) {
        this(minimumSilenceDurationUs, (float)paddingSilenceUs / (float)minimumSilenceDurationUs, minimumSilenceDurationUs, 0, silenceThresholdLevel);
    }

    public SilenceSkippingAudioProcessor(long minimumSilenceDurationUs, float silenceRetentionRatio, long maxSilenceToKeepDurationUs, int minVolumeToKeepPercentageWhenMuting, short silenceThresholdLevel) {
        Assertions.checkArgument((silenceRetentionRatio >= 0.0f && silenceRetentionRatio <= 1.0f ? 1 : 0) != 0);
        this.minimumSilenceDurationUs = minimumSilenceDurationUs;
        this.silenceRetentionRatio = silenceRetentionRatio;
        this.maxSilenceToKeepDurationUs = maxSilenceToKeepDurationUs;
        this.minVolumeToKeepPercentageWhenMuting = minVolumeToKeepPercentageWhenMuting;
        this.silenceThresholdLevel = silenceThresholdLevel;
        this.inputFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.maybeSilenceBuffer = Util.EMPTY_BYTE_ARRAY;
        this.contiguousOutputBuffer = Util.EMPTY_BYTE_ARRAY;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getSkippedFrames() {
        return this.skippedFrames;
    }

    protected AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        this.inputFormat = inputAudioFormat;
        this.bytesPerFrame = inputAudioFormat.channelCount * 2;
        return inputAudioFormat;
    }

    public boolean isActive() {
        return this.inputFormat.sampleRate != -1 && this.enabled;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        block4: while (inputBuffer.hasRemaining() && !this.hasPendingOutput()) {
            switch (this.state) {
                case 0: {
                    this.processNoisy(inputBuffer);
                    continue block4;
                }
                case 1: {
                    this.shortenSilenceSilenceUntilNoise(inputBuffer);
                    continue block4;
                }
            }
            throw new IllegalStateException();
        }
    }

    public void onQueueEndOfStream() {
        if (this.maybeSilenceBufferContentsSize > 0) {
            this.outputShortenedSilenceBuffer(true);
            this.outputSilenceFramesSinceNoise = 0;
        }
    }

    public void onFlush() {
        int maybeSilenceBufferSize;
        if (this.isActive() && this.maybeSilenceBuffer.length != (maybeSilenceBufferSize = this.alignToBytePerFrameBoundary(this.durationUsToFrames(this.minimumSilenceDurationUs) / 2) * 2)) {
            this.maybeSilenceBuffer = new byte[maybeSilenceBufferSize];
            this.contiguousOutputBuffer = new byte[maybeSilenceBufferSize];
        }
        this.state = 0;
        this.skippedFrames = 0L;
        this.outputSilenceFramesSinceNoise = 0;
        this.maybeSilenceBufferStartIndex = 0;
        this.maybeSilenceBufferContentsSize = 0;
    }

    public void onReset() {
        this.enabled = false;
        this.inputFormat = AudioProcessor.AudioFormat.NOT_SET;
        this.maybeSilenceBuffer = Util.EMPTY_BYTE_ARRAY;
        this.contiguousOutputBuffer = Util.EMPTY_BYTE_ARRAY;
    }

    private void processNoisy(ByteBuffer inputBuffer) {
        int limit = inputBuffer.limit();
        inputBuffer.limit(Math.min(limit, inputBuffer.position() + this.maybeSilenceBuffer.length));
        int noiseLimit = this.findNoiseLimit(inputBuffer);
        if (noiseLimit == inputBuffer.position()) {
            this.state = 1;
        } else {
            inputBuffer.limit(Math.min(noiseLimit, inputBuffer.capacity()));
            this.output(inputBuffer);
        }
        inputBuffer.limit(limit);
    }

    private void shortenSilenceSilenceUntilNoise(ByteBuffer inputBuffer) {
        int indexToWriteTo;
        int contiguousBufferRemaining;
        Assertions.checkState((this.maybeSilenceBufferStartIndex < this.maybeSilenceBuffer.length ? 1 : 0) != 0);
        int limit = inputBuffer.limit();
        int noisePosition = this.findNoisePosition(inputBuffer);
        int silenceInputSize = noisePosition - inputBuffer.position();
        if (this.maybeSilenceBufferStartIndex + this.maybeSilenceBufferContentsSize < this.maybeSilenceBuffer.length) {
            contiguousBufferRemaining = this.maybeSilenceBuffer.length - (this.maybeSilenceBufferContentsSize + this.maybeSilenceBufferStartIndex);
            indexToWriteTo = this.maybeSilenceBufferStartIndex + this.maybeSilenceBufferContentsSize;
        } else {
            int amountInUpperPartOfBuffer = this.maybeSilenceBuffer.length - this.maybeSilenceBufferStartIndex;
            indexToWriteTo = this.maybeSilenceBufferContentsSize - amountInUpperPartOfBuffer;
            contiguousBufferRemaining = this.maybeSilenceBufferStartIndex - indexToWriteTo;
        }
        boolean noiseFound = noisePosition < limit;
        int bytesOfInput = Math.min(silenceInputSize, contiguousBufferRemaining);
        inputBuffer.limit(inputBuffer.position() + bytesOfInput);
        inputBuffer.get(this.maybeSilenceBuffer, indexToWriteTo, bytesOfInput);
        this.maybeSilenceBufferContentsSize += bytesOfInput;
        Assertions.checkState((this.maybeSilenceBufferContentsSize <= this.maybeSilenceBuffer.length ? 1 : 0) != 0);
        boolean shouldTransitionToNoisyState = noiseFound && silenceInputSize < contiguousBufferRemaining;
        this.outputShortenedSilenceBuffer(shouldTransitionToNoisyState);
        if (shouldTransitionToNoisyState) {
            this.state = 0;
            this.outputSilenceFramesSinceNoise = 0;
        }
        inputBuffer.limit(limit);
    }

    private void outputShortenedSilenceBuffer(boolean shouldTransitionToNoisyState) {
        int sizeBeforeOutput = this.maybeSilenceBufferContentsSize;
        if (this.maybeSilenceBufferContentsSize == this.maybeSilenceBuffer.length || shouldTransitionToNoisyState) {
            int bytesConsumed;
            int bytesToOutput;
            if (this.outputSilenceFramesSinceNoise == 0) {
                if (shouldTransitionToNoisyState) {
                    int volumeChangeType = 3;
                    bytesToOutput = this.maybeSilenceBufferContentsSize;
                    this.outputSilence(bytesToOutput, volumeChangeType);
                    bytesConsumed = bytesToOutput;
                } else {
                    Assertions.checkState((this.maybeSilenceBufferContentsSize >= this.maybeSilenceBuffer.length / 2 ? 1 : 0) != 0);
                    int volumeChangeType = 0;
                    bytesToOutput = this.maybeSilenceBuffer.length / 2;
                    this.outputSilence(bytesToOutput, volumeChangeType);
                    bytesConsumed = bytesToOutput;
                }
            } else if (shouldTransitionToNoisyState) {
                int volumeChangeType = 2;
                int bytesRemainingAfterOutputtingHalfMin = this.maybeSilenceBufferContentsSize - this.maybeSilenceBuffer.length / 2;
                bytesConsumed = bytesRemainingAfterOutputtingHalfMin + this.maybeSilenceBuffer.length / 2;
                int shortenedSilenceLength = this.calculateShortenedSilenceLength(bytesRemainingAfterOutputtingHalfMin);
                bytesToOutput = this.maybeSilenceBuffer.length / 2 + shortenedSilenceLength;
                this.outputSilence(bytesToOutput, volumeChangeType);
            } else {
                int volumeChangeType = 1;
                bytesConsumed = this.maybeSilenceBufferContentsSize - this.maybeSilenceBuffer.length / 2;
                bytesToOutput = this.calculateShortenedSilenceLength(bytesConsumed);
                this.outputSilence(bytesToOutput, volumeChangeType);
            }
            Assertions.checkState((bytesConsumed % this.bytesPerFrame == 0 ? 1 : 0) != 0, (Object)("bytesConsumed is not aligned to frame size: %s" + bytesConsumed));
            Assertions.checkState((sizeBeforeOutput >= bytesToOutput ? 1 : 0) != 0);
            this.maybeSilenceBufferContentsSize -= bytesConsumed;
            this.maybeSilenceBufferStartIndex += bytesConsumed;
            this.maybeSilenceBufferStartIndex %= this.maybeSilenceBuffer.length;
            this.outputSilenceFramesSinceNoise += bytesToOutput / this.bytesPerFrame;
            this.skippedFrames += (long)((bytesConsumed - bytesToOutput) / this.bytesPerFrame);
        }
    }

    private int calculateShortenedSilenceLength(int silenceToShortenBytes) {
        int bytesNeededToReachMax = (this.durationUsToFrames(this.maxSilenceToKeepDurationUs) - this.outputSilenceFramesSinceNoise) * this.bytesPerFrame - this.maybeSilenceBuffer.length / 2;
        Assertions.checkState((bytesNeededToReachMax >= 0 ? 1 : 0) != 0);
        return this.alignToBytePerFrameBoundary(Math.min((float)silenceToShortenBytes * this.silenceRetentionRatio + 0.5f, (float)bytesNeededToReachMax));
    }

    private int alignToBytePerFrameBoundary(int value) {
        return value / this.bytesPerFrame * this.bytesPerFrame;
    }

    private int alignToBytePerFrameBoundary(float value) {
        return this.alignToBytePerFrameBoundary((int)value);
    }

    private void outputRange(byte[] data, int size, int rampType) {
        Assertions.checkArgument((size % this.bytesPerFrame == 0 ? 1 : 0) != 0, (Object)("byteOutput size is not aligned to frame size " + size));
        this.modifyVolume(data, size, rampType);
        this.replaceOutputBuffer(size).put(data, 0, size).flip();
    }

    private void outputSilence(int sizeToOutput, int rampType) {
        if (sizeToOutput == 0) {
            return;
        }
        Assertions.checkArgument((this.maybeSilenceBufferContentsSize >= sizeToOutput ? 1 : 0) != 0);
        if (rampType == 2) {
            if (this.maybeSilenceBufferStartIndex + this.maybeSilenceBufferContentsSize <= this.maybeSilenceBuffer.length) {
                System.arraycopy(this.maybeSilenceBuffer, this.maybeSilenceBufferStartIndex + this.maybeSilenceBufferContentsSize - sizeToOutput, this.contiguousOutputBuffer, 0, sizeToOutput);
            } else {
                int sizeInUpperPartOfArray = this.maybeSilenceBuffer.length - this.maybeSilenceBufferStartIndex;
                int sizeInLowerPartOfArray = this.maybeSilenceBufferContentsSize - sizeInUpperPartOfArray;
                if (sizeInLowerPartOfArray >= sizeToOutput) {
                    System.arraycopy(this.maybeSilenceBuffer, sizeInLowerPartOfArray - sizeToOutput, this.contiguousOutputBuffer, 0, sizeToOutput);
                } else {
                    int sizeToOutputInUpperPart = sizeToOutput - sizeInLowerPartOfArray;
                    System.arraycopy(this.maybeSilenceBuffer, this.maybeSilenceBuffer.length - sizeToOutputInUpperPart, this.contiguousOutputBuffer, 0, sizeToOutputInUpperPart);
                    System.arraycopy(this.maybeSilenceBuffer, 0, this.contiguousOutputBuffer, sizeToOutputInUpperPart, sizeInLowerPartOfArray);
                }
            }
        } else if (this.maybeSilenceBufferStartIndex + sizeToOutput <= this.maybeSilenceBuffer.length) {
            System.arraycopy(this.maybeSilenceBuffer, this.maybeSilenceBufferStartIndex, this.contiguousOutputBuffer, 0, sizeToOutput);
        } else {
            int sizeToCopyInUpperPartOfArray = this.maybeSilenceBuffer.length - this.maybeSilenceBufferStartIndex;
            System.arraycopy(this.maybeSilenceBuffer, this.maybeSilenceBufferStartIndex, this.contiguousOutputBuffer, 0, sizeToCopyInUpperPartOfArray);
            int amountToCopyFromLowerPartOfArray = sizeToOutput - sizeToCopyInUpperPartOfArray;
            System.arraycopy(this.maybeSilenceBuffer, 0, this.contiguousOutputBuffer, sizeToCopyInUpperPartOfArray, amountToCopyFromLowerPartOfArray);
        }
        Assertions.checkArgument((sizeToOutput % this.bytesPerFrame == 0 ? 1 : 0) != 0, (Object)("sizeToOutput is not aligned to frame size: " + sizeToOutput));
        Assertions.checkState((this.maybeSilenceBufferStartIndex < this.maybeSilenceBuffer.length ? 1 : 0) != 0);
        this.outputRange(this.contiguousOutputBuffer, sizeToOutput, rampType);
    }

    private void modifyVolume(byte[] sampleBuffer, int size, int volumeChangeType) {
        if (volumeChangeType == 3) {
            return;
        }
        for (int idx = 0; idx < size; idx += 2) {
            byte mostSignificantByte = sampleBuffer[idx + 1];
            byte leastSignificantByte = sampleBuffer[idx];
            int sample = SilenceSkippingAudioProcessor.twoByteSampleToInt(mostSignificantByte, leastSignificantByte);
            int volumeModificationPercentage = volumeChangeType == 0 ? this.calculateFadeOutPercentage(idx, size - 1) : (volumeChangeType == 2 ? this.calculateFadeInPercentage(idx, size - 1) : this.minVolumeToKeepPercentageWhenMuting);
            sample = sample * volumeModificationPercentage / 100;
            SilenceSkippingAudioProcessor.sampleIntToTwoBigEndianBytes(sampleBuffer, idx, sample);
        }
    }

    private int calculateFadeOutPercentage(int value, int max) {
        return (this.minVolumeToKeepPercentageWhenMuting - 100) * (1000 * value / max) / 1000 + 100;
    }

    private int calculateFadeInPercentage(int value, int max) {
        return this.minVolumeToKeepPercentageWhenMuting + (100 - this.minVolumeToKeepPercentageWhenMuting) * (1000 * value) / max / 1000;
    }

    private static int twoByteSampleToInt(byte mostSignificantByte, byte leastSignificantByte) {
        return leastSignificantByte & 0xFF | mostSignificantByte << 8;
    }

    private static void sampleIntToTwoBigEndianBytes(byte[] byteArray, int startIndex, int sample) {
        if (sample >= Short.MAX_VALUE) {
            byteArray[startIndex] = -1;
            byteArray[startIndex + 1] = 127;
        } else if (sample <= Short.MIN_VALUE) {
            byteArray[startIndex] = 0;
            byteArray[startIndex + 1] = -128;
        } else {
            byteArray[startIndex] = (byte)(sample & 0xFF);
            byteArray[startIndex + 1] = (byte)(sample >> 8);
        }
    }

    private void output(ByteBuffer data) {
        this.replaceOutputBuffer(data.remaining()).put(data).flip();
    }

    private int durationUsToFrames(long durationUs) {
        return (int)(durationUs * (long)this.inputFormat.sampleRate / 1000000L);
    }

    private int findNoisePosition(ByteBuffer buffer) {
        for (int i = buffer.position() + 1; i < buffer.limit(); i += 2) {
            if (!this.isNoise(buffer.get(i), buffer.get(i - 1))) continue;
            return this.bytesPerFrame * (i / this.bytesPerFrame);
        }
        return buffer.limit();
    }

    private int findNoiseLimit(ByteBuffer buffer) {
        for (int i = buffer.limit() - 1; i >= buffer.position(); i -= 2) {
            if (!this.isNoise(buffer.get(i), buffer.get(i - 1))) continue;
            return this.bytesPerFrame * (i / this.bytesPerFrame) + this.bytesPerFrame;
        }
        return buffer.position();
    }

    private boolean isNoise(byte mostSignificantByte, byte leastSignificantByte) {
        return Math.abs(SilenceSkippingAudioProcessor.twoByteSampleToInt(mostSignificantByte, leastSignificantByte)) > this.silenceThresholdLevel;
    }
}

