/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.util.SparseArray;
import androidx.annotation.FloatRange;
import androidx.media3.common.audio.AudioMixingUtil;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.ChannelMixingMatrix;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.audio.TeeAudioProcessor;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@UnstableApi
public class WaveformAudioBufferSink
implements TeeAudioProcessor.AudioBufferSink {
    private final int barsPerSecond;
    private final Listener listener;
    private final SparseArray<WaveformBar> outputChannels;
    private final ByteBuffer mixingBuffer;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull AudioProcessor.AudioFormat inputAudioFormat;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @MonotonicNonNull AudioProcessor.AudioFormat mixingAudioFormat;
    private @MonotonicNonNull ChannelMixingMatrix channelMixingMatrix;
    private int samplesPerBar;

    public WaveformAudioBufferSink(int barsPerSecond, int outputChannelCount, Listener listener) {
        this.barsPerSecond = barsPerSecond;
        this.listener = listener;
        this.mixingBuffer = ByteBuffer.allocate(Util.getPcmFrameSize((int)4, (int)outputChannelCount));
        this.outputChannels = new SparseArray(outputChannelCount);
        for (int i = 0; i < outputChannelCount; ++i) {
            this.outputChannels.append(i, (Object)new WaveformBar());
        }
    }

    @Override
    public void flush(int sampleRateHz, int channelCount, int encoding) {
        this.samplesPerBar = sampleRateHz / this.barsPerSecond;
        this.inputAudioFormat = new AudioProcessor.AudioFormat(sampleRateHz, channelCount, encoding);
        this.mixingAudioFormat = new AudioProcessor.AudioFormat(sampleRateHz, this.outputChannels.size(), 4);
        this.channelMixingMatrix = ChannelMixingMatrix.create((int)channelCount, (int)this.outputChannels.size());
    }

    @Override
    public void handleBuffer(ByteBuffer buffer) {
        Assertions.checkStateNotNull((Object)this.inputAudioFormat);
        Assertions.checkStateNotNull((Object)this.mixingAudioFormat);
        Assertions.checkStateNotNull((Object)this.channelMixingMatrix);
        while (buffer.hasRemaining()) {
            this.mixingBuffer.rewind();
            AudioMixingUtil.mix((ByteBuffer)buffer, (AudioProcessor.AudioFormat)this.inputAudioFormat, (ByteBuffer)this.mixingBuffer, (AudioProcessor.AudioFormat)this.mixingAudioFormat, (ChannelMixingMatrix)this.channelMixingMatrix, (int)1, (boolean)false);
            this.mixingBuffer.rewind();
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                WaveformBar bar = (WaveformBar)this.outputChannels.get(i);
                bar.addSample(this.mixingBuffer.getFloat());
                if (bar.getSampleCount() < this.samplesPerBar) continue;
                this.listener.onNewWaveformBar(i, bar);
                this.outputChannels.set(i, (Object)new WaveformBar());
            }
        }
    }

    public static interface Listener {
        public void onNewWaveformBar(int var1, WaveformBar var2);
    }

    public static class WaveformBar {
        private float minSampleValue = 1.0f;
        private float maxSampleValue = -1.0f;
        private double squareSum;
        private int sampleCount;

        public int getSampleCount() {
            return this.sampleCount;
        }

        public double getMinSampleValue() {
            return this.minSampleValue;
        }

        public double getMaxSampleValue() {
            return this.maxSampleValue;
        }

        public double getRootMeanSquare() {
            return Math.sqrt(this.squareSum / (double)this.sampleCount);
        }

        public void addSample(@FloatRange(from=-1.0, to=1.0) float sample) {
            Preconditions.checkArgument((sample >= -1.0f && sample <= 1.0f ? 1 : 0) != 0);
            this.minSampleValue = Math.min(this.minSampleValue, sample);
            this.maxSampleValue = Math.max(this.maxSampleValue, sample);
            this.squareSum += (double)sample * (double)sample;
            ++this.sampleCount;
        }
    }
}

