/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.annotation.SuppressLint;
import android.media.DeniedByServerException;
import android.media.MediaCrypto;
import android.media.MediaCryptoException;
import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.NotProvisionedException;
import android.media.UnsupportedSchemeException;
import android.media.metrics.LogSessionId;
import android.os.PersistableBundle;
import android.text.TextUtils;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.C;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.ClearKeyUtil;
import androidx.media3.exoplayer.drm.DummyExoMediaDrm;
import androidx.media3.exoplayer.drm.ExoMediaDrm;
import androidx.media3.exoplayer.drm.FrameworkCryptoConfig;
import androidx.media3.exoplayer.drm.UnsupportedDrmException;
import androidx.media3.extractor.mp4.PsshAtomUtil;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@RequiresApi(value=18)
public final class FrameworkMediaDrm
implements ExoMediaDrm {
    private static final String TAG = "FrameworkMediaDrm";
    @UnstableApi
    public static final ExoMediaDrm.Provider DEFAULT_PROVIDER = uuid -> {
        try {
            return FrameworkMediaDrm.newInstance(uuid);
        }
        catch (UnsupportedDrmException e) {
            Log.e((String)TAG, (String)("Failed to instantiate a FrameworkMediaDrm for uuid: " + uuid + "."));
            return new DummyExoMediaDrm();
        }
    };
    private static final String CENC_SCHEME_MIME_TYPE = "cenc";
    private static final String MOCK_LA_URL_VALUE = "https://x";
    private static final String MOCK_LA_URL = "<LA_URL>https://x</LA_URL>";
    private static final int UTF_16_BYTES_PER_CHARACTER = 2;
    private final UUID uuid;
    private final MediaDrm mediaDrm;
    private int referenceCount;

    public static boolean isCryptoSchemeSupported(UUID uuid) {
        return MediaDrm.isCryptoSchemeSupported((UUID)FrameworkMediaDrm.adjustUuid(uuid));
    }

    @UnstableApi
    public static FrameworkMediaDrm newInstance(UUID uuid) throws UnsupportedDrmException {
        try {
            return new FrameworkMediaDrm(uuid);
        }
        catch (UnsupportedSchemeException e) {
            throw new UnsupportedDrmException(1, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new UnsupportedDrmException(2, e);
        }
    }

    private FrameworkMediaDrm(UUID uuid) throws UnsupportedSchemeException {
        Assertions.checkNotNull((Object)uuid);
        Assertions.checkArgument((!C.COMMON_PSSH_UUID.equals(uuid) ? 1 : 0) != 0, (Object)"Use C.CLEARKEY_UUID instead");
        this.uuid = uuid;
        this.mediaDrm = new MediaDrm(FrameworkMediaDrm.adjustUuid(uuid));
        this.referenceCount = 1;
        if (C.WIDEVINE_UUID.equals(uuid) && FrameworkMediaDrm.needsForceWidevineL3Workaround()) {
            FrameworkMediaDrm.forceWidevineL3(this.mediaDrm);
        }
    }

    @Override
    @UnstableApi
    public void setOnEventListener(@Nullable ExoMediaDrm.OnEventListener listener) {
        this.mediaDrm.setOnEventListener(listener == null ? null : (mediaDrm, sessionId, event, extra, data) -> listener.onEvent(this, sessionId, event, extra, data));
    }

    @Override
    @UnstableApi
    @RequiresApi(value=23)
    public void setOnKeyStatusChangeListener(@Nullable ExoMediaDrm.OnKeyStatusChangeListener listener) {
        if (Util.SDK_INT < 23) {
            throw new UnsupportedOperationException();
        }
        this.mediaDrm.setOnKeyStatusChangeListener(listener == null ? null : (mediaDrm, sessionId, keyInfo, hasNewUsableKey) -> {
            ArrayList<ExoMediaDrm.KeyStatus> exoKeyInfo = new ArrayList<ExoMediaDrm.KeyStatus>();
            for (MediaDrm.KeyStatus keyStatus : keyInfo) {
                exoKeyInfo.add(new ExoMediaDrm.KeyStatus(keyStatus.getStatusCode(), keyStatus.getKeyId()));
            }
            listener.onKeyStatusChange(this, sessionId, exoKeyInfo, hasNewUsableKey);
        }, null);
    }

    @Override
    @UnstableApi
    @RequiresApi(value=23)
    public void setOnExpirationUpdateListener(@Nullable ExoMediaDrm.OnExpirationUpdateListener listener) {
        if (Util.SDK_INT < 23) {
            throw new UnsupportedOperationException();
        }
        this.mediaDrm.setOnExpirationUpdateListener(listener == null ? null : (mediaDrm, sessionId, expirationTimeMs) -> listener.onExpirationUpdate(this, sessionId, expirationTimeMs), null);
    }

    @Override
    @UnstableApi
    public byte[] openSession() throws MediaDrmException {
        return this.mediaDrm.openSession();
    }

    @Override
    @UnstableApi
    public void closeSession(byte[] sessionId) {
        this.mediaDrm.closeSession(sessionId);
    }

    @Override
    @UnstableApi
    public void setPlayerIdForSession(byte[] sessionId, PlayerId playerId) {
        if (Util.SDK_INT >= 31) {
            try {
                Api31.setLogSessionIdOnMediaDrmSession(this.mediaDrm, sessionId, playerId);
            }
            catch (UnsupportedOperationException e) {
                Log.w((String)TAG, (String)"setLogSessionId failed.");
            }
        }
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    @UnstableApi
    public ExoMediaDrm.KeyRequest getKeyRequest(byte[] scope, @Nullable List<DrmInitData.SchemeData> schemeDatas, int keyType, @Nullable HashMap<String, String> optionalParameters) throws NotProvisionedException {
        DrmInitData.SchemeData schemeData = null;
        byte[] initData = null;
        String mimeType = null;
        if (schemeDatas != null) {
            schemeData = FrameworkMediaDrm.getSchemeData(this.uuid, schemeDatas);
            initData = FrameworkMediaDrm.adjustRequestInitData(this.uuid, (byte[])Assertions.checkNotNull((Object)schemeData.data));
            mimeType = FrameworkMediaDrm.adjustRequestMimeType(this.uuid, schemeData.mimeType);
        }
        MediaDrm.KeyRequest request = this.mediaDrm.getKeyRequest(scope, initData, mimeType, keyType, optionalParameters);
        byte[] requestData = FrameworkMediaDrm.adjustRequestData(this.uuid, request.getData());
        String licenseServerUrl = FrameworkMediaDrm.adjustLicenseServerUrl(request.getDefaultUrl());
        if (TextUtils.isEmpty((CharSequence)licenseServerUrl) && schemeData != null && !TextUtils.isEmpty((CharSequence)schemeData.licenseServerUrl)) {
            licenseServerUrl = schemeData.licenseServerUrl;
        }
        int requestType = Util.SDK_INT >= 23 ? request.getRequestType() : Integer.MIN_VALUE;
        return new ExoMediaDrm.KeyRequest(requestData, licenseServerUrl, requestType);
    }

    private static String adjustLicenseServerUrl(String licenseServerUrl) {
        if (MOCK_LA_URL.equals(licenseServerUrl)) {
            return "";
        }
        if (Util.SDK_INT >= 33 && "https://default.url".equals(licenseServerUrl)) {
            return "";
        }
        return licenseServerUrl;
    }

    @Override
    @UnstableApi
    @Nullable
    public byte[] provideKeyResponse(byte[] scope, byte[] response) throws NotProvisionedException, DeniedByServerException {
        if (C.CLEARKEY_UUID.equals(this.uuid)) {
            response = ClearKeyUtil.adjustResponseData(response);
        }
        return this.mediaDrm.provideKeyResponse(scope, response);
    }

    @Override
    @UnstableApi
    public ExoMediaDrm.ProvisionRequest getProvisionRequest() {
        MediaDrm.ProvisionRequest request = this.mediaDrm.getProvisionRequest();
        return new ExoMediaDrm.ProvisionRequest(request.getData(), request.getDefaultUrl());
    }

    @Override
    @UnstableApi
    public void provideProvisionResponse(byte[] response) throws DeniedByServerException {
        this.mediaDrm.provideProvisionResponse(response);
    }

    @Override
    @UnstableApi
    public Map<String, String> queryKeyStatus(byte[] sessionId) {
        return this.mediaDrm.queryKeyStatus(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @UnstableApi
    public boolean requiresSecureDecoder(byte[] sessionId, String mimeType) {
        MediaCrypto mediaCrypto;
        if (Util.SDK_INT >= 31) {
            return Api31.requiresSecureDecoder(this.mediaDrm, mimeType);
        }
        try {
            mediaCrypto = new MediaCrypto(this.uuid, sessionId);
        }
        catch (MediaCryptoException e) {
            return true;
        }
        try {
            boolean bl = mediaCrypto.requiresSecureDecoderComponent(mimeType);
            return bl;
        }
        finally {
            mediaCrypto.release();
        }
    }

    @Override
    @UnstableApi
    public synchronized void acquire() {
        Assertions.checkState((this.referenceCount > 0 ? 1 : 0) != 0);
        ++this.referenceCount;
    }

    @Override
    @UnstableApi
    public synchronized void release() {
        if (--this.referenceCount == 0) {
            this.mediaDrm.release();
        }
    }

    @Override
    @UnstableApi
    public void restoreKeys(byte[] sessionId, byte[] keySetId) {
        this.mediaDrm.restoreKeys(sessionId, keySetId);
    }

    @Override
    @UnstableApi
    @RequiresApi(value=29)
    public void removeOfflineLicense(byte[] keySetId) {
        if (Util.SDK_INT < 29) {
            throw new UnsupportedOperationException();
        }
        this.mediaDrm.removeOfflineLicense(keySetId);
    }

    @Override
    @UnstableApi
    @RequiresApi(value=29)
    public List<byte[]> getOfflineLicenseKeySetIds() {
        if (Util.SDK_INT < 29) {
            throw new UnsupportedOperationException();
        }
        return this.mediaDrm.getOfflineLicenseKeySetIds();
    }

    @Override
    @UnstableApi
    @Nullable
    public PersistableBundle getMetrics() {
        if (Util.SDK_INT < 28) {
            return null;
        }
        return this.mediaDrm.getMetrics();
    }

    @Override
    @UnstableApi
    public String getPropertyString(String propertyName) {
        return this.mediaDrm.getPropertyString(propertyName);
    }

    @Override
    @UnstableApi
    public byte[] getPropertyByteArray(String propertyName) {
        return this.mediaDrm.getPropertyByteArray(propertyName);
    }

    @Override
    @UnstableApi
    public void setPropertyString(String propertyName, String value) {
        this.mediaDrm.setPropertyString(propertyName, value);
    }

    @Override
    @UnstableApi
    public void setPropertyByteArray(String propertyName, byte[] value) {
        this.mediaDrm.setPropertyByteArray(propertyName, value);
    }

    @Override
    @UnstableApi
    public FrameworkCryptoConfig createCryptoConfig(byte[] sessionId) throws MediaCryptoException {
        boolean forceAllowInsecureDecoderComponents = Util.SDK_INT < 21 && C.WIDEVINE_UUID.equals(this.uuid) && "L3".equals(this.getPropertyString("securityLevel"));
        return new FrameworkCryptoConfig(FrameworkMediaDrm.adjustUuid(this.uuid), sessionId, forceAllowInsecureDecoderComponents);
    }

    @Override
    @UnstableApi
    public int getCryptoType() {
        return 2;
    }

    private static DrmInitData.SchemeData getSchemeData(UUID uuid, List<DrmInitData.SchemeData> schemeDatas) {
        if (!C.WIDEVINE_UUID.equals(uuid)) {
            return schemeDatas.get(0);
        }
        if (Util.SDK_INT >= 28 && schemeDatas.size() > 1) {
            DrmInitData.SchemeData firstSchemeData = schemeDatas.get(0);
            int concatenatedDataLength = 0;
            boolean canConcatenateData = true;
            for (int i = 0; i < schemeDatas.size(); ++i) {
                DrmInitData.SchemeData schemeData = schemeDatas.get(i);
                byte[] schemeDataData = (byte[])Assertions.checkNotNull((Object)schemeData.data);
                if (Util.areEqual((Object)schemeData.mimeType, (Object)firstSchemeData.mimeType) && Util.areEqual((Object)schemeData.licenseServerUrl, (Object)firstSchemeData.licenseServerUrl) && PsshAtomUtil.isPsshAtom((byte[])schemeDataData)) {
                    concatenatedDataLength += schemeDataData.length;
                    continue;
                }
                canConcatenateData = false;
                break;
            }
            if (canConcatenateData) {
                byte[] concatenatedData = new byte[concatenatedDataLength];
                int concatenatedDataPosition = 0;
                for (int i = 0; i < schemeDatas.size(); ++i) {
                    DrmInitData.SchemeData schemeData = schemeDatas.get(i);
                    byte[] schemeDataData = (byte[])Assertions.checkNotNull((Object)schemeData.data);
                    int schemeDataLength = schemeDataData.length;
                    System.arraycopy(schemeDataData, 0, concatenatedData, concatenatedDataPosition, schemeDataLength);
                    concatenatedDataPosition += schemeDataLength;
                }
                return firstSchemeData.copyWithData(concatenatedData);
            }
        }
        for (int i = 0; i < schemeDatas.size(); ++i) {
            DrmInitData.SchemeData schemeData = schemeDatas.get(i);
            int version = PsshAtomUtil.parseVersion((byte[])((byte[])Assertions.checkNotNull((Object)schemeData.data)));
            if (Util.SDK_INT < 23 && version == 0) {
                return schemeData;
            }
            if (Util.SDK_INT < 23 || version != 1) continue;
            return schemeData;
        }
        return schemeDatas.get(0);
    }

    private static UUID adjustUuid(UUID uuid) {
        return Util.SDK_INT < 27 && C.CLEARKEY_UUID.equals(uuid) ? C.COMMON_PSSH_UUID : uuid;
    }

    private static byte[] adjustRequestInitData(UUID uuid, byte[] initData) {
        byte[] psshData;
        if (C.PLAYREADY_UUID.equals(uuid)) {
            byte[] schemeSpecificData = PsshAtomUtil.parseSchemeSpecificData((byte[])initData, (UUID)uuid);
            if (schemeSpecificData == null) {
                schemeSpecificData = initData;
            }
            initData = PsshAtomUtil.buildPsshAtom((UUID)C.PLAYREADY_UUID, (byte[])FrameworkMediaDrm.addLaUrlAttributeIfMissing(schemeSpecificData));
        }
        if ((Util.SDK_INT < 23 && C.WIDEVINE_UUID.equals(uuid) || C.PLAYREADY_UUID.equals(uuid) && "Amazon".equals(Util.MANUFACTURER) && ("AFTB".equals(Util.MODEL) || "AFTS".equals(Util.MODEL) || "AFTM".equals(Util.MODEL) || "AFTT".equals(Util.MODEL))) && (psshData = PsshAtomUtil.parseSchemeSpecificData((byte[])initData, (UUID)uuid)) != null) {
            return psshData;
        }
        return initData;
    }

    private static String adjustRequestMimeType(UUID uuid, String mimeType) {
        if (Util.SDK_INT < 26 && C.CLEARKEY_UUID.equals(uuid) && ("video/mp4".equals(mimeType) || "audio/mp4".equals(mimeType))) {
            return CENC_SCHEME_MIME_TYPE;
        }
        return mimeType;
    }

    private static byte[] adjustRequestData(UUID uuid, byte[] requestData) {
        if (C.CLEARKEY_UUID.equals(uuid)) {
            return ClearKeyUtil.adjustRequestData(requestData);
        }
        return requestData;
    }

    private static void forceWidevineL3(MediaDrm mediaDrm) {
        mediaDrm.setPropertyString("securityLevel", "L3");
    }

    private static boolean needsForceWidevineL3Workaround() {
        return "ASUS_Z00AD".equals(Util.MODEL);
    }

    private static byte[] addLaUrlAttributeIfMissing(byte[] data) {
        ParsableByteArray byteArray = new ParsableByteArray(data);
        int length = byteArray.readLittleEndianInt();
        short objectRecordCount = byteArray.readLittleEndianShort();
        short recordType = byteArray.readLittleEndianShort();
        if (objectRecordCount != 1 || recordType != 1) {
            Log.i((String)TAG, (String)"Unexpected record count or type. Skipping LA_URL workaround.");
            return data;
        }
        short recordLength = byteArray.readLittleEndianShort();
        String xml = byteArray.readString((int)recordLength, Charsets.UTF_16LE);
        if (xml.contains("<LA_URL>")) {
            return data;
        }
        int endOfDataTagIndex = xml.indexOf("</DATA>");
        if (endOfDataTagIndex == -1) {
            Log.w((String)TAG, (String)"Could not find the </DATA> tag. Skipping LA_URL workaround.");
        }
        String xmlWithMockLaUrl = xml.substring(0, endOfDataTagIndex) + MOCK_LA_URL + xml.substring(endOfDataTagIndex);
        int extraBytes = MOCK_LA_URL.length() * 2;
        ByteBuffer newData = ByteBuffer.allocate(length + extraBytes);
        newData.order(ByteOrder.LITTLE_ENDIAN);
        newData.putInt(length + extraBytes);
        newData.putShort(objectRecordCount);
        newData.putShort(recordType);
        newData.putShort((short)(xmlWithMockLaUrl.length() * 2));
        newData.put(xmlWithMockLaUrl.getBytes(Charsets.UTF_16LE));
        return newData.array();
    }

    @RequiresApi(value=31)
    private static class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static boolean requiresSecureDecoder(MediaDrm mediaDrm, String mimeType) {
            return mediaDrm.requiresSecureDecoder(mimeType);
        }

        @DoNotInline
        public static void setLogSessionIdOnMediaDrmSession(MediaDrm mediaDrm, byte[] drmSessionId, PlayerId playerId) {
            LogSessionId logSessionId = playerId.getLogSessionId();
            if (!logSessionId.equals((Object)LogSessionId.LOG_SESSION_ID_NONE)) {
                MediaDrm.PlaybackComponent playbackComponent = (MediaDrm.PlaybackComponent)Assertions.checkNotNull((Object)mediaDrm.getPlaybackComponent(drmSessionId));
                playbackComponent.setLogSessionId(logSessionId);
            }
        }
    }
}

