/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.DrmInitData;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.HttpMediaDrmCallback;
import androidx.media3.exoplayer.drm.KeysExpiredException;
import androidx.media3.exoplayer.drm.WidevineUtil;
import androidx.media3.exoplayer.source.MediaSource;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.concurrent.ExecutionException;

@RequiresApi(value=18)
@UnstableApi
public final class OfflineLicenseHelper {
    private static final Format FORMAT_WITH_EMPTY_DRM_INIT_DATA = new Format.Builder().setDrmInitData(new DrmInitData(new DrmInitData.SchemeData[0])).build();
    private final ConditionVariable drmListenerConditionVariable;
    private final DefaultDrmSessionManager drmSessionManager;
    private final HandlerThread handlerThread;
    private final Handler handler;
    private final DrmSessionEventListener.EventDispatcher eventDispatcher;

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, DataSource.Factory dataSourceFactory, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return OfflineLicenseHelper.newWidevineInstance(defaultLicenseUrl, false, dataSourceFactory, eventDispatcher);
    }

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, boolean forceDefaultLicenseUrl, DataSource.Factory dataSourceFactory, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return OfflineLicenseHelper.newWidevineInstance(defaultLicenseUrl, forceDefaultLicenseUrl, dataSourceFactory, null, eventDispatcher);
    }

    public static OfflineLicenseHelper newWidevineInstance(String defaultLicenseUrl, boolean forceDefaultLicenseUrl, DataSource.Factory dataSourceFactory, @Nullable Map<String, String> optionalKeyRequestParameters, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        return new OfflineLicenseHelper(new DefaultDrmSessionManager.Builder().setKeyRequestParameters(optionalKeyRequestParameters).build(new HttpMediaDrmCallback(defaultLicenseUrl, forceDefaultLicenseUrl, dataSourceFactory)), eventDispatcher);
    }

    public OfflineLicenseHelper(DefaultDrmSessionManager defaultDrmSessionManager, DrmSessionEventListener.EventDispatcher eventDispatcher) {
        this.drmSessionManager = defaultDrmSessionManager;
        this.eventDispatcher = eventDispatcher;
        this.handlerThread = new HandlerThread("ExoPlayer:OfflineLicenseHelper");
        this.handlerThread.start();
        this.handler = new Handler(this.handlerThread.getLooper());
        this.drmListenerConditionVariable = new ConditionVariable();
        DrmSessionEventListener eventListener = new DrmSessionEventListener(){

            @Override
            public void onDrmKeysLoaded(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.drmListenerConditionVariable.open();
            }

            @Override
            public void onDrmSessionManagerError(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, Exception e) {
                OfflineLicenseHelper.this.drmListenerConditionVariable.open();
            }

            @Override
            public void onDrmKeysRestored(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.drmListenerConditionVariable.open();
            }

            @Override
            public void onDrmKeysRemoved(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
                OfflineLicenseHelper.this.drmListenerConditionVariable.open();
            }
        };
        eventDispatcher.addEventListener(new Handler(this.handlerThread.getLooper()), eventListener);
    }

    public synchronized byte[] downloadLicense(Format format) throws DrmSession.DrmSessionException {
        Assertions.checkArgument((format.drmInitData != null ? 1 : 0) != 0);
        return this.acquireSessionAndGetOfflineLicenseKeySetIdOnHandlerThread(2, null, format);
    }

    public synchronized byte[] renewLicense(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        return this.acquireSessionAndGetOfflineLicenseKeySetIdOnHandlerThread(2, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
    }

    public synchronized void releaseLicense(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        this.acquireSessionAndGetOfflineLicenseKeySetIdOnHandlerThread(3, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
    }

    public synchronized Pair<Long, Long> getLicenseDurationRemainingSec(byte[] offlineLicenseKeySetId) throws DrmSession.DrmSessionException {
        DrmSession drmSession;
        Assertions.checkNotNull((Object)offlineLicenseKeySetId);
        try {
            drmSession = this.acquireFirstSessionOnHandlerThread(1, offlineLicenseKeySetId, FORMAT_WITH_EMPTY_DRM_INIT_DATA);
        }
        catch (DrmSession.DrmSessionException e) {
            if (e.getCause() instanceof KeysExpiredException) {
                return Pair.create((Object)0L, (Object)0L);
            }
            throw e;
        }
        SettableFuture licenseDurationRemainingSec = SettableFuture.create();
        this.handler.post(() -> {
            try {
                licenseDurationRemainingSec.set((Object)((Pair)Assertions.checkNotNull(WidevineUtil.getLicenseDurationRemainingSec(drmSession))));
            }
            catch (Throwable e) {
                licenseDurationRemainingSec.setException(e);
            }
            finally {
                drmSession.release(this.eventDispatcher);
            }
        });
        try {
            Pair pair = (Pair)licenseDurationRemainingSec.get();
            return pair;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.releaseManagerOnHandlerThread();
        }
    }

    public void release() {
        this.handlerThread.quit();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private byte[] acquireSessionAndGetOfflineLicenseKeySetIdOnHandlerThread(int licenseMode, @Nullable byte[] offlineLicenseKeySetId, Format format) throws DrmSession.DrmSessionException {
        DrmSession drmSession = this.acquireFirstSessionOnHandlerThread(licenseMode, offlineLicenseKeySetId, format);
        @NullableType SettableFuture keySetId = SettableFuture.create();
        this.handler.post(() -> {
            try {
                keySetId.set((Object)drmSession.getOfflineLicenseKeySetId());
            }
            catch (Throwable e) {
                keySetId.setException(e);
            }
            finally {
                drmSession.release(this.eventDispatcher);
            }
        });
        try {
            byte[] byArray = (byte[])Assertions.checkNotNull((Object)((byte[])keySetId.get()));
            return byArray;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.releaseManagerOnHandlerThread();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private DrmSession acquireFirstSessionOnHandlerThread(int licenseMode, @Nullable byte[] offlineLicenseKeySetId, Format format) throws DrmSession.DrmSessionException {
        DrmSession drmSession;
        Assertions.checkNotNull((Object)format.drmInitData);
        SettableFuture drmSessionFuture = SettableFuture.create();
        this.drmListenerConditionVariable.close();
        this.handler.post(() -> {
            try {
                this.drmSessionManager.setPlayer((Looper)Assertions.checkNotNull((Object)Looper.myLooper()), PlayerId.UNSET);
                this.drmSessionManager.prepare();
                try {
                    this.drmSessionManager.setMode(licenseMode, offlineLicenseKeySetId);
                    drmSessionFuture.set((Object)((DrmSession)Assertions.checkNotNull((Object)this.drmSessionManager.acquireSession(this.eventDispatcher, format))));
                }
                catch (Throwable e) {
                    this.drmSessionManager.release();
                    throw e;
                }
            }
            catch (Throwable e) {
                drmSessionFuture.setException(e);
            }
        });
        try {
            drmSession = (DrmSession)drmSessionFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
        this.drmListenerConditionVariable.block();
        @NullableType SettableFuture drmSessionError = SettableFuture.create();
        this.handler.post(() -> {
            try {
                DrmSession.DrmSessionException error = drmSession.getError();
                if (drmSession.getState() == 1) {
                    drmSession.release(this.eventDispatcher);
                    this.drmSessionManager.release();
                }
                drmSessionError.set((Object)error);
            }
            catch (Throwable e) {
                drmSessionError.setException(e);
                drmSession.release(this.eventDispatcher);
                this.drmSessionManager.release();
            }
        });
        try {
            if (drmSessionError.get() != null) {
                throw (DrmSession.DrmSessionException)drmSessionError.get();
            }
            return drmSession;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void releaseManagerOnHandlerThread() {
        SettableFuture result = SettableFuture.create();
        this.handler.post(() -> {
            try {
                this.drmSessionManager.release();
                result.set(null);
            }
            catch (Throwable e) {
                result.setException(e);
            }
        });
        try {
            result.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }
}

