/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.exifinterface.media.ExifInterface;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.decoder.SimpleDecoder;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.image.ImageDecoder;
import androidx.media3.exoplayer.image.ImageDecoderException;
import androidx.media3.exoplayer.image.ImageOutputBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@UnstableApi
public final class BitmapFactoryImageDecoder
extends SimpleDecoder<DecoderInputBuffer, ImageOutputBuffer, ImageDecoderException>
implements ImageDecoder {
    private final BitmapDecoder bitmapDecoder;

    private BitmapFactoryImageDecoder(BitmapDecoder bitmapDecoder) {
        super(new DecoderInputBuffer[1], (DecoderOutputBuffer[])new ImageOutputBuffer[1]);
        this.bitmapDecoder = bitmapDecoder;
    }

    public String getName() {
        return "BitmapFactoryImageDecoder";
    }

    protected DecoderInputBuffer createInputBuffer() {
        return new DecoderInputBuffer(1);
    }

    protected ImageOutputBuffer createOutputBuffer() {
        return new ImageOutputBuffer(){

            public void release() {
                BitmapFactoryImageDecoder.this.releaseOutputBuffer(this);
            }
        };
    }

    protected ImageDecoderException createUnexpectedDecodeException(Throwable error) {
        return new ImageDecoderException("Unexpected decode error", error);
    }

    @Nullable
    protected ImageDecoderException decode(DecoderInputBuffer inputBuffer, ImageOutputBuffer outputBuffer, boolean reset) {
        try {
            ByteBuffer inputData = (ByteBuffer)Assertions.checkNotNull((Object)inputBuffer.data);
            Assertions.checkState((boolean)inputData.hasArray());
            Assertions.checkArgument((inputData.arrayOffset() == 0 ? 1 : 0) != 0);
            outputBuffer.bitmap = this.bitmapDecoder.decode(inputData.array(), inputData.remaining());
            outputBuffer.timeUs = inputBuffer.timeUs;
            return null;
        }
        catch (ImageDecoderException e) {
            return e;
        }
    }

    private static Bitmap decode(byte[] data, int length) throws ImageDecoderException {
        ExifInterface exifInterface;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)length);
        if (bitmap == null) {
            throw new ImageDecoderException("Could not decode image data with BitmapFactory. (data.length = " + data.length + ", input length = " + length + ")");
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(data, 0, length);){
            exifInterface = new ExifInterface((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ImageDecoderException(e);
        }
        int rotationDegrees = exifInterface.getRotationDegrees();
        if (rotationDegrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotationDegrees);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
        }
        return bitmap;
    }

    @VisibleForTesting(otherwise=2)
    public static interface BitmapDecoder {
        public Bitmap decode(byte[] var1, int var2) throws ImageDecoderException;
    }

    public static final class Factory
    implements ImageDecoder.Factory {
        private final BitmapDecoder bitmapDecoder;

        public Factory() {
            this.bitmapDecoder = (x$0, x$1) -> BitmapFactoryImageDecoder.decode(x$0, x$1);
        }

        public Factory(BitmapDecoder bitmapDecoder) {
            this.bitmapDecoder = bitmapDecoder;
        }

        @Override
        public int supportsFormat(Format format) {
            if (format.sampleMimeType == null || !MimeTypes.isImage((String)format.sampleMimeType)) {
                return RendererCapabilities.create(0);
            }
            return Util.isBitmapFactorySupportedMimeType((String)format.sampleMimeType) ? RendererCapabilities.create(4) : RendererCapabilities.create(1);
        }

        @Override
        public BitmapFactoryImageDecoder createImageDecoder() {
            return new BitmapFactoryImageDecoder(this.bitmapDecoder);
        }
    }
}

