/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.image;

import android.graphics.Bitmap;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.TraceUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.BaseRenderer;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.image.ImageDecoder;
import androidx.media3.exoplayer.image.ImageDecoderException;
import androidx.media3.exoplayer.image.ImageOutput;
import androidx.media3.exoplayer.image.ImageOutputBuffer;
import androidx.media3.exoplayer.source.MediaSource;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public class ImageRenderer
extends BaseRenderer {
    private static final String TAG = "ImageRenderer";
    private static final int REINITIALIZATION_STATE_NONE = 0;
    private static final int REINITIALIZATION_STATE_SIGNAL_END_OF_STREAM_THEN_WAIT = 2;
    private static final int REINITIALIZATION_STATE_WAIT_END_OF_STREAM = 3;
    private static final long IMAGE_PRESENTATION_WINDOW_THRESHOLD_US = 30000L;
    private final ImageDecoder.Factory decoderFactory;
    private final DecoderInputBuffer flagsOnlyBuffer;
    private final ArrayDeque<OutputStreamInfo> pendingOutputStreamChanges;
    private boolean inputStreamEnded;
    private boolean outputStreamEnded;
    private OutputStreamInfo outputStreamInfo;
    private long lastProcessedOutputBufferTimeUs;
    private long largestQueuedPresentationTimeUs;
    private int decoderReinitializationState;
    private int firstFrameState;
    private @Nullable Format inputFormat;
    private @Nullable ImageDecoder decoder;
    private @Nullable DecoderInputBuffer inputBuffer;
    private ImageOutput imageOutput;
    private @Nullable Bitmap outputBitmap;
    private boolean readyToOutputTiles;
    private @Nullable TileInfo tileInfo;
    private @Nullable TileInfo nextTileInfo;
    private int currentTileIndex;

    public ImageRenderer(ImageDecoder.Factory decoderFactory, @Nullable ImageOutput imageOutput) {
        super(4);
        this.decoderFactory = decoderFactory;
        this.imageOutput = ImageRenderer.getImageOutput(imageOutput);
        this.flagsOnlyBuffer = DecoderInputBuffer.newNoDataInstance();
        this.outputStreamInfo = OutputStreamInfo.UNSET;
        this.pendingOutputStreamChanges = new ArrayDeque();
        this.largestQueuedPresentationTimeUs = -9223372036854775807L;
        this.lastProcessedOutputBufferTimeUs = -9223372036854775807L;
        this.decoderReinitializationState = 0;
        this.firstFrameState = 1;
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public int supportsFormat(Format format) {
        return this.decoderFactory.supportsFormat(format);
    }

    @Override
    public void render(long positionUs, long elapsedRealtimeUs) throws ExoPlaybackException {
        if (this.outputStreamEnded) {
            return;
        }
        if (this.inputFormat == null) {
            FormatHolder formatHolder = this.getFormatHolder();
            this.flagsOnlyBuffer.clear();
            int result = this.readSource(formatHolder, this.flagsOnlyBuffer, 2);
            if (result == -5) {
                this.inputFormat = (Format)Assertions.checkStateNotNull((Object)formatHolder.format);
                this.initDecoder();
            } else {
                if (result == -4) {
                    Assertions.checkState((boolean)this.flagsOnlyBuffer.isEndOfStream());
                    this.inputStreamEnded = true;
                    this.outputStreamEnded = true;
                    return;
                }
                return;
            }
        }
        try {
            TraceUtil.beginSection((String)"drainAndFeedDecoder");
            while (this.drainOutput(positionUs, elapsedRealtimeUs)) {
            }
            while (this.feedInputBuffer(positionUs)) {
            }
            TraceUtil.endSection();
        }
        catch (ImageDecoderException e) {
            throw this.createRendererException((Throwable)((Object)e), null, 4003);
        }
    }

    @Override
    public boolean isReady() {
        return this.firstFrameState == 3 || this.firstFrameState == 0 && this.readyToOutputTiles;
    }

    @Override
    public boolean isEnded() {
        return this.outputStreamEnded;
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) {
        this.firstFrameState = mayRenderStartOfStream ? 1 : 0;
    }

    @Override
    protected void onStreamChanged(Format[] formats, long startPositionUs, long offsetUs, MediaSource.MediaPeriodId mediaPeriodId) throws ExoPlaybackException {
        super.onStreamChanged(formats, startPositionUs, offsetUs, mediaPeriodId);
        if (this.outputStreamInfo.streamOffsetUs == -9223372036854775807L || this.pendingOutputStreamChanges.isEmpty() && (this.largestQueuedPresentationTimeUs == -9223372036854775807L || this.lastProcessedOutputBufferTimeUs != -9223372036854775807L && this.lastProcessedOutputBufferTimeUs >= this.largestQueuedPresentationTimeUs)) {
            this.outputStreamInfo = new OutputStreamInfo(-9223372036854775807L, offsetUs);
        } else {
            this.pendingOutputStreamChanges.add(new OutputStreamInfo(this.largestQueuedPresentationTimeUs, offsetUs));
        }
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        this.lowerFirstFrameState(1);
        this.outputStreamEnded = false;
        this.inputStreamEnded = false;
        this.outputBitmap = null;
        this.tileInfo = null;
        this.nextTileInfo = null;
        this.readyToOutputTiles = false;
        this.inputBuffer = null;
        if (this.decoder != null) {
            this.decoder.flush();
        }
        this.pendingOutputStreamChanges.clear();
    }

    @Override
    protected void onDisabled() {
        this.inputFormat = null;
        this.outputStreamInfo = OutputStreamInfo.UNSET;
        this.pendingOutputStreamChanges.clear();
        this.releaseDecoderResources();
        this.imageOutput.onDisabled();
    }

    @Override
    protected void onReset() {
        this.releaseDecoderResources();
        this.lowerFirstFrameState(1);
    }

    @Override
    protected void onRelease() {
        this.releaseDecoderResources();
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 15: {
                @Nullable ImageOutput imageOutput = message instanceof ImageOutput ? (ImageOutput)message : null;
                this.setImageOutput(imageOutput);
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    private boolean drainOutput(long positionUs, long elapsedRealtimeUs) throws ImageDecoderException, ExoPlaybackException {
        if (this.outputBitmap != null && this.tileInfo == null) {
            return false;
        }
        if (this.firstFrameState == 0 && this.getState() != 2) {
            return false;
        }
        if (this.outputBitmap == null) {
            Assertions.checkStateNotNull((Object)this.decoder);
            ImageOutputBuffer outputBuffer = this.decoder.dequeueOutputBuffer();
            if (outputBuffer == null) {
                return false;
            }
            if (((ImageOutputBuffer)((Object)Assertions.checkStateNotNull((Object)((Object)outputBuffer)))).isEndOfStream()) {
                if (this.decoderReinitializationState == 3) {
                    this.releaseDecoderResources();
                    Assertions.checkStateNotNull((Object)this.inputFormat);
                    this.initDecoder();
                } else {
                    ((ImageOutputBuffer)((Object)Assertions.checkStateNotNull((Object)((Object)outputBuffer)))).release();
                    if (this.pendingOutputStreamChanges.isEmpty()) {
                        this.outputStreamEnded = true;
                    }
                }
                return false;
            }
            Assertions.checkStateNotNull((Object)outputBuffer.bitmap, (Object)"Non-EOS buffer came back from the decoder without bitmap.");
            this.outputBitmap = outputBuffer.bitmap;
            ((ImageOutputBuffer)((Object)Assertions.checkStateNotNull((Object)((Object)outputBuffer)))).release();
        }
        if (this.readyToOutputTiles && this.outputBitmap != null && this.tileInfo != null) {
            boolean isThumbnailGrid;
            Assertions.checkStateNotNull((Object)this.inputFormat);
            boolean bl = isThumbnailGrid = (this.inputFormat.tileCountHorizontal != 1 || this.inputFormat.tileCountVertical != 1) && this.inputFormat.tileCountHorizontal != -1 && this.inputFormat.tileCountVertical != -1;
            if (!this.tileInfo.hasTileBitmap()) {
                this.tileInfo.setTileBitmap(isThumbnailGrid ? this.cropTileFromImageGrid(this.tileInfo.getTileIndex()) : (Bitmap)Assertions.checkStateNotNull((Object)this.outputBitmap));
            }
            if (!this.processOutputBuffer(positionUs, elapsedRealtimeUs, (Bitmap)Assertions.checkStateNotNull((Object)this.tileInfo.getTileBitmap()), this.tileInfo.getPresentationTimeUs())) {
                return false;
            }
            this.onProcessedOutputBuffer(((TileInfo)Assertions.checkStateNotNull((Object)this.tileInfo)).getPresentationTimeUs());
            this.firstFrameState = 3;
            if (!isThumbnailGrid || ((TileInfo)Assertions.checkStateNotNull((Object)this.tileInfo)).getTileIndex() == ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountVertical * ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountHorizontal - 1) {
                this.outputBitmap = null;
            }
            this.tileInfo = this.nextTileInfo;
            this.nextTileInfo = null;
            return true;
        }
        return false;
    }

    private boolean shouldForceRender() {
        boolean isStarted = this.getState() == 2;
        switch (this.firstFrameState) {
            case 0: {
                return isStarted;
            }
            case 1: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        throw new IllegalStateException();
    }

    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, Bitmap outputBitmap, long bufferPresentationTimeUs) throws ExoPlaybackException {
        long earlyUs = bufferPresentationTimeUs - positionUs;
        if (this.shouldForceRender() || earlyUs < 30000L) {
            this.imageOutput.onImageAvailable(bufferPresentationTimeUs - this.outputStreamInfo.streamOffsetUs, outputBitmap);
            return true;
        }
        return false;
    }

    private void onProcessedOutputBuffer(long presentationTimeUs) {
        this.lastProcessedOutputBufferTimeUs = presentationTimeUs;
        while (!this.pendingOutputStreamChanges.isEmpty() && presentationTimeUs >= this.pendingOutputStreamChanges.peek().previousStreamLastBufferTimeUs) {
            this.outputStreamInfo = this.pendingOutputStreamChanges.removeFirst();
        }
    }

    private boolean feedInputBuffer(long positionUs) throws ImageDecoderException {
        if (this.readyToOutputTiles && this.tileInfo != null) {
            return false;
        }
        FormatHolder formatHolder = this.getFormatHolder();
        if (this.decoder == null || this.decoderReinitializationState == 3 || this.inputStreamEnded) {
            return false;
        }
        if (this.inputBuffer == null) {
            this.inputBuffer = (DecoderInputBuffer)this.decoder.dequeueInputBuffer();
            if (this.inputBuffer == null) {
                return false;
            }
        }
        if (this.decoderReinitializationState == 2) {
            Assertions.checkStateNotNull((Object)this.inputBuffer);
            this.inputBuffer.setFlags(4);
            ((ImageDecoder)Assertions.checkStateNotNull((Object)this.decoder)).queueInputBuffer(this.inputBuffer);
            this.inputBuffer = null;
            this.decoderReinitializationState = 3;
            return false;
        }
        switch (this.readSource(formatHolder, this.inputBuffer, 0)) {
            case -3: {
                return false;
            }
            case -4: {
                boolean shouldQueueBuffer;
                this.inputBuffer.flip();
                boolean bl = shouldQueueBuffer = ((ByteBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer.data)).remaining() > 0 || ((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer)).isEndOfStream();
                if (shouldQueueBuffer) {
                    ((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer)).clearFlag(Integer.MIN_VALUE);
                    ((ImageDecoder)Assertions.checkStateNotNull((Object)this.decoder)).queueInputBuffer((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer));
                    this.currentTileIndex = 0;
                }
                this.maybeAdvanceTileInfo(positionUs, (DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer));
                if (((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer)).isEndOfStream()) {
                    this.inputStreamEnded = true;
                    this.inputBuffer = null;
                    return false;
                }
                this.largestQueuedPresentationTimeUs = Math.max(this.largestQueuedPresentationTimeUs, ((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer)).timeUs);
                if (shouldQueueBuffer) {
                    this.inputBuffer = null;
                } else {
                    ((DecoderInputBuffer)Assertions.checkStateNotNull((Object)this.inputBuffer)).clear();
                }
                return !this.readyToOutputTiles;
            }
            case -5: {
                this.inputFormat = (Format)Assertions.checkStateNotNull((Object)formatHolder.format);
                this.decoderReinitializationState = 2;
                return true;
            }
        }
        throw new IllegalStateException();
    }

    @RequiresNonNull(value={"inputFormat"})
    @EnsuresNonNull(value={"decoder"})
    private void initDecoder() throws ExoPlaybackException {
        if (this.canCreateDecoderForFormat(this.inputFormat)) {
            if (this.decoder != null) {
                this.decoder.release();
            }
        } else {
            throw this.createRendererException((Throwable)((Object)new ImageDecoderException("Provided decoder factory can't create decoder for format.")), this.inputFormat, 4005);
        }
        this.decoder = this.decoderFactory.createImageDecoder();
    }

    private boolean canCreateDecoderForFormat(Format format) {
        int supportsFormat = this.decoderFactory.supportsFormat(format);
        return supportsFormat == RendererCapabilities.create(4) || supportsFormat == RendererCapabilities.create(3);
    }

    private void lowerFirstFrameState(int firstFrameState) {
        this.firstFrameState = Math.min(this.firstFrameState, firstFrameState);
    }

    private void releaseDecoderResources() {
        this.inputBuffer = null;
        this.decoderReinitializationState = 0;
        this.largestQueuedPresentationTimeUs = -9223372036854775807L;
        if (this.decoder != null) {
            this.decoder.release();
            this.decoder = null;
        }
    }

    private void setImageOutput(@Nullable ImageOutput imageOutput) {
        this.imageOutput = ImageRenderer.getImageOutput(imageOutput);
    }

    private void maybeAdvanceTileInfo(long positionUs, DecoderInputBuffer inputBuffer) {
        if (inputBuffer.isEndOfStream()) {
            this.readyToOutputTiles = true;
            return;
        }
        this.nextTileInfo = new TileInfo(this.currentTileIndex, inputBuffer.timeUs);
        ++this.currentTileIndex;
        if (!this.readyToOutputTiles) {
            long tilePresentationTimeUs = this.nextTileInfo.getPresentationTimeUs();
            boolean isNextTileWithinPresentationThreshold = tilePresentationTimeUs - 30000L <= positionUs && positionUs <= tilePresentationTimeUs + 30000L;
            boolean isPositionBetweenTiles = this.tileInfo != null && this.tileInfo.getPresentationTimeUs() <= positionUs && positionUs < tilePresentationTimeUs;
            boolean isNextTileLastInGrid = this.isTileLastInGrid((TileInfo)Assertions.checkStateNotNull((Object)this.nextTileInfo));
            boolean bl = this.readyToOutputTiles = isNextTileWithinPresentationThreshold || isPositionBetweenTiles || isNextTileLastInGrid;
            if (isPositionBetweenTiles && !isNextTileWithinPresentationThreshold) {
                return;
            }
        }
        this.tileInfo = this.nextTileInfo;
        this.nextTileInfo = null;
    }

    private boolean isTileLastInGrid(TileInfo tileInfo) {
        return ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountHorizontal == -1 || this.inputFormat.tileCountVertical == -1 || tileInfo.getTileIndex() == ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountVertical * this.inputFormat.tileCountHorizontal - 1;
    }

    private Bitmap cropTileFromImageGrid(int tileIndex) {
        Assertions.checkStateNotNull((Object)this.outputBitmap);
        int tileWidth = this.outputBitmap.getWidth() / ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountHorizontal;
        int tileHeight = this.outputBitmap.getHeight() / ((Format)Assertions.checkStateNotNull((Object)this.inputFormat)).tileCountVertical;
        int tileStartXCoordinate = tileWidth * (tileIndex % this.inputFormat.tileCountVertical);
        int tileStartYCoordinate = tileHeight * (tileIndex / this.inputFormat.tileCountHorizontal);
        return Bitmap.createBitmap((Bitmap)this.outputBitmap, (int)tileStartXCoordinate, (int)tileStartYCoordinate, (int)tileWidth, (int)tileHeight);
    }

    private static ImageOutput getImageOutput(@Nullable ImageOutput imageOutput) {
        return imageOutput == null ? ImageOutput.NO_OP : imageOutput;
    }

    private static final class OutputStreamInfo {
        public static final OutputStreamInfo UNSET = new OutputStreamInfo(-9223372036854775807L, -9223372036854775807L);
        public final long previousStreamLastBufferTimeUs;
        public final long streamOffsetUs;

        public OutputStreamInfo(long previousStreamLastBufferTimeUs, long streamOffsetUs) {
            this.previousStreamLastBufferTimeUs = previousStreamLastBufferTimeUs;
            this.streamOffsetUs = streamOffsetUs;
        }
    }

    private static class TileInfo {
        private final int tileIndex;
        private final long presentationTimeUs;
        private @MonotonicNonNull Bitmap tileBitmap;

        public TileInfo(int tileIndex, long presentationTimeUs) {
            this.tileIndex = tileIndex;
            this.presentationTimeUs = presentationTimeUs;
        }

        public int getTileIndex() {
            return this.tileIndex;
        }

        public long getPresentationTimeUs() {
            return this.presentationTimeUs;
        }

        public @Nullable Bitmap getTileBitmap() {
            return this.tileBitmap;
        }

        public void setTileBitmap(Bitmap tileBitmap) {
            this.tileBitmap = tileBitmap;
        }

        public boolean hasTileBitmap() {
            return this.tileBitmap != null;
        }
    }
}

