/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.mediacodec;

import android.media.MediaCodec;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ConditionVariable;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.Util;
import androidx.media3.decoder.CryptoInfo;
import androidx.media3.exoplayer.mediacodec.MediaCodecBufferEnqueuer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=23)
class AsynchronousMediaCodecBufferEnqueuer
implements MediaCodecBufferEnqueuer {
    private static final int MSG_QUEUE_INPUT_BUFFER = 0;
    private static final int MSG_QUEUE_SECURE_INPUT_BUFFER = 1;
    private static final int MSG_OPEN_CV = 2;
    private static final int MSG_SET_PARAMETERS = 3;
    @GuardedBy(value="MESSAGE_PARAMS_INSTANCE_POOL")
    private static final ArrayDeque<MessageParams> MESSAGE_PARAMS_INSTANCE_POOL = new ArrayDeque();
    private static final Object QUEUE_SECURE_LOCK = new Object();
    private final MediaCodec codec;
    private final HandlerThread handlerThread;
    private @MonotonicNonNull Handler handler;
    private final AtomicReference<@NullableType RuntimeException> pendingRuntimeException;
    private final ConditionVariable conditionVariable;
    private boolean started;

    public AsynchronousMediaCodecBufferEnqueuer(MediaCodec codec, HandlerThread queueingThread) {
        this(codec, queueingThread, new ConditionVariable());
    }

    @VisibleForTesting
    AsynchronousMediaCodecBufferEnqueuer(MediaCodec codec, HandlerThread handlerThread, ConditionVariable conditionVariable) {
        this.codec = codec;
        this.handlerThread = handlerThread;
        this.conditionVariable = conditionVariable;
        this.pendingRuntimeException = new AtomicReference();
    }

    @Override
    public void start() {
        if (!this.started) {
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper()){

                public void handleMessage(Message msg) {
                    AsynchronousMediaCodecBufferEnqueuer.this.doHandleMessage(msg);
                }
            };
            this.started = true;
        }
    }

    @Override
    public void queueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flags) {
        this.maybeThrowException();
        MessageParams messageParams = AsynchronousMediaCodecBufferEnqueuer.getMessageParams();
        messageParams.setQueueParams(index, offset, size, presentationTimeUs, flags);
        Message message = ((Handler)Util.castNonNull((Object)this.handler)).obtainMessage(0, (Object)messageParams);
        message.sendToTarget();
    }

    @Override
    public void queueSecureInputBuffer(int index, int offset, CryptoInfo info, long presentationTimeUs, int flags) {
        this.maybeThrowException();
        MessageParams messageParams = AsynchronousMediaCodecBufferEnqueuer.getMessageParams();
        messageParams.setQueueParams(index, offset, 0, presentationTimeUs, flags);
        AsynchronousMediaCodecBufferEnqueuer.copy(info, messageParams.cryptoInfo);
        Message message = ((Handler)Util.castNonNull((Object)this.handler)).obtainMessage(1, (Object)messageParams);
        message.sendToTarget();
    }

    @Override
    public void setParameters(Bundle params) {
        this.maybeThrowException();
        ((Handler)Util.castNonNull((Object)this.handler)).obtainMessage(3, (Object)params).sendToTarget();
    }

    @Override
    public void flush() {
        if (this.started) {
            try {
                this.flushHandlerThread();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.started) {
            this.flush();
            this.handlerThread.quit();
        }
        this.started = false;
    }

    @Override
    public void waitUntilQueueingComplete() throws InterruptedException {
        this.blockUntilHandlerThreadIsIdle();
    }

    @Override
    public void maybeThrowException() {
        RuntimeException exception = this.pendingRuntimeException.getAndSet(null);
        if (exception != null) {
            throw exception;
        }
    }

    private void flushHandlerThread() throws InterruptedException {
        ((Handler)Assertions.checkNotNull((Object)this.handler)).removeCallbacksAndMessages(null);
        this.blockUntilHandlerThreadIsIdle();
    }

    private void blockUntilHandlerThreadIsIdle() throws InterruptedException {
        this.conditionVariable.close();
        ((Handler)Assertions.checkNotNull((Object)this.handler)).obtainMessage(2).sendToTarget();
        this.conditionVariable.block();
    }

    @VisibleForTesting(otherwise=5)
    void setPendingRuntimeException(RuntimeException exception) {
        this.pendingRuntimeException.set(exception);
    }

    private void doHandleMessage(Message msg) {
        MessageParams params = null;
        switch (msg.what) {
            case 0: {
                params = (MessageParams)msg.obj;
                this.doQueueInputBuffer(params.index, params.offset, params.size, params.presentationTimeUs, params.flags);
                break;
            }
            case 1: {
                params = (MessageParams)msg.obj;
                this.doQueueSecureInputBuffer(params.index, params.offset, params.cryptoInfo, params.presentationTimeUs, params.flags);
                break;
            }
            case 2: {
                this.conditionVariable.open();
                break;
            }
            case 3: {
                Bundle parameters = (Bundle)msg.obj;
                this.doSetParameters(parameters);
                break;
            }
            default: {
                this.pendingRuntimeException.compareAndSet(null, new IllegalStateException(String.valueOf(msg.what)));
            }
        }
        if (params != null) {
            AsynchronousMediaCodecBufferEnqueuer.recycleMessageParams(params);
        }
    }

    private void doQueueInputBuffer(int index, int offset, int size, long presentationTimeUs, int flag) {
        try {
            this.codec.queueInputBuffer(index, offset, size, presentationTimeUs, flag);
        }
        catch (RuntimeException e) {
            this.pendingRuntimeException.compareAndSet(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueueSecureInputBuffer(int index, int offset, MediaCodec.CryptoInfo info, long presentationTimeUs, int flags) {
        try {
            Object object = QUEUE_SECURE_LOCK;
            synchronized (object) {
                this.codec.queueSecureInputBuffer(index, offset, info, presentationTimeUs, flags);
            }
        }
        catch (RuntimeException e) {
            this.pendingRuntimeException.compareAndSet(null, e);
        }
    }

    private void doSetParameters(Bundle parameters) {
        try {
            this.codec.setParameters(parameters);
        }
        catch (RuntimeException e) {
            this.pendingRuntimeException.compareAndSet(null, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MessageParams getMessageParams() {
        ArrayDeque<MessageParams> arrayDeque = MESSAGE_PARAMS_INSTANCE_POOL;
        synchronized (arrayDeque) {
            if (MESSAGE_PARAMS_INSTANCE_POOL.isEmpty()) {
                return new MessageParams();
            }
            return MESSAGE_PARAMS_INSTANCE_POOL.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleMessageParams(MessageParams params) {
        ArrayDeque<MessageParams> arrayDeque = MESSAGE_PARAMS_INSTANCE_POOL;
        synchronized (arrayDeque) {
            MESSAGE_PARAMS_INSTANCE_POOL.add(params);
        }
    }

    private static void copy(CryptoInfo cryptoInfo, MediaCodec.CryptoInfo frameworkCryptoInfo) {
        frameworkCryptoInfo.numSubSamples = cryptoInfo.numSubSamples;
        frameworkCryptoInfo.numBytesOfClearData = AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.numBytesOfClearData, frameworkCryptoInfo.numBytesOfClearData);
        frameworkCryptoInfo.numBytesOfEncryptedData = AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.numBytesOfEncryptedData, frameworkCryptoInfo.numBytesOfEncryptedData);
        frameworkCryptoInfo.key = (byte[])Assertions.checkNotNull((Object)AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.key, frameworkCryptoInfo.key));
        frameworkCryptoInfo.iv = (byte[])Assertions.checkNotNull((Object)AsynchronousMediaCodecBufferEnqueuer.copy(cryptoInfo.iv, frameworkCryptoInfo.iv));
        frameworkCryptoInfo.mode = cryptoInfo.mode;
        if (Util.SDK_INT >= 24) {
            MediaCodec.CryptoInfo.Pattern pattern = new MediaCodec.CryptoInfo.Pattern(cryptoInfo.encryptedBlocks, cryptoInfo.clearBlocks);
            frameworkCryptoInfo.setPattern(pattern);
        }
    }

    @Nullable
    private static int[] copy(@Nullable int[] src, @Nullable int[] dst) {
        if (src == null) {
            return dst;
        }
        if (dst == null || dst.length < src.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    @Nullable
    private static byte[] copy(@Nullable byte[] src, @Nullable byte[] dst) {
        if (src == null) {
            return dst;
        }
        if (dst == null || dst.length < src.length) {
            return Arrays.copyOf(src, src.length);
        }
        System.arraycopy(src, 0, dst, 0, src.length);
        return dst;
    }

    private static class MessageParams {
        public int index;
        public int offset;
        public int size;
        public final MediaCodec.CryptoInfo cryptoInfo = new MediaCodec.CryptoInfo();
        public long presentationTimeUs;
        public int flags;

        MessageParams() {
        }

        public void setQueueParams(int index, int offset, int size, long presentationTimeUs, int flags) {
            this.index = index;
            this.offset = offset;
            this.size = size;
            this.presentationTimeUs = presentationTimeUs;
            this.flags = flags;
        }
    }
}

