/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.mediacodec;

import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Pair;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.Format;
import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.DecoderReuseEvaluation;
import androidx.media3.exoplayer.mediacodec.MediaCodecUtil;
import java.util.List;

@UnstableApi
public final class MediaCodecInfo {
    public static final String TAG = "MediaCodecInfo";
    public static final int MAX_SUPPORTED_INSTANCES_UNKNOWN = -1;
    public final String name;
    public final String mimeType;
    public final String codecMimeType;
    @Nullable
    public final MediaCodecInfo.CodecCapabilities capabilities;
    public final boolean adaptive;
    public final boolean tunneling;
    public final boolean secure;
    public final boolean hardwareAccelerated;
    public final boolean softwareOnly;
    public final boolean vendor;
    private final boolean isVideo;
    private static final int COVERAGE_RESULT_NO_PERFORMANCE_POINTS_UNSUPPORTED = 0;
    private static final int COVERAGE_RESULT_NO = 1;
    private static final int COVERAGE_RESULT_YES = 2;

    public static MediaCodecInfo newInstance(String name, String mimeType, String codecMimeType, @Nullable MediaCodecInfo.CodecCapabilities capabilities, boolean hardwareAccelerated, boolean softwareOnly, boolean vendor, boolean forceDisableAdaptive, boolean forceSecure) {
        return new MediaCodecInfo(name, mimeType, codecMimeType, capabilities, hardwareAccelerated, softwareOnly, vendor, !forceDisableAdaptive && capabilities != null && MediaCodecInfo.isAdaptive(capabilities) && !MediaCodecInfo.needsDisableAdaptationWorkaround(name), capabilities != null && MediaCodecInfo.isTunneling(capabilities), forceSecure || capabilities != null && MediaCodecInfo.isSecure(capabilities));
    }

    @VisibleForTesting
    MediaCodecInfo(String name, String mimeType, String codecMimeType, @Nullable MediaCodecInfo.CodecCapabilities capabilities, boolean hardwareAccelerated, boolean softwareOnly, boolean vendor, boolean adaptive, boolean tunneling, boolean secure) {
        this.name = (String)Assertions.checkNotNull((Object)name);
        this.mimeType = mimeType;
        this.codecMimeType = codecMimeType;
        this.capabilities = capabilities;
        this.hardwareAccelerated = hardwareAccelerated;
        this.softwareOnly = softwareOnly;
        this.vendor = vendor;
        this.adaptive = adaptive;
        this.tunneling = tunneling;
        this.secure = secure;
        this.isVideo = MimeTypes.isVideo((String)mimeType);
    }

    public String toString() {
        return this.name;
    }

    public MediaCodecInfo.CodecProfileLevel[] getProfileLevels() {
        return this.capabilities == null || this.capabilities.profileLevels == null ? new MediaCodecInfo.CodecProfileLevel[]{} : this.capabilities.profileLevels;
    }

    public int getMaxSupportedInstances() {
        if (Util.SDK_INT < 23 || this.capabilities == null) {
            return -1;
        }
        return MediaCodecInfo.getMaxSupportedInstancesV23(this.capabilities);
    }

    public boolean isFormatSupported(Format format) throws MediaCodecUtil.DecoderQueryException {
        if (!this.isSampleMimeTypeSupported(format)) {
            return false;
        }
        if (!this.isCodecProfileAndLevelSupported(format, true)) {
            return false;
        }
        if (this.isVideo) {
            boolean isFormatSupported;
            if (format.width <= 0 || format.height <= 0) {
                return true;
            }
            if (Util.SDK_INT >= 21) {
                return this.isVideoSizeAndRateSupportedV21(format.width, format.height, format.frameRate);
            }
            boolean bl = isFormatSupported = format.width * format.height <= MediaCodecUtil.maxH264DecodableFrameSize();
            if (!isFormatSupported) {
                this.logNoSupport("legacyFrameSize, " + format.width + "x" + format.height);
            }
            return isFormatSupported;
        }
        return Util.SDK_INT < 21 || (format.sampleRate == -1 || this.isAudioSampleRateSupportedV21(format.sampleRate)) && (format.channelCount == -1 || this.isAudioChannelCountSupportedV21(format.channelCount));
    }

    public boolean isFormatFunctionallySupported(Format format) {
        return this.isSampleMimeTypeSupported(format) && this.isCodecProfileAndLevelSupported(format, false);
    }

    private boolean isSampleMimeTypeSupported(Format format) {
        return this.mimeType.equals(format.sampleMimeType) || this.mimeType.equals(MediaCodecUtil.getAlternativeCodecMimeType(format));
    }

    private boolean isCodecProfileAndLevelSupported(Format format, boolean checkPerformanceCapabilities) {
        Pair<Integer, Integer> codecProfileAndLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
        if (codecProfileAndLevel == null) {
            return true;
        }
        int profile = (Integer)codecProfileAndLevel.first;
        int level = (Integer)codecProfileAndLevel.second;
        if ("video/dolby-vision".equals(format.sampleMimeType)) {
            if ("video/avc".equals(this.mimeType)) {
                profile = 8;
                level = 0;
            } else if ("video/hevc".equals(this.mimeType)) {
                profile = 2;
                level = 0;
            }
        }
        if (!this.isVideo && profile != 42) {
            return true;
        }
        MediaCodecInfo.CodecProfileLevel[] profileLevels = this.getProfileLevels();
        if (Util.SDK_INT <= 23 && "video/x-vnd.on2.vp9".equals(this.mimeType) && profileLevels.length == 0) {
            profileLevels = MediaCodecInfo.estimateLegacyVp9ProfileLevels(this.capabilities);
        }
        for (MediaCodecInfo.CodecProfileLevel profileLevel : profileLevels) {
            if (profileLevel.profile != profile || profileLevel.level < level && checkPerformanceCapabilities || MediaCodecInfo.needsProfileExcludedWorkaround(this.mimeType, profile)) continue;
            return true;
        }
        this.logNoSupport("codec.profileLevel, " + format.codecs + ", " + this.codecMimeType);
        return false;
    }

    public boolean isHdr10PlusOutOfBandMetadataSupported() {
        if (Util.SDK_INT >= 29 && "video/x-vnd.on2.vp9".equals(this.mimeType)) {
            for (MediaCodecInfo.CodecProfileLevel capabilities : this.getProfileLevels()) {
                if (capabilities.profile != 16384) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSeamlessAdaptationSupported(Format format) {
        if (this.isVideo) {
            return this.adaptive;
        }
        Pair<Integer, Integer> profileLevel = MediaCodecUtil.getCodecProfileAndLevel(format);
        return profileLevel != null && (Integer)profileLevel.first == 42;
    }

    @Deprecated
    public boolean isSeamlessAdaptationSupported(Format oldFormat, Format newFormat, boolean isNewFormatComplete) {
        int reuseResult;
        if (!isNewFormatComplete && oldFormat.colorInfo != null && newFormat.colorInfo == null) {
            newFormat = newFormat.buildUpon().setColorInfo(oldFormat.colorInfo).build();
        }
        return (reuseResult = this.canReuseCodec((Format)oldFormat, (Format)newFormat).result) == 2 || reuseResult == 3;
    }

    public DecoderReuseEvaluation canReuseCodec(Format oldFormat, Format newFormat) {
        int discardReasons = 0;
        if (!Util.areEqual((Object)oldFormat.sampleMimeType, (Object)newFormat.sampleMimeType)) {
            discardReasons |= 8;
        }
        if (this.isVideo) {
            if (oldFormat.rotationDegrees != newFormat.rotationDegrees) {
                discardReasons |= 0x400;
            }
            if (!(this.adaptive || oldFormat.width == newFormat.width && oldFormat.height == newFormat.height)) {
                discardReasons |= 0x200;
            }
            if (!Util.areEqual((Object)oldFormat.colorInfo, (Object)newFormat.colorInfo)) {
                discardReasons |= 0x800;
            }
            if (MediaCodecInfo.needsAdaptationReconfigureWorkaround(this.name) && !oldFormat.initializationDataEquals(newFormat)) {
                discardReasons |= 2;
            }
            if (discardReasons == 0) {
                return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, oldFormat.initializationDataEquals(newFormat) ? 3 : 2, 0);
            }
        } else {
            if (oldFormat.channelCount != newFormat.channelCount) {
                discardReasons |= 0x1000;
            }
            if (oldFormat.sampleRate != newFormat.sampleRate) {
                discardReasons |= 0x2000;
            }
            if (oldFormat.pcmEncoding != newFormat.pcmEncoding) {
                discardReasons |= 0x4000;
            }
            if (discardReasons == 0 && "audio/mp4a-latm".equals(this.mimeType)) {
                Pair<Integer, Integer> oldCodecProfileLevel = MediaCodecUtil.getCodecProfileAndLevel(oldFormat);
                Pair<Integer, Integer> newCodecProfileLevel = MediaCodecUtil.getCodecProfileAndLevel(newFormat);
                if (oldCodecProfileLevel != null && newCodecProfileLevel != null) {
                    int oldProfile = (Integer)oldCodecProfileLevel.first;
                    int newProfile = (Integer)newCodecProfileLevel.first;
                    if (oldProfile == 42 && newProfile == 42) {
                        return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 3, 0);
                    }
                }
            }
            if (!oldFormat.initializationDataEquals(newFormat)) {
                discardReasons |= 0x20;
            }
            if (MediaCodecInfo.needsAdaptationFlushWorkaround(this.mimeType)) {
                discardReasons |= 2;
            }
            if (discardReasons == 0) {
                return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 1, 0);
            }
        }
        return new DecoderReuseEvaluation(this.name, oldFormat, newFormat, 0, discardReasons);
    }

    @RequiresApi(value=21)
    public boolean isVideoSizeAndRateSupportedV21(int width, int height, double frameRate) {
        if (this.capabilities == null) {
            this.logNoSupport("sizeAndRate.caps");
            return false;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            this.logNoSupport("sizeAndRate.vCaps");
            return false;
        }
        if (Util.SDK_INT >= 29) {
            int evaluation = Api29.areResolutionAndFrameRateCovered(videoCapabilities, this.mimeType, width, height, frameRate);
            if (evaluation == 2) {
                return true;
            }
            if (evaluation == 1) {
                this.logNoSupport("sizeAndRate.cover, " + width + "x" + height + "@" + frameRate);
                return false;
            }
        }
        if (!MediaCodecInfo.areSizeAndRateSupportedV21(videoCapabilities, width, height, frameRate)) {
            if (width >= height || !MediaCodecInfo.needsRotatedVerticalResolutionWorkaround(this.name) || !MediaCodecInfo.areSizeAndRateSupportedV21(videoCapabilities, height, width, frameRate)) {
                this.logNoSupport("sizeAndRate.support, " + width + "x" + height + "@" + frameRate);
                return false;
            }
            this.logAssumedSupport("sizeAndRate.rotated, " + width + "x" + height + "@" + frameRate);
        }
        return true;
    }

    @Nullable
    @RequiresApi(value=21)
    public Point alignVideoSizeV21(int width, int height) {
        if (this.capabilities == null) {
            return null;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.capabilities.getVideoCapabilities();
        if (videoCapabilities == null) {
            return null;
        }
        return MediaCodecInfo.alignVideoSizeV21(videoCapabilities, width, height);
    }

    @RequiresApi(value=21)
    public boolean isAudioSampleRateSupportedV21(int sampleRate) {
        if (this.capabilities == null) {
            this.logNoSupport("sampleRate.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.logNoSupport("sampleRate.aCaps");
            return false;
        }
        if (!audioCapabilities.isSampleRateSupported(sampleRate)) {
            this.logNoSupport("sampleRate.support, " + sampleRate);
            return false;
        }
        return true;
    }

    @RequiresApi(value=21)
    public boolean isAudioChannelCountSupportedV21(int channelCount) {
        if (this.capabilities == null) {
            this.logNoSupport("channelCount.caps");
            return false;
        }
        MediaCodecInfo.AudioCapabilities audioCapabilities = this.capabilities.getAudioCapabilities();
        if (audioCapabilities == null) {
            this.logNoSupport("channelCount.aCaps");
            return false;
        }
        int maxInputChannelCount = MediaCodecInfo.adjustMaxInputChannelCount(this.name, this.mimeType, audioCapabilities.getMaxInputChannelCount());
        if (maxInputChannelCount < channelCount) {
            this.logNoSupport("channelCount.support, " + channelCount);
            return false;
        }
        return true;
    }

    private void logNoSupport(String message) {
        Log.d((String)TAG, (String)("NoSupport [" + message + "] [" + this.name + ", " + this.mimeType + "] [" + Util.DEVICE_DEBUG_INFO + "]"));
    }

    private void logAssumedSupport(String message) {
        Log.d((String)TAG, (String)("AssumedSupport [" + message + "] [" + this.name + ", " + this.mimeType + "] [" + Util.DEVICE_DEBUG_INFO + "]"));
    }

    private static int adjustMaxInputChannelCount(String name, String mimeType, int maxChannelCount) {
        if (maxChannelCount > 1 || Util.SDK_INT >= 26 && maxChannelCount > 0) {
            return maxChannelCount;
        }
        if ("audio/mpeg".equals(mimeType) || "audio/3gpp".equals(mimeType) || "audio/amr-wb".equals(mimeType) || "audio/mp4a-latm".equals(mimeType) || "audio/vorbis".equals(mimeType) || "audio/opus".equals(mimeType) || "audio/raw".equals(mimeType) || "audio/flac".equals(mimeType) || "audio/g711-alaw".equals(mimeType) || "audio/g711-mlaw".equals(mimeType) || "audio/gsm".equals(mimeType)) {
            return maxChannelCount;
        }
        int assumedMaxChannelCount = "audio/ac3".equals(mimeType) ? 6 : ("audio/eac3".equals(mimeType) ? 16 : 30);
        Log.w((String)TAG, (String)("AssumedMaxChannelAdjustment: " + name + ", [" + maxChannelCount + " to " + assumedMaxChannelCount + "]"));
        return assumedMaxChannelCount;
    }

    private static boolean isAdaptive(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 19 && MediaCodecInfo.isAdaptiveV19(capabilities);
    }

    @RequiresApi(value=19)
    private static boolean isAdaptiveV19(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("adaptive-playback");
    }

    private static boolean isTunneling(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 21 && MediaCodecInfo.isTunnelingV21(capabilities);
    }

    @RequiresApi(value=21)
    private static boolean isTunnelingV21(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("tunneled-playback");
    }

    private static boolean isSecure(MediaCodecInfo.CodecCapabilities capabilities) {
        return Util.SDK_INT >= 21 && MediaCodecInfo.isSecureV21(capabilities);
    }

    @RequiresApi(value=21)
    private static boolean isSecureV21(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.isFeatureSupported("secure-playback");
    }

    @RequiresApi(value=21)
    private static boolean areSizeAndRateSupportedV21(MediaCodecInfo.VideoCapabilities capabilities, int width, int height, double frameRate) {
        Point alignedSize = MediaCodecInfo.alignVideoSizeV21(capabilities, width, height);
        width = alignedSize.x;
        height = alignedSize.y;
        if (frameRate == -1.0 || frameRate < 1.0) {
            return capabilities.isSizeSupported(width, height);
        }
        double floorFrameRate = Math.floor(frameRate);
        return capabilities.areSizeAndRateSupported(width, height, floorFrameRate);
    }

    @RequiresApi(value=21)
    private static Point alignVideoSizeV21(MediaCodecInfo.VideoCapabilities capabilities, int width, int height) {
        int widthAlignment = capabilities.getWidthAlignment();
        int heightAlignment = capabilities.getHeightAlignment();
        return new Point(Util.ceilDivide((int)width, (int)widthAlignment) * widthAlignment, Util.ceilDivide((int)height, (int)heightAlignment) * heightAlignment);
    }

    @RequiresApi(value=23)
    private static int getMaxSupportedInstancesV23(MediaCodecInfo.CodecCapabilities capabilities) {
        return capabilities.getMaxSupportedInstances();
    }

    private static MediaCodecInfo.CodecProfileLevel[] estimateLegacyVp9ProfileLevels(@Nullable MediaCodecInfo.CodecCapabilities capabilities) {
        MediaCodecInfo.VideoCapabilities videoCapabilities;
        int maxBitrate = 0;
        if (capabilities != null && (videoCapabilities = capabilities.getVideoCapabilities()) != null) {
            maxBitrate = (Integer)videoCapabilities.getBitrateRange().getUpper();
        }
        int level = maxBitrate >= 180000000 ? 1024 : (maxBitrate >= 120000000 ? 512 : (maxBitrate >= 60000000 ? 256 : (maxBitrate >= 30000000 ? 128 : (maxBitrate >= 18000000 ? 64 : (maxBitrate >= 12000000 ? 32 : (maxBitrate >= 0x6DDD00 ? 16 : (maxBitrate >= 3600000 ? 8 : (maxBitrate >= 1800000 ? 4 : (maxBitrate >= 800000 ? 2 : 1)))))))));
        MediaCodecInfo.CodecProfileLevel profileLevel = new MediaCodecInfo.CodecProfileLevel();
        profileLevel.profile = 1;
        profileLevel.level = level;
        return new MediaCodecInfo.CodecProfileLevel[]{profileLevel};
    }

    private static boolean needsDisableAdaptationWorkaround(String name) {
        return !(Util.SDK_INT > 22 || !"ODROID-XU3".equals(Util.MODEL) && !"Nexus 10".equals(Util.MODEL) || !"OMX.Exynos.AVC.Decoder".equals(name) && !"OMX.Exynos.AVC.Decoder.secure".equals(name));
    }

    private static boolean needsAdaptationReconfigureWorkaround(String name) {
        return Util.MODEL.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(name);
    }

    private static boolean needsAdaptationFlushWorkaround(String mimeType) {
        return "audio/opus".equals(mimeType);
    }

    private static boolean needsRotatedVerticalResolutionWorkaround(String name) {
        return !"OMX.MTK.VIDEO.DECODER.HEVC".equals(name) || !"mcv5a".equals(Util.DEVICE);
    }

    private static boolean needsProfileExcludedWorkaround(String mimeType, int profile) {
        return "video/hevc".equals(mimeType) && 2 == profile && ("sailfish".equals(Util.DEVICE) || "marlin".equals(Util.DEVICE));
    }

    @RequiresApi(value=29)
    private static final class Api29 {
        private Api29() {
        }

        @DoNotInline
        public static int areResolutionAndFrameRateCovered(MediaCodecInfo.VideoCapabilities videoCapabilities, String mimeType, int width, int height, double frameRate) {
            List performancePointList = videoCapabilities.getSupportedPerformancePoints();
            if (performancePointList == null || performancePointList.isEmpty()) {
                return 0;
            }
            MediaCodecInfo.VideoCapabilities.PerformancePoint targetPerformancePoint = new MediaCodecInfo.VideoCapabilities.PerformancePoint(width, height, (int)frameRate);
            int performancePointCoverageResult = Api29.evaluatePerformancePointCoverage(performancePointList, targetPerformancePoint);
            if (performancePointCoverageResult == 1 && mimeType.equals("video/avc") && Api29.evaluatePerformancePointCoverage(performancePointList, new MediaCodecInfo.VideoCapabilities.PerformancePoint(1280, 720, 60)) != 2) {
                return 0;
            }
            return performancePointCoverageResult;
        }

        private static int evaluatePerformancePointCoverage(List<MediaCodecInfo.VideoCapabilities.PerformancePoint> performancePointList, MediaCodecInfo.VideoCapabilities.PerformancePoint targetPerformancePoint) {
            for (int i = 0; i < performancePointList.size(); ++i) {
                if (!performancePointList.get(i).covers(targetPerformancePoint)) continue;
                return 2;
            }
            return 1;
        }
    }
}

