/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.StreamKey;
import androidx.media3.common.Timeline;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.TrackSelectionOverride;
import androidx.media3.common.TrackSelectionParameters;
import androidx.media3.common.Tracks;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.Renderer;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.RenderersFactory;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.audio.AudioRendererEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.offline.DownloadRequest;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.source.chunk.MediaChunk;
import androidx.media3.exoplayer.source.chunk.MediaChunkIterator;
import androidx.media3.exoplayer.trackselection.BaseTrackSelection;
import androidx.media3.exoplayer.trackselection.DefaultTrackSelector;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.MappingTrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelectionUtil;
import androidx.media3.exoplayer.trackselection.TrackSelectorResult;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.DefaultAllocator;
import androidx.media3.exoplayer.video.VideoRendererEventListener;
import androidx.media3.extractor.ExtractorsFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@UnstableApi
public final class DownloadHelper {
    public static final DefaultTrackSelector.Parameters DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT = DefaultTrackSelector.Parameters.DEFAULT_WITHOUT_CONTEXT.buildUpon().setForceHighestSupportedBitrate(true).setConstrainAudioChannelCountToDeviceCapabilities(false).build();
    private final MediaItem.LocalConfiguration localConfiguration;
    @Nullable
    private final MediaSource mediaSource;
    private final DefaultTrackSelector trackSelector;
    private final RendererCapabilities[] rendererCapabilities;
    private final SparseIntArray scratchSet;
    private final Handler callbackHandler;
    private final Timeline.Window window;
    private boolean isPreparedWithMedia;
    private @MonotonicNonNull Callback callback;
    private @MonotonicNonNull MediaPreparer mediaPreparer;
    private TrackGroupArray @MonotonicNonNull [] trackGroupArrays;
    private MappingTrackSelector.MappedTrackInfo @MonotonicNonNull [] mappedTrackInfos;
    private List<ExoTrackSelection> @MonotonicNonNull [][] trackSelectionsByPeriodAndRenderer;
    private List<ExoTrackSelection> @MonotonicNonNull [][] immutableTrackSelectionsByPeriodAndRenderer;

    public static DefaultTrackSelector.Parameters getDefaultTrackSelectorParameters(Context context) {
        return DefaultTrackSelector.Parameters.getDefaults(context).buildUpon().setForceHighestSupportedBitrate(true).setConstrainAudioChannelCountToDeviceCapabilities(false).build();
    }

    public static RendererCapabilities[] getRendererCapabilities(RenderersFactory renderersFactory) {
        Renderer[] renderers = renderersFactory.createRenderers(Util.createHandlerForCurrentOrMainLooper(), new VideoRendererEventListener(){}, new AudioRendererEventListener(){}, cues -> {}, metadata -> {});
        RendererCapabilities[] capabilities = new RendererCapabilities[renderers.length];
        for (int i = 0; i < renderers.length; ++i) {
            capabilities[i] = renderers[i].getCapabilities();
        }
        return capabilities;
    }

    public static DownloadHelper forMediaItem(Context context, MediaItem mediaItem) {
        Assertions.checkArgument((boolean)DownloadHelper.isProgressive((MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration)));
        return DownloadHelper.forMediaItem(mediaItem, DownloadHelper.getDefaultTrackSelectorParameters(context), null, null, null);
    }

    public static DownloadHelper forMediaItem(Context context, MediaItem mediaItem, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory) {
        return DownloadHelper.forMediaItem(mediaItem, DownloadHelper.getDefaultTrackSelectorParameters(context), renderersFactory, dataSourceFactory, null);
    }

    public static DownloadHelper forMediaItem(MediaItem mediaItem, TrackSelectionParameters trackSelectionParameters, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory) {
        return DownloadHelper.forMediaItem(mediaItem, trackSelectionParameters, renderersFactory, dataSourceFactory, null);
    }

    public static DownloadHelper forMediaItem(MediaItem mediaItem, TrackSelectionParameters trackSelectionParameters, @Nullable RenderersFactory renderersFactory, @Nullable DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        boolean isProgressive = DownloadHelper.isProgressive((MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration));
        Assertions.checkArgument((isProgressive || dataSourceFactory != null ? 1 : 0) != 0);
        return new DownloadHelper(mediaItem, isProgressive ? null : DownloadHelper.createMediaSourceInternal(mediaItem, (DataSource.Factory)Util.castNonNull((Object)dataSourceFactory), drmSessionManager), trackSelectionParameters, renderersFactory != null ? DownloadHelper.getRendererCapabilities(renderersFactory) : new RendererCapabilities[]{});
    }

    public static MediaSource createMediaSource(DownloadRequest downloadRequest, DataSource.Factory dataSourceFactory) {
        return DownloadHelper.createMediaSource(downloadRequest, dataSourceFactory, null);
    }

    public static MediaSource createMediaSource(DownloadRequest downloadRequest, DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        return DownloadHelper.createMediaSourceInternal(downloadRequest.toMediaItem(), dataSourceFactory, drmSessionManager);
    }

    public DownloadHelper(MediaItem mediaItem, @Nullable MediaSource mediaSource, TrackSelectionParameters trackSelectionParameters, RendererCapabilities[] rendererCapabilities) {
        this.localConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        this.mediaSource = mediaSource;
        this.trackSelector = new DefaultTrackSelector(trackSelectionParameters, (ExoTrackSelection.Factory)new DownloadTrackSelection.Factory());
        this.rendererCapabilities = rendererCapabilities;
        this.scratchSet = new SparseIntArray();
        this.trackSelector.init(() -> {}, new FakeBandwidthMeter());
        this.callbackHandler = Util.createHandlerForCurrentOrMainLooper();
        this.window = new Timeline.Window();
    }

    public void prepare(Callback callback) {
        Assertions.checkState((this.callback == null ? 1 : 0) != 0);
        this.callback = callback;
        if (this.mediaSource != null) {
            this.mediaPreparer = new MediaPreparer(this.mediaSource, this);
        } else {
            this.callbackHandler.post(() -> callback.onPrepared(this));
        }
    }

    public void release() {
        if (this.mediaPreparer != null) {
            this.mediaPreparer.release();
        }
        this.trackSelector.release();
    }

    @Nullable
    public Object getManifest() {
        if (this.mediaSource == null) {
            return null;
        }
        this.assertPreparedWithMedia();
        return this.mediaPreparer.timeline.getWindowCount() > 0 ? this.mediaPreparer.timeline.getWindow((int)0, (Timeline.Window)this.window).manifest : null;
    }

    public int getPeriodCount() {
        if (this.mediaSource == null) {
            return 0;
        }
        this.assertPreparedWithMedia();
        return this.trackGroupArrays.length;
    }

    public Tracks getTracks(int periodIndex) {
        this.assertPreparedWithMedia();
        return TrackSelectionUtil.buildTracks(this.mappedTrackInfos[periodIndex], this.immutableTrackSelectionsByPeriodAndRenderer[periodIndex]);
    }

    public TrackGroupArray getTrackGroups(int periodIndex) {
        this.assertPreparedWithMedia();
        return this.trackGroupArrays[periodIndex];
    }

    public MappingTrackSelector.MappedTrackInfo getMappedTrackInfo(int periodIndex) {
        this.assertPreparedWithMedia();
        return this.mappedTrackInfos[periodIndex];
    }

    public List<ExoTrackSelection> getTrackSelections(int periodIndex, int rendererIndex) {
        this.assertPreparedWithMedia();
        return this.immutableTrackSelectionsByPeriodAndRenderer[periodIndex][rendererIndex];
    }

    public void clearTrackSelections(int periodIndex) {
        this.assertPreparedWithMedia();
        for (int i = 0; i < this.rendererCapabilities.length; ++i) {
            this.trackSelectionsByPeriodAndRenderer[periodIndex][i].clear();
        }
    }

    public void replaceTrackSelections(int periodIndex, TrackSelectionParameters trackSelectionParameters) {
        try {
            this.assertPreparedWithMedia();
            this.clearTrackSelections(periodIndex);
            this.addTrackSelectionInternal(periodIndex, trackSelectionParameters);
        }
        catch (ExoPlaybackException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public void addTrackSelection(int periodIndex, TrackSelectionParameters trackSelectionParameters) {
        try {
            this.assertPreparedWithMedia();
            this.addTrackSelectionInternal(periodIndex, trackSelectionParameters);
        }
        catch (ExoPlaybackException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public void addAudioLanguagesToSelection(String ... languages) {
        try {
            this.assertPreparedWithMedia();
            DefaultTrackSelector.Parameters.Builder parametersBuilder = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT.buildUpon();
            parametersBuilder.setForceHighestSupportedBitrate(true);
            for (RendererCapabilities capabilities : this.rendererCapabilities) {
                int trackType;
                parametersBuilder.setTrackTypeDisabled(trackType, (trackType = capabilities.getTrackType()) != 1);
            }
            int periodCount = this.getPeriodCount();
            for (String language : languages) {
                TrackSelectionParameters parameters = parametersBuilder.setPreferredAudioLanguage(language).build();
                for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                    this.addTrackSelectionInternal(periodIndex, parameters);
                }
            }
        }
        catch (ExoPlaybackException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public void addTextLanguagesToSelection(boolean selectUndeterminedTextLanguage, String ... languages) {
        try {
            this.assertPreparedWithMedia();
            DefaultTrackSelector.Parameters.Builder parametersBuilder = DEFAULT_TRACK_SELECTOR_PARAMETERS_WITHOUT_CONTEXT.buildUpon();
            parametersBuilder.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
            parametersBuilder.setForceHighestSupportedBitrate(true);
            for (RendererCapabilities capabilities : this.rendererCapabilities) {
                int trackType;
                parametersBuilder.setTrackTypeDisabled(trackType, (trackType = capabilities.getTrackType()) != 3);
            }
            int periodCount = this.getPeriodCount();
            for (String language : languages) {
                TrackSelectionParameters parameters = parametersBuilder.setPreferredTextLanguage(language).build();
                for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
                    this.addTrackSelectionInternal(periodIndex, parameters);
                }
            }
        }
        catch (ExoPlaybackException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public void addTrackSelectionForSingleRenderer(int periodIndex, int rendererIndex, DefaultTrackSelector.Parameters trackSelectorParameters, List<DefaultTrackSelector.SelectionOverride> overrides) {
        try {
            this.assertPreparedWithMedia();
            DefaultTrackSelector.Parameters.Builder builder = trackSelectorParameters.buildUpon();
            for (int i = 0; i < this.mappedTrackInfos[periodIndex].getRendererCount(); ++i) {
                builder.setRendererDisabled(i, i != rendererIndex);
            }
            if (overrides.isEmpty()) {
                this.addTrackSelectionInternal(periodIndex, builder.build());
            } else {
                TrackGroupArray trackGroupArray = this.mappedTrackInfos[periodIndex].getTrackGroups(rendererIndex);
                for (int i = 0; i < overrides.size(); ++i) {
                    builder.setSelectionOverride(rendererIndex, trackGroupArray, overrides.get(i));
                    this.addTrackSelectionInternal(periodIndex, builder.build());
                }
            }
        }
        catch (ExoPlaybackException e) {
            throw new IllegalStateException((Throwable)((Object)e));
        }
    }

    public DownloadRequest getDownloadRequest(@Nullable byte[] data) {
        return this.getDownloadRequest(this.localConfiguration.uri.toString(), data);
    }

    public DownloadRequest getDownloadRequest(String id, @Nullable byte[] data) {
        DownloadRequest.Builder requestBuilder = new DownloadRequest.Builder(id, this.localConfiguration.uri).setMimeType(this.localConfiguration.mimeType).setKeySetId(this.localConfiguration.drmConfiguration != null ? this.localConfiguration.drmConfiguration.getKeySetId() : null).setCustomCacheKey(this.localConfiguration.customCacheKey).setData(data);
        if (this.mediaSource == null) {
            return requestBuilder.build();
        }
        this.assertPreparedWithMedia();
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        ArrayList<ExoTrackSelection> allSelections = new ArrayList<ExoTrackSelection>();
        int periodCount = this.trackSelectionsByPeriodAndRenderer.length;
        for (int periodIndex = 0; periodIndex < periodCount; ++periodIndex) {
            allSelections.clear();
            int rendererCount = this.trackSelectionsByPeriodAndRenderer[periodIndex].length;
            for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
                allSelections.addAll(this.trackSelectionsByPeriodAndRenderer[periodIndex][rendererIndex]);
            }
            streamKeys.addAll(this.mediaPreparer.mediaPeriods[periodIndex].getStreamKeys(allSelections));
        }
        return requestBuilder.setStreamKeys(streamKeys).build();
    }

    @RequiresNonNull(value={"trackGroupArrays", "trackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline"})
    private void addTrackSelectionInternal(int periodIndex, TrackSelectionParameters trackSelectionParameters) throws ExoPlaybackException {
        this.trackSelector.setParameters(trackSelectionParameters);
        this.runTrackSelection(periodIndex);
        for (TrackSelectionOverride override : trackSelectionParameters.overrides.values()) {
            this.trackSelector.setParameters(trackSelectionParameters.buildUpon().setOverrideForType(override).build());
            this.runTrackSelection(periodIndex);
        }
    }

    private void onMediaPrepared() throws ExoPlaybackException {
        int i;
        Assertions.checkNotNull((Object)this.mediaPreparer);
        Assertions.checkNotNull((Object)this.mediaPreparer.mediaPeriods);
        Assertions.checkNotNull((Object)this.mediaPreparer.timeline);
        int periodCount = this.mediaPreparer.mediaPeriods.length;
        int rendererCount = this.rendererCapabilities.length;
        this.trackSelectionsByPeriodAndRenderer = new List[periodCount][rendererCount];
        this.immutableTrackSelectionsByPeriodAndRenderer = new List[periodCount][rendererCount];
        for (i = 0; i < periodCount; ++i) {
            for (int j = 0; j < rendererCount; ++j) {
                this.trackSelectionsByPeriodAndRenderer[i][j] = new ArrayList<ExoTrackSelection>();
                this.immutableTrackSelectionsByPeriodAndRenderer[i][j] = Collections.unmodifiableList(this.trackSelectionsByPeriodAndRenderer[i][j]);
            }
        }
        this.trackGroupArrays = new TrackGroupArray[periodCount];
        this.mappedTrackInfos = new MappingTrackSelector.MappedTrackInfo[periodCount];
        for (i = 0; i < periodCount; ++i) {
            this.trackGroupArrays[i] = this.mediaPreparer.mediaPeriods[i].getTrackGroups();
            TrackSelectorResult trackSelectorResult = this.runTrackSelection(i);
            this.trackSelector.onSelectionActivated(trackSelectorResult.info);
            this.mappedTrackInfos[i] = (MappingTrackSelector.MappedTrackInfo)Assertions.checkNotNull((Object)this.trackSelector.getCurrentMappedTrackInfo());
        }
        this.setPreparedWithMedia();
        ((Handler)Assertions.checkNotNull((Object)this.callbackHandler)).post(() -> ((Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this));
    }

    private void onMediaPreparationFailed(IOException error) {
        ((Handler)Assertions.checkNotNull((Object)this.callbackHandler)).post(() -> ((Callback)Assertions.checkNotNull((Object)this.callback)).onPrepareError(this, error));
    }

    @RequiresNonNull(value={"trackGroupArrays", "mappedTrackInfos", "trackSelectionsByPeriodAndRenderer", "immutableTrackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline", "mediaPreparer.mediaPeriods"})
    private void setPreparedWithMedia() {
        this.isPreparedWithMedia = true;
    }

    @EnsuresNonNull(value={"trackGroupArrays", "mappedTrackInfos", "trackSelectionsByPeriodAndRenderer", "immutableTrackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline", "mediaPreparer.mediaPeriods"})
    private void assertPreparedWithMedia() {
        Assertions.checkState((boolean)this.isPreparedWithMedia);
    }

    @RequiresNonNull(value={"trackGroupArrays", "trackSelectionsByPeriodAndRenderer", "mediaPreparer", "mediaPreparer.timeline"})
    private TrackSelectorResult runTrackSelection(int periodIndex) throws ExoPlaybackException {
        TrackSelectorResult trackSelectorResult = this.trackSelector.selectTracks(this.rendererCapabilities, this.trackGroupArrays[periodIndex], new MediaSource.MediaPeriodId(this.mediaPreparer.timeline.getUidOfPeriod(periodIndex)), this.mediaPreparer.timeline);
        for (int i = 0; i < trackSelectorResult.length; ++i) {
            ExoTrackSelection newSelection = trackSelectorResult.selections[i];
            if (newSelection == null) continue;
            List<ExoTrackSelection> existingSelectionList = this.trackSelectionsByPeriodAndRenderer[periodIndex][i];
            boolean mergedWithExistingSelection = false;
            for (int j = 0; j < existingSelectionList.size(); ++j) {
                int k;
                ExoTrackSelection existingSelection = existingSelectionList.get(j);
                if (!existingSelection.getTrackGroup().equals((Object)newSelection.getTrackGroup())) continue;
                this.scratchSet.clear();
                for (k = 0; k < existingSelection.length(); ++k) {
                    this.scratchSet.put(existingSelection.getIndexInTrackGroup(k), 0);
                }
                for (k = 0; k < newSelection.length(); ++k) {
                    this.scratchSet.put(newSelection.getIndexInTrackGroup(k), 0);
                }
                int[] mergedTracks = new int[this.scratchSet.size()];
                for (int k2 = 0; k2 < this.scratchSet.size(); ++k2) {
                    mergedTracks[k2] = this.scratchSet.keyAt(k2);
                }
                existingSelectionList.set(j, new DownloadTrackSelection(existingSelection.getTrackGroup(), mergedTracks));
                mergedWithExistingSelection = true;
                break;
            }
            if (mergedWithExistingSelection) continue;
            existingSelectionList.add(newSelection);
        }
        return trackSelectorResult;
    }

    private static MediaSource createMediaSourceInternal(MediaItem mediaItem, DataSource.Factory dataSourceFactory, @Nullable DrmSessionManager drmSessionManager) {
        DefaultMediaSourceFactory mediaSourceFactory = new DefaultMediaSourceFactory(dataSourceFactory, ExtractorsFactory.EMPTY);
        if (drmSessionManager != null) {
            mediaSourceFactory.setDrmSessionManagerProvider(unusedMediaItem -> drmSessionManager);
        }
        return mediaSourceFactory.createMediaSource(mediaItem);
    }

    private static boolean isProgressive(MediaItem.LocalConfiguration localConfiguration) {
        return Util.inferContentTypeForUriAndMimeType((Uri)localConfiguration.uri, (String)localConfiguration.mimeType) == 4;
    }

    private static final class DownloadTrackSelection
    extends BaseTrackSelection {
        public DownloadTrackSelection(TrackGroup trackGroup, int[] tracks) {
            super(trackGroup, tracks);
        }

        @Override
        public int getSelectedIndex() {
            return 0;
        }

        @Override
        public int getSelectionReason() {
            return 0;
        }

        @Override
        @Nullable
        public Object getSelectionData() {
            return null;
        }

        @Override
        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        }

        private static final class Factory
        implements ExoTrackSelection.Factory {
            private Factory() {
            }

            @Override
            public @NullableType ExoTrackSelection[] createTrackSelections(@NullableType ExoTrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) {
                @NullableType ExoTrackSelection[] selections = new ExoTrackSelection[definitions.length];
                for (int i = 0; i < definitions.length; ++i) {
                    selections[i] = definitions[i] == null ? null : new DownloadTrackSelection(definitions[i].group, definitions[i].tracks);
                }
                return selections;
            }
        }
    }

    private static final class FakeBandwidthMeter
    implements BandwidthMeter {
        private FakeBandwidthMeter() {
        }

        @Override
        public long getBitrateEstimate() {
            return 0L;
        }

        @Override
        @Nullable
        public TransferListener getTransferListener() {
            return null;
        }

        @Override
        public void addEventListener(Handler eventHandler, BandwidthMeter.EventListener eventListener) {
        }

        @Override
        public void removeEventListener(BandwidthMeter.EventListener eventListener) {
        }
    }

    public static interface Callback {
        public void onPrepared(DownloadHelper var1);

        public void onPrepareError(DownloadHelper var1, IOException var2);
    }

    private static final class MediaPreparer
    implements MediaSource.MediaSourceCaller,
    MediaPeriod.Callback,
    Handler.Callback {
        private static final int MESSAGE_PREPARE_SOURCE = 0;
        private static final int MESSAGE_CHECK_FOR_FAILURE = 1;
        private static final int MESSAGE_CONTINUE_LOADING = 2;
        private static final int MESSAGE_RELEASE = 3;
        private static final int DOWNLOAD_HELPER_CALLBACK_MESSAGE_PREPARED = 0;
        private static final int DOWNLOAD_HELPER_CALLBACK_MESSAGE_FAILED = 1;
        private final MediaSource mediaSource;
        private final DownloadHelper downloadHelper;
        private final Allocator allocator;
        private final ArrayList<MediaPeriod> pendingMediaPeriods;
        private final Handler downloadHelperHandler;
        private final HandlerThread mediaSourceThread;
        private final Handler mediaSourceHandler;
        public @MonotonicNonNull Timeline timeline;
        public MediaPeriod @MonotonicNonNull [] mediaPeriods;
        private boolean released;

        public MediaPreparer(MediaSource mediaSource, DownloadHelper downloadHelper) {
            Handler downloadThreadHandler;
            this.mediaSource = mediaSource;
            this.downloadHelper = downloadHelper;
            this.allocator = new DefaultAllocator(true, 65536);
            this.pendingMediaPeriods = new ArrayList();
            this.downloadHelperHandler = downloadThreadHandler = Util.createHandlerForCurrentOrMainLooper(this::handleDownloadHelperCallbackMessage);
            this.mediaSourceThread = new HandlerThread("ExoPlayer:DownloadHelper");
            this.mediaSourceThread.start();
            this.mediaSourceHandler = Util.createHandler((Looper)this.mediaSourceThread.getLooper(), (Handler.Callback)this);
            this.mediaSourceHandler.sendEmptyMessage(0);
        }

        public void release() {
            if (this.released) {
                return;
            }
            this.released = true;
            this.mediaSourceHandler.sendEmptyMessage(3);
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.mediaSource.prepareSource(this, null, PlayerId.UNSET);
                    this.mediaSourceHandler.sendEmptyMessage(1);
                    return true;
                }
                case 1: {
                    try {
                        if (this.mediaPeriods == null) {
                            this.mediaSource.maybeThrowSourceInfoRefreshError();
                        } else {
                            for (int i = 0; i < this.pendingMediaPeriods.size(); ++i) {
                                this.pendingMediaPeriods.get(i).maybeThrowPrepareError();
                            }
                        }
                        this.mediaSourceHandler.sendEmptyMessageDelayed(1, 100L);
                    }
                    catch (IOException e) {
                        this.downloadHelperHandler.obtainMessage(1, (Object)e).sendToTarget();
                    }
                    return true;
                }
                case 2: {
                    MediaPeriod mediaPeriod = (MediaPeriod)msg.obj;
                    if (this.pendingMediaPeriods.contains(mediaPeriod)) {
                        mediaPeriod.continueLoading(new LoadingInfo.Builder().setPlaybackPositionUs(0L).build());
                    }
                    return true;
                }
                case 3: {
                    if (this.mediaPeriods != null) {
                        for (MediaPeriod period : this.mediaPeriods) {
                            this.mediaSource.releasePeriod(period);
                        }
                    }
                    this.mediaSource.releaseSource(this);
                    this.mediaSourceHandler.removeCallbacksAndMessages(null);
                    this.mediaSourceThread.quit();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onSourceInfoRefreshed(MediaSource source, Timeline timeline) {
            if (this.timeline != null) {
                return;
            }
            if (timeline.getWindow(0, new Timeline.Window()).isLive()) {
                this.downloadHelperHandler.obtainMessage(1, (Object)new LiveContentUnsupportedException()).sendToTarget();
                return;
            }
            this.timeline = timeline;
            this.mediaPeriods = new MediaPeriod[timeline.getPeriodCount()];
            for (int i = 0; i < this.mediaPeriods.length; ++i) {
                MediaPeriod mediaPeriod;
                this.mediaPeriods[i] = mediaPeriod = this.mediaSource.createPeriod(new MediaSource.MediaPeriodId(timeline.getUidOfPeriod(i)), this.allocator, 0L);
                this.pendingMediaPeriods.add(mediaPeriod);
            }
            for (MediaPeriod mediaPeriod : this.mediaPeriods) {
                mediaPeriod.prepare(this, 0L);
            }
        }

        @Override
        public void onPrepared(MediaPeriod mediaPeriod) {
            this.pendingMediaPeriods.remove(mediaPeriod);
            if (this.pendingMediaPeriods.isEmpty()) {
                this.mediaSourceHandler.removeMessages(1);
                this.downloadHelperHandler.sendEmptyMessage(0);
            }
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
            if (this.pendingMediaPeriods.contains(mediaPeriod)) {
                this.mediaSourceHandler.obtainMessage(2, (Object)mediaPeriod).sendToTarget();
            }
        }

        private boolean handleDownloadHelperCallbackMessage(Message msg) {
            if (this.released) {
                return false;
            }
            switch (msg.what) {
                case 0: {
                    try {
                        this.downloadHelper.onMediaPrepared();
                    }
                    catch (ExoPlaybackException e) {
                        this.downloadHelperHandler.obtainMessage(1, (Object)new IOException((Throwable)((Object)e))).sendToTarget();
                    }
                    return true;
                }
                case 1: {
                    this.release();
                    this.downloadHelper.onMediaPreparationFailed((IOException)Util.castNonNull((Object)msg.obj));
                    return true;
                }
            }
            return false;
        }
    }

    public static class LiveContentUnsupportedException
    extends IOException {
    }
}

