/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.scheduler;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.scheduler.Requirements;

@UnstableApi
public final class RequirementsWatcher {
    private final Context context;
    private final Listener listener;
    private final Requirements requirements;
    private final Handler handler;
    @Nullable
    private DeviceStatusChangeReceiver receiver;
    private int notMetRequirements;
    @Nullable
    private NetworkCallback networkCallback;

    public RequirementsWatcher(Context context, Listener listener, Requirements requirements) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.requirements = requirements;
        this.handler = Util.createHandlerForCurrentOrMainLooper();
    }

    public int start() {
        this.notMetRequirements = this.requirements.getNotMetRequirements(this.context);
        IntentFilter filter = new IntentFilter();
        if (this.requirements.isNetworkRequired()) {
            if (Util.SDK_INT >= 24) {
                this.registerNetworkCallbackV24();
            } else {
                filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            }
        }
        if (this.requirements.isChargingRequired()) {
            filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
            filter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        }
        if (this.requirements.isIdleRequired()) {
            if (Util.SDK_INT >= 23) {
                filter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            } else {
                filter.addAction("android.intent.action.SCREEN_ON");
                filter.addAction("android.intent.action.SCREEN_OFF");
            }
        }
        if (this.requirements.isStorageNotLowRequired()) {
            filter.addAction("android.intent.action.DEVICE_STORAGE_LOW");
            filter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        }
        this.receiver = new DeviceStatusChangeReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.receiver, filter, null, this.handler);
        return this.notMetRequirements;
    }

    public void stop() {
        this.context.unregisterReceiver((BroadcastReceiver)Assertions.checkNotNull((Object)((Object)this.receiver)));
        this.receiver = null;
        if (Util.SDK_INT >= 24 && this.networkCallback != null) {
            this.unregisterNetworkCallbackV24();
        }
    }

    public Requirements getRequirements() {
        return this.requirements;
    }

    @RequiresApi(value=24)
    private void registerNetworkCallbackV24() {
        ConnectivityManager connectivityManager = (ConnectivityManager)Assertions.checkNotNull((Object)((ConnectivityManager)this.context.getSystemService("connectivity")));
        this.networkCallback = new NetworkCallback();
        connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    @RequiresApi(value=24)
    private void unregisterNetworkCallbackV24() {
        ConnectivityManager connectivityManager = (ConnectivityManager)Assertions.checkNotNull((Object)((ConnectivityManager)this.context.getSystemService("connectivity")));
        connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)Assertions.checkNotNull((Object)((Object)this.networkCallback)));
        this.networkCallback = null;
    }

    private void checkRequirements() {
        int notMetRequirements = this.requirements.getNotMetRequirements(this.context);
        if (this.notMetRequirements != notMetRequirements) {
            this.notMetRequirements = notMetRequirements;
            this.listener.onRequirementsStateChanged(this, notMetRequirements);
        }
    }

    private void recheckNotMetNetworkRequirements() {
        if ((this.notMetRequirements & 3) == 0) {
            return;
        }
        this.checkRequirements();
    }

    @RequiresApi(value=24)
    private final class NetworkCallback
    extends ConnectivityManager.NetworkCallback {
        private boolean receivedCapabilitiesChange;
        private boolean networkValidated;

        private NetworkCallback() {
        }

        public void onAvailable(Network network) {
            this.postCheckRequirements();
        }

        public void onLost(Network network) {
            this.postCheckRequirements();
        }

        public void onBlockedStatusChanged(Network network, boolean blocked) {
            if (!blocked) {
                this.postRecheckNotMetNetworkRequirements();
            }
        }

        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            boolean networkValidated = networkCapabilities.hasCapability(16);
            if (!this.receivedCapabilitiesChange || this.networkValidated != networkValidated) {
                this.receivedCapabilitiesChange = true;
                this.networkValidated = networkValidated;
                this.postCheckRequirements();
            } else if (networkValidated) {
                this.postRecheckNotMetNetworkRequirements();
            }
        }

        private void postCheckRequirements() {
            RequirementsWatcher.this.handler.post(() -> {
                if (RequirementsWatcher.this.networkCallback != null) {
                    RequirementsWatcher.this.checkRequirements();
                }
            });
        }

        private void postRecheckNotMetNetworkRequirements() {
            RequirementsWatcher.this.handler.post(() -> {
                if (RequirementsWatcher.this.networkCallback != null) {
                    RequirementsWatcher.this.recheckNotMetNetworkRequirements();
                }
            });
        }
    }

    public static interface Listener {
        public void onRequirementsStateChanged(RequirementsWatcher var1, int var2);
    }

    private class DeviceStatusChangeReceiver
    extends BroadcastReceiver {
        private DeviceStatusChangeReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!this.isInitialStickyBroadcast()) {
                RequirementsWatcher.this.checkRequirements();
            }
        }
    }
}

