/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.source.ClippingMediaPeriod;
import androidx.media3.exoplayer.source.ForwardingTimeline;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.WrappingMediaSource;
import androidx.media3.exoplayer.upstream.Allocator;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;

@UnstableApi
public final class ClippingMediaSource
extends WrappingMediaSource {
    private final long startUs;
    private final long endUs;
    private final boolean enableInitialDiscontinuity;
    private final boolean allowDynamicClippingUpdates;
    private final boolean relativeToDefaultPosition;
    private final ArrayList<ClippingMediaPeriod> mediaPeriods;
    private final Timeline.Window window;
    @Nullable
    private ClippingTimeline clippingTimeline;
    @Nullable
    private IllegalClippingException clippingError;
    private long periodStartUs;
    private long periodEndUs;

    public ClippingMediaSource(MediaSource mediaSource, long startPositionUs, long endPositionUs) {
        this(mediaSource, startPositionUs, endPositionUs, true, false, false);
    }

    public ClippingMediaSource(MediaSource mediaSource, long durationUs) {
        this(mediaSource, 0L, durationUs, true, false, true);
    }

    public ClippingMediaSource(MediaSource mediaSource, long startPositionUs, long endPositionUs, boolean enableInitialDiscontinuity, boolean allowDynamicClippingUpdates, boolean relativeToDefaultPosition) {
        super((MediaSource)Assertions.checkNotNull((Object)mediaSource));
        Assertions.checkArgument((startPositionUs >= 0L ? 1 : 0) != 0);
        this.startUs = startPositionUs;
        this.endUs = endPositionUs;
        this.enableInitialDiscontinuity = enableInitialDiscontinuity;
        this.allowDynamicClippingUpdates = allowDynamicClippingUpdates;
        this.relativeToDefaultPosition = relativeToDefaultPosition;
        this.mediaPeriods = new ArrayList();
        this.window = new Timeline.Window();
    }

    @Override
    public boolean canUpdateMediaItem(MediaItem mediaItem) {
        return this.getMediaItem().clippingConfiguration.equals((Object)mediaItem.clippingConfiguration) && this.mediaSource.canUpdateMediaItem(mediaItem);
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.clippingError != null) {
            throw this.clippingError;
        }
        super.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        ClippingMediaPeriod mediaPeriod = new ClippingMediaPeriod(this.mediaSource.createPeriod(id, allocator, startPositionUs), this.enableInitialDiscontinuity, this.periodStartUs, this.periodEndUs);
        this.mediaPeriods.add(mediaPeriod);
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        Assertions.checkState((boolean)this.mediaPeriods.remove(mediaPeriod));
        this.mediaSource.releasePeriod(((ClippingMediaPeriod)mediaPeriod).mediaPeriod);
        if (this.mediaPeriods.isEmpty() && !this.allowDynamicClippingUpdates) {
            this.refreshClippedTimeline(((ClippingTimeline)((Object)Assertions.checkNotNull((Object)((Object)this.clippingTimeline)))).timeline);
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        this.clippingError = null;
        this.clippingTimeline = null;
    }

    @Override
    protected void onChildSourceInfoRefreshed(Timeline newTimeline) {
        if (this.clippingError != null) {
            return;
        }
        this.refreshClippedTimeline(newTimeline);
    }

    private void refreshClippedTimeline(Timeline timeline) {
        int i;
        long windowEndUs;
        long windowStartUs;
        timeline.getWindow(0, this.window);
        long windowPositionInPeriodUs = this.window.getPositionInFirstPeriodUs();
        if (this.clippingTimeline == null || this.mediaPeriods.isEmpty() || this.allowDynamicClippingUpdates) {
            windowStartUs = this.startUs;
            windowEndUs = this.endUs;
            if (this.relativeToDefaultPosition) {
                long windowDefaultPositionUs = this.window.getDefaultPositionUs();
                windowStartUs += windowDefaultPositionUs;
                windowEndUs += windowDefaultPositionUs;
            }
            this.periodStartUs = windowPositionInPeriodUs + windowStartUs;
            this.periodEndUs = this.endUs == Long.MIN_VALUE ? Long.MIN_VALUE : windowPositionInPeriodUs + windowEndUs;
            int count = this.mediaPeriods.size();
            for (i = 0; i < count; ++i) {
                this.mediaPeriods.get(i).updateClipping(this.periodStartUs, this.periodEndUs);
            }
        } else {
            windowStartUs = this.periodStartUs - windowPositionInPeriodUs;
            windowEndUs = this.endUs == Long.MIN_VALUE ? Long.MIN_VALUE : this.periodEndUs - windowPositionInPeriodUs;
        }
        try {
            this.clippingTimeline = new ClippingTimeline(timeline, windowStartUs, windowEndUs);
        }
        catch (IllegalClippingException e) {
            this.clippingError = e;
            for (i = 0; i < this.mediaPeriods.size(); ++i) {
                this.mediaPeriods.get(i).setClippingError(this.clippingError);
            }
            return;
        }
        this.refreshSourceInfo(this.clippingTimeline);
    }

    public static final class IllegalClippingException
    extends IOException {
        public static final int REASON_INVALID_PERIOD_COUNT = 0;
        public static final int REASON_NOT_SEEKABLE_TO_START = 1;
        public static final int REASON_START_EXCEEDS_END = 2;
        public final int reason;

        public IllegalClippingException(int reason) {
            super("Illegal clipping: " + IllegalClippingException.getReasonDescription(reason));
            this.reason = reason;
        }

        private static String getReasonDescription(int reason) {
            switch (reason) {
                case 0: {
                    return "invalid period count";
                }
                case 1: {
                    return "not seekable to start";
                }
                case 2: {
                    return "start exceeds end";
                }
            }
            return "unknown";
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface Reason {
        }
    }

    private static final class ClippingTimeline
    extends ForwardingTimeline {
        private final long startUs;
        private final long endUs;
        private final long durationUs;
        private final boolean isDynamic;

        public ClippingTimeline(Timeline timeline, long startUs, long endUs) throws IllegalClippingException {
            super(timeline);
            long resolvedEndUs;
            if (timeline.getPeriodCount() != 1) {
                throw new IllegalClippingException(0);
            }
            Timeline.Window window = timeline.getWindow(0, new Timeline.Window());
            startUs = Math.max(0L, startUs);
            if (!window.isPlaceholder && startUs != 0L && !window.isSeekable) {
                throw new IllegalClippingException(1);
            }
            long l = resolvedEndUs = endUs == Long.MIN_VALUE ? window.durationUs : Math.max(0L, endUs);
            if (window.durationUs != -9223372036854775807L) {
                if (resolvedEndUs > window.durationUs) {
                    resolvedEndUs = window.durationUs;
                }
                if (startUs > resolvedEndUs) {
                    throw new IllegalClippingException(2);
                }
            }
            this.startUs = startUs;
            this.endUs = resolvedEndUs;
            this.durationUs = resolvedEndUs == -9223372036854775807L ? -9223372036854775807L : resolvedEndUs - startUs;
            this.isDynamic = window.isDynamic && (resolvedEndUs == -9223372036854775807L || window.durationUs != -9223372036854775807L && resolvedEndUs == window.durationUs);
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            this.timeline.getWindow(0, window, 0L);
            window.positionInFirstPeriodUs += this.startUs;
            window.durationUs = this.durationUs;
            window.isDynamic = this.isDynamic;
            if (window.defaultPositionUs != -9223372036854775807L) {
                window.defaultPositionUs = Math.max(window.defaultPositionUs, this.startUs);
                window.defaultPositionUs = this.endUs == -9223372036854775807L ? window.defaultPositionUs : Math.min(window.defaultPositionUs, this.endUs);
                window.defaultPositionUs -= this.startUs;
            }
            long startMs = Util.usToMs((long)this.startUs);
            if (window.presentationStartTimeMs != -9223372036854775807L) {
                window.presentationStartTimeMs += startMs;
            }
            if (window.windowStartTimeMs != -9223372036854775807L) {
                window.windowStartTimeMs += startMs;
            }
            return window;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            this.timeline.getPeriod(0, period, setIds);
            long positionInClippedWindowUs = period.getPositionInWindowUs() - this.startUs;
            long periodDurationUs = this.durationUs == -9223372036854775807L ? -9223372036854775807L : this.durationUs - positionInClippedWindowUs;
            return period.set(period.id, period.uid, 0, periodDurationUs, positionInClippedWindowUs);
        }
    }
}

