/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.source.SequenceableLoader;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

@UnstableApi
public final class CompositeSequenceableLoader
implements SequenceableLoader {
    private final ImmutableList<SequenceableLoaderWithTrackTypes> loadersWithTrackTypes;
    private long lastAudioVideoBufferedPositionUs;

    @Deprecated
    public CompositeSequenceableLoader(SequenceableLoader[] loaders) {
        this((List<? extends SequenceableLoader>)ImmutableList.copyOf((Object[])loaders), Collections.nCopies(loaders.length, ImmutableList.of((Object)-1)));
    }

    public CompositeSequenceableLoader(List<? extends SequenceableLoader> loaders, List<List<Integer>> loaderTrackTypes) {
        ImmutableList.Builder loaderAndTrackTypes = ImmutableList.builder();
        Assertions.checkArgument((loaders.size() == loaderTrackTypes.size() ? 1 : 0) != 0);
        for (int i = 0; i < loaders.size(); ++i) {
            loaderAndTrackTypes.add((Object)new SequenceableLoaderWithTrackTypes(loaders.get(i), loaderTrackTypes.get(i)));
        }
        this.loadersWithTrackTypes = loaderAndTrackTypes.build();
        this.lastAudioVideoBufferedPositionUs = -9223372036854775807L;
    }

    @Override
    public long getBufferedPositionUs() {
        long bufferedPositionUs = Long.MAX_VALUE;
        long bufferedPositionAudioVideoUs = Long.MAX_VALUE;
        for (int i = 0; i < this.loadersWithTrackTypes.size(); ++i) {
            SequenceableLoaderWithTrackTypes loader = (SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i);
            long loaderBufferedPositionUs = loader.getBufferedPositionUs();
            if ((loader.getTrackTypes().contains((Object)1) || loader.getTrackTypes().contains((Object)2) || loader.getTrackTypes().contains((Object)4)) && loaderBufferedPositionUs != Long.MIN_VALUE) {
                bufferedPositionAudioVideoUs = Math.min(bufferedPositionAudioVideoUs, loaderBufferedPositionUs);
            }
            if (loaderBufferedPositionUs == Long.MIN_VALUE) continue;
            bufferedPositionUs = Math.min(bufferedPositionUs, loaderBufferedPositionUs);
        }
        if (bufferedPositionAudioVideoUs != Long.MAX_VALUE) {
            this.lastAudioVideoBufferedPositionUs = bufferedPositionAudioVideoUs;
            return bufferedPositionAudioVideoUs;
        }
        if (bufferedPositionUs != Long.MAX_VALUE) {
            return this.lastAudioVideoBufferedPositionUs != -9223372036854775807L ? this.lastAudioVideoBufferedPositionUs : bufferedPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long getNextLoadPositionUs() {
        long nextLoadPositionUs = Long.MAX_VALUE;
        for (int i = 0; i < this.loadersWithTrackTypes.size(); ++i) {
            SequenceableLoaderWithTrackTypes loader = (SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i);
            long loaderNextLoadPositionUs = loader.getNextLoadPositionUs();
            if (loaderNextLoadPositionUs == Long.MIN_VALUE) continue;
            nextLoadPositionUs = Math.min(nextLoadPositionUs, loaderNextLoadPositionUs);
        }
        return nextLoadPositionUs == Long.MAX_VALUE ? Long.MIN_VALUE : nextLoadPositionUs;
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        for (int i = 0; i < this.loadersWithTrackTypes.size(); ++i) {
            ((SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i)).reevaluateBuffer(positionUs);
        }
    }

    @Override
    public boolean continueLoading(LoadingInfo loadingInfo) {
        boolean madeProgressThisIteration;
        boolean madeProgress = false;
        do {
            madeProgressThisIteration = false;
            long nextLoadPositionUs = this.getNextLoadPositionUs();
            if (nextLoadPositionUs == Long.MIN_VALUE) break;
            for (int i = 0; i < this.loadersWithTrackTypes.size(); ++i) {
                boolean isLoaderBehind;
                long loaderNextLoadPositionUs = ((SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i)).getNextLoadPositionUs();
                boolean bl = isLoaderBehind = loaderNextLoadPositionUs != Long.MIN_VALUE && loaderNextLoadPositionUs <= loadingInfo.playbackPositionUs;
                if (loaderNextLoadPositionUs != nextLoadPositionUs && !isLoaderBehind) continue;
                madeProgressThisIteration |= ((SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i)).continueLoading(loadingInfo);
            }
            madeProgress |= madeProgressThisIteration;
        } while (madeProgressThisIteration);
        return madeProgress;
    }

    @Override
    public boolean isLoading() {
        for (int i = 0; i < this.loadersWithTrackTypes.size(); ++i) {
            if (!((SequenceableLoaderWithTrackTypes)this.loadersWithTrackTypes.get(i)).isLoading()) continue;
            return true;
        }
        return false;
    }

    private static final class SequenceableLoaderWithTrackTypes
    implements SequenceableLoader {
        private final SequenceableLoader loader;
        private final ImmutableList<Integer> trackTypes;

        public SequenceableLoaderWithTrackTypes(SequenceableLoader loader, List<Integer> trackTypes) {
            this.loader = loader;
            this.trackTypes = ImmutableList.copyOf(trackTypes);
        }

        public ImmutableList<Integer> getTrackTypes() {
            return this.trackTypes;
        }

        @Override
        public long getBufferedPositionUs() {
            return this.loader.getBufferedPositionUs();
        }

        @Override
        public long getNextLoadPositionUs() {
            return this.loader.getNextLoadPositionUs();
        }

        @Override
        public boolean continueLoading(LoadingInfo loadingInfo) {
            return this.loader.continueLoading(loadingInfo);
        }

        @Override
        public boolean isLoading() {
            return this.loader.isLoading();
        }

        @Override
        public void reevaluateBuffer(long positionUs) {
            this.loader.reevaluateBuffer(positionUs);
        }
    }
}

