/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.source.CompositeMediaSource;
import androidx.media3.exoplayer.source.DefaultMediaSourceFactory;
import androidx.media3.exoplayer.source.MaskingMediaSource;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.ProgressiveMediaSource;
import androidx.media3.exoplayer.source.TimeOffsetMediaPeriod;
import androidx.media3.exoplayer.upstream.Allocator;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.IdentityHashMap;

@UnstableApi
public final class ConcatenatingMediaSource2
extends CompositeMediaSource<Integer> {
    private static final int MSG_UPDATE_TIMELINE = 0;
    private final ImmutableList<MediaSourceHolder> mediaSourceHolders;
    private final IdentityHashMap<MediaPeriod, MediaSourceHolder> mediaSourceByMediaPeriod;
    @Nullable
    private Handler playbackThreadHandler;
    private boolean timelineUpdateScheduled;
    @GuardedBy(value="this")
    private MediaItem mediaItem;

    private ConcatenatingMediaSource2(MediaItem mediaItem, ImmutableList<MediaSourceHolder> mediaSourceHolders) {
        this.mediaItem = mediaItem;
        this.mediaSourceHolders = mediaSourceHolders;
        this.mediaSourceByMediaPeriod = new IdentityHashMap();
    }

    @Override
    @Nullable
    public Timeline getInitialTimeline() {
        return this.maybeCreateConcatenatedTimeline();
    }

    @Override
    public synchronized MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    public boolean canUpdateMediaItem(MediaItem mediaItem) {
        return true;
    }

    @Override
    public synchronized void updateMediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        this.playbackThreadHandler = new Handler(this::handleMessage);
        for (int i = 0; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder holder = (MediaSourceHolder)this.mediaSourceHolders.get(i);
            this.prepareChildSource(i, holder.mediaSource);
        }
        this.scheduleTimelineUpdate();
    }

    @Override
    protected void enableInternal() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        int holderIndex = ConcatenatingMediaSource2.getChildIndex(id.periodUid);
        MediaSourceHolder holder = (MediaSourceHolder)this.mediaSourceHolders.get(holderIndex);
        MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(ConcatenatingMediaSource2.getChildPeriodUid(id.periodUid)).copyWithWindowSequenceNumber(ConcatenatingMediaSource2.getChildWindowSequenceNumber(id.windowSequenceNumber, this.mediaSourceHolders.size(), holder.index));
        this.enableChildSource(holder.index);
        ++holder.activeMediaPeriods;
        long timeOffsetUs = id.isAd() ? 0L : (Long)Assertions.checkNotNull((Object)holder.periodTimeOffsetsByUid.get(childMediaPeriodId.periodUid));
        TimeOffsetMediaPeriod mediaPeriod = new TimeOffsetMediaPeriod(holder.mediaSource.createPeriod(childMediaPeriodId, allocator, startPositionUs - timeOffsetUs), timeOffsetUs);
        this.mediaSourceByMediaPeriod.put(mediaPeriod, holder);
        this.disableUnusedMediaSources();
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MediaSourceHolder holder = (MediaSourceHolder)Assertions.checkNotNull((Object)this.mediaSourceByMediaPeriod.remove(mediaPeriod));
        holder.mediaSource.releasePeriod(((TimeOffsetMediaPeriod)mediaPeriod).getWrappedMediaPeriod());
        --holder.activeMediaPeriods;
        if (!this.mediaSourceByMediaPeriod.isEmpty()) {
            this.disableUnusedMediaSources();
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        if (this.playbackThreadHandler != null) {
            this.playbackThreadHandler.removeCallbacksAndMessages(null);
            this.playbackThreadHandler = null;
        }
        this.timelineUpdateScheduled = false;
    }

    @Override
    protected void onChildSourceInfoRefreshed(Integer childSourceId, MediaSource mediaSource, Timeline newTimeline) {
        this.scheduleTimelineUpdate();
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Integer childSourceId, MediaSource.MediaPeriodId mediaPeriodId) {
        int childIndex = ConcatenatingMediaSource2.getChildIndexFromChildWindowSequenceNumber(mediaPeriodId.windowSequenceNumber, this.mediaSourceHolders.size());
        if (childSourceId != childIndex) {
            return null;
        }
        long windowSequenceNumber = ConcatenatingMediaSource2.getWindowSequenceNumberFromChildWindowSequenceNumber(mediaPeriodId.windowSequenceNumber, this.mediaSourceHolders.size());
        Object periodUid = ConcatenatingMediaSource2.getPeriodUid(childSourceId, mediaPeriodId.periodUid);
        return mediaPeriodId.copyWithPeriodUid(periodUid).copyWithWindowSequenceNumber(windowSequenceNumber);
    }

    @Override
    protected int getWindowIndexForChildWindowIndex(Integer childSourceId, int windowIndex) {
        return 0;
    }

    @Override
    protected long getMediaTimeForChildMediaTime(Integer childSourceId, long mediaTimeMs, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        if (mediaTimeMs == -9223372036854775807L || mediaPeriodId == null || mediaPeriodId.isAd()) {
            return mediaTimeMs;
        }
        Long timeOffsetUs = ((MediaSourceHolder)this.mediaSourceHolders.get((int)childSourceId.intValue())).periodTimeOffsetsByUid.get(mediaPeriodId.periodUid);
        if (timeOffsetUs == null) {
            return mediaTimeMs;
        }
        return mediaTimeMs + Util.usToMs((long)timeOffsetUs);
    }

    private boolean handleMessage(Message msg) {
        if (msg.what == 0) {
            this.updateTimeline();
        }
        return true;
    }

    private void scheduleTimelineUpdate() {
        if (!this.timelineUpdateScheduled) {
            ((Handler)Assertions.checkNotNull((Object)this.playbackThreadHandler)).obtainMessage(0).sendToTarget();
            this.timelineUpdateScheduled = true;
        }
    }

    private void updateTimeline() {
        this.timelineUpdateScheduled = false;
        ConcatenatedTimeline timeline = this.maybeCreateConcatenatedTimeline();
        if (timeline != null) {
            this.refreshSourceInfo(timeline);
        }
    }

    private void disableUnusedMediaSources() {
        for (int i = 0; i < this.mediaSourceHolders.size(); ++i) {
            MediaSourceHolder holder = (MediaSourceHolder)this.mediaSourceHolders.get(i);
            if (holder.activeMediaPeriods != 0) continue;
            this.disableChildSource(holder.index);
        }
    }

    @Nullable
    private ConcatenatedTimeline maybeCreateConcatenatedTimeline() {
        Timeline.Window window = new Timeline.Window();
        Timeline.Period period = new Timeline.Period();
        ImmutableList.Builder timelinesBuilder = ImmutableList.builder();
        ImmutableList.Builder firstPeriodIndicesBuilder = ImmutableList.builder();
        ImmutableList.Builder periodOffsetsInWindowUsBuilder = ImmutableList.builder();
        int periodCount = 0;
        boolean isSeekable = true;
        boolean isDynamic = false;
        long durationUs = 0L;
        long defaultPositionUs = 0L;
        long nextPeriodOffsetInWindowUs = 0L;
        boolean manifestsAreIdentical = true;
        boolean hasInitialManifest = false;
        Object initialManifest = null;
        int mediaSourceHoldersCount = this.mediaSourceHolders.size();
        for (int i = 0; i < mediaSourceHoldersCount; ++i) {
            MediaSourceHolder holder = (MediaSourceHolder)this.mediaSourceHolders.get(i);
            Timeline timeline = holder.mediaSource.getTimeline();
            Assertions.checkArgument((!timeline.isEmpty() ? 1 : 0) != 0, (Object)"Can't concatenate empty child Timeline.");
            timelinesBuilder.add((Object)timeline);
            firstPeriodIndicesBuilder.add((Object)periodCount);
            int periodCountInMediaSourceHolder = timeline.getPeriodCount();
            periodCount += periodCountInMediaSourceHolder;
            for (int j = 0; j < timeline.getWindowCount(); ++j) {
                timeline.getWindow(j, window);
                if (!hasInitialManifest) {
                    initialManifest = window.manifest;
                    hasInitialManifest = true;
                }
                manifestsAreIdentical = manifestsAreIdentical && Util.areEqual((Object)initialManifest, (Object)window.manifest);
                long windowDurationUs = window.durationUs;
                if (windowDurationUs == -9223372036854775807L) {
                    if (holder.initialPlaceholderDurationUs == -9223372036854775807L) {
                        return null;
                    }
                    windowDurationUs = holder.initialPlaceholderDurationUs;
                }
                durationUs += windowDurationUs;
                if (holder.index == 0 && j == 0) {
                    defaultPositionUs = window.defaultPositionUs;
                    nextPeriodOffsetInWindowUs = -window.positionInFirstPeriodUs;
                }
                isSeekable &= window.isSeekable || window.isPlaceholder;
                isDynamic |= window.isDynamic;
                for (int k = window.firstPeriodIndex; k <= window.lastPeriodIndex; ++k) {
                    boolean isFirstPeriodInNonFirstWindow;
                    periodOffsetsInWindowUsBuilder.add((Object)nextPeriodOffsetInWindowUs);
                    timeline.getPeriod(k, period, true);
                    long periodDurationUs = period.durationUs;
                    if (periodDurationUs == -9223372036854775807L) {
                        Assertions.checkArgument((window.firstPeriodIndex == window.lastPeriodIndex ? 1 : 0) != 0, (Object)"Can't apply placeholder duration to multiple periods with unknown duration in a single window.");
                        periodDurationUs = windowDurationUs + window.positionInFirstPeriodUs;
                    }
                    long timeOffsetUsForPeriod = 0L;
                    boolean bl = isFirstPeriodInNonFirstWindow = k == window.firstPeriodIndex && (holder.index != 0 || j != 0);
                    if (isFirstPeriodInNonFirstWindow && periodDurationUs != -9223372036854775807L) {
                        timeOffsetUsForPeriod = -window.positionInFirstPeriodUs;
                        periodDurationUs += timeOffsetUsForPeriod;
                    }
                    Object periodUid = Assertions.checkNotNull((Object)period.uid);
                    Assertions.checkArgument((holder.activeMediaPeriods == 0 || !holder.periodTimeOffsetsByUid.containsKey(periodUid) || holder.periodTimeOffsetsByUid.get(periodUid).equals(timeOffsetUsForPeriod) ? 1 : 0) != 0, (Object)"Can't handle windows with changing offset in first period.");
                    holder.periodTimeOffsetsByUid.put(periodUid, timeOffsetUsForPeriod);
                    nextPeriodOffsetInWindowUs += periodDurationUs;
                }
            }
        }
        return new ConcatenatedTimeline(this.getMediaItem(), (ImmutableList<Timeline>)timelinesBuilder.build(), (ImmutableList<Integer>)firstPeriodIndicesBuilder.build(), (ImmutableList<Long>)periodOffsetsInWindowUsBuilder.build(), isSeekable, isDynamic, durationUs, defaultPositionUs, manifestsAreIdentical ? initialManifest : null);
    }

    private static Object getPeriodUid(int childIndex, Object childPeriodUid) {
        return Pair.create((Object)childIndex, (Object)childPeriodUid);
    }

    private static int getChildIndex(Object periodUid) {
        return (Integer)((Pair)periodUid).first;
    }

    private static Object getChildPeriodUid(Object periodUid) {
        return ((Pair)periodUid).second;
    }

    private static long getChildWindowSequenceNumber(long windowSequenceNumber, int childCount, int childIndex) {
        return windowSequenceNumber * (long)childCount + (long)childIndex;
    }

    private static int getChildIndexFromChildWindowSequenceNumber(long childWindowSequenceNumber, int childCount) {
        return (int)(childWindowSequenceNumber % (long)childCount);
    }

    private static long getWindowSequenceNumberFromChildWindowSequenceNumber(long childWindowSequenceNumber, int childCount) {
        return childWindowSequenceNumber / (long)childCount;
    }

    private static final class ConcatenatedTimeline
    extends Timeline {
        private final MediaItem mediaItem;
        private final ImmutableList<Timeline> timelines;
        private final ImmutableList<Integer> firstPeriodIndices;
        private final ImmutableList<Long> periodOffsetsInWindowUs;
        private final boolean isSeekable;
        private final boolean isDynamic;
        private final long durationUs;
        private final long defaultPositionUs;
        @Nullable
        private final Object manifest;

        public ConcatenatedTimeline(MediaItem mediaItem, ImmutableList<Timeline> timelines, ImmutableList<Integer> firstPeriodIndices, ImmutableList<Long> periodOffsetsInWindowUs, boolean isSeekable, boolean isDynamic, long durationUs, long defaultPositionUs, @Nullable Object manifest) {
            this.mediaItem = mediaItem;
            this.timelines = timelines;
            this.firstPeriodIndices = firstPeriodIndices;
            this.periodOffsetsInWindowUs = periodOffsetsInWindowUs;
            this.isSeekable = isSeekable;
            this.isDynamic = isDynamic;
            this.durationUs = durationUs;
            this.defaultPositionUs = defaultPositionUs;
            this.manifest = manifest;
        }

        public int getWindowCount() {
            return 1;
        }

        public int getPeriodCount() {
            return this.periodOffsetsInWindowUs.size();
        }

        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            return window.set(Timeline.Window.SINGLE_WINDOW_UID, this.mediaItem, this.manifest, -9223372036854775807L, -9223372036854775807L, -9223372036854775807L, this.isSeekable, this.isDynamic, null, this.defaultPositionUs, this.durationUs, 0, this.getPeriodCount() - 1, -((Long)this.periodOffsetsInWindowUs.get(0)).longValue());
        }

        public Timeline.Period getPeriodByUid(Object periodUid, Timeline.Period period) {
            int childIndex = ConcatenatingMediaSource2.getChildIndex(periodUid);
            Object childPeriodUid = ConcatenatingMediaSource2.getChildPeriodUid(periodUid);
            Timeline timeline = (Timeline)this.timelines.get(childIndex);
            int periodIndex = (Integer)this.firstPeriodIndices.get(childIndex) + timeline.getIndexOfPeriod(childPeriodUid);
            timeline.getPeriodByUid(childPeriodUid, period);
            period.windowIndex = 0;
            period.positionInWindowUs = (Long)this.periodOffsetsInWindowUs.get(periodIndex);
            period.durationUs = this.getPeriodDurationUs(period, periodIndex);
            period.uid = periodUid;
            return period;
        }

        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            int childIndex = this.getChildIndexByPeriodIndex(periodIndex);
            int firstPeriodIndexInChild = (Integer)this.firstPeriodIndices.get(childIndex);
            ((Timeline)this.timelines.get(childIndex)).getPeriod(periodIndex - firstPeriodIndexInChild, period, setIds);
            period.windowIndex = 0;
            period.positionInWindowUs = (Long)this.periodOffsetsInWindowUs.get(periodIndex);
            period.durationUs = this.getPeriodDurationUs(period, periodIndex);
            if (setIds) {
                period.uid = ConcatenatingMediaSource2.getPeriodUid(childIndex, Assertions.checkNotNull((Object)period.uid));
            }
            return period;
        }

        public int getIndexOfPeriod(Object uid) {
            if (!(uid instanceof Pair) || !(((Pair)uid).first instanceof Integer)) {
                return -1;
            }
            int childIndex = ConcatenatingMediaSource2.getChildIndex(uid);
            Object periodUid = ConcatenatingMediaSource2.getChildPeriodUid(uid);
            int periodIndexInChild = ((Timeline)this.timelines.get(childIndex)).getIndexOfPeriod(periodUid);
            return periodIndexInChild == -1 ? -1 : (Integer)this.firstPeriodIndices.get(childIndex) + periodIndexInChild;
        }

        public Object getUidOfPeriod(int periodIndex) {
            int childIndex = this.getChildIndexByPeriodIndex(periodIndex);
            int firstPeriodIndexInChild = (Integer)this.firstPeriodIndices.get(childIndex);
            Object periodUidInChild = ((Timeline)this.timelines.get(childIndex)).getUidOfPeriod(periodIndex - firstPeriodIndexInChild);
            return ConcatenatingMediaSource2.getPeriodUid(childIndex, periodUidInChild);
        }

        private int getChildIndexByPeriodIndex(int periodIndex) {
            return Util.binarySearchFloor(this.firstPeriodIndices, (Comparable)Integer.valueOf(periodIndex + 1), (boolean)false, (boolean)false);
        }

        private long getPeriodDurationUs(Timeline.Period childPeriod, int periodIndex) {
            if (childPeriod.durationUs == -9223372036854775807L) {
                return -9223372036854775807L;
            }
            long periodStartTimeInWindowUs = (Long)this.periodOffsetsInWindowUs.get(periodIndex);
            long periodEndTimeInWindowUs = periodIndex == this.periodOffsetsInWindowUs.size() - 1 ? this.durationUs : (Long)this.periodOffsetsInWindowUs.get(periodIndex + 1);
            return periodEndTimeInWindowUs - periodStartTimeInWindowUs;
        }
    }

    static final class MediaSourceHolder {
        public final MaskingMediaSource mediaSource;
        public final int index;
        public final long initialPlaceholderDurationUs;
        public final HashMap<Object, Long> periodTimeOffsetsByUid;
        public int activeMediaPeriods;

        public MediaSourceHolder(MediaSource mediaSource, int index, long initialPlaceholderDurationUs) {
            this.mediaSource = new MaskingMediaSource(mediaSource, false);
            this.index = index;
            this.initialPlaceholderDurationUs = initialPlaceholderDurationUs;
            this.periodTimeOffsetsByUid = new HashMap();
        }
    }

    public static final class Builder {
        private final ImmutableList.Builder<MediaSourceHolder> mediaSourceHoldersBuilder = ImmutableList.builder();
        private int index;
        @Nullable
        private MediaItem mediaItem;
        @Nullable
        private MediaSource.Factory mediaSourceFactory;

        @CanIgnoreReturnValue
        public Builder useDefaultMediaSourceFactory(Context context) {
            return this.setMediaSourceFactory(new DefaultMediaSourceFactory(context));
        }

        @CanIgnoreReturnValue
        public Builder setMediaSourceFactory(MediaSource.Factory mediaSourceFactory) {
            this.mediaSourceFactory = (MediaSource.Factory)Assertions.checkNotNull((Object)mediaSourceFactory);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMediaItem(MediaItem mediaItem) {
            this.mediaItem = mediaItem;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(MediaItem mediaItem) {
            return this.add(mediaItem, -9223372036854775807L);
        }

        @CanIgnoreReturnValue
        public Builder add(MediaItem mediaItem, long initialPlaceholderDurationMs) {
            Assertions.checkNotNull((Object)mediaItem);
            if (initialPlaceholderDurationMs == -9223372036854775807L && mediaItem.clippingConfiguration.endPositionMs != Long.MIN_VALUE) {
                initialPlaceholderDurationMs = Util.usToMs((long)(mediaItem.clippingConfiguration.endPositionUs - mediaItem.clippingConfiguration.startPositionUs));
            }
            Assertions.checkStateNotNull((Object)this.mediaSourceFactory, (Object)"Must use useDefaultMediaSourceFactory or setMediaSourceFactory first.");
            return this.add(this.mediaSourceFactory.createMediaSource(mediaItem), initialPlaceholderDurationMs);
        }

        @CanIgnoreReturnValue
        public Builder add(MediaSource mediaSource) {
            return this.add(mediaSource, -9223372036854775807L);
        }

        @CanIgnoreReturnValue
        public Builder add(MediaSource mediaSource, long initialPlaceholderDurationMs) {
            Assertions.checkNotNull((Object)mediaSource);
            Assertions.checkState((!(mediaSource instanceof ProgressiveMediaSource) || initialPlaceholderDurationMs != -9223372036854775807L ? 1 : 0) != 0, (Object)"Progressive media source must define an initial placeholder duration.");
            this.mediaSourceHoldersBuilder.add((Object)new MediaSourceHolder(mediaSource, this.index++, Util.msToUs((long)initialPlaceholderDurationMs)));
            return this;
        }

        public ConcatenatingMediaSource2 build() {
            Assertions.checkArgument((this.index > 0 ? 1 : 0) != 0, (Object)"Must add at least one source to the concatenation.");
            if (this.mediaItem == null) {
                this.mediaItem = MediaItem.fromUri((Uri)Uri.EMPTY);
            }
            return new ConcatenatingMediaSource2(this.mediaItem, this.mediaSourceHoldersBuilder.build());
        }
    }
}

