/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.NullableType;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.source.ExternalLoader;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import com.google.common.base.Charsets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class ExternallyLoadedMediaPeriod
implements MediaPeriod {
    private final Uri uri;
    private final ExternalLoader externalLoader;
    private final TrackGroupArray tracks;
    private final byte[] sampleData;
    private final AtomicBoolean loadingFinished;
    private final AtomicReference<Throwable> loadingThrowable;
    private @MonotonicNonNull ListenableFuture<?> loadingFuture;

    public ExternallyLoadedMediaPeriod(Uri uri, String mimeType, ExternalLoader externalLoader) {
        this.uri = uri;
        Format format = new Format.Builder().setSampleMimeType(mimeType).build();
        this.externalLoader = externalLoader;
        this.tracks = new TrackGroupArray(new TrackGroup(new Format[]{format}));
        this.sampleData = uri.toString().getBytes(Charsets.UTF_8);
        this.loadingFinished = new AtomicBoolean();
        this.loadingThrowable = new AtomicReference();
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        callback.onPrepared(this);
        this.loadingFuture = this.externalLoader.load(new ExternalLoader.LoadRequest(this.uri));
        Futures.addCallback(this.loadingFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object result) {
                ExternallyLoadedMediaPeriod.this.loadingFinished.set(true);
            }

            public void onFailure(Throwable t) {
                ExternallyLoadedMediaPeriod.this.loadingThrowable.set(t);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public void maybeThrowPrepareError() {
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.tracks;
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        for (int i = 0; i < selections.length; ++i) {
            if (!(streams[i] == null || selections[i] != null && mayRetainStreamFlags[i])) {
                streams[i] = null;
            }
            if (streams[i] != null || selections[i] == null) continue;
            SampleStreamImpl stream = new SampleStreamImpl();
            streams[i] = stream;
            streamResetFlags[i] = true;
        }
        return positionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
    }

    @Override
    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    @Override
    public long seekToUs(long positionUs) {
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return positionUs;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.loadingFinished.get() ? Long.MIN_VALUE : 0L;
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.loadingFinished.get() ? Long.MIN_VALUE : 0L;
    }

    @Override
    public boolean continueLoading(LoadingInfo loadingInfo) {
        return !this.loadingFinished.get();
    }

    @Override
    public boolean isLoading() {
        return !this.loadingFinished.get();
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
    }

    public void releasePeriod() {
        if (this.loadingFuture != null) {
            this.loadingFuture.cancel(false);
        }
    }

    private final class SampleStreamImpl
    implements SampleStream {
        private static final int STREAM_STATE_SEND_FORMAT = 0;
        private static final int STREAM_STATE_SEND_SAMPLE = 1;
        private static final int STREAM_STATE_END_OF_STREAM = 2;
        private int streamState = 0;

        @Override
        public boolean isReady() {
            return ExternallyLoadedMediaPeriod.this.loadingFinished.get();
        }

        @Override
        public void maybeThrowError() throws IOException {
            Throwable loadingThrowable = (Throwable)ExternallyLoadedMediaPeriod.this.loadingThrowable.get();
            if (loadingThrowable != null) {
                throw new IOException(loadingThrowable);
            }
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            if (this.streamState == 2) {
                buffer.addFlag(4);
                return -4;
            }
            if ((readFlags & 2) != 0 || this.streamState == 0) {
                formatHolder.format = ExternallyLoadedMediaPeriod.this.tracks.get(0).getFormat(0);
                this.streamState = 1;
                return -5;
            }
            if (!ExternallyLoadedMediaPeriod.this.loadingFinished.get()) {
                return -3;
            }
            int sampleSize = ExternallyLoadedMediaPeriod.this.sampleData.length;
            buffer.addFlag(1);
            buffer.timeUs = 0L;
            if ((readFlags & 4) == 0) {
                buffer.ensureSpaceForWrite(sampleSize);
                buffer.data.put(ExternallyLoadedMediaPeriod.this.sampleData, 0, sampleSize);
            }
            if ((readFlags & 1) == 0) {
                this.streamState = 2;
            }
            return -4;
        }

        @Override
        public int skipData(long positionUs) {
            return 0;
        }
    }
}

