/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.ExternalLoader;
import androidx.media3.exoplayer.source.ExternallyLoadedMediaPeriod;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.SinglePeriodTimeline;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import java.util.Objects;

@UnstableApi
public final class ExternallyLoadedMediaSource
extends BaseMediaSource {
    private final ExternalLoader externalLoader;
    private final long timelineDurationUs;
    @GuardedBy(value="this")
    private MediaItem mediaItem;

    private ExternallyLoadedMediaSource(MediaItem mediaItem, long timelineDurationUs, ExternalLoader externalLoader) {
        this.mediaItem = mediaItem;
        this.timelineDurationUs = timelineDurationUs;
        this.externalLoader = externalLoader;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        SinglePeriodTimeline timeline = new SinglePeriodTimeline(this.timelineDurationUs, true, false, false, (Object)null, this.getMediaItem());
        this.refreshSourceInfo(timeline);
    }

    @Override
    protected void releaseSourceInternal() {
    }

    @Override
    public synchronized MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    public boolean canUpdateMediaItem(MediaItem mediaItem) {
        MediaItem.LocalConfiguration newConfiguration = mediaItem.localConfiguration;
        MediaItem.LocalConfiguration oldConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)this.getMediaItem().localConfiguration);
        return newConfiguration != null && newConfiguration.uri.equals((Object)oldConfiguration.uri) && Objects.equals(newConfiguration.mimeType, oldConfiguration.mimeType) && (newConfiguration.imageDurationMs == -9223372036854775807L || Util.msToUs((long)newConfiguration.imageDurationMs) == this.timelineDurationUs);
    }

    @Override
    public synchronized void updateMediaItem(MediaItem mediaItem) {
        this.mediaItem = mediaItem;
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaItem mediaItem = this.getMediaItem();
        Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        Assertions.checkNotNull((Object)mediaItem.localConfiguration.mimeType, (Object)"Externally loaded mediaItems require a MIME type.");
        return new ExternallyLoadedMediaPeriod(mediaItem.localConfiguration.uri, mediaItem.localConfiguration.mimeType, this.externalLoader);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((ExternallyLoadedMediaPeriod)mediaPeriod).releasePeriod();
    }

    public static final class Factory
    implements MediaSource.Factory {
        private final long timelineDurationUs;
        private final ExternalLoader externalLoader;

        public Factory(long timelineDurationUs, ExternalLoader externalLoader) {
            this.timelineDurationUs = timelineDurationUs;
            this.externalLoader = externalLoader;
        }

        @Override
        public MediaSource.Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            return this;
        }

        @Override
        public MediaSource.Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            return this;
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{4};
        }

        @Override
        public ExternallyLoadedMediaSource createMediaSource(MediaItem mediaItem) {
            return new ExternallyLoadedMediaSource(mediaItem, this.timelineDurationUs, this.externalLoader);
        }
    }
}

