/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import androidx.annotation.Nullable;
import androidx.media3.common.StreamKey;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NullableType;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.source.WrappingMediaSource;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.upstream.Allocator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;

@UnstableApi
public class FilteringMediaSource
extends WrappingMediaSource {
    private final ImmutableSet<Integer> trackTypes;

    public FilteringMediaSource(MediaSource mediaSource, int trackType) {
        this(mediaSource, (Set<Integer>)ImmutableSet.of((Object)trackType));
    }

    public FilteringMediaSource(MediaSource mediaSource, Set<Integer> trackTypes) {
        super(mediaSource);
        this.trackTypes = ImmutableSet.copyOf(trackTypes);
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaPeriod wrappedPeriod = super.createPeriod(id, allocator, startPositionUs);
        return new FilteringMediaPeriod(wrappedPeriod, this.trackTypes);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        MediaPeriod wrappedPeriod = ((FilteringMediaPeriod)mediaPeriod).mediaPeriod;
        super.releasePeriod(wrappedPeriod);
    }

    private static final class FilteringMediaPeriod
    implements MediaPeriod,
    MediaPeriod.Callback {
        public final MediaPeriod mediaPeriod;
        private final ImmutableSet<Integer> trackTypes;
        @Nullable
        private MediaPeriod.Callback callback;
        @Nullable
        private TrackGroupArray filteredTrackGroups;

        public FilteringMediaPeriod(MediaPeriod mediaPeriod, ImmutableSet<Integer> trackTypes) {
            this.mediaPeriod = mediaPeriod;
            this.trackTypes = trackTypes;
        }

        @Override
        public void prepare(MediaPeriod.Callback callback, long positionUs) {
            this.callback = callback;
            this.mediaPeriod.prepare(this, positionUs);
        }

        @Override
        public void maybeThrowPrepareError() throws IOException {
            this.mediaPeriod.maybeThrowPrepareError();
        }

        @Override
        public TrackGroupArray getTrackGroups() {
            return (TrackGroupArray)Assertions.checkNotNull((Object)this.filteredTrackGroups);
        }

        @Override
        public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
            return this.mediaPeriod.getStreamKeys(trackSelections);
        }

        @Override
        public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
            return this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
        }

        @Override
        public void discardBuffer(long positionUs, boolean toKeyframe) {
            this.mediaPeriod.discardBuffer(positionUs, toKeyframe);
        }

        @Override
        public long readDiscontinuity() {
            return this.mediaPeriod.readDiscontinuity();
        }

        @Override
        public long seekToUs(long positionUs) {
            return this.mediaPeriod.seekToUs(positionUs);
        }

        @Override
        public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
            return this.mediaPeriod.getAdjustedSeekPositionUs(positionUs, seekParameters);
        }

        @Override
        public long getBufferedPositionUs() {
            return this.mediaPeriod.getBufferedPositionUs();
        }

        @Override
        public long getNextLoadPositionUs() {
            return this.mediaPeriod.getNextLoadPositionUs();
        }

        @Override
        public boolean continueLoading(LoadingInfo loadingInfo) {
            return this.mediaPeriod.continueLoading(loadingInfo);
        }

        @Override
        public boolean isLoading() {
            return this.mediaPeriod.isLoading();
        }

        @Override
        public void reevaluateBuffer(long positionUs) {
            this.mediaPeriod.reevaluateBuffer(positionUs);
        }

        @Override
        public void onPrepared(MediaPeriod mediaPeriod) {
            TrackGroupArray trackGroups = mediaPeriod.getTrackGroups();
            ImmutableList.Builder trackGroupsBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroups.length; ++i) {
                TrackGroup trackGroup = trackGroups.get(i);
                if (!this.trackTypes.contains((Object)trackGroup.type)) continue;
                trackGroupsBuilder.add((Object)trackGroup);
            }
            this.filteredTrackGroups = new TrackGroupArray((TrackGroup[])trackGroupsBuilder.build().toArray((Object[])new TrackGroup[0]));
            ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod source) {
            ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
        }
    }
}

