/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.annotation.SuppressLint;
import android.media.MediaParser;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.RequiresApi;
import androidx.media3.common.DataReader;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.source.ProgressiveMediaExtractor;
import androidx.media3.exoplayer.source.mediaparser.InputReaderAdapterV30;
import androidx.media3.exoplayer.source.mediaparser.MediaParserUtil;
import androidx.media3.exoplayer.source.mediaparser.OutputConsumerAdapterV30;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiresApi(value=30)
@UnstableApi
public final class MediaParserExtractorAdapter
implements ProgressiveMediaExtractor {
    @Deprecated
    public static final ProgressiveMediaExtractor.Factory FACTORY = playerId -> new MediaParserExtractorAdapter(playerId, (Map<String, Object>)ImmutableMap.of());
    private final OutputConsumerAdapterV30 outputConsumerAdapter = new OutputConsumerAdapterV30();
    private final InputReaderAdapterV30 inputReaderAdapter = new InputReaderAdapterV30();
    private final MediaParser mediaParser = MediaParser.create((MediaParser.OutputConsumer)this.outputConsumerAdapter, (String[])new String[0]);
    private String parserName;

    @Deprecated
    public MediaParserExtractorAdapter(PlayerId playerId) {
        this(playerId, (Map<String, Object>)ImmutableMap.of());
    }

    @SuppressLint(value={"WrongConstant"})
    private MediaParserExtractorAdapter(PlayerId playerId, Map<String, Object> parameters) {
        this.mediaParser.setParameter("android.media.mediaparser.eagerlyExposeTrackType", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.inBandCryptoInfo", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.includeSupplementalData", (Object)true);
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            this.mediaParser.setParameter(parameter.getKey(), parameter.getValue());
        }
        this.parserName = "android.media.mediaparser.UNKNOWN";
        if (Util.SDK_INT >= 31) {
            MediaParserUtil.setLogSessionIdOnMediaParser(this.mediaParser, playerId);
        }
    }

    @Override
    public void init(DataReader dataReader, Uri uri, Map<String, List<String>> responseHeaders, long position, long length, ExtractorOutput output) throws IOException {
        this.outputConsumerAdapter.setExtractorOutput(output);
        this.inputReaderAdapter.setDataReader(dataReader, length);
        this.inputReaderAdapter.setCurrentPosition(position);
        String currentParserName = this.mediaParser.getParserName();
        if ("android.media.mediaparser.UNKNOWN".equals(currentParserName)) {
            this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
            this.parserName = this.mediaParser.getParserName();
            this.outputConsumerAdapter.setSelectedParserName(this.parserName);
        } else if (!currentParserName.equals(this.parserName)) {
            this.parserName = this.mediaParser.getParserName();
            this.outputConsumerAdapter.setSelectedParserName(this.parserName);
        }
    }

    @Override
    public void release() {
        this.mediaParser.release();
    }

    @Override
    public void disableSeekingOnMp3Streams() {
        if ("android.media.mediaparser.Mp3Parser".equals(this.parserName)) {
            this.outputConsumerAdapter.disableSeeking();
        }
    }

    @Override
    public long getCurrentInputPosition() {
        return this.inputReaderAdapter.getPosition();
    }

    @Override
    public void seek(long position, long seekTimeUs) {
        this.inputReaderAdapter.setCurrentPosition(position);
        Pair<MediaParser.SeekPoint, MediaParser.SeekPoint> seekPoints = this.outputConsumerAdapter.getSeekPoints(seekTimeUs);
        this.mediaParser.seek(((MediaParser.SeekPoint)seekPoints.second).position == position ? (MediaParser.SeekPoint)seekPoints.second : (MediaParser.SeekPoint)seekPoints.first);
    }

    @Override
    public int read(PositionHolder positionHolder) throws IOException {
        boolean shouldContinue = this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
        positionHolder.position = this.inputReaderAdapter.getAndResetSeekPosition();
        return !shouldContinue ? -1 : (positionHolder.position != -1L ? 1 : 0);
    }

    public static final class Factory
    implements ProgressiveMediaExtractor.Factory {
        private static final Map<String, Object> parameters = new HashMap<String, Object>();

        public void setConstantBitrateSeekingEnabled(boolean enabled) {
            if (enabled) {
                parameters.put("android.media.mediaparser.adts.enableCbrSeeking", true);
                parameters.put("android.media.mediaparser.amr.enableCbrSeeking", true);
                parameters.put("android.media.mediaparser.mp3.enableCbrSeeking", true);
            } else {
                parameters.remove("android.media.mediaparser.adts.enableCbrSeeking");
                parameters.remove("android.media.mediaparser.amr.enableCbrSeeking");
                parameters.remove("android.media.mediaparser.mp3.enableCbrSeeking");
            }
        }

        @Override
        public MediaParserExtractorAdapter createProgressiveMediaExtractor(PlayerId playerId) {
            return new MediaParserExtractorAdapter(playerId, parameters);
        }
    }
}

