/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.extractor.text.SubtitleParser;
import java.io.IOException;

public interface MediaSource {
    @UnstableApi
    public void addEventListener(Handler var1, MediaSourceEventListener var2);

    @UnstableApi
    public void removeEventListener(MediaSourceEventListener var1);

    @UnstableApi
    public void addDrmEventListener(Handler var1, DrmSessionEventListener var2);

    @UnstableApi
    public void removeDrmEventListener(DrmSessionEventListener var1);

    @UnstableApi
    @Nullable
    default public Timeline getInitialTimeline() {
        return null;
    }

    @UnstableApi
    default public boolean isSingleWindow() {
        return true;
    }

    @UnstableApi
    public MediaItem getMediaItem();

    @UnstableApi
    default public boolean canUpdateMediaItem(MediaItem mediaItem) {
        return false;
    }

    @UnstableApi
    default public void updateMediaItem(MediaItem mediaItem) {
    }

    @Deprecated
    @UnstableApi
    default public void prepareSource(MediaSourceCaller caller, @Nullable TransferListener mediaTransferListener) {
        this.prepareSource(caller, mediaTransferListener, PlayerId.UNSET);
    }

    @UnstableApi
    public void prepareSource(MediaSourceCaller var1, @Nullable TransferListener var2, PlayerId var3);

    @UnstableApi
    public void maybeThrowSourceInfoRefreshError() throws IOException;

    @UnstableApi
    public void enable(MediaSourceCaller var1);

    @UnstableApi
    public MediaPeriod createPeriod(MediaPeriodId var1, Allocator var2, long var3);

    @UnstableApi
    public void releasePeriod(MediaPeriod var1);

    @UnstableApi
    public void disable(MediaSourceCaller var1);

    @UnstableApi
    public void releaseSource(MediaSourceCaller var1);

    @UnstableApi
    public static interface MediaSourceCaller {
        public void onSourceInfoRefreshed(MediaSource var1, Timeline var2);
    }

    @UnstableApi
    public static final class MediaPeriodId {
        public final Object periodUid;
        public final int adGroupIndex;
        public final int adIndexInAdGroup;
        public final long windowSequenceNumber;
        public final int nextAdGroupIndex;

        public MediaPeriodId(Object periodUid) {
            this(periodUid, -1L);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber) {
            this(periodUid, -1, -1, windowSequenceNumber, -1);
        }

        public MediaPeriodId(Object periodUid, long windowSequenceNumber, int nextAdGroupIndex) {
            this(periodUid, -1, -1, windowSequenceNumber, nextAdGroupIndex);
        }

        public MediaPeriodId(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long windowSequenceNumber) {
            this(periodUid, adGroupIndex, adIndexInAdGroup, windowSequenceNumber, -1);
        }

        private MediaPeriodId(Object periodUid, int adGroupIndex, int adIndexInAdGroup, long windowSequenceNumber, int nextAdGroupIndex) {
            this.periodUid = periodUid;
            this.adGroupIndex = adGroupIndex;
            this.adIndexInAdGroup = adIndexInAdGroup;
            this.windowSequenceNumber = windowSequenceNumber;
            this.nextAdGroupIndex = nextAdGroupIndex;
        }

        public MediaPeriodId copyWithPeriodUid(Object newPeriodUid) {
            return this.periodUid.equals(newPeriodUid) ? this : new MediaPeriodId(newPeriodUid, this.adGroupIndex, this.adIndexInAdGroup, this.windowSequenceNumber, this.nextAdGroupIndex);
        }

        public MediaPeriodId copyWithWindowSequenceNumber(long windowSequenceNumber) {
            return this.windowSequenceNumber == windowSequenceNumber ? this : new MediaPeriodId(this.periodUid, this.adGroupIndex, this.adIndexInAdGroup, windowSequenceNumber, this.nextAdGroupIndex);
        }

        public boolean isAd() {
            return this.adGroupIndex != -1;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof MediaPeriodId)) {
                return false;
            }
            MediaPeriodId periodId = (MediaPeriodId)obj;
            return this.periodUid.equals(periodId.periodUid) && this.adGroupIndex == periodId.adGroupIndex && this.adIndexInAdGroup == periodId.adIndexInAdGroup && this.windowSequenceNumber == periodId.windowSequenceNumber && this.nextAdGroupIndex == periodId.nextAdGroupIndex;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.periodUid.hashCode();
            result = 31 * result + this.adGroupIndex;
            result = 31 * result + this.adIndexInAdGroup;
            result = 31 * result + (int)this.windowSequenceNumber;
            result = 31 * result + this.nextAdGroupIndex;
            return result;
        }
    }

    public static interface Factory {
        @UnstableApi
        public static final Factory UNSUPPORTED = MediaSourceFactory.UNSUPPORTED;

        @UnstableApi
        default public Factory setCmcdConfigurationFactory(CmcdConfiguration.Factory cmcdConfigurationFactory) {
            return this;
        }

        @UnstableApi
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider var1);

        @UnstableApi
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy var1);

        @UnstableApi
        default public Factory experimentalParseSubtitlesDuringExtraction(boolean parseSubtitlesDuringExtraction) {
            return this;
        }

        @UnstableApi
        default public Factory setSubtitleParserFactory(SubtitleParser.Factory subtitleParserFactory) {
            return this;
        }

        @UnstableApi
        public int[] getSupportedTypes();

        @UnstableApi
        public MediaSource createMediaSource(MediaItem var1);
    }
}

