/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import androidx.media3.common.StreamKey;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NullableType;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.exoplayer.FormatHolder;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import java.io.IOException;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class TimeOffsetMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    private final MediaPeriod mediaPeriod;
    private final long timeOffsetUs;
    private @MonotonicNonNull MediaPeriod.Callback callback;

    public TimeOffsetMediaPeriod(MediaPeriod mediaPeriod, long timeOffsetUs) {
        this.mediaPeriod = mediaPeriod;
        this.timeOffsetUs = timeOffsetUs;
    }

    public MediaPeriod getWrappedMediaPeriod() {
        return this.mediaPeriod;
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        this.mediaPeriod.prepare(this, positionUs - this.timeOffsetUs);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.mediaPeriod.maybeThrowPrepareError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.mediaPeriod.getTrackGroups();
    }

    @Override
    public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
        return this.mediaPeriod.getStreamKeys(trackSelections);
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        @NullableType SampleStream[] childStreams = new SampleStream[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            TimeOffsetSampleStream sampleStream = (TimeOffsetSampleStream)streams[i];
            childStreams[i] = sampleStream != null ? sampleStream.getChildStream() : null;
        }
        long startPositionUs = this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs - this.timeOffsetUs);
        for (int i = 0; i < streams.length; ++i) {
            SampleStream childStream = childStreams[i];
            if (childStream == null) {
                streams[i] = null;
                continue;
            }
            if (streams[i] != null && ((TimeOffsetSampleStream)streams[i]).getChildStream() == childStream) continue;
            streams[i] = new TimeOffsetSampleStream(childStream, this.timeOffsetUs);
        }
        return startPositionUs + this.timeOffsetUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        this.mediaPeriod.discardBuffer(positionUs - this.timeOffsetUs, toKeyframe);
    }

    @Override
    public long readDiscontinuity() {
        long discontinuityPositionUs = this.mediaPeriod.readDiscontinuity();
        return discontinuityPositionUs == -9223372036854775807L ? -9223372036854775807L : discontinuityPositionUs + this.timeOffsetUs;
    }

    @Override
    public long seekToUs(long positionUs) {
        return this.mediaPeriod.seekToUs(positionUs - this.timeOffsetUs) + this.timeOffsetUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return this.mediaPeriod.getAdjustedSeekPositionUs(positionUs - this.timeOffsetUs, seekParameters) + this.timeOffsetUs;
    }

    @Override
    public long getBufferedPositionUs() {
        long bufferedPositionUs = this.mediaPeriod.getBufferedPositionUs();
        return bufferedPositionUs == Long.MIN_VALUE ? Long.MIN_VALUE : bufferedPositionUs + this.timeOffsetUs;
    }

    @Override
    public long getNextLoadPositionUs() {
        long nextLoadPositionUs = this.mediaPeriod.getNextLoadPositionUs();
        return nextLoadPositionUs == Long.MIN_VALUE ? Long.MIN_VALUE : nextLoadPositionUs + this.timeOffsetUs;
    }

    @Override
    public boolean continueLoading(LoadingInfo loadingInfo) {
        return this.mediaPeriod.continueLoading(loadingInfo.buildUpon().setPlaybackPositionUs(loadingInfo.playbackPositionUs - this.timeOffsetUs).build());
    }

    @Override
    public boolean isLoading() {
        return this.mediaPeriod.isLoading();
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        this.mediaPeriod.reevaluateBuffer(positionUs - this.timeOffsetUs);
    }

    @Override
    public void onPrepared(MediaPeriod mediaPeriod) {
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod source) {
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    private static final class TimeOffsetSampleStream
    implements SampleStream {
        private final SampleStream sampleStream;
        private final long timeOffsetUs;

        public TimeOffsetSampleStream(SampleStream sampleStream, long timeOffsetUs) {
            this.sampleStream = sampleStream;
            this.timeOffsetUs = timeOffsetUs;
        }

        public SampleStream getChildStream() {
            return this.sampleStream;
        }

        @Override
        public boolean isReady() {
            return this.sampleStream.isReady();
        }

        @Override
        public void maybeThrowError() throws IOException {
            this.sampleStream.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            int readResult = this.sampleStream.readData(formatHolder, buffer, readFlags);
            if (readResult == -4) {
                buffer.timeUs += this.timeOffsetUs;
            }
            return readResult;
        }

        @Override
        public int skipData(long positionUs) {
            return this.sampleStream.skipData(positionUs - this.timeOffsetUs);
        }
    }
}

