/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.media3.common.Bundleable;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.BundleCollectionUtil;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@UnstableApi
public final class TrackGroupArray
implements Bundleable {
    private static final String TAG = "TrackGroupArray";
    public static final TrackGroupArray EMPTY = new TrackGroupArray(new TrackGroup[0]);
    public final int length;
    private final ImmutableList<TrackGroup> trackGroups;
    private int hashCode;
    private static final String FIELD_TRACK_GROUPS = Util.intToStringMaxRadix((int)0);
    @Deprecated
    public static final Bundleable.Creator<TrackGroupArray> CREATOR = TrackGroupArray::fromBundle;

    public TrackGroupArray(TrackGroup ... trackGroups) {
        this.trackGroups = ImmutableList.copyOf((Object[])trackGroups);
        this.length = trackGroups.length;
        this.verifyCorrectness();
    }

    public TrackGroup get(int index) {
        return (TrackGroup)this.trackGroups.get(index);
    }

    public int indexOf(TrackGroup group) {
        int index = this.trackGroups.indexOf((Object)group);
        return index >= 0 ? index : -1;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public ImmutableList<Integer> getTrackTypes() {
        return ImmutableList.copyOf((Collection)Lists.transform(this.trackGroups, t -> t.type));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.trackGroups.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroupArray other = (TrackGroupArray)obj;
        return this.length == other.length && this.trackGroups.equals(other.trackGroups);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(FIELD_TRACK_GROUPS, BundleCollectionUtil.toBundleArrayList(this.trackGroups, TrackGroup::toBundle));
        return bundle;
    }

    public static TrackGroupArray fromBundle(Bundle bundle) {
        ArrayList trackGroupBundles = bundle.getParcelableArrayList(FIELD_TRACK_GROUPS);
        if (trackGroupBundles == null) {
            return new TrackGroupArray(new TrackGroup[0]);
        }
        return new TrackGroupArray((TrackGroup[])BundleCollectionUtil.fromBundleList(TrackGroup::fromBundle, (List)trackGroupBundles).toArray((Object[])new TrackGroup[0]));
    }

    private void verifyCorrectness() {
        for (int i = 0; i < this.trackGroups.size(); ++i) {
            for (int j = i + 1; j < this.trackGroups.size(); ++j) {
                if (!((TrackGroup)this.trackGroups.get(i)).equals(this.trackGroups.get(j))) continue;
                Log.e((String)TAG, (String)"", (Throwable)new IllegalArgumentException("Multiple identical TrackGroups added to one TrackGroupArray."));
            }
        }
    }
}

