/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.preload;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.NullableType;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.trackselection.TrackSelectorResult;
import java.io.IOException;
import java.util.Objects;

final class PreloadMediaPeriod
implements MediaPeriod {
    public final MediaPeriod mediaPeriod;
    private boolean prepareInternalCalled;
    private boolean prepared;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private PreloadTrackSelectionHolder preloadTrackSelectionHolder;

    public PreloadMediaPeriod(MediaPeriod mediaPeriod) {
        this.mediaPeriod = mediaPeriod;
    }

    void preload(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        if (this.prepared) {
            callback.onPrepared(this);
        }
        if (!this.prepareInternalCalled) {
            this.prepareInternal(positionUs);
        }
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        if (this.prepared) {
            callback.onPrepared(this);
            return;
        }
        if (!this.prepareInternalCalled) {
            this.prepareInternal(positionUs);
        }
    }

    private void prepareInternal(long positionUs) {
        this.prepareInternalCalled = true;
        this.mediaPeriod.prepare(new MediaPeriod.Callback(){

            @Override
            public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
                ((MediaPeriod.Callback)Assertions.checkNotNull((Object)PreloadMediaPeriod.this.callback)).onContinueLoadingRequested(PreloadMediaPeriod.this);
            }

            @Override
            public void onPrepared(MediaPeriod mediaPeriod) {
                PreloadMediaPeriod.this.prepared = true;
                ((MediaPeriod.Callback)Assertions.checkNotNull((Object)PreloadMediaPeriod.this.callback)).onPrepared(PreloadMediaPeriod.this);
            }
        }, positionUs);
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        this.mediaPeriod.maybeThrowPrepareError();
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return this.mediaPeriod.getTrackGroups();
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        if (this.preloadTrackSelectionHolder == null) {
            return this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
        }
        Assertions.checkState((streams.length == this.preloadTrackSelectionHolder.streams.length ? 1 : 0) != 0);
        if (positionUs != this.preloadTrackSelectionHolder.trackSelectionPositionUs) {
            for (int i = 0; i < this.preloadTrackSelectionHolder.streams.length; ++i) {
                if (this.preloadTrackSelectionHolder.streams[i] == null) continue;
                streams[i] = this.preloadTrackSelectionHolder.streams[i];
                mayRetainStreamFlags[i] = false;
            }
            this.preloadTrackSelectionHolder = null;
            return this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, streams, streamResetFlags, positionUs);
        }
        PreloadTrackSelectionHolder holder = (PreloadTrackSelectionHolder)Assertions.checkNotNull((Object)this.preloadTrackSelectionHolder);
        long trackSelectionPositionUs = holder.trackSelectionPositionUs;
        boolean[] preloadStreamResetFlags = holder.streamResetFlags;
        if (PreloadMediaPeriod.maybeUpdatePreloadTrackSelectionHolderForReselection(selections, holder)) {
            preloadStreamResetFlags = new boolean[preloadStreamResetFlags.length];
            trackSelectionPositionUs = this.mediaPeriod.selectTracks(holder.trackSelectorResult.selections, holder.mayRetainStreamFlags, holder.streams, preloadStreamResetFlags, holder.trackSelectionPositionUs);
            for (int i = 0; i < holder.mayRetainStreamFlags.length; ++i) {
                if (!holder.mayRetainStreamFlags[i]) continue;
                preloadStreamResetFlags[i] = true;
            }
        }
        System.arraycopy(holder.streams, 0, streams, 0, holder.streams.length);
        System.arraycopy(preloadStreamResetFlags, 0, streamResetFlags, 0, preloadStreamResetFlags.length);
        this.preloadTrackSelectionHolder = null;
        return trackSelectionPositionUs;
    }

    private static boolean maybeUpdatePreloadTrackSelectionHolderForReselection(@NullableType ExoTrackSelection[] selections, PreloadTrackSelectionHolder preloadTrackSelectionHolder) {
        @NullableType ExoTrackSelection[] preloadSelections = ((PreloadTrackSelectionHolder)Assertions.checkNotNull((Object)preloadTrackSelectionHolder)).trackSelectorResult.selections;
        boolean needsReselection = false;
        for (int i = 0; i < selections.length; ++i) {
            ExoTrackSelection selection = selections[i];
            ExoTrackSelection preloadSelection = preloadSelections[i];
            if (selection == null && preloadSelection == null) continue;
            preloadTrackSelectionHolder.mayRetainStreamFlags[i] = false;
            if (selection == null) {
                preloadTrackSelectionHolder.trackSelectorResult.selections[i] = null;
                needsReselection = true;
                continue;
            }
            if (preloadSelection == null) {
                preloadTrackSelectionHolder.trackSelectorResult.selections[i] = selection;
                needsReselection = true;
                continue;
            }
            if (!PreloadMediaPeriod.isSameAdaptionSet(selection, preloadSelection)) {
                preloadTrackSelectionHolder.trackSelectorResult.selections[i] = selection;
                needsReselection = true;
                continue;
            }
            if (selection.getTrackGroup().type == 2 || selection.getTrackGroup().type == 1 || selection.getSelectedIndexInTrackGroup() == preloadSelection.getSelectedIndexInTrackGroup()) {
                preloadTrackSelectionHolder.mayRetainStreamFlags[i] = true;
                continue;
            }
            preloadTrackSelectionHolder.trackSelectorResult.selections[i] = selection;
            needsReselection = true;
        }
        return needsReselection;
    }

    private static boolean isSameAdaptionSet(ExoTrackSelection selection, ExoTrackSelection preloadSelection) {
        if (!Objects.equals(selection.getTrackGroup(), preloadSelection.getTrackGroup()) || selection.length() != preloadSelection.length()) {
            return false;
        }
        for (int i = 0; i < selection.length(); ++i) {
            if (selection.getIndexInTrackGroup(i) == preloadSelection.getIndexInTrackGroup(i)) continue;
            return false;
        }
        return true;
    }

    long selectTracksForPreloading(TrackSelectorResult trackSelectorResult, long positionUs) {
        @NullableType ExoTrackSelection[] selections = trackSelectorResult.selections;
        @NullableType SampleStream[] preloadedSampleStreams = new SampleStream[selections.length];
        boolean[] preloadedStreamResetFlags = new boolean[selections.length];
        boolean[] mayRetainStreamFlags = new boolean[selections.length];
        if (this.preloadTrackSelectionHolder != null) {
            for (int i = 0; i < trackSelectorResult.length; ++i) {
                mayRetainStreamFlags[i] = trackSelectorResult.isEquivalent(((PreloadTrackSelectionHolder)Assertions.checkNotNull((Object)this.preloadTrackSelectionHolder)).trackSelectorResult, i);
            }
        }
        long trackSelectionPositionUs = this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, preloadedSampleStreams, preloadedStreamResetFlags, positionUs);
        this.preloadTrackSelectionHolder = new PreloadTrackSelectionHolder(trackSelectorResult, mayRetainStreamFlags, preloadedSampleStreams, preloadedStreamResetFlags, trackSelectionPositionUs);
        return trackSelectionPositionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        this.mediaPeriod.discardBuffer(positionUs, toKeyframe);
    }

    @Override
    public long readDiscontinuity() {
        return this.mediaPeriod.readDiscontinuity();
    }

    @Override
    public long seekToUs(long positionUs) {
        return this.mediaPeriod.seekToUs(positionUs);
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        return this.mediaPeriod.getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    @Override
    public long getBufferedPositionUs() {
        return this.mediaPeriod.getBufferedPositionUs();
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.mediaPeriod.getNextLoadPositionUs();
    }

    @Override
    public boolean continueLoading(LoadingInfo loadingInfo) {
        return this.mediaPeriod.continueLoading(loadingInfo);
    }

    @Override
    public boolean isLoading() {
        return this.mediaPeriod.isLoading();
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        this.mediaPeriod.reevaluateBuffer(positionUs);
    }

    private static class PreloadTrackSelectionHolder {
        public final TrackSelectorResult trackSelectorResult;
        public final boolean[] mayRetainStreamFlags;
        public final @NullableType SampleStream[] streams;
        public final boolean[] streamResetFlags;
        public final long trackSelectionPositionUs;

        public PreloadTrackSelectionHolder(TrackSelectorResult trackSelectorResult, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long trackSelectionPositionUs) {
            this.trackSelectorResult = trackSelectorResult;
            this.mayRetainStreamFlags = mayRetainStreamFlags;
            this.streams = streams;
            this.streamResetFlags = streamResetFlags;
            this.trackSelectionPositionUs = trackSelectionPositionUs;
        }
    }
}

