/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.preload;

import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.LoadingInfo;
import androidx.media3.exoplayer.RendererCapabilities;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.source.WrappingMediaSource;
import androidx.media3.exoplayer.source.preload.PreloadMediaPeriod;
import androidx.media3.exoplayer.trackselection.TrackSelector;
import androidx.media3.exoplayer.trackselection.TrackSelectorResult;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import java.util.Arrays;

@UnstableApi
public final class PreloadMediaSource
extends WrappingMediaSource {
    private static final String TAG = "PreloadMediaSource";
    private final PreloadControl preloadControl;
    private final TrackSelector trackSelector;
    private final BandwidthMeter bandwidthMeter;
    private final RendererCapabilities[] rendererCapabilities;
    private final Allocator allocator;
    private final Handler preloadHandler;
    private boolean preloadCalled;
    private boolean prepareChildSourceCalled;
    private long startPositionUs;
    @Nullable
    private Timeline timeline;
    @Nullable
    private Pair<PreloadMediaPeriod, MediaPeriodKey> preloadingMediaPeriodAndKey;
    @Nullable
    private Pair<PreloadMediaPeriod, MediaSource.MediaPeriodId> playingPreloadedMediaPeriodAndId;

    private PreloadMediaSource(MediaSource mediaSource, PreloadControl preloadControl, TrackSelector trackSelector, BandwidthMeter bandwidthMeter, RendererCapabilities[] rendererCapabilities, Allocator allocator, Looper preloadLooper) {
        super(mediaSource);
        this.preloadControl = preloadControl;
        this.trackSelector = trackSelector;
        this.bandwidthMeter = bandwidthMeter;
        this.rendererCapabilities = rendererCapabilities;
        this.allocator = allocator;
        this.preloadHandler = Util.createHandler((Looper)preloadLooper, null);
        this.startPositionUs = -9223372036854775807L;
    }

    public void preload(long startPositionUs) {
        this.preloadHandler.post(() -> {
            this.preloadCalled = true;
            this.startPositionUs = startPositionUs;
            if (!this.isUsedByPlayer()) {
                this.setPlayerId(PlayerId.UNSET);
                this.prepareSourceInternal(this.bandwidthMeter.getTransferListener());
            }
        });
    }

    @Override
    protected void prepareSourceInternal() {
        if (this.timeline != null) {
            this.onChildSourceInfoRefreshed(this.timeline);
        } else if (!this.prepareChildSourceCalled) {
            this.prepareChildSourceCalled = true;
            this.prepareChildSource();
        }
    }

    @Override
    protected void onChildSourceInfoRefreshed(Timeline newTimeline) {
        this.timeline = newTimeline;
        this.refreshSourceInfo(newTimeline);
        if (this.isUsedByPlayer() || !this.preloadControl.onTimelineRefreshed(this)) {
            return;
        }
        Pair periodPosition = newTimeline.getPeriodPositionUs(new Timeline.Window(), new Timeline.Period(), 0, this.startPositionUs);
        MediaSource.MediaPeriodId mediaPeriodId = new MediaSource.MediaPeriodId(periodPosition.first);
        PreloadMediaPeriod mediaPeriod = this.createPeriod(mediaPeriodId, this.allocator, (Long)periodPosition.second);
        mediaPeriod.preload(new PreloadMediaPeriodCallback((Long)periodPosition.second), (Long)periodPosition.second);
    }

    @Override
    public PreloadMediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaPeriodKey key = new MediaPeriodKey(id, startPositionUs);
        if (this.preloadingMediaPeriodAndKey != null && key.equals(this.preloadingMediaPeriodAndKey.second)) {
            PreloadMediaPeriod mediaPeriod = (PreloadMediaPeriod)((Pair)Assertions.checkNotNull(this.preloadingMediaPeriodAndKey)).first;
            if (this.isUsedByPlayer()) {
                this.preloadingMediaPeriodAndKey = null;
                this.playingPreloadedMediaPeriodAndId = new Pair((Object)mediaPeriod, (Object)id);
            }
            return mediaPeriod;
        }
        if (this.preloadingMediaPeriodAndKey != null) {
            this.mediaSource.releasePeriod(((PreloadMediaPeriod)((Pair)Assertions.checkNotNull(this.preloadingMediaPeriodAndKey)).first).mediaPeriod);
            this.preloadingMediaPeriodAndKey = null;
        }
        PreloadMediaPeriod mediaPeriod = new PreloadMediaPeriod(this.mediaSource.createPeriod(id, allocator, startPositionUs));
        if (!this.isUsedByPlayer()) {
            this.preloadingMediaPeriodAndKey = new Pair((Object)mediaPeriod, (Object)key);
        }
        return mediaPeriod;
    }

    @Override
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(MediaSource.MediaPeriodId mediaPeriodId) {
        if (this.playingPreloadedMediaPeriodAndId != null && PreloadMediaSource.mediaPeriodIdEqualsWithoutWindowSequenceNumber(mediaPeriodId, (MediaSource.MediaPeriodId)((Pair)Assertions.checkNotNull(this.playingPreloadedMediaPeriodAndId)).second)) {
            return (MediaSource.MediaPeriodId)((Pair)Assertions.checkNotNull(this.playingPreloadedMediaPeriodAndId)).second;
        }
        return mediaPeriodId;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        PreloadMediaPeriod preloadMediaPeriod = (PreloadMediaPeriod)mediaPeriod;
        if (this.preloadingMediaPeriodAndKey != null && preloadMediaPeriod == ((Pair)Assertions.checkNotNull(this.preloadingMediaPeriodAndKey)).first) {
            this.preloadingMediaPeriodAndKey = null;
        } else if (this.playingPreloadedMediaPeriodAndId != null && preloadMediaPeriod == ((Pair)Assertions.checkNotNull(this.playingPreloadedMediaPeriodAndId)).first) {
            this.playingPreloadedMediaPeriodAndId = null;
        }
        MediaPeriod periodToRelease = preloadMediaPeriod.mediaPeriod;
        this.mediaSource.releasePeriod(periodToRelease);
    }

    @Override
    protected void releaseSourceInternal() {
        if (!this.preloadCalled && !this.isUsedByPlayer()) {
            this.timeline = null;
            this.prepareChildSourceCalled = false;
            super.releaseSourceInternal();
        }
    }

    public void releasePreloadMediaSource() {
        this.preloadHandler.post(() -> {
            this.preloadCalled = false;
            this.startPositionUs = -9223372036854775807L;
            if (this.preloadingMediaPeriodAndKey != null) {
                this.mediaSource.releasePeriod(((PreloadMediaPeriod)this.preloadingMediaPeriodAndKey.first).mediaPeriod);
                this.preloadingMediaPeriodAndKey = null;
            }
            this.releaseSourceInternal();
            this.preloadHandler.removeCallbacksAndMessages(null);
        });
    }

    boolean isUsedByPlayer() {
        return this.prepareSourceCalled();
    }

    private static boolean mediaPeriodIdEqualsWithoutWindowSequenceNumber(MediaSource.MediaPeriodId firstPeriodId, MediaSource.MediaPeriodId secondPeriodId) {
        return firstPeriodId.periodUid.equals(secondPeriodId.periodUid) && firstPeriodId.adGroupIndex == secondPeriodId.adGroupIndex && firstPeriodId.adIndexInAdGroup == secondPeriodId.adIndexInAdGroup && firstPeriodId.nextAdGroupIndex == secondPeriodId.nextAdGroupIndex;
    }

    public static interface PreloadControl {
        public boolean onTimelineRefreshed(PreloadMediaSource var1);

        public boolean onPrepared(PreloadMediaSource var1);

        public boolean onContinueLoadingRequested(PreloadMediaSource var1, long var2);
    }

    private class PreloadMediaPeriodCallback
    implements MediaPeriod.Callback {
        private final long periodStartPositionUs;
        private boolean prepared;

        public PreloadMediaPeriodCallback(long periodStartPositionUs) {
            this.periodStartPositionUs = periodStartPositionUs;
        }

        @Override
        public void onPrepared(MediaPeriod mediaPeriod) {
            this.prepared = true;
            PreloadMediaPeriod preloadMediaPeriod = (PreloadMediaPeriod)mediaPeriod;
            TrackGroupArray trackGroups = preloadMediaPeriod.getTrackGroups();
            TrackSelectorResult trackSelectorResult = null;
            MediaPeriodKey key = (MediaPeriodKey)((Pair)Assertions.checkNotNull((Object)((PreloadMediaSource)PreloadMediaSource.this).preloadingMediaPeriodAndKey)).second;
            try {
                trackSelectorResult = PreloadMediaSource.this.trackSelector.selectTracks(PreloadMediaSource.this.rendererCapabilities, trackGroups, key.mediaPeriodId, (Timeline)Assertions.checkNotNull((Object)PreloadMediaSource.this.timeline));
            }
            catch (ExoPlaybackException e) {
                Log.e((String)PreloadMediaSource.TAG, (String)"Failed to select tracks", (Throwable)((Object)e));
            }
            if (trackSelectorResult != null) {
                preloadMediaPeriod.selectTracksForPreloading(trackSelectorResult, this.periodStartPositionUs);
                if (PreloadMediaSource.this.preloadControl.onPrepared(PreloadMediaSource.this)) {
                    preloadMediaPeriod.continueLoading(new LoadingInfo.Builder().setPlaybackPositionUs(this.periodStartPositionUs).build());
                }
            }
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod mediaPeriod) {
            PreloadMediaPeriod preloadMediaPeriod = (PreloadMediaPeriod)mediaPeriod;
            if (!this.prepared || PreloadMediaSource.this.preloadControl.onContinueLoadingRequested(PreloadMediaSource.this, preloadMediaPeriod.getBufferedPositionUs())) {
                preloadMediaPeriod.continueLoading(new LoadingInfo.Builder().setPlaybackPositionUs(this.periodStartPositionUs).build());
            }
        }
    }

    private static class MediaPeriodKey {
        public final MediaSource.MediaPeriodId mediaPeriodId;
        private final Long startPositionUs;

        public MediaPeriodKey(MediaSource.MediaPeriodId mediaPeriodId, long startPositionUs) {
            this.mediaPeriodId = mediaPeriodId;
            this.startPositionUs = startPositionUs;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MediaPeriodKey)) {
                return false;
            }
            MediaPeriodKey mediaPeriodKey = (MediaPeriodKey)other;
            return PreloadMediaSource.mediaPeriodIdEqualsWithoutWindowSequenceNumber(this.mediaPeriodId, mediaPeriodKey.mediaPeriodId) && this.startPositionUs.equals(mediaPeriodKey.startPositionUs);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.mediaPeriodId.periodUid.hashCode();
            result = 31 * result + this.mediaPeriodId.adGroupIndex;
            result = 31 * result + this.mediaPeriodId.adIndexInAdGroup;
            result = 31 * result + this.mediaPeriodId.nextAdGroupIndex;
            result = 31 * result + this.startPositionUs.intValue();
            return result;
        }
    }

    public static final class Factory
    implements MediaSource.Factory {
        private final MediaSource.Factory mediaSourceFactory;
        private final Looper preloadLooper;
        private final Allocator allocator;
        private final TrackSelector trackSelector;
        private final BandwidthMeter bandwidthMeter;
        private final RendererCapabilities[] rendererCapabilities;
        private final PreloadControl preloadControl;

        public Factory(MediaSource.Factory mediaSourceFactory, PreloadControl preloadControl, TrackSelector trackSelector, BandwidthMeter bandwidthMeter, RendererCapabilities[] rendererCapabilities, Allocator allocator, Looper preloadLooper) {
            this.mediaSourceFactory = mediaSourceFactory;
            this.preloadControl = preloadControl;
            this.trackSelector = trackSelector;
            this.bandwidthMeter = bandwidthMeter;
            this.rendererCapabilities = Arrays.copyOf(rendererCapabilities, rendererCapabilities.length);
            this.allocator = allocator;
            this.preloadLooper = preloadLooper;
        }

        @Override
        public Factory setCmcdConfigurationFactory(CmcdConfiguration.Factory cmcdConfigurationFactory) {
            this.mediaSourceFactory.setCmcdConfigurationFactory(cmcdConfigurationFactory);
            return this;
        }

        @Override
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            this.mediaSourceFactory.setDrmSessionManagerProvider(drmSessionManagerProvider);
            return this;
        }

        @Override
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.mediaSourceFactory.setLoadErrorHandlingPolicy(loadErrorHandlingPolicy);
            return this;
        }

        @Override
        public int[] getSupportedTypes() {
            return this.mediaSourceFactory.getSupportedTypes();
        }

        @Override
        public PreloadMediaSource createMediaSource(MediaItem mediaItem) {
            return new PreloadMediaSource(this.mediaSourceFactory.createMediaSource(mediaItem), this.preloadControl, this.trackSelector, this.bandwidthMeter, this.rendererCapabilities, this.allocator, this.preloadLooper);
        }

        public PreloadMediaSource createMediaSource(MediaSource mediaSource) {
            return new PreloadMediaSource(mediaSource, this.preloadControl, this.trackSelector, this.bandwidthMeter, this.rendererCapabilities, this.allocator, this.preloadLooper);
        }
    }
}

