/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.text;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.exoplayer.text.CuesResolver;
import androidx.media3.extractor.text.CuesWithTiming;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class MergingCuesResolver
implements CuesResolver {
    private static final Ordering<CuesWithTiming> CUES_DISPLAY_PRIORITY_COMPARATOR = Ordering.natural().onResultOf(c -> c.startTimeUs).compound((Comparator)Ordering.natural().reverse().onResultOf(c -> c.durationUs));
    private final List<CuesWithTiming> cuesWithTimingList = new ArrayList<CuesWithTiming>();

    @Override
    public boolean addCues(CuesWithTiming cues, long currentPositionUs) {
        Assertions.checkArgument((cues.startTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        Assertions.checkArgument((cues.durationUs != -9223372036854775807L ? 1 : 0) != 0);
        boolean cuesAreShownAtCurrentTime = cues.startTimeUs <= currentPositionUs && currentPositionUs < cues.endTimeUs;
        for (int i = this.cuesWithTimingList.size() - 1; i >= 0; --i) {
            if (cues.startTimeUs < this.cuesWithTimingList.get((int)i).startTimeUs) continue;
            this.cuesWithTimingList.add(i + 1, cues);
            return cuesAreShownAtCurrentTime;
        }
        this.cuesWithTimingList.add(0, cues);
        return cuesAreShownAtCurrentTime;
    }

    @Override
    public ImmutableList<Cue> getCuesAtTimeUs(long timeUs) {
        if (this.cuesWithTimingList.isEmpty() || timeUs < this.cuesWithTimingList.get((int)0).startTimeUs) {
            return ImmutableList.of();
        }
        ArrayList<CuesWithTiming> visibleCues = new ArrayList<CuesWithTiming>();
        for (int i = 0; i < this.cuesWithTimingList.size(); ++i) {
            CuesWithTiming cues = this.cuesWithTimingList.get(i);
            if (timeUs >= cues.startTimeUs && timeUs < cues.endTimeUs) {
                visibleCues.add(cues);
            }
            if (timeUs < cues.startTimeUs) break;
        }
        ImmutableList sortedResult = ImmutableList.sortedCopyOf(CUES_DISPLAY_PRIORITY_COMPARATOR, visibleCues);
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < sortedResult.size(); ++i) {
            result.addAll((Iterable)((CuesWithTiming)sortedResult.get((int)i)).cues);
        }
        return result.build();
    }

    @Override
    public void discardCuesBeforeTimeUs(long timeUs) {
        for (int i = 0; i < this.cuesWithTimingList.size(); ++i) {
            long startTimeUs = this.cuesWithTimingList.get((int)i).startTimeUs;
            if (timeUs > startTimeUs && timeUs > this.cuesWithTimingList.get((int)i).endTimeUs) {
                this.cuesWithTimingList.remove(i);
                --i;
                continue;
            }
            if (timeUs < startTimeUs) break;
        }
    }

    @Override
    public long getPreviousCueChangeTimeUs(long timeUs) {
        if (this.cuesWithTimingList.isEmpty() || timeUs < this.cuesWithTimingList.get((int)0).startTimeUs) {
            return -9223372036854775807L;
        }
        long result = this.cuesWithTimingList.get((int)0).startTimeUs;
        for (int i = 0; i < this.cuesWithTimingList.size(); ++i) {
            long startTimeUs = this.cuesWithTimingList.get((int)i).startTimeUs;
            long endTimeUs = this.cuesWithTimingList.get((int)i).endTimeUs;
            if (endTimeUs <= timeUs) {
                result = Math.max(result, endTimeUs);
                continue;
            }
            if (startTimeUs > timeUs) break;
            result = Math.max(result, startTimeUs);
        }
        return result;
    }

    @Override
    public long getNextCueChangeTimeUs(long timeUs) {
        long result = -9223372036854775807L;
        for (int i = 0; i < this.cuesWithTimingList.size(); ++i) {
            long startTimeUs = this.cuesWithTimingList.get((int)i).startTimeUs;
            long endTimeUs = this.cuesWithTimingList.get((int)i).endTimeUs;
            if (timeUs < startTimeUs) {
                result = result == -9223372036854775807L ? startTimeUs : Math.min(result, startTimeUs);
                break;
            }
            if (timeUs >= endTimeUs) continue;
            result = result == -9223372036854775807L ? endTimeUs : Math.min(result, endTimeUs);
        }
        return result != -9223372036854775807L ? result : Long.MIN_VALUE;
    }

    @Override
    public void clear() {
        this.cuesWithTimingList.clear();
    }
}

