/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.text;

import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.exoplayer.text.CuesResolver;
import androidx.media3.extractor.text.CuesWithTiming;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;

final class ReplacingCuesResolver
implements CuesResolver {
    private final ArrayList<CuesWithTiming> cuesWithTimingList = new ArrayList();

    @Override
    public boolean addCues(CuesWithTiming cues, long currentPositionUs) {
        Assertions.checkArgument((cues.startTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        boolean cuesAreShownAtCurrentTime = cues.startTimeUs <= currentPositionUs && (cues.endTimeUs == -9223372036854775807L || currentPositionUs < cues.endTimeUs);
        for (int i = this.cuesWithTimingList.size() - 1; i >= 0; --i) {
            if (cues.startTimeUs >= this.cuesWithTimingList.get((int)i).startTimeUs) {
                this.cuesWithTimingList.add(i + 1, cues);
                return cuesAreShownAtCurrentTime;
            }
            if (this.cuesWithTimingList.get((int)i).startTimeUs > currentPositionUs) continue;
            cuesAreShownAtCurrentTime = false;
        }
        this.cuesWithTimingList.add(0, cues);
        return cuesAreShownAtCurrentTime;
    }

    @Override
    public ImmutableList<Cue> getCuesAtTimeUs(long timeUs) {
        int indexStartingAfterTimeUs = this.getIndexOfCuesStartingAfter(timeUs);
        if (indexStartingAfterTimeUs == 0) {
            return ImmutableList.of();
        }
        CuesWithTiming cues = this.cuesWithTimingList.get(indexStartingAfterTimeUs - 1);
        return cues.endTimeUs == -9223372036854775807L || timeUs < cues.endTimeUs ? cues.cues : ImmutableList.of();
    }

    @Override
    public void discardCuesBeforeTimeUs(long timeUs) {
        int indexToDiscardTo = this.getIndexOfCuesStartingAfter(timeUs);
        if (indexToDiscardTo > 0) {
            this.cuesWithTimingList.subList(0, indexToDiscardTo).clear();
        }
    }

    @Override
    public long getPreviousCueChangeTimeUs(long timeUs) {
        if (this.cuesWithTimingList.isEmpty() || timeUs < this.cuesWithTimingList.get((int)0).startTimeUs) {
            return -9223372036854775807L;
        }
        for (int i = 1; i < this.cuesWithTimingList.size(); ++i) {
            long nextCuesStartTimeUs = this.cuesWithTimingList.get((int)i).startTimeUs;
            if (timeUs == nextCuesStartTimeUs) {
                return nextCuesStartTimeUs;
            }
            if (timeUs >= nextCuesStartTimeUs) continue;
            CuesWithTiming cues = this.cuesWithTimingList.get(i - 1);
            return cues.endTimeUs != -9223372036854775807L && cues.endTimeUs <= timeUs ? cues.endTimeUs : cues.startTimeUs;
        }
        CuesWithTiming lastCues = (CuesWithTiming)Iterables.getLast(this.cuesWithTimingList);
        return lastCues.endTimeUs == -9223372036854775807L || timeUs < lastCues.endTimeUs ? lastCues.startTimeUs : lastCues.endTimeUs;
    }

    @Override
    public long getNextCueChangeTimeUs(long timeUs) {
        if (this.cuesWithTimingList.isEmpty()) {
            return Long.MIN_VALUE;
        }
        if (timeUs < this.cuesWithTimingList.get((int)0).startTimeUs) {
            return this.cuesWithTimingList.get((int)0).startTimeUs;
        }
        for (int i = 1; i < this.cuesWithTimingList.size(); ++i) {
            CuesWithTiming cues = this.cuesWithTimingList.get(i);
            if (timeUs >= cues.startTimeUs) continue;
            CuesWithTiming previousCues = this.cuesWithTimingList.get(i - 1);
            return previousCues.endTimeUs != -9223372036854775807L && previousCues.endTimeUs > timeUs && previousCues.endTimeUs < cues.startTimeUs ? previousCues.endTimeUs : cues.startTimeUs;
        }
        CuesWithTiming lastCues = (CuesWithTiming)Iterables.getLast(this.cuesWithTimingList);
        return lastCues.endTimeUs != -9223372036854775807L && timeUs < lastCues.endTimeUs ? lastCues.endTimeUs : Long.MIN_VALUE;
    }

    @Override
    public void clear() {
        this.cuesWithTimingList.clear();
    }

    private int getIndexOfCuesStartingAfter(long timeUs) {
        for (int i = 0; i < this.cuesWithTimingList.size(); ++i) {
            if (timeUs >= this.cuesWithTimingList.get((int)i).startTimeUs) continue;
            return i;
        }
        return this.cuesWithTimingList.size();
    }
}

