/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.text;

import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.text.DelegatingSubtitleDecoder;
import androidx.media3.extractor.text.DefaultSubtitleParserFactory;
import androidx.media3.extractor.text.SubtitleDecoder;
import androidx.media3.extractor.text.SubtitleParser;
import androidx.media3.extractor.text.cea.Cea608Decoder;
import androidx.media3.extractor.text.cea.Cea708Decoder;
import java.util.Objects;

@UnstableApi
public interface SubtitleDecoderFactory {
    public static final SubtitleDecoderFactory DEFAULT = new SubtitleDecoderFactory(){
        private final DefaultSubtitleParserFactory delegate = new DefaultSubtitleParserFactory();

        @Override
        public boolean supportsFormat(Format format) {
            String mimeType = format.sampleMimeType;
            return this.delegate.supportsFormat(format) || Objects.equals(mimeType, "application/cea-608") || Objects.equals(mimeType, "application/x-mp4-cea-608") || Objects.equals(mimeType, "application/cea-708");
        }

        @Override
        public SubtitleDecoder createDecoder(Format format) {
            String mimeType = format.sampleMimeType;
            if (mimeType != null) {
                switch (mimeType) {
                    case "application/cea-608": 
                    case "application/x-mp4-cea-608": {
                        return new Cea608Decoder(mimeType, format.accessibilityChannel, 16000L);
                    }
                    case "application/cea-708": {
                        return new Cea708Decoder(format.accessibilityChannel, format.initializationData);
                    }
                }
            }
            if (this.delegate.supportsFormat(format)) {
                SubtitleParser subtitleParser = this.delegate.create(format);
                return new DelegatingSubtitleDecoder(subtitleParser.getClass().getSimpleName() + "Decoder", subtitleParser);
            }
            throw new IllegalArgumentException("Attempted to create decoder for unsupported MIME type: " + mimeType);
        }
    };

    public boolean supportsFormat(Format var1);

    public SubtitleDecoder createDecoder(Format var1);
}

